/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.period;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.NumberUtils;
import kd.epm.eb.common.utils.StringUtils;

public class PeriodLeadUtils {
    public static final Log log = LogFactory.getLog(PeriodLeadUtils.class);
    private static final Set<String> HasNotLeadPeriodNumbers = new HashSet<String>();

    public static boolean hasPeriodDim(String dimensionNumber) {
        return "BudgetPeriod".equals(dimensionNumber) || "Year".equals(dimensionNumber) || "Period".equals(dimensionNumber);
    }

    public static PeriodLead getCTPLead() {
        PeriodLead lead = new PeriodLead();
        lead.setLead(-1);
        return lead;
    }

    public static PeriodLead parse(String numberLeadStr) {
        if (StringUtils.isEmpty(numberLeadStr) || !NumberUtils.isNumber(numberLeadStr)) {
            return null;
        }
        PeriodLead lead = new PeriodLead();
        lead.setExpr(numberLeadStr);
        try {
            lead.setLead(Integer.parseInt(numberLeadStr));
        }
        catch (NumberFormatException ex) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u671f\u95f4\u504f\u79fb\u6570\u503c\u201c%1\u201d\u89e3\u6790\u4e0d\u6b63\u786e\uff0c\u6216\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PeriodLeadUtils_0", (String)"epm-eb-common", (Object[])new Object[]{numberLeadStr}));
        }
        if (lead.getLead() > 100 || lead.getLead() < -100) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u671f\u95f4\u504f\u79fb\u6570\u503c\u201c%1\u201d\u8d85\u51fa\u8303\u56f4\uff08\u6700\u5927\u503c\u4e3a100\uff0c\u6700\u5c0f\u503c\u4e3a-100\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PeriodLeadUtils_1", (String)"epm-eb-common", (Object[])new Object[]{numberLeadStr}));
        }
        return lead;
    }

    public static String get(String periodNumber, PeriodLead lead) {
        return PeriodLeadUtils.get(periodNumber, lead, null);
    }

    public static String get(String periodNumber, PeriodLead lead, Map<String, String> cache) {
        String _periodNumber;
        if (periodNumber == null || lead == null || lead.getLead() == 0) {
            return periodNumber;
        }
        if (HasNotLeadPeriodNumbers.contains(periodNumber)) {
            return periodNumber;
        }
        String cacheKey = periodNumber + '@' + lead.getExpr();
        String string = _periodNumber = cache != null ? cache.get(cacheKey) : null;
        if (_periodNumber != null) {
            return _periodNumber;
        }
        String[] periods = periodNumber.split("\\.");
        if (periods == null || periods.length == 0) {
            return null;
        }
        try {
            int cYear = Integer.parseInt(periods[0].substring(2));
            int cMonth = 1;
            int cDay = 1;
            int periodType = 1;
            if (periods.length > 1) {
                if (periods[1].startsWith("HF")) {
                    periodType = 2;
                    int cHalfYear = Integer.parseInt(periods[1].substring(2));
                    cMonth = cHalfYear * 6;
                } else if (periods[1].startsWith("Q")) {
                    periodType = 3;
                    int cQuarter = Integer.parseInt(periods[1].substring(1));
                    cMonth = cQuarter * 3;
                } else if (periods[1].startsWith("M")) {
                    periodType = 4;
                    cMonth = Integer.parseInt(periods[1].substring(1));
                } else if (periods[1].startsWith("D")) {
                    periodType = 8;
                    cDay = Integer.parseInt(periods[1].substring(1));
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(cYear, cMonth - 1, cDay);
            switch (periodType) {
                case 1: {
                    calendar.add(1, lead.getLead());
                    break;
                }
                case 2: {
                    calendar.add(2, lead.getLead() * 6);
                    break;
                }
                case 3: {
                    calendar.add(2, lead.getLead() * 3);
                    break;
                }
                case 4: {
                    calendar.add(2, lead.getLead());
                    break;
                }
                case 8: {
                    calendar.add(6, lead.getLead());
                    break;
                }
            }
            CalendarHelper calendarHelper = new CalendarHelper();
            calendarHelper.setTime(calendar.getTime());
            StringBuilder periodStr = new StringBuilder();
            periodStr.append("FY").append(calendarHelper.getCurrentlyYear());
            if (periods.length > 1) {
                periodStr.append('.');
                switch (periodType) {
                    case 2: {
                        periodStr.append("HF").append(calendarHelper.getCurrentlyHalfYear());
                        break;
                    }
                    case 3: {
                        periodStr.append("Q").append(calendarHelper.getCurrentlyQuarter());
                        break;
                    }
                    case 4: {
                        periodStr.append("M").append(String.format("%02d", calendarHelper.getCurrentlyMonth()));
                        break;
                    }
                    case 8: {
                        periodStr.append("D").append(String.format("%02d", calendarHelper.getCurrentlyDay()));
                        break;
                    }
                }
            }
            _periodNumber = periodStr.toString();
            if (cache != null) {
                cache.put(cacheKey, _periodNumber);
            }
        }
        catch (Exception ex) {
            log.error("periodNumber-parse-error", (Throwable)ex);
            _periodNumber = periodNumber;
        }
        return _periodNumber;
    }

    static {
        HasNotLeadPeriodNumbers.add("BudgetPeriod");
        HasNotLeadPeriodNumbers.add("Year");
        HasNotLeadPeriodNumbers.add("Period");
    }

    public static class PeriodLead {
        private String expr = null;
        private int lead = 0;

        public void setExpr(String expr) {
            this.expr = expr;
        }

        public String getExpr() {
            return this.expr;
        }

        public void setLead(int lead) {
            this.lead = lead;
        }

        public int getLead() {
            return this.lead;
        }
    }
}

