/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.pkgversioncheck;

import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.VersionUtils;
import kd.epm.eb.common.utils.cache.Cache;

public class PkgVersionCheckService {
    private static final Log log = LogFactory.getLog(PkgVersionCheckService.class);
    public static final String TEST_CLASS_NAME = "kd.bos.olap.dataSources.MetadataCommandInfo";
    public static final String DYNAMIC_STORE_C_VERSION = "2.8.3";
    public static final String DYNAMIC_STORE_S_VERSION = "9.2.5";

    public static PkgVersionCheckService getInstance() {
        return InnerClass.instance;
    }

    private PkgVersionCheckService() {
    }

    public boolean hasClass(String className) {
        boolean check;
        block5: {
            check = false;
            try {
                String cacheRes = Cache.get().get("PkgVersionCheckService." + className);
                if (cacheRes == null) {
                    try {
                        Class.forName(className);
                        check = true;
                    }
                    catch (ClassNotFoundException ex) {
                        log.info("PkgVersionCheckService." + className + "-ClassNotFound.");
                    }
                    Cache.get().set("PkgVersionCheckService." + className, String.valueOf(check), 150, TimeUnit.SECONDS);
                    break block5;
                }
                check = Boolean.parseBoolean(cacheRes);
            }
            catch (Exception e) {
                log.error("PkgVersionCheckService:" + e);
            }
        }
        log.info("check-version:className=" + className);
        return check;
    }

    public boolean checkPkgVersionOverOrDefault(String className, String versionNum, boolean _default) {
        try {
            String cacheRes = Cache.get().get("PkgVersionCheckService." + className);
            if (cacheRes == null) {
                int checkRes = this.checkPkgVersion(className, versionNum);
                _default = checkRes >= 0;
                Cache.get().set("PkgVersionCheckService." + className, String.valueOf(_default), 60, TimeUnit.SECONDS);
            } else {
                _default = Boolean.parseBoolean(cacheRes);
            }
        }
        catch (Exception e) {
            log.error("PkgVersionCheckService:" + e);
        }
        log.info("check-version:className=" + className + ";version=" + versionNum + ";value=" + _default);
        return _default;
    }

    public int checkPkgVersion(String className, String versionNum) {
        int re = -1;
        try {
            Class<?> _class = Class.forName(className);
            Package pkg = _class.getPackage();
            if (pkg != null) {
                String version = pkg.getImplementationVersion();
                re = VersionUtils.compareVersion(version, versionNum);
            }
        }
        catch (ClassNotFoundException ex) {
            log.error("checkPkgVersion-error:", (Throwable)ex);
        }
        return re;
    }

    private static class InnerClass {
        private static final PkgVersionCheckService instance = new PkgVersionCheckService();

        private InnerClass() {
        }
    }
}

