/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.table;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.table.ITable;

public class PlanRuleTable
extends ITable {
    private static final String APPORTION_TAG = "t_eb_Plan";
    private String cubeNumber;

    public PlanRuleTable(String cubeNumber) {
        this.tableName = null;
        this.tableIndex = new ArrayList();
        this.cubeNumber = cubeNumber;
    }

    @Override
    public List<String[]> getTableIndex() {
        return this.tableIndex;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean buildTable() {
        String[] tableIndex;
        this.verify();
        String index = this.getIndex();
        this.buildTableName(index);
        DBRoute epm = DBRoute.of((String)"epm");
        boolean re = true;
        if (!DB.exitsTable((DBRoute)epm, (String)this.tableName)) {
            re = DB.execute((DBRoute)epm, (String)("create table " + this.tableName + " (fid BIGINT DEFAULT 0 NOT NULL, fmaindim nvarchar(255) DEFAULT ' ' NOT NULL,fsourceperiod nvarchar(255) DEFAULT ' ' NOT NULL,finjectperiod nvarchar(255) DEFAULT ' ' NOT NULL, finjectaccount nvarchar(255) DEFAULT ' ' NOT NULL, fdimnumber  nvarchar(2000) DEFAULT ' ' NOT NULL,fvalue DECIMAL(19,6) NOT NULL DEFAULT 0)"));
        }
        if (StringUtils.isNotEmpty((tableIndex = new String[]{"ix_eb_plan" + index + "maindim", "create index ix_eb_plan" + index + "maindim on " + this.tableName + "(fmaindim)"})[0]) && StringUtils.isNotEmpty(tableIndex[1]) && !DB.exitsIndex((DBRoute)epm, (String)this.tableName, (String)tableIndex[0])) {
            re = DB.execute((DBRoute)epm, (String)tableIndex[1]);
        }
        return re;
    }

    private void verify() {
        if (StringUtils.isEmpty(this.cubeNumber) || this.cubeNumber.length() <= 4) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"PlanRuleTable_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    @Override
    public void buildTableName(String index) {
        if (index == null) {
            index = this.getIndex();
        }
        this.tableName = APPORTION_TAG + index;
    }

    private String getIndex() {
        StringBuilder str = new StringBuilder();
        int in = this.cubeNumber.length();
        for (int i = 0; i < in; ++i) {
            char _char = this.cubeNumber.charAt(i);
            if (!Character.isDigit(_char)) continue;
            str.append(_char);
        }
        return str.toString();
    }
}

