/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.task;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OrgMemberUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BgTaskPackServiceHelper {
    public static boolean delete(Long taskPackId) {
        boolean re = false;
        if (taskPackId == null || taskPackId == 0L) {
            return re;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "=", (Object)taskPackId));
        if (QueryServiceHelper.exists((String)"eb_tasklist", (QFilter[])builder.toArrays())) {
            try {
                DeleteServiceHelper.delete((String)"eb_taskdispatchsave", (QFilter[])new QFilter[]{new QFilter("task", "=", (Object)taskPackId)});
                builder.clear();
                builder.add(new QFilter("tasklist", "=", (Object)taskPackId));
                DeleteServiceHelper.delete((String)"eb_task", (QFilter[])builder.toArrays());
                builder.clear();
                builder.add(new QFilter("id", "=", (Object)taskPackId));
                DeleteServiceHelper.delete((String)"eb_tasklist", (QFilter[])builder.toArrays());
                BgTaskPackServiceHelper.deleteMemberQuote(taskPackId);
                re = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return re;
    }

    private static void deleteMemberQuote(Long taskPackId) {
        if (IDUtils.isNull(taskPackId)) {
            return;
        }
        HashSet<Long> resourceIds = new HashSet<Long>();
        resourceIds.add(taskPackId);
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.TaskList.getType(), resourceIds});
    }

    public static void distributionTaskProcess(Long modelId, Set<Long> taskIds, List<Object[]> selOrgs, Map<Long, DynamicObject> orgUnitMap, Set<Long> templateIds, Map<String, DynamicObject> disOrgData) {
        if (modelId == null || modelId == 0L || taskIds.isEmpty() || selOrgs == null || selOrgs.isEmpty()) {
            return;
        }
        DynamicObjectCollection saveProcesss = new DynamicObjectCollection();
        DynamicObject process = null;
        Set<Object> tempalteIds = new HashSet(16);
        String key = null;
        HashMap<String, DynamicObject> processMap = new HashMap<String, DynamicObject>();
        HashMap templateMap = new HashMap();
        QFBuilder builder = new QFBuilder();
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"eb_task", (String)"id, tasklist, number, name, description, begintime, time, deadline, entryentity.templateid, entryentity.seq", (QFilter[])builder.add(new QFilter("id", "in", taskIds)).toArrays());
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return;
        }
        for (DynamicObject task : tasks) {
            Long templateId = task.getLong("entryentity.templateid");
            if (templateId == 0L || templateIds != null && !templateIds.contains(templateId)) continue;
            tempalteIds = (Set)templateMap.get(task.getLong("id"));
            if (tempalteIds == null) {
                tempalteIds = new HashSet();
                templateMap.put(task.getLong("id"), tempalteIds);
            }
            tempalteIds.add(templateId);
        }
        if (templateMap.isEmpty()) {
            return;
        }
        if (orgUnitMap == null) {
            orgUnitMap = OrgMemberUtils.getSelectOrgUnits(modelId, selOrgs);
        }
        if (orgUnitMap.isEmpty()) {
            return;
        }
        Set orgIdSet = orgUnitMap.values().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        HashSet templateIdSet = new HashSet(16);
        for (Set set : templateMap.values()) {
            templateIdSet.addAll(set);
        }
        builder.clear();
        builder.add(new QFilter("task", "in", taskIds));
        builder.add(new QFilter("org", "in", orgIdSet));
        builder.add(new QFilter("template", "in", templateIdSet));
        DynamicObjectCollection exists = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id, task.id, org.id, template.id", (QFilter[])builder.toArrays());
        if (exists != null && exists.size() > 0) {
            int in = exists.size();
            for (int i = 0; i < in; ++i) {
                process = (DynamicObject)exists.get(i);
                if (IDUtils.isEmptyLong(process.getLong("task.id")).booleanValue() || IDUtils.isEmptyLong(process.getLong("org.id")).booleanValue() || IDUtils.isEmptyLong(process.getLong("template.id")).booleanValue()) continue;
                key = process.getLong("task.id") + "_" + process.getLong("org.id") + "_" + process.getLong("template.id");
                processMap.put(key, process);
            }
        }
        Date date = new Date();
        Long userId = UserUtils.getUserId();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"eb_taskprocess");
        String defTemplateType = "eb_templateentity";
        for (DynamicObject task : tasks) {
            long taskId = task.getLong("id");
            long templateId = task.getLong("entryentity.templateid");
            int seq = task.getInt("entryentity.seq");
            for (DynamicObject org : orgUnitMap.values()) {
                long orgId = org.getLong("id");
                key = taskId + "_" + orgId + "_" + templateId;
                String mapKey = taskId + "_" + orgId;
                if (processMap.containsKey(key)) continue;
                process = new DynamicObject((DynamicObjectType)dataEntityType);
                process.set("task", (Object)taskId);
                process.set("org", (Object)orgId);
                process.set("templatetype", (Object)defTemplateType);
                process.set("template", (Object)templateId);
                process.set("tempseq", (Object)seq);
                DynamicObject distOrg = disOrgData.get(mapKey);
                if (distOrg != null) {
                    DynamicObjectCollection disOrgDataExecutors = distOrg.getDynamicObjectCollection("executors");
                    DynamicObjectCollection executors = process.getDynamicObjectCollection("executors");
                    for (DynamicObject disOrgDataExecutor : disOrgDataExecutors) {
                        DynamicObject object = executors.addNew();
                        object.set("fbasedataid_id", (Object)disOrgDataExecutor.getLong("fbasedataid_id"));
                    }
                    process.set("orgview", (Object)distOrg.getString("distorgview"));
                    DynamicObjectCollection dcs = (DynamicObjectCollection)distOrg.get("entryentity");
                    if (dcs != null) {
                        DynamicObjectCollection dynamicObjects = process.getDynamicObjectCollection("entryentity");
                        for (DynamicObject dc : dcs) {
                            DynamicObject d = new DynamicObject(dynamicObjects.getDynamicObjectType());
                            d.set("supervisor", (Object)((Long)dc.get("supervisor")));
                            dynamicObjects.add((Object)d);
                        }
                        process.set("entryentity", (Object)dynamicObjects);
                    }
                } else {
                    DynamicObjectCollection executors = process.getDynamicObjectCollection("executors");
                    DynamicObject _executor = executors.addNew();
                    _executor.set("fbasedataid_id", (Object)org.getLong("executor"));
                    DynamicObjectCollection dynamicObjects = process.getDynamicObjectCollection("entryentity");
                    DynamicObject d = new DynamicObject(dynamicObjects.getDynamicObjectType());
                    d.set("supervisor", (Object)org.getLong("owner"));
                    dynamicObjects.add((Object)d);
                    process.set("entryentity", (Object)dynamicObjects);
                }
                process.set("state", (Object)BgTaskStateEnum.UNSTARTED.getNumber());
                process.set("creater", (Object)userId);
                process.set("createdate", (Object)date);
                process.set("modifier", (Object)userId);
                process.set("modifydate", (Object)date);
                saveProcesss.add((Object)process);
            }
        }
        if (exists != null && !exists.isEmpty()) {
            List<Long> idList = exists.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            int inMaxSize = HugeInConfig.inMaxSize();
            if (idList.size() > inMaxSize) {
                List partition = Lists.partition(idList, (int)inMaxSize);
                for (List ids : partition) {
                    BgTaskPackServiceHelper.updateTaskProcess(disOrgData, builder, date, userId, ids);
                }
            } else {
                BgTaskPackServiceHelper.updateTaskProcess(disOrgData, builder, date, userId, idList);
            }
        }
        if (!saveProcesss.isEmpty()) {
            DynamicObjectUtils.save((List<DynamicObject>)saveProcesss);
        }
    }

    private static void updateTaskProcess(Map<String, DynamicObject> disOrgData, QFBuilder builder, Date date, Long userId, List<Long> ids) {
        DynamicObject[] processArr;
        if (disOrgData == null || builder == null || CollectionUtils.isEmpty(ids)) {
            return;
        }
        builder.clear();
        builder.add(new QFilter("id", "in", ids));
        for (DynamicObject pro : processArr = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"id, task, org, executors, modifier, modifydate,entryentity.supervisor", (QFilter[])builder.toArrays())) {
            if (pro.get("task") == null || pro.get("org") == null) continue;
            String mapKey = pro.getLong("task.id") + "_" + pro.getLong("org.id");
            pro.set("modifier", (Object)userId);
            pro.set("modifydate", (Object)date);
            DynamicObject distOrg = disOrgData.get(mapKey);
            if (distOrg == null) continue;
            DynamicObjectCollection executors = pro.getDynamicObjectCollection("executors");
            DynamicObjectCollection disExecutors = distOrg.getDynamicObjectCollection("executors");
            if (CollectionUtils.isEmpty((Collection)executors)) {
                for (DynamicObject disExecutor : disExecutors) {
                    DynamicObject _executor = executors.addNew();
                    _executor.set("fbasedata_id", (Object)disExecutor.getLong("fbasedata_id"));
                }
            }
            DynamicObjectCollection dcs = (DynamicObjectCollection)distOrg.get("entryentity");
            DynamicObjectCollection supervisors = pro.getDynamicObjectCollection("entryentity");
            supervisors.clear();
            if (dcs == null) continue;
            for (DynamicObject dc : dcs) {
                DynamicObject _row = supervisors.addNew();
                _row.set("supervisor", (Object)((Long)dc.get("supervisor")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])processArr);
    }
}

