/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.task;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.task.SubTaskStatusEnum;
import kd.epm.eb.common.utils.BgTaskNode;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.WorkdayUtils;

public class BgTaskServiceHelper {
    public static final String FIELDS_ALL = "id, number, name, description, relytasks, entryentity.templateid, entryentity.seq, entryentity.templatetype, begintime, time, deadline, taskseq, creater, createdate, modifier, modifydate, org, tasklist, model, approvaltype, tasktemplate,, monitorop, pretaskstatus, pretasklogic";
    public static final String FIELDS_RELY = "id, relytasks";

    public static Map<Object, DynamicObject> loadFromCache(Long taskPackId, String field) {
        HashMap<Object, DynamicObject> taskMap = new HashMap<Object, DynamicObject>();
        if (taskPackId == 0L) {
            return taskMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("tasklist", "=", (Object)taskPackId));
        return BusinessDataServiceHelper.loadFromCache((String)"eb_task", (String)field, (QFilter[])builder.toArrays());
    }

    private static BgTaskNode buildNode(DynamicObject task, Map<Long, DynamicObject> taskMap, Map<Long, Set<Long>> relyMap, Map<Long, Set<Long>> refMap, Map<Long, BgTaskNode> taskNodeMap) {
        if (task == null) {
            return null;
        }
        BgTaskNode node = null;
        BgTaskNode tmpNode = null;
        DynamicObject _task = null;
        Long taskId = task.getLong("id");
        if (taskNodeMap.containsKey(taskId)) {
            node = taskNodeMap.get(taskId);
        } else {
            node = new BgTaskNode(task);
            taskNodeMap.put(taskId, node);
            if (relyMap.containsKey(taskId)) {
                Set<Long> relyIds = relyMap.get(taskId);
                for (Long relyId : relyIds) {
                    _task = taskMap.get(relyId);
                    tmpNode = BgTaskServiceHelper.buildNode(_task, taskMap, relyMap, refMap, taskNodeMap);
                    node.addParent(relyId, tmpNode);
                }
            }
            if (refMap.containsKey(taskId)) {
                Set<Long> refIds = refMap.get(taskId);
                for (Long refId : refIds) {
                    _task = taskMap.get(refId);
                    tmpNode = BgTaskServiceHelper.buildNode(_task, taskMap, relyMap, refMap, taskNodeMap);
                    node.addChild(refId, tmpNode);
                }
            }
        }
        return node;
    }

    public static boolean checkRefTask(Long[] taskIds) {
        boolean re = false;
        if (taskIds == null || taskIds.length == 0) {
            return re;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("relytasks.fbasedataid", "in", Arrays.asList(taskIds)));
        DynamicObject refTask = QueryServiceHelper.queryOne((String)"eb_task", (String)"relytasks", (QFilter[])builder.toArrays());
        if (refTask != null) {
            re = true;
        }
        return re;
    }

    public static boolean checkTaskDisPatch(Long[] taskIds) {
        boolean re = false;
        if (taskIds == null || taskIds.length == 0) {
            return re;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("task", "in", Arrays.asList(taskIds)));
        DynamicObject refTask = QueryServiceHelper.queryOne((String)"eb_taskprocess", (String)"id", (QFilter[])builder.toArrays());
        if (refTask != null) {
            re = true;
        }
        return re;
    }

    public static boolean delete(Long[] taskIds) {
        boolean re = false;
        if (taskIds == null || taskIds.length == 0) {
            return re;
        }
        if (QueryServiceHelper.exists((String)"eb_task", (QFilter[])new QFilter("id", "in", (Object)taskIds).toArray())) {
            try (TXHandle th = TX.required();){
                try {
                    DeleteServiceHelper.delete((String)"eb_taskdispatchsave", (QFilter[])new QFilter("taskid", "in", (Object)taskIds).toArray());
                    DeleteServiceHelper.delete((String)"eb_taskorg", (QFilter[])new QFilter("taskid", "in", (Object)taskIds).toArray());
                    DeleteServiceHelper.delete((String)"eb_task", (QFilter[])new QFilter("id", "in", (Object)taskIds).toArray());
                    re = true;
                }
                catch (Exception e) {
                    th.markRollback();
                    throw e;
                }
            }
        }
        return re;
    }

    public static void setTaskClosed(Long[] taskIds, SubTaskStatusEnum subTaskStatusEnum) {
        if (taskIds == null || taskIds.length == 0) {
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_task", (String)"isclosed", (QFilter[])new QFilter("id", "in", (Object)taskIds).toArray());
        if (load == null || load.length == 0) {
            return;
        }
        for (DynamicObject object : load) {
            object.set("isclosed", (Object)subTaskStatusEnum.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }

    public static void updateTaskTime(DynamicObject task, Map<Long, Set<Long>> refMap, Map<Long, DynamicObject> taskMap, List<DynamicObject> upTasks) {
        int compare;
        if (task == null || refMap == null || taskMap == null || upTasks == null) {
            return;
        }
        Date begin = null;
        Date dead = null;
        begin = task.getDate("begintime");
        DynamicObjectCollection relys = task.getDynamicObjectCollection("relytasks");
        if (CollectionUtils.isEmpty(relys)) {
            return;
        }
        for (DynamicObject _rely : relys) {
            if (dead == null) {
                dead = _rely.getDynamicObject("fbasedataid").getDate("deadline");
                continue;
            }
            if (dead.compareTo(_rely.getDynamicObject("fbasedataid").getDate("deadline")) >= 0) continue;
            dead = _rely.getDynamicObject("fbasedataid").getDate("deadline");
        }
        if (dead == null) {
            dead = task.getDate("deadline");
        }
        if ((compare = begin.compareTo(dead)) <= 0) {
            task.set("begintime", (Object)dead);
            task.set("deadline", (Object)BgTaskServiceHelper.calcDeadTime(dead, task.getInt("time")));
            upTasks.add(task);
        }
        if (refMap.containsKey(task.getLong("id"))) {
            Set<Long> refIds = refMap.get(task.getLong("id"));
            for (Long refId : refIds) {
                DynamicObject refTask = taskMap.get(refId);
                BgTaskServiceHelper.updateTaskTime(refTask, refMap, taskMap, upTasks);
            }
        }
    }

    public static Date calcBeginTime(Date dead, Integer use) {
        return WorkdayUtils.calcBeginByWork(dead, use);
    }

    public static Date calcDeadTime(Date begin, Integer use) {
        return WorkdayUtils.calcDeadByWork(begin, use);
    }

    public static Map<Long, DynamicObject> getTaskMap(DynamicObject[] tasks) {
        HashMap<Long, DynamicObject> taskMap = new HashMap<Long, DynamicObject>(16);
        if (tasks == null || tasks.length == 0) {
            return taskMap;
        }
        for (DynamicObject task : tasks) {
            taskMap.put(task.getLong("id"), task);
        }
        return taskMap;
    }

    public static Map<Long, Set<Long>> getRefMap(DynamicObject[] tasks) {
        HashMap<Long, Set<Long>> refMap = new HashMap<Long, Set<Long>>();
        if (tasks == null || tasks.length == 0) {
            return refMap;
        }
        Set<Long> refSet = null;
        DynamicObjectCollection relys = null;
        Long taskId = 0L;
        Long relyId = 0L;
        for (DynamicObject task : tasks) {
            taskId = task.getLong("id");
            relys = task.getDynamicObjectCollection("relytasks");
            if (relys == null || relys.isEmpty()) continue;
            for (DynamicObject rely : relys) {
                relyId = rely.getDynamicObject("fbasedataid").getLong("id");
                if (refMap.containsKey(relyId)) {
                    refSet = (Set)refMap.get(relyId);
                } else {
                    refSet = new HashSet();
                    refMap.put(relyId, refSet);
                }
                refSet.add(taskId);
            }
        }
        return refMap;
    }

    public static boolean checkRefTaskFlow(Long[] taskIds) {
        if (taskIds == null || taskIds.length == 0) {
            return false;
        }
        return QueryServiceHelper.exists((String)"eb_bgmtaskflow", (QFilter[])new QFilter("nodeentry.subtasks.fbasedataid_id", "in", (Object)taskIds).toArray());
    }
}

