/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AttachementTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.task.TaskDecomposeStatus;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.task.TaskDecomposeRecord;
import kd.epm.eb.common.utils.ApproveBill.BasicInfoHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskDecomposeService {
    private static final String SIGN = "\\|";

    public static TaskDecomposeService getInstance() {
        return new TaskDecomposeService();
    }

    public List<TaskDecomposeRecord> getTaskDecomposeRecord(QFilter qFilter, Long modelId) {
        ArrayList<TaskDecomposeRecord> taskDecomposeRecords = new ArrayList<TaskDecomposeRecord>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        String selectFields = "id,org,task,status,modifier,modifydate,manager,supervisors,executors,parentdecompose,model,orgview,longnumber";
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"eb_taskdecompose_entity", (String)selectFields, (QFilter[])qFilter.toArray());
        if (query.length > 0) {
            for (DynamicObject object : query) {
                TaskDecomposeRecord taskDecomposeRecord = this.buildTaskDecomposeRecord(object, modelCacheHelper);
                taskDecomposeRecords.add(taskDecomposeRecord);
            }
        }
        return taskDecomposeRecords;
    }

    public void deleteTaskDecomposeDispatchRecord(Set<Long> subTaskIds, Set<String> decomposeLongNumbers, Long modelId) {
        QFilter qFilter = new QFilter("task", "in", subTaskIds);
        List<TaskDecomposeRecord> taskDecomposeRecord = this.getTaskDecomposeRecord(qFilter, modelId);
        HashSet<Long> needDeleteRecordIds = new HashSet<Long>(16);
        for (TaskDecomposeRecord decomposeRecord : taskDecomposeRecord) {
            if (!TaskDecomposeService.isParentInRange(decomposeLongNumbers, decomposeRecord.getDecomposeOrgLongNumber(), "|")) continue;
            needDeleteRecordIds.add(decomposeRecord.getId());
        }
        if (needDeleteRecordIds.size() > 0) {
            DeleteServiceHelper.delete((String)"eb_taskdecompose_entity", (QFilter[])new QFilter("id", "in", needDeleteRecordIds).toArray());
        }
    }

    public void deleteToLinkDecomposeRecord(List<Long> decomposeIds, QFilter queryRangeQFilter) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"parentdecompose,id", (QFilter[])queryRangeQFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashMap<Long, Set<Long>> decomposeIdsMap = new HashMap<Long, Set<Long>>(16);
            for (DynamicObject object : query) {
                long id = object.getLong("id");
                long parentDecompose = object.getLong("parentdecompose");
                Set childIds = decomposeIdsMap.computeIfAbsent(parentDecompose, e -> new HashSet(5));
                childIds.add(id);
            }
            Set<Long> needDeleteRecordIds = this.findNeedDelete(decomposeIdsMap, decomposeIds);
            if (needDeleteRecordIds.size() > 0) {
                DeleteServiceHelper.delete((String)"eb_taskdecompose_entity", (QFilter[])new QFilter("id", "in", needDeleteRecordIds).toArray());
            }
        }
    }

    public void deleteToLinkDecomposeRecord(Long decomposeId, QFilter queryRangeQFilter) {
        this.deleteToLinkDecomposeRecord(Collections.singletonList(decomposeId), queryRangeQFilter);
    }

    public Set<Long> findNeedDelete(Map<Long, Set<Long>> decomposeIdsMap, List<Long> decomposeIds) {
        HashSet<Long> needDeleteRecordIds = new HashSet<Long>(16);
        ArrayDeque<Long> stack = new ArrayDeque<Long>(decomposeIds);
        while (!stack.isEmpty()) {
            Long currentId = (Long)stack.pop();
            Set<Long> ids = decomposeIdsMap.get(currentId);
            if (!CollectionUtils.isNotEmpty(ids)) continue;
            needDeleteRecordIds.addAll(ids);
            for (Long id : ids) {
                stack.push(id);
            }
        }
        return needDeleteRecordIds;
    }

    public List<BaseRptProcessRequest> checkBeforeCancelDecomposeDispatch(Set<Long> subTaskIds, Set<String> decomposeLongNumbers, Long modelId, boolean needCheck) {
        QFilter qFilter = new QFilter("task", "in", subTaskIds);
        qFilter.and("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        List<TaskDecomposeRecord> taskDecomposeRecord = this.getTaskDecomposeRecord(qFilter, modelId);
        HashMap<Long, Set<Long>> taskDispatchOrgIds = new HashMap<Long, Set<Long>>(16);
        for (TaskDecomposeRecord decomposeRecord : taskDecomposeRecord) {
            if (!TaskDecomposeService.isParentInRange(decomposeLongNumbers, decomposeRecord.getDecomposeOrgLongNumber(), "|")) continue;
            Set orgIds = taskDispatchOrgIds.computeIfAbsent(decomposeRecord.getSubTaskId(), e -> new HashSet());
            orgIds.add(decomposeRecord.getOrgId());
        }
        if (taskDispatchOrgIds.size() == 0) {
            return new ArrayList<BaseRptProcessRequest>(0);
        }
        List<BaseRptProcessRequest> reportProcess = this.createReportProcess(taskDispatchOrgIds);
        if (needCheck && ReportProcessAggService.getInstance().checkRequestHasApproveBill(reportProcess, modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4efb\u52a1\u542b\u6709\u5df2\u751f\u6210\u62a5\u8868\u8bb0\u5f55\u4efb\u52a1\u3002", (String)"BgTaskDispatchPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return reportProcess;
    }

    public List<BaseRptProcessRequest> checkBeforeCancelDecomposeDispatch(Long subTaskId, Set<String> decomposeLongNumbers, Long modelId, boolean needCheck) {
        return this.checkBeforeCancelDecomposeDispatch(Sets.newHashSet((Object[])new Long[]{subTaskId}), decomposeLongNumbers, modelId, needCheck);
    }

    public Map<Long, Set<Long>> getTaskDecomposeDispatchedOrgIds(Set<Long> executeSubTaskIds, Set<String> decomposeLongNumbers, Long modelId) {
        HashMap<Long, Set<Long>> taskDecomposeDispatchedOrgIds = new HashMap<Long, Set<Long>>();
        QFilter qFilter = new QFilter("task", "in", executeSubTaskIds);
        qFilter.and("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        List<TaskDecomposeRecord> taskDecomposeRecord = TaskDecomposeService.getInstance().getTaskDecomposeRecord(qFilter, modelId);
        for (TaskDecomposeRecord decomposeRecord : taskDecomposeRecord) {
            Long subTaskId = decomposeRecord.getSubTaskId();
            String decomposeOrgLongNumber = decomposeRecord.getDecomposeOrgLongNumber();
            if (!TaskDecomposeService.isParentInRange(decomposeLongNumbers, decomposeOrgLongNumber, "|")) continue;
            Set decomposeDispatchOrgIds = taskDecomposeDispatchedOrgIds.computeIfAbsent(subTaskId, e -> new HashSet());
            decomposeDispatchOrgIds.add(decomposeRecord.getOrgId());
        }
        return taskDecomposeDispatchedOrgIds;
    }

    public void deleteTaskProcess(Set<Long> subTaskIds, Set<String> decomposeLongNumbers, Long modelId) {
        Map<Long, Set<Long>> taskDecomposeDispatchedOrgIds = this.getTaskDecomposeDispatchedOrgIds(subTaskIds, decomposeLongNumbers, modelId);
        QFilter qFilter = new QFilter("task", "in", subTaskIds);
        qFilter.and("state", "not in", (Object)Sets.newHashSet((Object[])new String[]{BgTaskStateEnum.UNDERWAY.getNumber(), BgTaskStateEnum.COMPLETED.getNumber()}));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"unDistOrg", (String)"eb_taskprocess", (String)"id,task,org", (QFilter[])qFilter.toArray(), null);
        if (dataSet != null && dataSet.hasNext()) {
            HashSet<Long> needDeleteProcessIds = new HashSet<Long>(16);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long taskId = row.getLong("task");
                Long orgId = row.getLong("org");
                Set<Long> dispatchedOrgIds = taskDecomposeDispatchedOrgIds.get(taskId);
                if (dispatchedOrgIds == null || !dispatchedOrgIds.contains(orgId)) continue;
                needDeleteProcessIds.add(row.getLong("id"));
            }
            if (needDeleteProcessIds.size() > 0) {
                ArrayList<Long> needDeleteProcessIdList = new ArrayList<Long>(needDeleteProcessIds);
                int inMaxSize = HugeInConfig.inMaxSize();
                if (needDeleteProcessIdList.size() > inMaxSize) {
                    List partition = Lists.partition(needDeleteProcessIdList, (int)inMaxSize);
                    for (List ids : partition) {
                        this.deleteTaskProcess(ids);
                    }
                } else {
                    this.deleteTaskProcess(needDeleteProcessIdList);
                }
            }
        }
    }

    private void deleteTaskProcess(List<Long> needDeleteProcessIdList) {
        if (CollectionUtils.isEmpty(needDeleteProcessIdList)) {
            return;
        }
        DeleteServiceHelper.delete((String)"eb_taskprocess", (QFilter[])new QFilter("id", "in", needDeleteProcessIdList).toArray());
        QFilter delAttachmentQFilter = new QFilter("taskproid", "in", needDeleteProcessIdList);
        delAttachmentQFilter.and("type", "=", (Object)AttachementTypeEnum.TEMPLATE.getValue());
        DeleteServiceHelper.delete((String)"eb_reportattachment", (QFilter[])delAttachmentQFilter.toArray());
    }

    public void deleteTaskProcess(Long subTaskId, Set<String> decomposeLongNumbers, Long modelId) {
        this.deleteTaskProcess(Sets.newHashSet((Object[])new Long[]{subTaskId}), decomposeLongNumbers, modelId);
    }

    public List<BaseRptProcessRequest> createReportProcess(Map<Long, Set<Long>> taskDispatchOrgIds) {
        Set<Long> subTaskIds = taskDispatchOrgIds.keySet();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_task", (String)"model,tasklist.id,tasklist.year,tasklist.version,tasklist.datatype,tasklist.orgview", (QFilter[])new QFilter("id", "in", subTaskIds).toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u5b50\u4efb\u52a1\u6240\u5c5e\u4efb\u52a1\u5305\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskDecomposeService_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        Set taskListIds = query.stream().map(e -> e.getLong("tasklist.id")).collect(Collectors.toSet());
        if (taskListIds.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u5b50\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u4e00\u4e2a\u4efb\u52a1\u5305\uff0c\u8bf7\u68c0\u67e5", (String)"TaskDecomposeService_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        Long modelId = ((DynamicObject)query.get(0)).getLong("model");
        Long year = ((DynamicObject)query.get(0)).getLong("tasklist.year");
        Long datatype = ((DynamicObject)query.get(0)).getLong("tasklist.datatype");
        Long version = ((DynamicObject)query.get(0)).getLong("tasklist.version");
        Long orgViewId = ((DynamicObject)query.get(0)).getLong("tasklist.orgview");
        Map<Long, Set<Long>> taskTemplateIdMap = this.getTemplateIdSet(subTaskIds);
        ArrayList<TemplateEntityDto> templateEntityDtoList = new ArrayList<TemplateEntityDto>(16);
        for (Map.Entry<Long, Set<Long>> entry : taskTemplateIdMap.entrySet()) {
            Set<Long> orgIds;
            Long subTaskId = entry.getKey();
            Set<Long> templateIds = entry.getValue();
            if (CollectionUtils.isEmpty(templateIds) || CollectionUtils.isEmpty(orgIds = taskDispatchOrgIds.get(subTaskId))) continue;
            for (Long templateId : templateIds) {
                for (Long orgId : orgIds) {
                    TemplateEntityDto templateEntityDto = new TemplateEntityDto(templateId, orgId, 10);
                    templateEntityDtoList.add(templateEntityDto);
                }
            }
        }
        return Collections.singletonList(new BaseRptProcessRequest(modelId, orgViewId, year, datatype, version, templateEntityDtoList));
    }

    private Map<Long, Set<Long>> getTemplateIdSet(Set<Long> taskIds) {
        HashMap<Long, Set<Long>> taskTemplateIdMap = new HashMap<Long, Set<Long>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.ftemplateid as templateId,b.fid as taskId from t_eb_taskreftemplate a, t_eb_task b where a.fid = b.fid and ", new Object[0]);
        sqlBuilder.appendIn("b.fid", taskIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"getTemplateIdSetByTaskIds", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Set templateIdSet = taskTemplateIdMap.computeIfAbsent(next.getLong("taskId"), e -> new HashSet(16));
                templateIdSet.add(next.getLong("templateId"));
            }
        }
        return taskTemplateIdMap;
    }

    public void distributionTaskProcess(Long modelId, List<Long> taskIds, List<Long> selOrgs, Map<String, TaskDecomposeRecord> taskOrgDecomposeMap) {
        if (IDUtils.isNull(modelId) || CollectionUtils.isEmpty(taskIds) || taskOrgDecomposeMap == null || taskOrgDecomposeMap.size() == 0) {
            return;
        }
        DynamicObjectCollection taskProcesses = new DynamicObjectCollection();
        DynamicObject taskProcess = null;
        String key = null;
        HashMap<String, DynamicObject> processMap = new HashMap<String, DynamicObject>();
        QFBuilder builder = new QFBuilder();
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"eb_task", (String)"id, tasklist, number, name, description, begintime, time, deadline, entryentity.templateid, entryentity.templatetype, entryentity.seq", (QFilter[])builder.add(new QFilter("id", "in", taskIds)).toArrays());
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return;
        }
        builder.clear();
        builder.add(new QFilter("task", "in", taskIds));
        DynamicObject[] exists = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"id, task, org,templatetype, template, executor, assigner, state, creater, createdate, modifier, modifydate", (QFilter[])builder.toArrays());
        if (exists != null && exists.length > 0) {
            for (DynamicObject exist : exists) {
                taskProcess = exist;
                if (taskProcess.get("task") == null || taskProcess.get("org") == null || taskProcess.get("template") == null) continue;
                key = taskProcess.getLong("task.id") + "_" + taskProcess.getLong("org.id") + "_" + taskProcess.getLong("template.id");
                processMap.put(key, taskProcess);
            }
        }
        Date date = new Date();
        Long userId = UserUtils.getUserId();
        for (DynamicObject task : tasks) {
            for (Long org : selOrgs) {
                key = task.getLong("id") + "_" + org + "_" + task.getLong("entryentity.templateid");
                String mapKey = task.getLong("id") + "_" + org;
                TaskDecomposeRecord taskDecomposeRecord = taskOrgDecomposeMap.get(mapKey);
                if (taskDecomposeRecord == null) continue;
                if (!processMap.containsKey(key)) {
                    taskProcess = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_taskprocess"));
                    taskProcess.set("task", (Object)task.getLong("id"));
                    taskProcess.set("org", (Object)org);
                    String string = task.getString("entryentity.templatetype").equals("1") || task.getString("entryentity.templatetype").equals("4") ? "eb_templateentity" : "bcm_templateentity";
                    taskProcess.set("templatetype", (Object)string);
                    taskProcess.set("template", (Object)task.getLong("entryentity.templateid"));
                    taskProcess.set("tempseq", (Object)task.getInt("entryentity.seq"));
                    DynamicObjectCollection executors = taskProcess.getDynamicObjectCollection("executors");
                    for (Long executor : taskDecomposeRecord.getExecutors()) {
                        DynamicObject object = new DynamicObject(executors.getDynamicObjectType());
                        object.set("fbasedataid_id", (Object)executor);
                        executors.add((Object)object);
                    }
                    taskProcess.set("orgview", (Object)taskDecomposeRecord.getOrgViewId());
                    DynamicObjectCollection dynamicObjects = taskProcess.getDynamicObjectCollection("entryentity");
                    Set<Long> supervisors = taskDecomposeRecord.getSupervisors();
                    for (Long supervisor : supervisors) {
                        DynamicObject object = new DynamicObject(dynamicObjects.getDynamicObjectType());
                        object.set("supervisor", (Object)supervisor);
                        dynamicObjects.add((Object)object);
                    }
                    taskProcess.set("state", (Object)BgTaskStateEnum.UNSTARTED.getNumber());
                    taskProcess.set("creater", (Object)userId);
                    taskProcess.set("createdate", (Object)date);
                    taskProcess.set("modifier", (Object)userId);
                    taskProcess.set("modifydate", (Object)date);
                    taskProcesses.add((Object)taskProcess);
                    continue;
                }
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add(new QFilter("task", "=", (Object)task.getLong("id")));
                qfBuilder.add(new QFilter("org", "=", (Object)org));
                qfBuilder.add(new QFilter("template", "=", (Object)task.getLong("entryentity.templateid")));
                DynamicObjectCollection ds = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id", (QFilter[])qfBuilder.toArrays());
                if (ds == null) continue;
                Object[] idsArr = new Long[ds.size()];
                for (int i = 0; i < ds.size(); ++i) {
                    idsArr[i] = ((DynamicObject)ds.get(i)).getLong("id");
                }
                DynamicObject[] processArr = BusinessDataServiceHelper.load((Object[])idsArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_taskprocess"));
                if (processArr == null || processArr.length == 0) continue;
                for (DynamicObject process : processArr) {
                    process.set("modifier", (Object)userId);
                    process.set("modifydate", (Object)date);
                    DynamicObjectCollection executors = process.getDynamicObjectCollection("executors");
                    executors.clear();
                    for (Long executor : taskDecomposeRecord.getExecutors()) {
                        DynamicObject object = new DynamicObject(executors.getDynamicObjectType());
                        object.set("fbasedataid_id", (Object)executor);
                        executors.add((Object)object);
                    }
                    DynamicObjectCollection dynamicObjects = process.getDynamicObjectCollection("entryentity");
                    dynamicObjects.clear();
                    Set<Long> supervisors = taskDecomposeRecord.getSupervisors();
                    for (Long supervisor : supervisors) {
                        DynamicObject object = new DynamicObject(dynamicObjects.getDynamicObjectType());
                        object.set("supervisor", (Object)supervisor);
                        dynamicObjects.add((Object)object);
                    }
                    taskProcesses.add((Object)process);
                }
            }
        }
        if (!taskProcesses.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])taskProcesses.toArray((Object[])new DynamicObject[0])));
        }
    }

    public TaskDecomposeRecord buildTaskDecomposeRecord(DynamicObject object, IModelCacheHelper modelCacheHelper) {
        DynamicObjectCollection supervisors;
        TaskDecomposeRecord taskDecomposeRecord = new TaskDecomposeRecord();
        taskDecomposeRecord.setId(object.getLong("id"));
        taskDecomposeRecord.setModelId(object.getLong("model.id"));
        taskDecomposeRecord.setSubTaskId(object.getLong("task.id"));
        taskDecomposeRecord.setOrgId(object.getLong("org.id"));
        taskDecomposeRecord.setOrgViewId(object.getLong("orgview.id"));
        taskDecomposeRecord.setParentDecomposeId(object.getLong("parentdecompose.id"));
        taskDecomposeRecord.setStatus(TaskDecomposeStatus.getEnumByValue(object.getString("status")));
        taskDecomposeRecord.setManagerId(object.getLong("manager.id"));
        DynamicObjectCollection executors = object.getDynamicObjectCollection("executors");
        if (CollectionUtils.isNotEmpty((Collection)executors)) {
            taskDecomposeRecord.setExecutors(executors.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(supervisors = object.getDynamicObjectCollection("supervisors")))) {
            taskDecomposeRecord.setSupervisors(supervisors.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet()));
        }
        String decomposeOrgLongNumber = object.getString("longnumber");
        taskDecomposeRecord.setDecomposeOrgLongNumber(decomposeOrgLongNumber);
        String[] split = decomposeOrgLongNumber.split(SIGN);
        if (split.length >= 2) {
            String rootEntityNumber = split[1];
            Member member = modelCacheHelper.getMember("Entity", (Long)object.getLong("orgview.id"), rootEntityNumber);
            if (member != null) {
                taskDecomposeRecord.setDecomposeRootOrgId(member.getId());
                taskDecomposeRecord.setDecomposeRootOrgNumber(member.getNumber());
            }
        }
        taskDecomposeRecord.setModifier(object.getLong("modifier.id"));
        taskDecomposeRecord.setModifyDate(object.getDate("modifydate"));
        return taskDecomposeRecord;
    }

    public List<Long> updateDecompose(Set<Long> oldExecutors, Long receiverId, List<Long> decomposeIds) {
        DynamicObject[] load;
        DynamicObject[] taskDecomposes = BusinessDataServiceHelper.load((Object[])decomposeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_taskdecompose_entity"));
        ArrayList<DynamicObject> needUpdates = new ArrayList<DynamicObject>(10);
        ArrayList<Long> needUpdateManagerIds = new ArrayList<Long>(10);
        for (DynamicObject taskDecompose : taskDecomposes) {
            DynamicObjectCollection executors = taskDecompose.getDynamicObjectCollection("executors");
            Set fbasedataid_id = executors.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toSet());
            boolean remove = fbasedataid_id.removeAll(oldExecutors);
            if (!remove) continue;
            fbasedataid_id.add(receiverId);
            executors.clear();
            for (Long userId : fbasedataid_id) {
                DynamicObject dynamicObject2 = executors.addNew();
                dynamicObject2.set("fbasedataid_id", (Object)userId);
            }
            taskDecompose.set("modifier", (Object)UserUtils.getUserId());
            taskDecompose.set("modifydate", (Object)new Date());
            needUpdates.add(taskDecompose);
            needUpdateManagerIds.add(taskDecompose.getLong("id"));
        }
        for (DynamicObject dynamicObject3 : load = BusinessDataServiceHelper.load((String)"eb_taskdecompose_entity", (String)"id,manager", (QFilter[])new QFilter("parentdecompose", "in", needUpdateManagerIds).toArray())) {
            dynamicObject3.set("manager", (Object)receiverId);
        }
        SaveServiceHelper.save((DynamicObject[])load);
        SaveServiceHelper.save((DynamicObject[])needUpdates.toArray(new DynamicObject[0]));
        return needUpdateManagerIds;
    }

    public List<Long> queryDecomposeByTaskAndOrg(Set<String> taskOrgSet) {
        HashSet<Long> taskIds = new HashSet<Long>(taskOrgSet.size());
        HashSet<Long> orgIds = new HashSet<Long>(taskOrgSet.size());
        for (String string : taskOrgSet) {
            String[] split;
            if (StringUtils.isEmpty((CharSequence)string) || (split = string.split("_")).length != 2) continue;
            taskIds.add(IDUtils.toLong(split[0]));
            orgIds.add(IDUtils.toLong(split[1]));
        }
        QFilter qFilter = new QFilter("task", "in", taskIds);
        qFilter.and("org", "in", orgIds);
        qFilter.and("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObjectCollection taskDecomposes = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"id,task,org", (QFilter[])qFilter.toArray());
        ArrayList<Long> decomposeIds = new ArrayList<Long>(taskDecomposes.size());
        for (DynamicObject dynamicObject : taskDecomposes) {
            String taskOrg = dynamicObject.getString("task") + "_" + dynamicObject.getString("org");
            if (!taskOrgSet.contains(taskOrg)) continue;
            decomposeIds.add(dynamicObject.getLong("id"));
        }
        return decomposeIds;
    }

    public int updateTaskProcessSupervisors(Set<Long> suaTaskIds, Map<Long, Set<Long>> orgToSupervisors) {
        QFilter qFilter = new QFilter("task", "in", suaTaskIds);
        qFilter.and("org", "in", orgToSupervisors.keySet());
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"entryentity.supervisor,org", (QFilter[])qFilter.toArray());
        if (objects == null || objects.length == 0) {
            return 0;
        }
        int i = 0;
        for (DynamicObject object : objects) {
            Long orgId = object.getLong("org.id");
            DynamicObjectCollection supervisors = object.getDynamicObjectCollection("entryentity");
            supervisors.clear();
            Set<Long> supervisorIds = orgToSupervisors.get(orgId);
            if (CollectionUtils.isNotEmpty(supervisorIds)) {
                for (Long supervisorId : supervisorIds) {
                    DynamicObject _row = supervisors.addNew();
                    _row.set("supervisor", (Object)supervisorId);
                }
            }
            ++i;
        }
        if (i > 0) {
            SaveServiceHelper.save((DynamicObject[])objects);
        }
        return i;
    }

    public Map<Long, Set<String>> getUserManageTaskOrg(Long modelId, Long userId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("manager", "=", (Object)userId);
        qFilter.and("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObjectCollection taskDecomposes = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"task,longnumber", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)taskDecomposes)) {
            return null;
        }
        HashSet<Long> taskIds = new HashSet<Long>(16);
        HashMap<Long, Set> taskOrgDecomposePathMap = new HashMap<Long, Set>(16);
        for (DynamicObject taskDecompose : taskDecomposes) {
            Long task = taskDecompose.getLong("task");
            taskIds.add(task);
            taskOrgDecomposePathMap.computeIfAbsent(task, e -> new HashSet()).add(taskDecompose.getString("longnumber"));
        }
        HashMap<Long, Set<String>> manageTaskOrg = new HashMap<Long, Set<String>>(16);
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId).and("task", "in", taskIds);
        qFilter1.and("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"task.tasklist,task,org,longnumber", (QFilter[])qFilter1.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject taskDecompose : query) {
                Long subTskId = taskDecompose.getLong("task");
                String orgDecomposePath = taskDecompose.getString("longnumber");
                Set taskOrgDecomposePaths = (Set)taskOrgDecomposePathMap.get(subTskId);
                if (taskOrgDecomposePaths == null) continue;
                if (!taskOrgDecomposePaths.stream().anyMatch(orgDecomposePath::startsWith)) continue;
                Set taskOrgSet = manageTaskOrg.computeIfAbsent(taskDecompose.getLong("task.tasklist"), e -> new HashSet());
                taskOrgSet.add(subTskId + "_" + taskDecompose.getString("org"));
            }
        }
        return manageTaskOrg;
    }

    public Set<String> getTaskDecomposeDispatchOrgNumbers(Set<Long> taskIds) {
        QFilter qFilter = new QFilter("task", "in", taskIds);
        qFilter.and("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        qFilter.and("parentdecompose", "!=", (Object)0L);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"org.number", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return query.stream().map(e -> e.getString("org.number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public void updateApproveBill(List<Long> updateDecomposeIds, Long receiverId, Set<Long> oldExecutors) {
        DynamicObject[] decomposes = BusinessDataServiceHelper.load((Object[])updateDecomposeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_taskdecompose_entity"));
        HashSet<Long> approveIds = new HashSet<Long>(decomposes.length);
        for (DynamicObject decompose : decomposes) {
            Long approveBill = this.queryApproveBill(decompose, oldExecutors);
            if (!IDUtils.isNotNull(approveBill)) continue;
            approveIds.add(approveBill);
        }
        if (CollectionUtils.isNotEmpty(approveIds)) {
            DynamicObject[] approvebills;
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)receiverId, (String)"bos_user");
            Map<String, Object> userInfoData = BasicInfoHelper.getUserInfoData(user, true);
            for (DynamicObject approvebill : approvebills = BusinessDataServiceHelper.load((Object[])approveIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))) {
                approvebill.set("createrid", (Object)receiverId);
                approvebill.set("createorgid", userInfoData.get("company"));
                approvebill.set("department", userInfoData.get("department"));
                approvebill.set("position", userInfoData.get("position"));
            }
            SaveServiceHelper.save((DynamicObject[])approvebills);
        }
    }

    private Long queryApproveBill(DynamicObject decompose, Set<Long> oldExecutors) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)decompose.getLong("task.id"), (String)"eb_task");
        DynamicObjectCollection entryentity = task.getDynamicObjectCollection("entryentity");
        Set templateid = entryentity.stream().map(dyObj -> dyObj.getLong("templateid")).collect(Collectors.toSet());
        long orgId = decompose.getLong("org.id");
        QFilter qFilter = new QFilter("modelid", "=", (Object)decompose.getLong("model.id"));
        qFilter.and("dim_period", "=", (Object)task.getLong("tasklist.year.id"));
        qFilter.and("dim_version", "=", (Object)task.getLong("tasklist.version.id"));
        qFilter.and("dim_datatype", "=", (Object)task.getLong("tasklist.datatype.id"));
        qFilter.and("entryentity.tempid", "in", templateid);
        qFilter.and("eborgid", "=", (Object)orgId);
        qFilter.and("rptprocesstype", "=", (Object)"1");
        qFilter.and("source", "=", (Object)task.getLong("tasklist.id"));
        qFilter.and("createrid", "in", oldExecutors);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"id", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public boolean existDecomposeRecord(Long parentDecomposeId, Long taskId, Long orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        if (parentDecomposeId != null) {
            qFilters.add(new QFilter("parentdecompose", "=", (Object)parentDecomposeId));
        }
        if (taskId != null) {
            qFilters.add(new QFilter("task", "=", (Object)taskId));
        }
        if (orgId != null) {
            qFilters.add(new QFilter("org", "=", (Object)orgId));
        }
        return QueryServiceHelper.exists((String)"eb_taskdecompose_entity", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public Set<String> getCurTaskDecomposeOrgNumber(Long taskId) {
        QFilter qFilter = new QFilter("task", "=", (Object)taskId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"org.number", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashSet<String> decomposeOrgNumbers = new HashSet<String>(query.size());
            for (DynamicObject object : query) {
                String orgNumber = object.getString("org.number");
                if (!StringUtils.isNotEmpty((CharSequence)orgNumber)) continue;
                decomposeOrgNumbers.add(orgNumber);
            }
            return decomposeOrgNumbers;
        }
        return new HashSet<String>(0);
    }

    public void updateProcessRelUserOfLeafDeSelf(Long taskId, Long orgId, boolean updateExecutor, boolean updateSuperVisor) {
        DynamicObject[] objects;
        HashSet<Long> supervisorIds = new HashSet<Long>(5);
        HashSet<Long> executorIds = new HashSet<Long>(5);
        QFilter taskQFilter = new QFilter("task", "=", (Object)taskId);
        QFilter orgQFilter = new QFilter("org", "=", (Object)orgId);
        QFilter decomposedFilter = new QFilter("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObjectCollection taskDecomposes = QueryServiceHelper.query((String)"eb_taskdecompose_entity", (String)"supervisors.fbasedataid_id,executors.fbasedataid_id", (QFilter[])new QFilter[]{decomposedFilter, taskQFilter, orgQFilter});
        if (CollectionUtils.isNotEmpty((Collection)taskDecomposes)) {
            for (DynamicObject taskDecompose : taskDecomposes) {
                Long id;
                if (updateExecutor && IDUtils.isNotEmptyLong(id = Long.valueOf(taskDecompose.getLong("executors.fbasedataid_id"))).booleanValue()) {
                    executorIds.add(id);
                }
                if (!updateSuperVisor || !IDUtils.isNotEmptyLong(id = Long.valueOf(taskDecompose.getLong("supervisors.fbasedataid_id"))).booleanValue()) continue;
                supervisorIds.add(id);
            }
        }
        if ((objects = BusinessDataServiceHelper.load((String)"eb_taskprocess", (String)"executors,entryentity.supervisor", (QFilter[])new QFilter[]{taskQFilter, orgQFilter})) != null && objects.length > 0) {
            for (DynamicObject object : objects) {
                if (updateExecutor) {
                    DynamicObjectCollection proExecutors = object.getDynamicObjectCollection("executors");
                    proExecutors.clear();
                    executorIds.forEach(e -> proExecutors.addNew().set("fbasedataid_id", e));
                }
                if (!updateExecutor) continue;
                DynamicObjectCollection proSupervisors = object.getDynamicObjectCollection("entryentity");
                proSupervisors.clear();
                supervisorIds.forEach(e -> proSupervisors.addNew().set("supervisor", e));
            }
            SaveServiceHelper.save((DynamicObject[])objects);
        }
    }

    private static boolean isParentInRange(Set<String> parentLongNumbers, String curLongNumber, String splitSign) {
        String pLongNumber = curLongNumber;
        int lastIndexOf = pLongNumber.lastIndexOf(splitSign);
        while (lastIndexOf != -1) {
            if (parentLongNumbers.contains((pLongNumber = pLongNumber.substring(0, lastIndexOf)) + splitSign)) {
                return true;
            }
            lastIndexOf = pLongNumber.lastIndexOf(splitSign);
        }
        return false;
    }
}

