/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.task.TaskDecomposeStatus;
import kd.epm.eb.common.enums.task.TaskDispatchSaveSourceEnum;
import kd.epm.eb.common.enums.task.TaskDispatchStatusEnum;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.task.TaskDecomposeRecord;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.task.TaskDecomposeService;
import org.apache.commons.collections4.CollectionUtils;

public class TaskDispatchService {
    public static TaskDispatchService getInstance() {
        return new TaskDispatchService();
    }

    public Map<Long, Map<Long, Long>> getTaskDecomposeDispatchedRootOrg(Set<Long> executeSubTaskIds, Set<Long> orgIds, Long modelId) {
        HashMap<Long, Map<Long, Long>> taskDecomposeDispatchOrgIds = new HashMap<Long, Map<Long, Long>>();
        QFilter qFilter = new QFilter("task", "in", executeSubTaskIds);
        qFilter.and("parentdecompose", "!=", (Object)0L);
        qFilter.and("status", "=", (Object)"1");
        List<TaskDecomposeRecord> taskDecomposeRecord = TaskDecomposeService.getInstance().getTaskDecomposeRecord(qFilter, modelId);
        for (TaskDecomposeRecord decomposeRecord : taskDecomposeRecord) {
            Long subTaskId = decomposeRecord.getSubTaskId();
            if (!orgIds.contains(decomposeRecord.getDecomposeRootOrgId())) continue;
            Map decomposeOrgToRootOrgMap = taskDecomposeDispatchOrgIds.computeIfAbsent(subTaskId, e -> new HashMap());
            decomposeOrgToRootOrgMap.put(decomposeRecord.getOrgId(), decomposeRecord.getDecomposeRootOrgId());
        }
        return taskDecomposeDispatchOrgIds;
    }

    public void saveTaskDecomposeRootRecord(Long modelId, Set<Long> subTaskIds, Set<Long> executeOrgIds) {
        QFilter qFilter1 = new QFilter("org", "in", executeOrgIds).and("task", "in", subTaskIds);
        qFilter1.and("status", "=", (Object)TaskDecomposeStatus.DECOMPOSED.getValue());
        DynamicObject[] existTaskDecomposeRecord = BusinessDataServiceHelper.load((String)"eb_taskdecompose_entity", (String)"org,task,modifydate", (QFilter[])qFilter1.toArray());
        HashMap<String, DynamicObject> taskDecomposeRecordMap = new HashMap<String, DynamicObject>(16);
        if (existTaskDecomposeRecord != null && existTaskDecomposeRecord.length > 0) {
            for (DynamicObject object : existTaskDecomposeRecord) {
                taskDecomposeRecordMap.put(object.getString("task.id") + "_" + object.getString("org.id"), object);
            }
        }
        QFilter qFilter2 = new QFilter("taskid", "in", subTaskIds).and("distorg", "in", executeOrgIds);
        DynamicObject[] taskDispatchSaveRecord = BusinessDataServiceHelper.load((String)"eb_taskdispatchsave", (String)"distorg,taskid,entryentity.supervisor,executors,orgview", (QFilter[])qFilter2.toArray());
        Long userId = UserUtils.getUserId();
        Date date = new Date();
        ArrayList<DynamicObject> taskDecomposeRecord = new ArrayList<DynamicObject>(10);
        for (DynamicObject object : taskDispatchSaveRecord) {
            long taskId = object.getLong("taskid.id");
            long orgId = object.getLong("distorg.id");
            DynamicObject _decomposeRecord = (DynamicObject)taskDecomposeRecordMap.get(taskId + "_" + orgId);
            if (_decomposeRecord == null) {
                _decomposeRecord = BusinessDataServiceHelper.newDynamicObject((String)"eb_taskdecompose_entity");
                taskDecomposeRecord.add(_decomposeRecord);
                _decomposeRecord.set("org", (Object)orgId);
                _decomposeRecord.set("status", (Object)"1");
                _decomposeRecord.set("task", (Object)taskId);
                _decomposeRecord.set("manager", (Object)userId);
                DynamicObjectCollection supervisor = _decomposeRecord.getDynamicObjectCollection("supervisors");
                DynamicObjectCollection entries = object.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    DynamicObject _supervisor = supervisor.addNew();
                    _supervisor.set("fbasedataid_id", (Object)entry.getLong("supervisor.id"));
                }
                DynamicObjectCollection executors = _decomposeRecord.getDynamicObjectCollection("executors");
                DynamicObjectCollection dispExecutors = object.getDynamicObjectCollection("executors");
                for (DynamicObject dispExecutor : dispExecutors) {
                    DynamicObject _executor = executors.addNew();
                    _executor.set("fbasedataid_id", (Object)dispExecutor.getLong("fbasedataid_id"));
                }
                _decomposeRecord.set("model", (Object)modelId);
                _decomposeRecord.set("orgview", (Object)object.getLong("orgview.id"));
                _decomposeRecord.set("longnumber", (Object)("|" + object.getString("distorg.number") + "|"));
            }
            _decomposeRecord.set("modifydate", (Object)date);
        }
        if (!taskDecomposeRecordMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])taskDecomposeRecordMap.values().toArray(new DynamicObject[0]));
        }
        if (!taskDecomposeRecord.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])taskDecomposeRecord.toArray(new DynamicObject[0]));
        }
    }

    public void updateTaskDispatchSaveRecord(TaskDispatchStatusEnum updateToStatus, Long taskPackageId, Set<Long> subTaskIds, Set<Long> executeOrgIds, Map<String, DynamicObject> taskDispatchRecord) {
        subTaskIds.add(taskPackageId);
        QFilter qFilter = new QFilter("taskid", "in", subTaskIds);
        qFilter.and("distorg", "in", executeOrgIds);
        DynamicObject[] taskDispatchSaveRecord = BusinessDataServiceHelper.load((String)"eb_taskdispatchsave", (String)"taskstatus,taskid,distorg,executors,sourcetype", (QFilter[])qFilter.toArray());
        if (taskDispatchSaveRecord != null && taskDispatchSaveRecord.length > 0) {
            for (DynamicObject object : taskDispatchSaveRecord) {
                if (taskDispatchRecord != null && object.getString("taskid.id") != null) {
                    this.updateSubTaskExecutors(taskDispatchRecord, object);
                }
                object.set("taskstatus", (Object)updateToStatus.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])taskDispatchSaveRecord);
        }
    }

    private void updateSubTaskExecutors(Map<String, DynamicObject> taskDispatchRecord, DynamicObject object) {
        TaskDispatchSaveSourceEnum sourceType = TaskDispatchSaveSourceEnum.getEnumByValue(object.getString("sourcetype"));
        String task_org = object.getString("taskid.id") + "_" + object.getString("distorg.id");
        if (sourceType == TaskDispatchSaveSourceEnum.TASK_PACKAGE && taskDispatchRecord.containsKey(task_org)) {
            DynamicObjectCollection executors = object.getDynamicObjectCollection("executors");
            executors.clear();
            DynamicObjectCollection taskPackExecutors = taskDispatchRecord.get(task_org).getDynamicObjectCollection("executors");
            if (CollectionUtils.isNotEmpty((Collection)taskPackExecutors)) {
                for (DynamicObject taskPackExecutor : taskPackExecutors) {
                    DynamicObject executor = executors.addNew();
                    executor.set("fbasedataid_id", (Object)taskPackExecutor.getLong("fbasedataid_id"));
                }
            }
        }
    }

    public void deleteTaskProcess(Set<Long> subTaskIds, Set<Long> orgIds, Long modelId, Long entityViewId) {
        Set<String> decomposeLongNumbers = this.getDecomposeLongNumber(orgIds, modelId, entityViewId);
        TaskDecomposeService.getInstance().deleteTaskProcess(subTaskIds, decomposeLongNumbers, modelId);
    }

    public void deleteTaskDecomposeDispatchRecord(Set<Long> subTaskIds, Set<Long> orgIds, Long modelId, Long entityViewId) {
        Set<String> decomposeLongNumbers = this.getDecomposeLongNumber(orgIds, modelId, entityViewId);
        TaskDecomposeService.getInstance().deleteTaskDecomposeDispatchRecord(subTaskIds, decomposeLongNumbers, modelId);
    }

    public List<BaseRptProcessRequest> createReportProcess(Set<Long> taskIds, Long modelId, Set<Long> orgIds, Long entityViewId) {
        TaskDecomposeService instance = TaskDecomposeService.getInstance();
        Set<String> decomposeLongNumbers = this.getDecomposeLongNumber(orgIds, modelId, entityViewId);
        Map<Long, Set<Long>> taskDecomposeDispatchedOrgIds = instance.getTaskDecomposeDispatchedOrgIds(taskIds, decomposeLongNumbers, modelId);
        for (Long taskId : taskIds) {
            Set dispatchOrgIds = taskDecomposeDispatchedOrgIds.computeIfAbsent(taskId, e -> new HashSet(16));
            dispatchOrgIds.addAll(orgIds);
        }
        return instance.createReportProcess(taskDecomposeDispatchedOrgIds);
    }

    public List<BaseRptProcessRequest> checkExistRelApproveBill(Set<Long> subTaskIds, Set<Long> orgIds, Long modelId, Long orgViewId) {
        Set<String> decomposeLongNumbers = this.getDecomposeLongNumber(orgIds, modelId, orgViewId);
        return TaskDecomposeService.getInstance().checkBeforeCancelDecomposeDispatch(subTaskIds, decomposeLongNumbers, modelId, true);
    }

    public void deleteTaskDispatchData(Set<Long> subTaskIds, Set<Long> orgIds) {
        QFilter qFilter = new QFilter("taskid", "in", subTaskIds);
        qFilter.and("distorg", "in", orgIds);
        DeleteServiceHelper.delete((String)"eb_taskorg", (QFilter[])qFilter.toArray());
    }

    public Set<String> getDecomposeLongNumber(Set<Long> orgIds, Long modelId, Long entityViewId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        HashSet<String> decomposeLongNumbers = new HashSet<String>(16);
        for (Long orgId : orgIds) {
            Member member = modelCacheHelper.getMember("Entity", entityViewId, orgId);
            if (member == null) continue;
            decomposeLongNumbers.add("|" + member.getNumber() + "|");
        }
        return decomposeLongNumbers;
    }

    public int updateTaskProcessSupervisors(Set<Long> suaTaskIds, Map<Long, Set<Long>> orgToSupervisors) {
        return TaskDecomposeService.getInstance().updateTaskProcessSupervisors(suaTaskIds, orgToSupervisors);
    }

    public int updateTaskDecomposeSupervisors(Set<Long> taskIds, Map<Long, Set<Long>> orgToSupervisors) {
        QFilter qFilter = new QFilter("task", "in", taskIds);
        qFilter.and("org", "in", orgToSupervisors.keySet());
        DynamicObject[] taskDecomposes = BusinessDataServiceHelper.load((String)"eb_taskdecompose_entity", (String)"id,task,org,supervisors", (QFilter[])qFilter.toArray());
        if (taskDecomposes == null || taskDecomposes.length == 0) {
            return 0;
        }
        int i = 0;
        for (DynamicObject taskDecompose : taskDecomposes) {
            Long orgId = taskDecompose.getLong("org.id");
            DynamicObjectCollection supervisors = taskDecompose.getDynamicObjectCollection("supervisors");
            supervisors.clear();
            Set<Long> supervisorIds = orgToSupervisors.get(orgId);
            if (CollectionUtils.isNotEmpty(supervisorIds)) {
                for (Long supervisorId : supervisorIds) {
                    DynamicObject _row = supervisors.addNew();
                    _row.set("fbasedataid_id", (Object)supervisorId);
                }
            }
            ++i;
        }
        if (i > 0) {
            SaveServiceHelper.save((DynamicObject[])taskDecomposes);
        }
        return i;
    }

    public int updateTaskDisOrgSupervisors(Set<Long> suaTaskIds, Map<Long, Set<Long>> orgToSupervisors) {
        QFilter qFilter = new QFilter("taskid", "in", suaTaskIds);
        qFilter.and("distorg", "in", orgToSupervisors.keySet());
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"eb_taskorg", (String)"entryentity.supervisor,distorg", (QFilter[])qFilter.toArray());
        if (objects == null || objects.length == 0) {
            return 0;
        }
        int i = 0;
        for (DynamicObject object : objects) {
            Long orgId = object.getLong("distorg.id");
            DynamicObjectCollection supervisors = object.getDynamicObjectCollection("entryentity");
            supervisors.clear();
            Set<Long> supervisorIds = orgToSupervisors.get(orgId);
            if (CollectionUtils.isNotEmpty(supervisorIds)) {
                for (Long supervisorId : supervisorIds) {
                    DynamicObject _row = supervisors.addNew();
                    _row.set("supervisor", (Object)supervisorId);
                }
            }
            ++i;
        }
        if (i > 0) {
            SaveServiceHelper.save((DynamicObject[])objects);
        }
        return i;
    }

    public Set<String> getTaskDispatchSaveOrgNumbers(Set<Long> taskIds) {
        QFilter qFilters = new QFilter("taskid", "in", taskIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskdispatchsave", (String)"distorg.number", (QFilter[])qFilters.toArray());
        if (query != null && !query.isEmpty()) {
            return query.stream().map(e -> e.getString("distorg.number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public void updateTaskDispatchExecutors(Set<Long> oldExecutors, Long receiverId, Set<String> taskOrgSet) {
        if (CollectionUtils.isEmpty(oldExecutors) || IDUtils.isEmptyLong(receiverId).booleanValue() || CollectionUtils.isEmpty(taskOrgSet)) {
            throw new KDBizException("There are illegal parameters.");
        }
        HashSet<Long> taskIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        taskOrgSet.forEach(e -> {
            String[] split = e.split("_");
            if (split.length == 2) {
                taskIds.add(IDUtils.toLong(split[0]));
                orgIds.add(IDUtils.toLong(split[1]));
            }
        });
        this.updateTaskDispatchExecutors(oldExecutors, receiverId, taskOrgSet, taskIds, orgIds, "eb_taskdispatchsave");
        this.updateTaskDispatchExecutors(oldExecutors, receiverId, taskOrgSet, taskIds, orgIds, "eb_taskorg");
    }

    private void updateTaskDispatchExecutors(Set<Long> oldExecutors, Long receiverId, Set<String> taskOrgSet, Set<Long> taskIds, Set<Long> orgIds, String entityKey) {
        QFilter qFilter = new QFilter("distorg", "in", orgIds).and("taskid", "in", taskIds);
        DynamicObject[] query = BusinessDataServiceHelper.load((String)entityKey, (String)"distorg,taskid,executors", (QFilter[])qFilter.toArray());
        if (query == null || query.length == 0) {
            return;
        }
        ArrayList<DynamicObject> needUpdate = new ArrayList<DynamicObject>(10);
        for (DynamicObject object : query) {
            Set executorIds;
            boolean exist;
            String taskId_orgId = object.getString("taskid.id") + "_" + object.getString("distorg.id");
            DynamicObjectCollection executors = object.getDynamicObjectCollection("executors");
            if (!taskOrgSet.contains(taskId_orgId) || CollectionUtils.isEmpty((Collection)executors) || !(exist = (executorIds = executors.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toSet())).removeAll(oldExecutors))) continue;
            executorIds.add(receiverId);
            executors.clear();
            for (Long executorId : executorIds) {
                DynamicObject executor = executors.addNew();
                executor.set("fbasedataid_id", (Object)executorId);
            }
            needUpdate.add(object);
        }
        if (!needUpdate.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
        }
    }

    public Set<Long> getTaskDispatchOrgIds(Long subTaskId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_taskprocess", (String)"org", (QFilter[])new QFilter("task", "=", (Object)subTaskId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashSet<Long> orgIds = new HashSet<Long>(query.size());
            for (DynamicObject object : query) {
                orgIds.add(object.getLong("org"));
            }
            return orgIds;
        }
        return new HashSet<Long>(0);
    }
}

