/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.threadpool;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class EBThreadPoolExecutor
implements ExecutorService {
    private ExecutorService executorService;
    private ThreadPoolExecutor poolExecutor;

    public EBThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory());
    }

    public EBThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public EBThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public EBThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this.poolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.poolExecutor.allowCoreThreadTimeOut(true);
        this.wrapExecutor(this.poolExecutor);
    }

    public ThreadPoolExecutor getPoolExecutor() {
        return this.poolExecutor;
    }

    public static void executeOnce(Runnable r, String name) {
        ThreadPools.executeOnce((String)name, (Runnable)r);
    }

    public static Future<Object> executeOnce(Callable<Object> callable, String name) {
        FutureTask<Object> futureTask = new FutureTask<Object>(EBThreadPoolExecutor.wrapCallable(callable));
        new Thread(futureTask, name).start();
        return futureTask;
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(EBThreadPoolExecutor.wrapRunnable(command));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(EBThreadPoolExecutor.wrapRunnable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(EBThreadPoolExecutor.wrapRunnable(task), result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(EBThreadPoolExecutor.wrapCallable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    private void wrapExecutor(ThreadPoolExecutor executor) {
        this.executorService = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)executor);
    }

    private static Runnable wrapRunnable(Runnable command) {
        command = new RequestContextRunnable(command, RequestContextCreator.createForThreadPool());
        return command;
    }

    private static Callable wrapCallable(Callable callable) {
        return ThreadLifeCycleManager.wrapCallable(new RequestContextCallable(callable, RequestContextCreator.createForThreadPool()));
    }

    private static class RequestContextCallable<T>
    implements Callable<T> {
        private final RequestContext rc;
        private final Callable<T> task;

        public RequestContextCallable(Callable<T> task, RequestContext rc) {
            this.task = task;
            this.rc = rc;
        }

        @Override
        public T call() throws Exception {
            RequestContextCreator.restoreForThreadPool((RequestContext)this.rc);
            try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)"RequestContextCallable");){
                span.addTag("tenantId", this.rc.getTenantId());
                span.addTag("accountId", this.rc.getAccountId());
                T t = this.task.call();
                return t;
            }
        }
    }
}

