/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.epm.eb.common.utils.StringUtils;

public class TreeNodeUtils {
    public static void getChildrenNodeIds(TreeNode node, Collection<String> nodeIds) {
        if (node == null || nodeIds == null) {
            return;
        }
        nodeIds.add(node.getId());
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                TreeNodeUtils.getChildrenNodeIds(child, nodeIds);
            }
        }
    }

    public static void getParentIds(String nodeId, TreeNode treeNode, Collection<String> parentIds) {
        if (nodeId == null || treeNode == null) {
            return;
        }
        TreeNodeUtils.getParentIds(treeNode.getTreeNode(nodeId), treeNode, parentIds);
    }

    private static void getParentIds(TreeNode node, TreeNode treeNode, Collection<String> parentIds) {
        if (node == null || treeNode == null) {
            return;
        }
        TreeNode parent = treeNode.getTreeNode(node.getParentid());
        if (parent != null) {
            parentIds.add(parent.getId());
            TreeNodeUtils.getParentIds(parent, treeNode, parentIds);
        }
    }

    public static List<String> getParentIds(String nodeId, Map<String, String> allParentIds) {
        if (StringUtils.isEmpty(nodeId)) {
            return Collections.emptyList();
        }
        ArrayList<String> parentIds = new ArrayList<String>();
        TreeNodeUtils.getParentIds(nodeId, parentIds, allParentIds);
        return parentIds;
    }

    public static void getParentIds(String nodeId, List<String> parentIds, Map<String, String> allParentIds) {
        if (StringUtils.isEmpty(nodeId)) {
            return;
        }
        String parentId = allParentIds.get(nodeId);
        if (StringUtils.isNotEmpty(parentId)) {
            parentIds.add(parentId);
            TreeNodeUtils.getParentIds(parentId, parentIds, allParentIds);
        }
    }
}

