/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.viewgroup;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;

public class ViewGroupServiceHelper {
    public static final String EB_DIMENSIONVIEW_GROUP = "eb_dimensionview_group";
    private static final ViewGroupServiceHelper instance = new ViewGroupServiceHelper();

    public static ViewGroupServiceHelper getInstance() {
        return instance;
    }

    public Set<Long> getAllViewByGroupId(List<Long> groupIds) {
        Set<Long> ids = this.getAllGroup(groupIds);
        Map views = BusinessDataServiceHelper.loadFromCache((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter("viewgroup", "in", ids).toArray());
        if (CollectionUtils.isEmpty(views)) {
            return Collections.emptySet();
        }
        return views.values().stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getAllGroup(List<Long> sourceGroupIds) {
        HashSet ids = Sets.newHashSet(sourceGroupIds);
        Map query = BusinessDataServiceHelper.loadFromCache((String)EB_DIMENSIONVIEW_GROUP, (String)"id", (QFilter[])new QFilter("parent", "in", sourceGroupIds).toArray());
        if (CollectionUtils.isNotEmpty(query)) {
            query.values().forEach(x -> ids.add(x.getLong("id")));
        }
        return ids;
    }

    public Set<Long> getViewsByViewId(long viewId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        DynamicObject viewGroup = dynamicObject.getDynamicObject("viewgroup");
        String type = viewGroup.getString("type");
        long sourceGroupId = "1".equals(type) ? viewGroup.getLong("id") : viewGroup.getLong("parent.id");
        return this.getAllViewByGroupId(Collections.singletonList(sourceGroupId));
    }

    public Set<Long> getViewGroupIdByViewId(long viewId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        DynamicObject viewgroup = dynamicObject.getDynamicObject("viewgroup");
        String type = viewgroup.getString("type");
        long sourceGroupId = "1".equals(type) ? viewgroup.getLong("id") : viewgroup.getLong("parent.id");
        return this.getAllGroup(Collections.singletonList(sourceGroupId));
    }

    public long getViewGroupByViewId(long viewId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
        DynamicObject viewgroup = dynamicObject.getDynamicObject("viewgroup");
        String type = viewgroup.getString("type");
        long sourceGroupId = "1".equals(type) ? viewgroup.getLong("id") : viewgroup.getLong("parent.id");
        return sourceGroupId;
    }

    public boolean isSameGroupIdByViews(List<Long> viewIds) {
        DynamicObject[] viewObjs = BusinessDataServiceHelper.load((String)"eb_dimensionview", (String)"viewgroup", (QFilter[])new QFilter("id", "in", viewIds).toArray());
        if (viewObjs == null || viewObjs.length == 0) {
            return true;
        }
        Set viewGroupIds = Arrays.stream(viewObjs).map(obj -> obj.getLong("viewgroup_id")).collect(Collectors.toSet());
        if (viewGroupIds.size() == 1) {
            return true;
        }
        DynamicObject[] viewGroupObjs = BusinessDataServiceHelper.load((String)EB_DIMENSIONVIEW_GROUP, (String)"id, type, parent", (QFilter[])new QFilter("id", "in", viewGroupIds).toArray());
        HashSet groupIds = new HashSet(2);
        Arrays.stream(viewGroupObjs).forEach(obj -> {
            String type = obj.getString("type");
            long id = obj.getLong("id");
            long parent = obj.getLong("parent.id");
            if ("2".equals(type)) {
                groupIds.add(parent);
            } else {
                groupIds.add(id);
            }
        });
        return groupIds.size() == 1;
    }
}

