/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.var;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.variable.VariableCacheService;
import kd.epm.eb.common.dao.variable.VariableDto;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.var.TemplateVarCommonUtil;
import kd.epm.eb.common.var.VarException;
import org.apache.commons.collections4.CollectionUtils;

public class ReportVarUtil {
    private static Log log = LogFactory.getLog(ReportVarUtil.class);

    public static String transVarNumToRealNum(Long modelId, String dimNumber, String varNumber, Map<String, Map<String, String>> varValues, String msg) {
        if (!TemplateVarCommonUtil.checkIsVar(varNumber, dimNumber).booleanValue() || varValues == null) {
            return varNumber;
        }
        if (!varValues.containsKey(dimNumber)) {
            throw new VarException(msg);
        }
        Map<String, String> varValueMap = varValues.get(dimNumber);
        String realNumberOrSameUnKnownFuckingMsg = ReportVarUtil.transVarNumToRealNumz(modelId, dimNumber, varNumber, varValueMap, msg);
        if (realNumberOrSameUnKnownFuckingMsg.contains("!")) {
            String errMsg = realNumberOrSameUnKnownFuckingMsg.split("!")[1];
            throw new VarException(errMsg);
        }
        return realNumberOrSameUnKnownFuckingMsg;
    }

    private static String transVarNumToRealNumz(Long modelId, String dimNumber, String varNumber, Map<String, String> varValueMap, String msg) {
        String[] str;
        if (varValueMap == null || varValueMap.size() == 0) {
            return ReportVarUtil.getErrInfo(dimNumber, varNumber, msg);
        }
        String returnStr = null;
        String num = varNumber;
        if (varNumber.indexOf("+") > 0) {
            str = varNumber.split("[+]");
            num = str[0].trim();
        }
        if (varNumber.indexOf("-") > 0) {
            str = varNumber.split("-");
            num = str[0].trim();
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && (varNumber.startsWith("@NextY") || varNumber.startsWith("@BaseY") || varNumber.startsWith("@LastY"))) {
            returnStr = ReportVarUtil.getRealNumber(dimNumber, varNumber, varValueMap, modelId, msg);
            if (returnStr.contains("!")) {
                return returnStr;
            }
            returnStr = ReportVarUtil.getOff(modelId, returnStr);
        } else {
            String varNumberName = ReportVarUtil.getMatchVarValue(num, varValueMap);
            String[] varSingleNumberName = varNumberName.split("!");
            if (varSingleNumberName == null) {
                return ReportVarUtil.getErrInfo(dimNumber, num, msg);
            }
            String varValue = varValueMap.get(varNumberName);
            if (varValue == null) {
                return ReportVarUtil.getErrInfo(dimNumber, num, msg);
            }
            String fomulaStr = varNumber.replace(varSingleNumberName[0], varValue);
            returnStr = SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) ? ReportVarUtil.getOff(modelId, fomulaStr) : fomulaStr;
            if (returnStr.equalsIgnoreCase("error")) {
                return "error!" + String.format(ResManager.loadKDString((String)"\u53d8\u91cf%1$s\u8bbe\u7f6e\u7684\u503c%2$s\u504f\u79fb\u4e3a[%3$s]\u540e\u4e0d\u5728\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ReportVarUtil_2", (String)"epm-eb-spread", (Object[])new Object[0]), varSingleNumberName[0], varValue, fomulaStr);
            }
        }
        return returnStr;
    }

    public static Set<String> getRealDimByVar(Long modelid, String varNumber, String varDimenstion, Map<String, Map<String, Set<String>>> varValues, String msg, DynamicObjectCollection varList) {
        Set<String> returnStr = new HashSet<String>(16);
        if (!TemplateVarCommonUtil.checkIsVar(varNumber, varDimenstion).booleanValue()) {
            returnStr.add(varNumber);
            return returnStr;
        }
        if (varValues == null) {
            returnStr.add(varNumber);
            return returnStr;
        }
        Map<String, Set<String>> varValueMap = varValues.get(varDimenstion);
        if (varValues == null || varValueMap == null || varNumber == null) {
            throw new VarException(String.format(msg, varDimenstion, varNumber));
        }
        returnStr = ReportVarUtil.getVarValueByRule(modelid, varNumber, varValueMap, varDimenstion, msg, varList);
        return returnStr;
    }

    public static Map<String, Map<String, Set<String>>> getVarValuesByRule(String processType, Long modelId) {
        if (ProcessTypeEnum.RULE.getIndex() == Integer.parseInt(processType)) {
            return ReportVarUtil.getVarValueFromRuleList(modelId, "1");
        }
        if (ProcessTypeEnum.EXAMINE.getIndex() == Integer.parseInt(processType)) {
            return ReportVarUtil.getVarValueFromRuleList(modelId, "2");
        }
        return null;
    }

    public static String getVarMemberName(Long modelId, String dimNumber, String varNumber) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"name", (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)varNumber).and("dimension.number", "=", (Object)dimNumber).toArray());
        if (object != null) {
            return object.getString("name");
        }
        return "";
    }

    public static DynamicObject getPeriodvariableDynamicObject(Long modelIdLong, String dimensionNumberString, String varNumberString) {
        return QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id,name,number", (QFilter[])new QFilter("model", "=", (Object)modelIdLong).and("number", "=", (Object)varNumberString).and("dimension.number", "=", (Object)dimensionNumberString).toArray());
    }

    public static Map<String, Map<String, Set<String>>> getVarValueFromRuleList(Long modelId, String type) {
        String selectFields = "entryentity.dimension.number as dimension,entryentity.variablenumber.number as varnumber,entryentity.variablenumber.name as varname,entryentity.variablejson as variablejson";
        String formID = "eb_rule_varible";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("type", "=", (Object)type);
        HashMap<String, Map<String, Set<String>>> returnMap = new HashMap<String, Map<String, Set<String>>>(16);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"ReportVarUtil", (String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    String json = dataRow.getString("variablejson");
                    if (json == null || json.isEmpty()) continue;
                    String varNumberName = dataRow.getString("varnumber") + "!" + dataRow.getString("varname");
                    List valueMap = (List)SerializationUtils.fromJsonString((String)json, List.class);
                    for (Map map : valueMap) {
                        ReportVarUtil.putValue2MapByRule(returnMap, dataRow.getString("dimension"), varNumberName, map.get("number").toString());
                    }
                }
            }
        }
        return returnMap;
    }

    private static String getMatchVarValue(String var, Map<String, String> varValueMap) {
        for (Map.Entry<String, String> entry : varValueMap.entrySet()) {
            String varNumberName = entry.getKey();
            String[] varSingleNumberName = varNumberName.split("!");
            if (varSingleNumberName == null || !var.equalsIgnoreCase(varSingleNumberName[0])) continue;
            return varNumberName;
        }
        return "";
    }

    private static String getMatchVarValueByRule(String var, Map<String, Set<String>> varValueMap) {
        for (Map.Entry<String, Set<String>> entry : varValueMap.entrySet()) {
            String varNumberName = entry.getKey();
            String[] varSingleNumberName = varNumberName.split("!");
            if (varSingleNumberName == null || !var.equalsIgnoreCase(varSingleNumberName[0])) continue;
            return varNumberName;
        }
        return "";
    }

    private static String getErrInfo(String dimension, String var, String msg) {
        return "error!" + msg;
    }

    public static String getVarValueNoError(Long modelid, String number, Map<String, String> varValueMap, String dimension) {
        String result;
        try {
            result = ReportVarUtil.getVarValue(modelid, number, varValueMap, dimension, "");
            if (ReportVarUtil.varHasError(result)) {
                result = null;
            }
        }
        catch (Throwable e) {
            log.error(e);
            if (e instanceof VarException) {
                result = null;
            }
            throw e;
        }
        return result;
    }

    private static String getVarValue(Long modelid, String number, Map<String, String> varValueMap, String dimension, String msg) {
        String[] str;
        if (varValueMap == null || varValueMap.size() == 0) {
            return ReportVarUtil.getErrInfo(dimension, number, msg);
        }
        String returnStr = null;
        String num = number;
        if (number.indexOf("+") > 0) {
            str = number.split("[+]");
            num = str[0].trim();
        }
        if (number.indexOf("-") > 0) {
            str = number.split("-");
            num = str[0].trim();
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension) && (number.startsWith("@NextY") || number.startsWith("@BaseY") || number.startsWith("@LastY"))) {
            returnStr = ReportVarUtil.getRealNumber(dimension, number, varValueMap, modelid, msg);
        } else {
            String varNumberName = ReportVarUtil.getMatchVarValue(num, varValueMap);
            if (varNumberName == null) {
                return ReportVarUtil.getErrInfo(dimension, num, msg);
            }
            String[] varSingleNumberName = varNumberName.split("!");
            if (varSingleNumberName == null) {
                return ReportVarUtil.getErrInfo(dimension, num, msg);
            }
            String varValue = varValueMap.get(varNumberName);
            if (varValue == null) {
                return ReportVarUtil.getErrInfo(dimension, num, msg);
            }
            String fomulaStr = number.replace(varSingleNumberName[0], varValue);
            returnStr = SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension) ? ReportVarUtil.getOff(modelid, fomulaStr) : fomulaStr;
            if (returnStr.equalsIgnoreCase("error")) {
                return "error!" + String.format(ResManager.loadKDString((String)"\u53d8\u91cf%1$s\u8bbe\u7f6e\u7684\u503c%2$s\u504f\u79fb\u4e3a[%3$s]\u540e\u4e0d\u5728\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ReportVarUtil_2", (String)"epm-eb-spread", (Object[])new Object[0]), varSingleNumberName[0], varValue, fomulaStr);
            }
        }
        return returnStr;
    }

    private static Set<String> getVarValueByRule(Long modelid, String number, Map<String, Set<String>> varValueMap, String dimension, String msg, DynamicObjectCollection varList) {
        String[] str;
        if (varValueMap == null || varValueMap.size() == 0) {
            throw new VarException(msg);
        }
        Set<String> returnStr = null;
        String num = number;
        if (number.indexOf("+") > 0) {
            str = number.split("[+]");
            num = str[0].trim();
        }
        if (number.indexOf("-") > 0) {
            str = number.split("-");
            num = str[0].trim();
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension) && (number.startsWith("@NextY") || number.startsWith("@BaseY") || number.startsWith("@LastY"))) {
            returnStr = ReportVarUtil.getRealNumberByRule(dimension, number, varValueMap, modelid, msg, varList);
        }
        return returnStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getRealNumber(String dimension, String number, Map<String, String> varValueMap, Long modelId, String msg) {
        String varNumberName = ReportVarUtil.getMatchVarValue("@BaseY", varValueMap);
        String[] varSingleNumberName = varNumberName.split("!");
        if (varSingleNumberName == null) {
            return ReportVarUtil.getErrInfo(dimension, number, msg);
        }
        String base = varValueMap.get(varNumberName);
        if (StringUtils.isEmpty(base)) {
            return ReportVarUtil.getErrInfo(dimension, number, msg);
        }
        String realNumber = null;
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate(modelId);
        if (number.startsWith("@BaseY")) {
            String[] split = number.split("\\.");
            if (split == null) return base;
            if (split.length == 0) return base;
            if (split.length == 1) {
                return base;
            }
            if (split.length != 2) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
            String suffix = split[1];
            return base + "." + suffix;
        }
        if (!number.startsWith("@NextY") && !number.startsWith("@LastY")) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
        String[] split = number.split("\\.");
        String splitNumber = "";
        splitNumber = split.length == 0 ? number : split[0];
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"offset", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension.number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()).and("number", "=", (Object)splitNumber).toArray());
        if (dynamicObject == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1,\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u53d8\u91cf\u3002", (String)"ReportVarUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
        }
        int offset = dynamicObject.getInt("offset");
        Member memberOffset = modelcache.getMemberOffset(dimension, base, offset);
        if (memberOffset == null) {
            throw new VarException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf\u201c%1$s\u201d\u57fa\u4e8e\u57fa\u51c6\u503c\u201c%2$s\u201d\u504f\u79fb\u4e3a\u201c%3$s\u201c\u540e\u4e0d\u5728\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ReportVarUtil_7", (String)"epm-eb-spread", (Object[])new Object[0]), number, base, offset));
        }
        if (split.length < 2) return memberOffset.getNumber();
        return memberOffset.getNumber() + "." + split[1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<String> getRealNumberByRule(String dimension, String number, Map<String, Set<String>> varValueMap, Long modelId, String msg, DynamicObjectCollection varList) {
        String varNumberName = ReportVarUtil.getMatchVarValueByRule("@BaseY", varValueMap);
        String[] varSingleNumberName = varNumberName.split("!");
        if (varSingleNumberName == null) {
            throw new VarException(msg);
        }
        Set<String> baseNum = varValueMap.get(varNumberName);
        if (CollectionUtils.isEmpty(baseNum)) {
            throw new VarException(msg);
        }
        HashSet<String> realNumers = new HashSet<String>(baseNum.size());
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate(modelId);
        for (String base : baseNum) {
            String[] split;
            String realNumber = null;
            if (number.startsWith("@BaseY")) {
                split = number.split("\\.");
                if (split == null || split.length == 0 || split.length == 1) {
                    realNumber = base;
                } else {
                    if (split.length != 2) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
                    String suffix = split[1];
                    realNumber = base + "." + suffix;
                }
            } else {
                if (!number.startsWith("@NextY") && !number.startsWith("@LastY")) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
                split = number.split("\\.");
                String splitNumber = "";
                splitNumber = split == null || split.length == 0 ? number : split[0];
                String finalSplitNumber = splitNumber;
                List dynList = varList.stream().filter(v -> v.getString("number").equals(finalSplitNumber)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(dynList)) {
                    throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1,\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u53d8\u91cf\u3002", (String)"ReportVarUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
                }
                DynamicObject dynamicObject = (DynamicObject)dynList.get(0);
                int offset = dynamicObject.getInt("offset");
                Member memberOffset = modelcache.getMemberOffset(dimension, base, offset);
                if (memberOffset == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf\u201c%1$s\u201d\u57fa\u4e8e\u57fa\u51c6\u503c\u201c%2$s\u201d\u504f\u79fb\u4e3a\u201c%3$s\u201c\u540e\u4e0d\u5728\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ReportVarUtil_7", (String)"epm-eb-spread", (Object[])new Object[0]), number, base, offset));
                }
                realNumber = split != null && split.length >= 2 ? memberOffset.getNumber() + "." + split[1] : memberOffset.getNumber();
            }
            realNumers.add(realNumber);
        }
        return realNumers;
    }

    private static String getOff(Long modelid, String number) {
        String[] str;
        String returnstr = number;
        if (number.indexOf("+") > 0) {
            str = number.split("[+]");
            returnstr = TemplateVarCommonUtil.getOff(str[0].trim(), Integer.parseInt(str[1].trim()), modelid);
        }
        if (number.indexOf("-") > 0) {
            str = number.split("-");
            returnstr = TemplateVarCommonUtil.getOff(str[0].trim(), Integer.parseInt("-" + str[1].trim()), modelid);
        }
        return returnstr;
    }

    public static void putValue2MapByRule(Map<String, Map<String, Set<String>>> returnMap, String dimension, String varNumber, String valueNumber) {
        if (returnMap == null) {
            return;
        }
        Map<String, Set<String>> varValue = returnMap.get(dimension);
        if (varValue == null) {
            varValue = new HashMap<String, Set<String>>(16);
            HashSet<String> var = new HashSet<String>(16);
            var.add(valueNumber);
            varValue.put(varNumber, var);
            returnMap.put(dimension, varValue);
        } else {
            Set<String> var = varValue.get(varNumber);
            if (var == null) {
                var = new HashSet<String>(16);
            }
            var.add(valueNumber);
            varValue.put(varNumber, var);
        }
    }

    private static boolean varHasError(String varValue) {
        return varValue != null && varValue.contains("!");
    }

    public static int queryVariableOffSet(Long modelId, String dimNum, String number) {
        Map<String, VariableDto> variableDtoMap = VariableCacheService.getInstance().listVariableFromLocalCache(modelId).getVariableDtoMap();
        if (variableDtoMap == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1,\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u53d8\u91cf\u3002", (String)"ReportVarUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{dimNum, number}));
        }
        VariableDto dynamicObject = variableDtoMap.get(dimNum + ":" + number);
        if (dynamicObject == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1,\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u53d8\u91cf\u3002", (String)"ReportVarUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{dimNum, number}));
        }
        return dynamicObject.getOffset();
    }

    public static VariableDto queryVariable(Long modelId, String dimNum, String number) {
        Map<String, VariableDto> variableDtoMap = VariableCacheService.getInstance().listVariableFromLocalCache(modelId).getVariableDtoMap();
        if (variableDtoMap == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1,\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u53d8\u91cf\u3002", (String)"ReportVarUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{dimNum, number}));
        }
        VariableDto dynamicObject = variableDtoMap.get(dimNum + ":" + number);
        if (dynamicObject == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1,\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u53d8\u91cf\u3002", (String)"ReportVarUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{dimNum, number}));
        }
        return dynamicObject;
    }

    public static Map<String, VariableDto> queryAllVariable(Long modelId) {
        QFilter qModel = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number,name,dimension.number,offset", (QFilter[])qModel.toArray());
        if (dynamicObjects == null) {
            return null;
        }
        return dynamicObjects.stream().map(x -> {
            VariableDto obj = new VariableDto();
            obj.setId(x.getLong("id"));
            obj.setNumber(x.getString("number"));
            obj.setName(x.getString("name"));
            obj.setDimNum(x.getString("dimension.number"));
            obj.setOffset(x.getInt("offset"));
            return obj;
        }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<VariableDto>(Comparator.comparing(x -> x.getDimNum() + ":" + x.getNumber()))), ArrayList::new)).stream().collect(Collectors.toMap(x -> x.getDimNum() + ":" + x.getNumber(), x -> x));
    }
}

