/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.var;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Pair;

public class TemplateVarCommonUtil {
    public static final String ISNEEDVAR = "isNeedVar";
    public static final String VARROOTID = "11";
    public static final String SPLIT = "!";
    public static final String ERRINFOFLAG = "error";
    public static final String VARTEMPLATE = "1";
    private static final String VARPREF = "@";
    private static final String LOGPROF = "varReplace:";

    public static Boolean checkIsVar(String dimDetail, String dimKey) {
        if (dimDetail == null || dimDetail.isEmpty()) {
            return false;
        }
        if (dimDetail.equalsIgnoreCase(ISNEEDVAR)) {
            return true;
        }
        if (dimDetail.contains("+") || dimDetail.contains("-")) {
            return SysDimensionEnum.BudgetPeriod.getNumber().equals(dimKey);
        }
        return dimDetail.startsWith(VARPREF);
    }

    public static String getOff(String periodNumber, int offValue, Long modelId) {
        Pair pair;
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate(modelId);
        HashMap<String, Pair<Member, Integer>> number2index = new HashMap<String, Pair<Member, Integer>>(16);
        Member member1 = modelcache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, periodNumber);
        if (member1 == null) {
            return periodNumber;
        }
        int level1 = member1.getLevel();
        List<Member> budgetPeriod1 = TemplateVarCommonUtil.getBudgetPeriodByLevel(level1, modelcache);
        if (budgetPeriod1 == null || budgetPeriod1.isEmpty()) {
            return periodNumber;
        }
        int index1 = TemplateVarCommonUtil.binarySearch(budgetPeriod1, member1.getSeq(), 0, budgetPeriod1.size());
        if (index1 > -1) {
            number2index.put(periodNumber, new Pair<Member, Integer>(member1, index1));
        }
        if ((pair = (Pair)number2index.get(periodNumber)) == null) {
            return periodNumber;
        }
        Member member2 = (Member)pair.getKey();
        Integer index2 = (Integer)pair.getValue();
        int level2 = member2.getLevel();
        List<Member> budgetPeriod2 = TemplateVarCommonUtil.getBudgetPeriodByLevel(level2, modelcache);
        if ((index2 = Integer.valueOf(index2 + offValue)) < 0 || index2 > budgetPeriod2.size() - 1) {
            return ERRINFOFLAG;
        }
        String offPeriodNumbers = budgetPeriod2.get(index2).getNumber();
        return offPeriodNumbers;
    }

    private static int binarySearch(List<Member> members, int seq, int low, int high) {
        if (members == null || members.isEmpty() || low > high) {
            return -1;
        }
        int mid = low + (high - low) / 2;
        Member midMember = members.get(mid);
        int midSeq = midMember.getSeq();
        if (midSeq == seq) {
            return mid;
        }
        if (midSeq > seq) {
            return TemplateVarCommonUtil.binarySearch(members, seq, low, mid - 1);
        }
        if (midSeq < seq) {
            return TemplateVarCommonUtil.binarySearch(members, seq, mid + 1, high);
        }
        return -1;
    }

    private static List<Member> getBudgetPeriodByLevel(int level, IModelCacheHelper modelcache) {
        HashMap<Integer, List<Member>> bpMembers = new HashMap<Integer, List<Member>>(16);
        List<Member> members = (List<Member>)bpMembers.get(level);
        if (members == null) {
            Member member = modelcache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, SysDimensionEnum.BudgetPeriod.getNumber());
            members = member.getLevelMembers(level);
            members.sort(Comparator.comparingInt(BaseCache::getSeq));
            bpMembers.put(level, members);
        }
        return members;
    }
}

