/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.versionconstrast;

import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.versionconstrast.VersionConstrastData;
import kd.epm.eb.common.versionconstrast.VersionConstrastNode;
import org.jetbrains.annotations.NotNull;

public class VersionConstrastCheckDto
implements Serializable {
    private static final long serialVersionUID = -8654433269519777872L;
    private Map<Long, List<Long>> memberIdList = new HashMap<Long, List<Long>>(10);
    private Map<Long, Map<Long, Integer>> memberIdIndex = new HashMap<Long, Map<Long, Integer>>(16);
    private Map<Long, List<String>> memberNameList = new HashMap<Long, List<String>>(10);
    private List<Long> dimensions = new ArrayList<Long>(10);
    private List<Long> showDimensions = new ArrayList<Long>(10);
    private VersionConstrastData floatRow = null;
    private VersionConstrastNode root = VersionConstrastNode.createRoot(this);
    private List<VersionConstrastNode> selectedNodes = null;
    private boolean hasDeletedHistory = false;
    private Map<String, String> defaultDimMember = null;
    private Long dataSetId = 0L;
    Map<String, List<Long>> viewGroupViewsMap = null;
    private String currentEntityViewId = null;
    private Long targetSchemeId = null;
    private String targetProcessType = null;

    public Map<Long, List<Long>> getMemberIdList() {
        return this.memberIdList;
    }

    public void setMemberIdList(Map<Long, List<Long>> memberIdList) {
        this.memberIdList = memberIdList;
    }

    public Map<Long, Map<Long, Integer>> getMemberIdIndex() {
        return this.memberIdIndex;
    }

    public void setMemberIdIndex(Map<Long, Map<Long, Integer>> memberIdIndex) {
        this.memberIdIndex = memberIdIndex;
    }

    public int getMemberIndex(@NotNull Long dimId, @NotNull Long memberId, boolean iscreate) {
        Integer i;
        Map<Long, Integer> index = this.memberIdIndex.get(dimId);
        if (index == null) {
            if (iscreate) {
                index = new HashMap<Long, Integer>(10);
                this.memberIdIndex.put(dimId, index);
            } else {
                return -1;
            }
        }
        if ((i = index.get(memberId)) != null) {
            return i;
        }
        if (iscreate) {
            List ids = this.memberIdList.computeIfAbsent(dimId, f -> new ArrayList(10));
            i = ids.size();
            ids.add(memberId);
            index.put(memberId, i);
            return i;
        }
        return -1;
    }

    public Map<Long, List<String>> getMemberNameList() {
        return this.memberNameList;
    }

    public List<Long> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Long> dimensions) {
        this.dimensions = dimensions;
    }

    public List<Long> getShowDimensions() {
        return this.showDimensions;
    }

    public void setShowDimensions(List<Long> showDimensions) {
        this.showDimensions = showDimensions;
    }

    public void setFloatRow(VersionConstrastData floatRow) {
        this.floatRow = floatRow;
    }

    public VersionConstrastData getFloatRow() {
        return this.floatRow;
    }

    public VersionConstrastNode getRoot() {
        return this.root;
    }

    public void setRoot(VersionConstrastNode root) {
        this.root = root;
    }

    public boolean isEmpty() {
        return this.getRoot() == null || this.getRoot().getChildNode() == null || this.getRoot().getChildNode().isEmpty();
    }

    public void add(Map<Long, Long> memberMap, VersionConstrastData data, List<Point> points) {
        VersionConstrastNode node = this.root.indexOf(this.repalaceMemberId(memberMap, true), this.getDimensions(), true);
        if (node == null) {
            return;
        }
        node.setData(data);
        if (points != null) {
            points.forEach(f -> node.addPoint((Point)f));
        }
    }

    public List<Point> getPoints(Map<Long, Long> memberMap) {
        VersionConstrastNode node = this.root.indexOf(this.repalaceMemberId(memberMap, false), this.getDimensions(), false);
        if (node != null) {
            return node.getPoints();
        }
        return null;
    }

    private Map<Long, Long> repalaceMemberId(Map<Long, Long> memberMap, boolean iscreate) {
        HashMap<Long, Long> simpleMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Long> entry : memberMap.entrySet()) {
            int index = this.getMemberIndex(entry.getKey(), entry.getValue(), iscreate);
            if (index == -1) {
                simpleMap.clear();
                return simpleMap;
            }
            simpleMap.put(entry.getKey(), Long.valueOf(index));
        }
        return simpleMap;
    }

    public VersionConstrastData getData(Map<Long, Long> memberMap) {
        VersionConstrastNode node = this.root.indexOf(this.repalaceMemberId(memberMap, false), this.getDimensions(), false);
        if (node != null) {
            return node.getData();
        }
        return null;
    }

    public List<VersionConstrastNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setSelectedNodes(List<VersionConstrastNode> selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public void filterCellClick(int startRow, int endRow, int startCol, int endCol) {
        this.selectedNodes = new ArrayList<VersionConstrastNode>(16);
        if (this.getRoot() == null) {
            return;
        }
        ArrayList<VersionConstrastNode> leafNodes = new ArrayList<VersionConstrastNode>(16);
        this.getRoot().getLeafNodes(leafNodes);
        block0: for (VersionConstrastNode node : leafNodes) {
            if (node.getPoints() == null) continue;
            for (Point p : node.getPoints()) {
                if (!(p.getY() >= (double)startRow) || !(p.getY() <= (double)endRow) || !(p.getX() >= (double)startCol) || !(p.getX() <= (double)endCol)) continue;
                this.selectedNodes.add(node);
                continue block0;
            }
        }
    }

    public void setHasDeletedHistory(boolean hasDeletedHistory) {
        this.hasDeletedHistory = hasDeletedHistory;
    }

    public boolean isHasDeletedHistory() {
        return this.hasDeletedHistory;
    }

    public Map<String, String> getDefaultDimMember() {
        return this.defaultDimMember;
    }

    public void setDefaultDimMember(Map<String, String> defaultDimMember) {
        this.defaultDimMember = defaultDimMember;
    }

    public Long getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(Long dataSetId) {
        this.dataSetId = dataSetId;
    }

    public Map<String, List<Long>> getViewGroupViewsMap() {
        return this.viewGroupViewsMap;
    }

    public void setViewGroupViewsMap(Map<String, List<Long>> viewGroupViewsMap) {
        this.viewGroupViewsMap = viewGroupViewsMap;
    }

    public String getCurrentEntityViewId() {
        return this.currentEntityViewId;
    }

    public void setCurrentEntityViewId(String currentEntityViewId) {
        this.currentEntityViewId = currentEntityViewId;
    }

    public void setTargetSchemeId(Long targetSchemeId) {
        this.targetSchemeId = targetSchemeId;
    }

    public Long getTargetSchemeId() {
        return this.targetSchemeId;
    }

    public void setTargetProcessType(String targetProcessType) {
        this.targetProcessType = targetProcessType;
    }

    public String getTargetProcessType() {
        return this.targetProcessType;
    }
}

