/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.versionconstrast;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.MathContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.versionconstrast.VersionConstrastSimpleData;

public class VersionConstrastData
extends VersionConstrastSimpleData {
    private static final long serialVersionUID = -6048047313074965249L;
    @JsonProperty(value="cd")
    private BigDecimal curDecimal = null;
    @JsonProperty(value="cn")
    private String curNote = null;
    @JsonProperty(value="td")
    private BigDecimal targetDecimal = null;
    @JsonProperty(value="tn")
    private String targetNote = null;
    @JsonProperty(value="dv")
    private String diffValue = null;
    @JsonProperty(value="dr")
    private BigDecimal difRate = null;
    @JsonProperty(value="mn")
    private String member = null;
    @JsonProperty(value="fm")
    private String fullMember = null;
    @JsonProperty(value="dt")
    private boolean isDetail = true;

    public BigDecimal getCurDecimal() {
        return this.curDecimal;
    }

    public void setCurDecimal(BigDecimal curDecimal) {
        this.curDecimal = curDecimal;
    }

    public String getCurNote() {
        return this.curNote;
    }

    public void setCurNote(String curNote) {
        this.curNote = curNote;
    }

    public BigDecimal getTargetDecimal() {
        return this.targetDecimal;
    }

    public void setTargetDecimal(BigDecimal targetDecimal) {
        this.targetDecimal = targetDecimal;
    }

    public String getTargetNote() {
        return this.targetNote;
    }

    public void setTargetNote(String targetNote) {
        this.targetNote = targetNote;
    }

    public String getDiffValue() {
        return this.diffValue;
    }

    public void setDiffValue(String diffValue) {
        this.diffValue = diffValue;
    }

    public BigDecimal getDifRate() {
        return this.difRate;
    }

    public void setDifRate(BigDecimal difRate) {
        this.difRate = difRate;
    }

    public String getMember() {
        return this.member;
    }

    public void setMember(String member) {
        this.member = member;
    }

    public void setFullMember(String fullMember) {
        this.fullMember = fullMember;
    }

    public String getFullMember() {
        return this.fullMember;
    }

    public void setDetail(boolean isDetail) {
        this.isDetail = isDetail;
    }

    public boolean isDetail() {
        return this.isDetail;
    }

    public void calcRate() {
        if (MetricDataTypeEnum.isNumber(this.getMetricDataType().getIndex())) {
            if (this.getCurDecimal() == null || BigDecimal.ZERO.compareTo(this.getCurDecimal()) == 0) {
                this.setDifRate(BigDecimal.ZERO);
            } else if (this.getTargetDecimal() == null) {
                this.setDifRate(BigDecimal.ONE);
            } else {
                try {
                    this.setDifRate(this.getCurDecimal().subtract(this.getTargetDecimal()).divide(this.getCurDecimal(), MathContext.DECIMAL128));
                }
                catch (Throwable e) {
                    this.setDifRate(BigDecimal.ZERO);
                }
            }
        }
    }

    @Override
    public void build(DynamicObject obj) {
        if (obj != null) {
            this.setColSeq(obj.getInt("colseq"));
            this.setCurValue(obj.getString("curvalue"));
            this.setCurNote(obj.getString("curnote"));
            this.setDiffValue(obj.getString("diffvalue"));
            this.setDifRate(obj.getBigDecimal("diffrate"));
            this.setMember(obj.getString("member"));
            this.setFullMember(obj.getString("fullmember"));
            this.setMetricId(obj.getLong("metric.id"));
            this.setRowSeq(obj.getInt("rowseq"));
            this.setTargetNote(obj.getString("targetnote"));
            this.setTargetValue(obj.getString("targetvalue"));
            this.setDynamicrow(obj.getBoolean("dynamicrow"));
            this.setDetail(obj.getBoolean("detail"));
            if (StringUtils.isNotEmpty(obj.getString("unit"))) {
                this.setUnit(DataUnitEnum.getEnumByIndex(Integer.parseInt(obj.getString("unit"))));
            }
            this.setPrecision(obj.getInt("precision"));
        }
    }

    public void convertCurDecimal() {
        if (MetricDataTypeEnum.isNumber(this.getMetricDataType().getIndex())) {
            this.setCurDecimal(Convert.toBigDecimal(this.getCurValue()));
        }
    }

    public void convertTargetDecimal() {
        if (MetricDataTypeEnum.isNumber(this.getMetricDataType().getIndex())) {
            this.setTargetDecimal(Convert.toBigDecimal(this.getTargetValue()));
        }
    }

    @Override
    public VersionConstrastData newInstance() {
        return new VersionConstrastData();
    }
}

