/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.versionconstrast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.versionconstrast.IVersionConstrastData;
import kd.epm.eb.common.versionconstrast.VersionConstrastCheckDto;
import kd.epm.eb.common.versionconstrast.VersionConstrastData;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class VersionConstrastNode
implements IVersionConstrastData,
Serializable {
    private static final Log log = LogFactory.getLog(VersionConstrastNode.class);
    private static final long serialVersionUID = 9169351512043581198L;
    @JsonProperty(value="dt")
    private VersionConstrastData data = null;
    @JsonProperty(value="m")
    private Long memberId = null;
    @JsonProperty(value="ps")
    private List<Point> points = null;
    @JsonProperty(value="i")
    private Long id = null;
    @JsonProperty(value="r")
    private Integer rowSeq = null;
    @JsonProperty(value="c")
    private Integer colSeq = null;
    private BitSet flags = null;
    @JsonProperty(value="cn")
    private Map<Long, VersionConstrastNode> childNode = Maps.newHashMap();

    public VersionConstrastData getData() {
        return this.data;
    }

    public void setData(VersionConstrastData data) {
        this.data = data;
    }

    public Long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public void addPoint(Point point) {
        if (point == null) {
            return;
        }
        if (this.points == null) {
            this.points = new LinkedList<Point>();
        }
        this.points.add(point);
    }

    @Override
    public Integer getRowSeq() {
        return this.rowSeq;
    }

    @Override
    public void setRowSeq(int rowSeq) {
        this.rowSeq = rowSeq;
    }

    @Override
    public Integer getColSeq() {
        return this.colSeq;
    }

    @Override
    public void setColSeq(int colSeq) {
        this.colSeq = colSeq;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    private VersionConstrastNode() {
    }

    public static VersionConstrastNode createRoot(VersionConstrastCheckDto dto) {
        VersionConstrastNode root = new VersionConstrastNode();
        return root;
    }

    public Map<Long, VersionConstrastNode> getChildNode() {
        return this.childNode;
    }

    public void setChildNode(Map<Long, VersionConstrastNode> childNode) {
        this.childNode = childNode;
    }

    public VersionConstrastNode indexOf(Map<Long, Long> memberMap, List<Long> dimensions, boolean iscreate) {
        if (memberMap == null || memberMap.isEmpty()) {
            return this;
        }
        if (dimensions == null || dimensions.isEmpty()) {
            return this;
        }
        VersionConstrastNode node = this;
        VersionConstrastNode child = null;
        for (Long dimid : dimensions) {
            Long id = memberMap.get(dimid);
            if (id == null) {
                return null;
            }
            child = node.childNode.get(id);
            if (child == null) {
                if (iscreate) {
                    child = new VersionConstrastNode();
                    child.setMemberId(id);
                    node.childNode.put(id, child);
                } else {
                    return null;
                }
            }
            node = child;
        }
        return node;
    }

    public VersionConstrastNode addChild(Map<Long, Long> memberMap, Long nextDimId, VersionConstrastData data) {
        return null;
    }

    public void calcDiffRate() {
        ArrayList<VersionConstrastNode> nodes = new ArrayList<VersionConstrastNode>(16);
        this.getLeafNodes(nodes);
        for (VersionConstrastNode node : nodes) {
            if (node.getData() == null) continue;
            node.getData().calcRate();
        }
    }

    public void getLeafNodes(@NotNull List<VersionConstrastNode> nodes) {
        if (IDUtils.isNotNull(this.getId()) || this.getData() != null) {
            nodes.add(this);
        } else if (this.getChildNode() != null && !this.getChildNode().isEmpty()) {
            this.getChildNode().values().forEach(f -> f.getLeafNodes(nodes));
        }
    }

    public void syncData(boolean isClearData) {
        if (this.getData() != null) {
            this.setId(this.getData().getId());
            this.setRowSeq(this.getData().getRowSeq());
            this.setColSeq(this.data.getColSeq());
            if (isClearData) {
                this.setData(null);
            }
        }
    }

    public VersionConstrastNode indexOf(Long rowId) {
        if (rowId == null) {
            return null;
        }
        if (IDUtils.isNotNull(this.getId())) {
            if (rowId.equals(this.getId())) {
                return this;
            }
        } else if (this.getChildNode() != null) {
            for (VersionConstrastNode node : this.getChildNode().values()) {
                VersionConstrastNode r = node.indexOf(rowId);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }
}

