/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.DimensionView;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.DimensionView.DimensionViewPreset;
import kd.epm.eb.common.enums.DimensionViewGroupEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;

public class DimensionViewGroupPreset {
    public static Map<Long, Long> presetData(String modelId, Map<Long, Long> viewMap) {
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
        if (StringUtils.isEmpty((String)modelId)) {
            return idMap;
        }
        List list = DimensionViewGroupEnum.getAll();
        ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(list.size());
        Map<String, Long> dimMap = DimensionViewPreset.getDimensionIdMap(modelId);
        if (dimMap.size() == 0) {
            return idMap;
        }
        HashMap<Long, Long> viewViewGroupMap = new HashMap<Long, Long>(16);
        for (DimensionViewGroupEnum dimensionViewGroupEnum : list) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview_group");
            long id = GlobalIdUtil.genGlobalLongId();
            String dimensionNumber = dimensionViewGroupEnum.getDimensionNumber();
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("number", (Object)dimensionViewGroupEnum.getNumber());
            dynamicObject.set("name", (Object)LanguageUtils.getLocaleValue((String)dimensionViewGroupEnum.getName(), (String)dimensionViewGroupEnum.getNameKey().getResourceID(), (String)"epm-eb-common"));
            dynamicObject.set("type", (Object)"1");
            Long defaultView = viewMap.get(dimMap.get(dimensionNumber));
            dynamicObject.set("defaultview", (Object)defaultView);
            dynamicObject.set("description", (Object)"");
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("creater", (Object)UserUtils.getUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("modifier", (Object)UserUtils.getUserId());
            dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
            dynamicObject.set("dimension", (Object)dimMap.get(dimensionNumber));
            dynamicObject.set("source", (Object)"1");
            dynamicObject.set("parent", (Object)0L);
            idMap.put(dimMap.get(dimensionNumber), id);
            viewViewGroupMap.put(defaultView, id);
            save.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)IDUtils.toLong((Object)modelId));
        DynamicObject[] views = BusinessDataServiceHelper.load((String)"eb_dimensionview", (String)"id, viewgroup", (QFilter[])qfBuilder.toArray());
        if (views.length > 0) {
            for (DynamicObject view : views) {
                view.set("viewgroup", viewViewGroupMap.get(view.getLong("id")));
            }
            SaveServiceHelper.save((DynamicObject[])views);
        }
        return idMap;
    }
}

