/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.DimensionView;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.DimensionViewEnum;
import kd.epm.eb.common.enums.dimensionEnums.ChangeTypeFormulaEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;

public class DimensionViewPreset {
    public static Map<Long, Long> presetData(String modelId) {
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
        if (StringUtils.isEmpty((String)modelId)) {
            return idMap;
        }
        List list = DimensionViewEnum.getAll();
        ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(list.size());
        Map<String, Long> dimMap = DimensionViewPreset.getDimensionIdMap(modelId);
        if (dimMap.size() == 0) {
            return idMap;
        }
        for (DimensionViewEnum dimensionViewEnum : list) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
            long id = GlobalIdUtil.genGlobalLongId();
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("number", (Object)dimensionViewEnum.getNumber());
            dynamicObject.set("name", (Object)LanguageUtils.getLocaleValue((String)dimensionViewEnum.getName(), (String)dimensionViewEnum.getNameKey().getResourceID(), (String)"epm-eb-common"));
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("dimension", (Object)dimMap.get(dimensionViewEnum.getDimensionNumber()));
            dynamicObject.set("level", (Object)1);
            dynamicObject.set("dseq", (Object)1);
            dynamicObject.set("longnumber", (Object)("!" + dimensionViewEnum.getNumber()));
            dynamicObject.set("isleaf", (Object)true);
            dynamicObject.set("source", (Object)dimensionViewEnum.getSource());
            dynamicObject.set("parent", (Object)0L);
            dynamicObject.set("usage", (Object)"0");
            dynamicObject.set("baseview", (Object)0L);
            dynamicObject.set("creater", (Object)UserUtils.getUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("modifier", (Object)UserUtils.getUserId());
            dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
            dynamicObject.set("description", (Object)"");
            idMap.put(dimMap.get(dimensionViewEnum.getDimensionNumber()), id);
            save.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
        return idMap;
    }

    public static Map<String, Long> getDimensionIdMap(String modelId) {
        QFilter qFilter;
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        ArrayList<String> dimensionNumber = new ArrayList<String>(10);
        for (DimensionViewEnum dimensionViewEnum : DimensionViewEnum.getAll()) {
            dimensionNumber.add(dimensionViewEnum.getDimensionNumber());
        }
        QFilter modelQf = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number", (QFilter[])new QFilter[]{modelQf, qFilter = new QFilter("number", "in", dimensionNumber)}, (String)"dseq asc");
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                map.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
            }
        }
        return map;
    }

    public static void setChangeTypePresetData(Long modelId) {
        List<String> numbers = Arrays.asList("CurrentPeriod", "EndingBalance", "EBChanges", "Occupation", "Execute");
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("number", "in", numbers);
        DynamicObject[] members = BusinessDataServiceHelper.load((String)"epm_changetypemembertree", (String)"id,number,isPeriodDistribution,dimension.id,view,entryentity_formul,entryentity_formul.formulview,entryentity_formul.formula,entryentity_formul.formulaname", (QFilter[])qfBuilder.toArray());
        if (members.length > 0) {
            long dimensionId = members[0].getLong("dimension.id");
            Long viewId = DimensionViewServiceHelper.getInstance().queryBaseViewId(modelId, Long.valueOf(dimensionId));
            for (DynamicObject member : members) {
                List formulaData;
                String number = member.getString("number");
                if ("CurrentPeriod".equals(number)) {
                    member.set("isPeriodDistribution", (Object)true);
                }
                if ((formulaData = ChangeTypeFormulaEnum.getFormulaData((String)number)) != null) {
                    DynamicObjectCollection entryentity_formul = member.getDynamicObjectCollection("entryentity_formul");
                    DynamicObject object = entryentity_formul.addNew();
                    object.set("formulview", (Object)viewId);
                    object.set("formula", formulaData.get(0));
                    object.set("formulaname", formulaData.get(1));
                    continue;
                }
                member.set("view", (Object)viewId);
            }
            SaveServiceHelper.save((DynamicObject[])members);
        }
    }
}

