/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public abstract class AbstractAdjust {
    protected IModelCacheHelper getModelCacheHelper(Long modelId) {
        return ModelCacheContext.getOrCreate((Long)modelId);
    }

    protected String getValueField(boolean submit) {
        return submit ? "adjustdata" : "submitvalue";
    }

    protected void verify(DynamicObject[] adjusts, boolean isSubmit) {
        if (adjusts == null || adjusts.length == 0) {
            return;
        }
        for (DynamicObject adjust : adjusts) {
            String formType = "";
            DynamicObjectCollection entries = adjust.getDynamicObjectCollection("adjdetailentity");
            long modelId = adjust.getLong("model.id");
            if (StringUtils.isEmpty((String)formType)) {
                formType = adjust.getString("billtype");
            }
            if (entries != null && !entries.isEmpty()) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u3001\u8c03\u5242\u5355\u5206\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"Adjust_Submit_4", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    protected Map<Long, String> queryBillStatus(List<Object> billIds, String entityNumber) {
        if (billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)entityNumber)) {
            return Collections.emptyMap();
        }
        HashMap billStatus = Maps.newHashMapWithExpectedSize((int)billIds.size());
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", billIds));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBillStatus", (String)entityNumber, (String)"id, billstatus", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    billStatus.put(row.getLong("id"), row.getString("billstatus"));
                }
            }
        }
        return billStatus;
    }

    protected void submitByBgm(DynamicObject[] bills, boolean isSubmit) {
        IAdjustBillService adjustBillService = AdjustHelper.getInstance(AdjustBillEnum.OVERALL);
        for (DynamicObject billObj : bills) {
            AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill(billObj, false);
            adjustBillService.saveOccupyData2Olap(adjustBill, isSubmit);
        }
    }
}

