/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillDetail;
import kd.epm.eb.common.adjust.BasicData;
import kd.epm.eb.common.adjust.CustomDim;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;

public class AdjustBillConvertor {
    public static AdjustBill dataModel2AdjustBill(IDataModel dataModel, Set<Integer> completedRows, Set<Integer> periodColumns) {
        AdjustBill adjustBill = new AdjustBill();
        AdjustBillConvertor.setBillHeadValue(adjustBill, dataModel);
        AdjustBillConvertor.setBillEntryValue(adjustBill, dataModel, completedRows, periodColumns);
        return adjustBill;
    }

    public static AdjustBill dataModel2AdjustBill(IDataModel dataModel, Set<Integer> completedRows) {
        AdjustBill adjustBill = new AdjustBill();
        AdjustBillConvertor.setBillHeadValue(adjustBill, dataModel);
        AdjustBillConvertor.setBillEntryValue(adjustBill, dataModel, completedRows);
        return adjustBill;
    }

    public static AdjustBill dynamic2AdjustBill(DynamicObject dynamicObject, boolean isAudit) {
        AdjustBill adjustBill = new AdjustBill();
        AdjustBillConvertor.setBillHeadValue(adjustBill, dynamicObject);
        AdjustBillConvertor.setBillEntryValue(adjustBill, dynamicObject, isAudit);
        return adjustBill;
    }

    private static void setBillHeadValue(AdjustBill adjustBill, DynamicObject dynamicObject) {
        DynamicObject currencyObj;
        DynamicObject versionObj;
        DynamicObject changeTypeObj;
        adjustBill.setBillId(Long.valueOf(dynamicObject.getLong("id")));
        adjustBill.setBillNumber(dynamicObject.getString("billno"));
        adjustBill.setBillType(dynamicObject.getString("billtype"));
        DynamicObject modelObj = dynamicObject.getDynamicObject("model");
        Long modelId = modelObj.getLong("id");
        BasicData model = new BasicData();
        model.setId(modelId);
        model.setNumber(modelObj.getString("number"));
        adjustBill.setModel(model);
        if (AdjustHelper.isEb(modelId)) {
            DynamicObject yearObj = dynamicObject.getDynamicObject("year");
            if (yearObj != null) {
                BasicData year = new BasicData();
                year.setId(Long.valueOf(yearObj.getLong("id")));
                year.setNumber(yearObj.getString("number"));
                adjustBill.setYear(year);
            }
        } else {
            DynamicObject bizModelObj = dynamicObject.getDynamicObject("bizmodel");
            if (bizModelObj != null) {
                BasicData bizModel = new BasicData();
                bizModel.setId(Long.valueOf(bizModelObj.getLong("id")));
                bizModel.setNumber(bizModelObj.getString("number"));
                adjustBill.setBizModel(bizModel);
            }
        }
        DynamicObject dataTypeObj = dynamicObject.getDynamicObject("datatype");
        if (dataTypeObj != null) {
            BasicData dataType = new BasicData();
            dataType.setId(Long.valueOf(dataTypeObj.getLong("id")));
            dataType.setNumber(dataTypeObj.getString("number"));
            adjustBill.setDataType(dataType);
        }
        if ((changeTypeObj = dynamicObject.getDynamicObject("changetype")) != null) {
            BasicData changeType = new BasicData();
            changeType.setId(Long.valueOf(changeTypeObj.getLong("id")));
            changeType.setNumber(changeTypeObj.getString("number"));
            adjustBill.setChangeType(changeType);
        }
        if ((versionObj = dynamicObject.getDynamicObject("version")) != null) {
            BasicData version = new BasicData();
            version.setId(Long.valueOf(versionObj.getLong("id")));
            version.setNumber(versionObj.getString("number"));
            adjustBill.setVersion(version);
        }
        if ((currencyObj = dynamicObject.getDynamicObject("currency")) != null) {
            BasicData currency = new BasicData();
            currency.setId(Long.valueOf(currencyObj.getLong("id")));
            currency.setNumber(currencyObj.getString("number"));
            adjustBill.setCurrency(currency);
        }
    }

    private static void setBillEntryValue(AdjustBill adjustBill, DynamicObject dynamicObject, boolean isAudit) {
        DynamicObjectCollection entityRows = dynamicObject.getDynamicObjectCollection("adjdetailentity");
        if (CollectionUtils.isEmpty((Collection)entityRows)) {
            return;
        }
        Long modelId = adjustBill.getModel().getId();
        ArrayList<AdjustBillDetail> detailList = new ArrayList<AdjustBillDetail>(entityRows.size());
        if (AdjustHelper.isEb(modelId)) {
            Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByModel(modelId);
            for (int i = 0; i < entityRows.size(); ++i) {
                DynamicObject rowObj = (DynamicObject)entityRows.get(i);
                AdjustBillDetail adjustBillDetail = new AdjustBillDetail();
                if (isAudit) {
                    adjustBillDetail.setRow(i);
                } else {
                    String orderSign = rowObj.getString("ordersign");
                    if (orderSign.indexOf(":") != -1) {
                        String rowIndex = orderSign.substring(0, orderSign.indexOf(":"));
                        int row = Integer.parseInt(rowIndex);
                        adjustBillDetail.setRow(row);
                    }
                }
                DynamicObject periodObj = rowObj.getDynamicObject("period");
                BasicData period = new BasicData();
                period.setId(Long.valueOf(periodObj.getLong("id")));
                period.setNumber(periodObj.getString("number"));
                adjustBillDetail.setPeriod(period);
                DynamicObject entityObj = rowObj.getDynamicObject("entity");
                BasicData entity = new BasicData();
                entity.setId(Long.valueOf(entityObj.getLong("id")));
                entity.setNumber(entityObj.getString("number"));
                adjustBillDetail.setEntity(entity);
                DynamicObject accountObj = rowObj.getDynamicObject("account");
                Long accountId = accountObj.getLong("id");
                BasicData account = new BasicData();
                account.setId(accountId);
                account.setNumber(accountObj.getString("number"));
                adjustBillDetail.setAccount(account);
                ArrayList<CustomDim> customDimList = new ArrayList<CustomDim>(customDimMap.size());
                for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                    String dimKey = entry.getKey();
                    Dimension dimension = entry.getValue();
                    DynamicObject customDimObj = rowObj.getDynamicObject(dimKey);
                    CustomDim customDim = new CustomDim();
                    customDim.setDimNumber(dimension.getNumber());
                    if (customDimObj != null) {
                        customDim.setMemberNumber(customDimObj.getString("number"));
                    } else {
                        customDim.setMemberNumber(dimension.getNoneNumber());
                    }
                    customDimList.add(customDim);
                }
                adjustBillDetail.setCustomDimList(customDimList);
                adjustBillDetail.setAdjustData(rowObj.getBigDecimal("adjustdata"));
                adjustBillDetail.setSubmitValue(rowObj.getBigDecimal("submitvalue"));
                adjustBillDetail.setFinalData(rowObj.getBigDecimal("finaldata"));
                detailList.add(adjustBillDetail);
            }
        } else {
            Long bizModelId = adjustBill.getBizModel().getId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByBizModel(modelId, bizModelId);
            for (int i = 0; i < entityRows.size(); ++i) {
                DynamicObject rowObj = (DynamicObject)entityRows.get(i);
                AdjustBillDetail adjustBillDetail = new AdjustBillDetail();
                if (isAudit) {
                    adjustBillDetail.setRow(i);
                } else {
                    String orderSign = rowObj.getString("ordersign");
                    if (orderSign.indexOf(":") != -1) {
                        String rowIndex = orderSign.substring(0, orderSign.indexOf(":"));
                        int row = Integer.parseInt(rowIndex);
                        adjustBillDetail.setRow(row);
                    }
                }
                DynamicObject budgetPeriodObj = rowObj.getDynamicObject("budgetperiod");
                BasicData budgetPeriod = new BasicData();
                budgetPeriod.setId(Long.valueOf(budgetPeriodObj.getLong("id")));
                budgetPeriod.setNumber(budgetPeriodObj.getString("number"));
                budgetPeriod.setName(budgetPeriodObj.getString("name"));
                adjustBillDetail.setBudgetPeriod(budgetPeriod);
                DynamicObject entityObj = rowObj.getDynamicObject("entity");
                BasicData entity = new BasicData();
                entity.setId(Long.valueOf(entityObj.getLong("id")));
                entity.setNumber(entityObj.getString("number"));
                entity.setName(entityObj.getString("name"));
                adjustBillDetail.setEntity(entity);
                DynamicObject accountObj = rowObj.getDynamicObject("account");
                Long accountId = accountObj.getLong("id");
                BasicData account = new BasicData();
                account.setId(accountId);
                account.setNumber(accountObj.getString("number"));
                account.setName(accountObj.getString("name"));
                adjustBillDetail.setAccount(account);
                DynamicObject metricObj = rowObj.getDynamicObject("metric");
                BasicData metric = new BasicData();
                metric.setId(Long.valueOf(metricObj.getLong("id")));
                metric.setNumber(metricObj.getString("number"));
                metric.setName(metricObj.getString("name"));
                adjustBillDetail.setMetric(metric);
                Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
                if (accountMember == null) continue;
                Long datasetId = accountMember.getDatasetId();
                adjustBillDetail.setDatasetId(datasetId);
                Map<String, Dimension> rowCustomDimMap = AdjustHelper.getCustomDimsByDataset(modelId, datasetId, customDimMap);
                ArrayList<CustomDim> customDimList = new ArrayList<CustomDim>(rowCustomDimMap.size());
                for (Map.Entry<String, Dimension> entry : rowCustomDimMap.entrySet()) {
                    String dimKey = entry.getKey();
                    Dimension dimension = entry.getValue();
                    DynamicObject customDimObj = rowObj.getDynamicObject(dimKey);
                    CustomDim customDim = new CustomDim();
                    customDim.setDimNumber(dimension.getNumber());
                    if (customDimObj != null) {
                        customDim.setMemberNumber(customDimObj.getString("number"));
                        customDim.setMemberName(customDimObj.getString("name"));
                    } else {
                        customDim.setMemberNumber(dimension.getNoneNumber());
                        customDim.setMemberName(ResManager.loadResFormat((String)"\u4e0d\u533a\u5206%1", (String)"AdjustBillConvertor_1", (String)"epm-eb-business", (Object[])new Object[]{dimension.getName()}));
                    }
                    customDimList.add(customDim);
                }
                adjustBillDetail.setCustomDimList(customDimList);
                adjustBillDetail.setAdjustData(rowObj.getBigDecimal("adjustdata"));
                adjustBillDetail.setSubmitValue(rowObj.getBigDecimal("submitvalue"));
                adjustBillDetail.setFinalData(rowObj.getBigDecimal("finaldata"));
                String billType = adjustBill.getBillType();
                if (EbAdjBillTypeEnum.adjpst.getNumber().equals(billType)) {
                    adjustBillDetail.setGroupNum(rowObj.getString("groupnum"));
                }
                detailList.add(adjustBillDetail);
            }
        }
        adjustBill.setDetailList(detailList);
    }

    private static void setBillHeadValue(AdjustBill adjustBill, IDataModel dataModel) {
        DynamicObject currencyObj;
        DynamicObject versionObj;
        DynamicObject changeTypeObj;
        adjustBill.setBillId((Long)dataModel.getValue("id"));
        adjustBill.setBillNumber((String)dataModel.getValue("billno"));
        adjustBill.setBillType((String)dataModel.getValue("billtype"));
        DynamicObject modelObj = (DynamicObject)dataModel.getValue("model");
        Long modelId = modelObj.getLong("id");
        BasicData model = new BasicData();
        model.setId(modelId);
        model.setNumber(modelObj.getString("number"));
        adjustBill.setModel(model);
        if (AdjustHelper.isEb(modelId)) {
            DynamicObject yearObj = (DynamicObject)dataModel.getValue("year");
            if (yearObj != null) {
                BasicData year = new BasicData();
                year.setId(Long.valueOf(yearObj.getLong("id")));
                year.setNumber(yearObj.getString("number"));
                adjustBill.setYear(year);
            }
        } else {
            DynamicObject bizModelObj = (DynamicObject)dataModel.getValue("bizmodel");
            if (bizModelObj != null) {
                BasicData bizModel = new BasicData();
                bizModel.setId(Long.valueOf(bizModelObj.getLong("id")));
                bizModel.setNumber(bizModelObj.getString("number"));
                adjustBill.setBizModel(bizModel);
            }
        }
        DynamicObject dataTypeObj = (DynamicObject)dataModel.getValue("datatype");
        if (dataTypeObj != null) {
            BasicData dataType = new BasicData();
            dataType.setId(Long.valueOf(dataTypeObj.getLong("id")));
            dataType.setNumber(dataTypeObj.getString("number"));
            adjustBill.setDataType(dataType);
        }
        if ((changeTypeObj = (DynamicObject)dataModel.getValue("changetype")) != null) {
            BasicData changeType = new BasicData();
            changeType.setId(Long.valueOf(changeTypeObj.getLong("id")));
            changeType.setNumber(changeTypeObj.getString("number"));
            adjustBill.setChangeType(changeType);
        }
        if ((versionObj = (DynamicObject)dataModel.getValue("version")) != null) {
            BasicData version = new BasicData();
            version.setId(Long.valueOf(versionObj.getLong("id")));
            version.setNumber(versionObj.getString("number"));
            adjustBill.setVersion(version);
        }
        if ((currencyObj = (DynamicObject)dataModel.getValue("currency")) != null) {
            BasicData currency = new BasicData();
            currency.setId(Long.valueOf(currencyObj.getLong("id")));
            currency.setNumber(currencyObj.getString("number"));
            adjustBill.setCurrency(currency);
        }
    }

    private static void setBillEntryValue(AdjustBill adjustBill, IDataModel dataModel, Set<Integer> completedRows) {
        if (CollectionUtils.isEmpty(completedRows)) {
            return;
        }
        Long modelId = adjustBill.getModel().getId();
        ArrayList<AdjustBillDetail> detailList = new ArrayList<AdjustBillDetail>(completedRows.size());
        if (AdjustHelper.isEb(modelId)) {
            Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByModel(modelId);
            for (Integer row : completedRows) {
                DynamicObject rowObj = dataModel.getEntryRowEntity("adjdetailentity", row.intValue());
                AdjustBillDetail adjustBillDetail = new AdjustBillDetail();
                adjustBillDetail.setRow(row.intValue());
                DynamicObject periodObj = rowObj.getDynamicObject("period");
                BasicData period = new BasicData();
                period.setId(Long.valueOf(periodObj.getLong("id")));
                period.setNumber(periodObj.getString("number"));
                adjustBillDetail.setPeriod(period);
                DynamicObject entityObj = rowObj.getDynamicObject("entity");
                BasicData entity = new BasicData();
                entity.setId(Long.valueOf(entityObj.getLong("id")));
                entity.setNumber(entityObj.getString("number"));
                adjustBillDetail.setEntity(entity);
                DynamicObject accountObj = rowObj.getDynamicObject("account");
                Long accountId = accountObj.getLong("id");
                BasicData account = new BasicData();
                account.setId(accountId);
                account.setNumber(accountObj.getString("number"));
                adjustBillDetail.setAccount(account);
                ArrayList<CustomDim> customDimList = new ArrayList<CustomDim>(customDimMap.size());
                for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                    String dimKey = entry.getKey();
                    Dimension dimension = entry.getValue();
                    DynamicObject customDimObj = rowObj.getDynamicObject(dimKey);
                    if (customDimObj == null) continue;
                    CustomDim customDim = new CustomDim();
                    customDim.setDimNumber(dimension.getNumber());
                    customDim.setMemberNumber(customDimObj.getString("number"));
                    customDimList.add(customDim);
                }
                adjustBillDetail.setCustomDimList(customDimList);
                adjustBillDetail.setAdjustData(rowObj.getBigDecimal("adjustdata"));
                adjustBillDetail.setFinalData(rowObj.getBigDecimal("finaldata"));
                detailList.add(adjustBillDetail);
            }
        } else {
            Long bizModelId = adjustBill.getBizModel().getId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByBizModel(modelId, bizModelId);
            for (Integer row : completedRows) {
                DynamicObject rowObj = dataModel.getEntryRowEntity("adjdetailentity", row.intValue());
                AdjustBillDetail adjustBillDetail = new AdjustBillDetail();
                adjustBillDetail.setRow(row.intValue());
                DynamicObject budgetPeriodObj = rowObj.getDynamicObject("budgetperiod");
                BasicData budgetPeriod = new BasicData();
                budgetPeriod.setId(Long.valueOf(budgetPeriodObj.getLong("id")));
                budgetPeriod.setNumber(budgetPeriodObj.getString("number"));
                budgetPeriod.setName(budgetPeriodObj.getString("name"));
                adjustBillDetail.setBudgetPeriod(budgetPeriod);
                DynamicObject entityObj = rowObj.getDynamicObject("entity");
                BasicData entity = new BasicData();
                entity.setId(Long.valueOf(entityObj.getLong("id")));
                entity.setNumber(entityObj.getString("number"));
                entity.setName(entityObj.getString("name"));
                adjustBillDetail.setEntity(entity);
                DynamicObject accountObj = rowObj.getDynamicObject("account");
                Long accountId = accountObj.getLong("id");
                BasicData account = new BasicData();
                account.setId(accountId);
                account.setNumber(accountObj.getString("number"));
                account.setName(accountObj.getString("name"));
                adjustBillDetail.setAccount(account);
                DynamicObject metricObj = rowObj.getDynamicObject("metric");
                BasicData metric = new BasicData();
                metric.setId(Long.valueOf(metricObj.getLong("id")));
                metric.setNumber(metricObj.getString("number"));
                metric.setName(metricObj.getString("name"));
                adjustBillDetail.setMetric(metric);
                Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
                if (accountMember == null) continue;
                Long datasetId = accountMember.getDatasetId();
                adjustBillDetail.setDatasetId(datasetId);
                Map<String, Dimension> rowCustomDimMap = AdjustHelper.getCustomDimsByDataset(modelId, datasetId, customDimMap);
                ArrayList<CustomDim> customDimList = new ArrayList<CustomDim>(rowCustomDimMap.size());
                for (Map.Entry<String, Dimension> entry : rowCustomDimMap.entrySet()) {
                    String dimKey = entry.getKey();
                    Dimension dimension = entry.getValue();
                    DynamicObject customDimObj = rowObj.getDynamicObject(dimKey);
                    if (customDimObj == null) continue;
                    CustomDim customDim = new CustomDim();
                    customDim.setDimNumber(dimension.getNumber());
                    customDim.setMemberNumber(customDimObj.getString("number"));
                    customDim.setMemberName(customDimObj.getString("name"));
                    customDimList.add(customDim);
                }
                adjustBillDetail.setCustomDimList(customDimList);
                adjustBillDetail.setAdjustData(rowObj.getBigDecimal("adjustdata"));
                adjustBillDetail.setFinalData(rowObj.getBigDecimal("finaldata"));
                String billType = adjustBill.getBillType();
                if (EbAdjBillTypeEnum.adjpst.getNumber().equals(billType)) {
                    adjustBillDetail.setGroupNum(rowObj.getString("groupnum"));
                }
                detailList.add(adjustBillDetail);
            }
        }
        adjustBill.setDetailList(detailList);
    }

    private static void setBillEntryValue(AdjustBill adjustBill, IDataModel dataModel, Set<Integer> completedRows, Set<Integer> periodColumns) {
        if (CollectionUtils.isEmpty(completedRows)) {
            return;
        }
        Long modelId = adjustBill.getModel().getId();
        ArrayList<AdjustBillDetail> detailList = new ArrayList<AdjustBillDetail>(completedRows.size());
        if (AdjustHelper.isEb(modelId)) {
            Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByModel(modelId);
            for (Integer row : completedRows) {
                DynamicObject rowObj = dataModel.getEntryRowEntity("entryentity", row.intValue());
                if (rowObj == null) continue;
                DynamicObject entityObj = rowObj.getDynamicObject("adjentity");
                BasicData entity = new BasicData();
                entity.setId(Long.valueOf(entityObj.getLong("id")));
                entity.setNumber(entityObj.getString("number"));
                DynamicObject accountObj = rowObj.getDynamicObject("adjaccount");
                Long accountId = accountObj.getLong("id");
                BasicData account = new BasicData();
                account.setId(accountId);
                account.setNumber(accountObj.getString("number"));
                ArrayList<CustomDim> customDimList = new ArrayList<CustomDim>(customDimMap.size());
                for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                    String dimKey = entry.getKey();
                    Dimension dimension = entry.getValue();
                    DynamicObject customDimObj = rowObj.getDynamicObject("adj" + dimKey);
                    CustomDim customDim = new CustomDim();
                    customDim.setDimNumber(dimension.getNumber());
                    if (customDimObj != null) {
                        customDim.setMemberNumber(customDimObj.getString("number"));
                    } else {
                        customDim.setMemberNumber(dimension.getNoneNumber());
                    }
                    customDimList.add(customDim);
                }
                for (int j = 1; j <= periodColumns.size(); ++j) {
                    AdjustBillDetail adjustBillDetail = new AdjustBillDetail();
                    adjustBillDetail.setRow(row.intValue());
                    DynamicObject periodObj = rowObj.getDynamicObject("adjperiod" + j);
                    if (periodObj == null) continue;
                    BasicData period = new BasicData();
                    period.setId(Long.valueOf(periodObj.getLong("id")));
                    period.setNumber(periodObj.getString("number"));
                    adjustBillDetail.setPeriod(period);
                    adjustBillDetail.setEntity(entity);
                    adjustBillDetail.setAccount(account);
                    adjustBillDetail.setCustomDimList(customDimList);
                    adjustBillDetail.setAdjustData(rowObj.getBigDecimal("adjadjustdata" + j));
                    adjustBillDetail.setFinalData(rowObj.getBigDecimal("adjfinaldata" + j));
                    detailList.add(adjustBillDetail);
                }
            }
        } else {
            Long bizModelId = adjustBill.getBizModel().getId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByBizModel(modelId, bizModelId);
            for (Integer row : completedRows) {
                DynamicObject entityObj;
                DynamicObject rowObj = dataModel.getEntryRowEntity("entryentity", row.intValue());
                if (rowObj == null || (entityObj = rowObj.getDynamicObject("adjentity")) == null) continue;
                BasicData entity = new BasicData();
                entity.setId(Long.valueOf(entityObj.getLong("id")));
                entity.setNumber(entityObj.getString("number"));
                entity.setName(entityObj.getString("name"));
                DynamicObject accountObj = rowObj.getDynamicObject("adjaccount");
                if (accountObj == null) continue;
                Long accountId = accountObj.getLong("id");
                BasicData account = new BasicData();
                account.setId(accountId);
                account.setNumber(accountObj.getString("number"));
                account.setName(accountObj.getString("name"));
                DynamicObject metricObj = rowObj.getDynamicObject("adjmetric");
                if (metricObj == null) continue;
                BasicData metric = new BasicData();
                metric.setId(Long.valueOf(metricObj.getLong("id")));
                metric.setNumber(metricObj.getString("number"));
                metric.setName(metricObj.getString("name"));
                Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
                if (accountMember == null) continue;
                Long datasetId = accountMember.getDatasetId();
                Map<String, Dimension> rowCustomDimMap = AdjustHelper.getCustomDimsByDataset(modelId, datasetId, customDimMap);
                ArrayList<CustomDim> customDimList = new ArrayList<CustomDim>(rowCustomDimMap.size());
                for (Map.Entry<String, Dimension> entry : rowCustomDimMap.entrySet()) {
                    String dimKey = entry.getKey();
                    Dimension dimension = entry.getValue();
                    DynamicObject customDimObj = rowObj.getDynamicObject("adj" + dimKey);
                    CustomDim customDim = new CustomDim();
                    customDim.setDimNumber(dimension.getNumber());
                    if (customDimObj != null) {
                        customDim.setMemberNumber(customDimObj.getString("number"));
                        customDim.setMemberName(customDimObj.getString("name"));
                    } else {
                        customDim.setMemberNumber(dimension.getNoneNumber());
                        customDim.setMemberName(ResManager.loadResFormat((String)"\u4e0d\u533a\u5206%1", (String)"AdjustBillConvertor_1", (String)"epm-eb-business", (Object[])new Object[]{dimension.getName()}));
                    }
                    customDimList.add(customDim);
                }
                for (int j = 1; j <= periodColumns.size(); ++j) {
                    AdjustBillDetail adjustBillDetail = new AdjustBillDetail();
                    adjustBillDetail.setRow(row.intValue());
                    DynamicObject budgetPeriodObj = rowObj.getDynamicObject("adjbudgetperiod" + j);
                    if (budgetPeriodObj == null) continue;
                    BasicData budgetPeriod = new BasicData();
                    budgetPeriod.setId(Long.valueOf(budgetPeriodObj.getLong("id")));
                    budgetPeriod.setNumber(budgetPeriodObj.getString("number"));
                    budgetPeriod.setName(budgetPeriodObj.getString("name"));
                    adjustBillDetail.setBudgetPeriod(budgetPeriod);
                    adjustBillDetail.setEntity(entity);
                    adjustBillDetail.setAccount(account);
                    adjustBillDetail.setDatasetId(datasetId);
                    adjustBillDetail.setMetric(metric);
                    adjustBillDetail.setCustomDimList(customDimList);
                    adjustBillDetail.setAdjustData(rowObj.getBigDecimal("adjadjustdata" + j));
                    adjustBillDetail.setFinalData(rowObj.getBigDecimal("adjfinaldata" + j));
                    String billType = adjustBill.getBillType();
                    if (EbAdjBillTypeEnum.adjpst.getNumber().equals(billType)) {
                        adjustBillDetail.setGroupNum(rowObj.getString("adjgroupnum"));
                    }
                    detailList.add(adjustBillDetail);
                }
            }
        }
        adjustBill.setDetailList(detailList);
    }
}

