/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.validator.AdjustBillValidatorImpl;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.model.utils.ModelUtil;

public class AdjustBillValidator {
    public static void singleValidate(DynamicObject adjustBillObj, String opType) {
        AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill(adjustBillObj, false);
        ArrayList<AdjustBill> adjustBillList = new ArrayList<AdjustBill>(1);
        adjustBillList.add(adjustBill);
        HashSet<String> errorBillNos = new HashSet<String>(1);
        HashMap<String, String> errorInfos = new HashMap<String, String>(1);
        AdjustBillValidator.validate(adjustBillList, errorBillNos, errorInfos, opType);
        if (CollectionUtils.isNotEmpty(errorInfos.values())) {
            throw new KDBizException((String)errorInfos.values().iterator().next());
        }
    }

    public static void singleValidate(IDataModel dataModel, Set<Integer> completedRows, String opType) {
        DynamicObjectCollection budgetPeriods = (DynamicObjectCollection)dataModel.getValue("budgetperiods");
        HashSet<Integer> periodColumns = new HashSet<Integer>(budgetPeriods.size());
        for (int i = 0; i < budgetPeriods.size(); ++i) {
            periodColumns.add(i);
        }
        if (CollectionUtils.isEmpty(periodColumns) || CollectionUtils.isEmpty(completedRows)) {
            return;
        }
        AdjustBill adjustBill = AdjustBillConvertor.dataModel2AdjustBill(dataModel, completedRows, periodColumns);
        ArrayList<AdjustBill> adjustBillList = new ArrayList<AdjustBill>(1);
        adjustBillList.add(adjustBill);
        HashSet<String> errorBillNos = new HashSet<String>(1);
        HashMap<String, String> errorInfos = new HashMap<String, String>(1);
        AdjustBillValidator.validate(adjustBillList, errorBillNos, errorInfos, opType);
        if (CollectionUtils.isNotEmpty(errorInfos.values())) {
            throw new KDBizException((String)errorInfos.values().iterator().next());
        }
    }

    public static void batchValidate(List<DynamicInfoCollection.InfoObject> infoList, Map<String, String> errorInfos) {
        if (infoList.isEmpty()) {
            return;
        }
        ArrayList<Long> passedBillIds = new ArrayList<Long>(infoList.size());
        for (DynamicInfoCollection.InfoObject in : infoList) {
            DynamicObject[] billId = (DynamicObject[])in.getValueByPropName("billId");
            passedBillIds.add(Long.valueOf((String)billId));
        }
        DynamicObject[] passedBills = BusinessDataServiceHelper.load((Object[])passedBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bgm_adjustbill"));
        ArrayList<AdjustBill> adjustBillList = new ArrayList<AdjustBill>(16);
        for (DynamicObject bill : passedBills) {
            AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill(bill, false);
            adjustBillList.add(adjustBill);
        }
        HashSet<String> errorBillNos = new HashSet<String>(16);
        AdjustBillValidator.validate(adjustBillList, errorBillNos, errorInfos, "submit");
        Iterator<DynamicInfoCollection.InfoObject> iterator = infoList.iterator();
        while (iterator.hasNext()) {
            DynamicInfoCollection.InfoObject info = iterator.next();
            String billNum = (String)info.getValueByPropName("billno");
            if (!errorBillNos.contains(billNum)) continue;
            iterator.remove();
        }
    }

    public static void validate(List<AdjustBill> adjustBillList, Set<String> errorBillNos, Map<String, String> errorInfos, String opType) {
        Long modelId = adjustBillList.get(0).getModel().getId();
        String billType = adjustBillList.get(0).getBillType();
        HashSet<Long> selectBillIds = new HashSet<Long>(adjustBillList.size());
        if (adjustBillList.size() > 1) {
            for (AdjustBill adjustBill : adjustBillList) {
                selectBillIds.add(adjustBill.getBillId());
            }
        }
        boolean allowSameDims = AdjustHelper.isAllowSameDim(modelId, billType);
        boolean allowOnOrderBill = AdjustHelper.isAllowOnOrderBill(modelId, billType);
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)billType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        AdjustBillValidatorImpl validator = AdjustBillValidatorImpl.getInstance();
        ArrayList<String> _errorInfos = new ArrayList<String>(16);
        for (AdjustBill adjustBill : adjustBillList) {
            _errorInfos.clear();
            boolean validateDimView = validator.validateDimView(adjustBill, errorBillNos, _errorInfos);
            if (!validateDimView) {
                errorInfos.put(adjustBill.getBillNumber(), _errorInfos.isEmpty() ? adjustBill.getBillNumber() : (String)_errorInfos.get(0));
                continue;
            }
            boolean validateRowDimSamePass = validator.validateRowDimSame(adjustBill, errorBillNos, _errorInfos, allowSameDims);
            if (!validateRowDimSamePass) {
                errorInfos.put(adjustBill.getBillNumber(), _errorInfos.isEmpty() ? adjustBill.getBillNumber() : (String)_errorInfos.get(0));
                continue;
            }
            boolean validDimRulePass = validator.validateDimRule(adjustBill, errorBillNos, _errorInfos, auditTrail);
            if (!validDimRulePass) {
                errorInfos.put(adjustBill.getBillNumber(), _errorInfos.isEmpty() ? adjustBill.getBillNumber() : (String)_errorInfos.get(0));
                continue;
            }
            if (!"submit".equals(opType)) continue;
            boolean validateOnOrderBill = validator.validateOnOrderBill(adjustBill, errorBillNos, _errorInfos, selectBillIds, allowOnOrderBill);
            if (!validateOnOrderBill) {
                errorInfos.put(adjustBill.getBillNumber(), _errorInfos.isEmpty() ? adjustBill.getBillNumber() : (String)_errorInfos.get(0));
                continue;
            }
            boolean validateDimLock = validator.validateDimLock(adjustBill, errorBillNos, _errorInfos, auditTrail);
            if (validateDimLock) continue;
            errorInfos.put(adjustBill.getBillNumber(), _errorInfos.isEmpty() ? adjustBill.getBillNumber() : (String)_errorInfos.get(0));
        }
    }
}

