/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.adjust.AbstractAdjust;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;

public class AdjustSubmitOp
extends AbstractAdjust {
    private static final Log log = LogFactory.getLog(AdjustSubmitOp.class);

    public static AdjustSubmitOp get() {
        return new AdjustSubmitOp();
    }

    public void submit(DynamicObject[] bills) {
        block9: {
            if (bills == null || bills.length == 0) {
                return;
            }
            this.verify(bills, true);
            Long modelId = bills[0].getDynamicObject("model").getLong("id");
            IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            String formType = bills[0].getString("billtype");
            if (formType == null) {
                formType = EbAdjBillTypeEnum.adjust.getNumber();
            }
            if (!ControlParamsSettingUtil.isOpenReduceBill((Long)modelId, (String)formType)) break block9;
            if (cacheHelper.getModelobj().isModelByEB()) {
                for (DynamicObject bill : bills) {
                    AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill(bill, false);
                    IAdjustBillService adjustBillService = AdjustHelper.getInstance(AdjustBillEnum.EXPENSE);
                    adjustBillService.saveOccupyData2Olap(adjustBill, true);
                }
                for (DynamicObject adjust : bills) {
                    DynamicObjectCollection entries = adjust.getDynamicObjectCollection("adjdetailentity");
                    if (entries == null) continue;
                    for (DynamicObject entry : entries) {
                        BigDecimal adjustValue = entry.getBigDecimal("adjustdata");
                        if (adjustValue == null || adjustValue.compareTo(BigDecimal.ZERO) >= 0) continue;
                        entry.set("submitvalue", (Object)adjustValue);
                    }
                }
            } else {
                this.submitByBgm(bills, true);
                for (DynamicObject adjust : bills) {
                    DynamicObjectCollection entries = adjust.getDynamicObjectCollection("adjdetailentity");
                    if (entries == null) continue;
                    for (DynamicObject entry : entries) {
                        BigDecimal adjustValue = entry.getBigDecimal("adjustdata");
                        entry.set("submitvalue", (Object)adjustValue);
                    }
                }
            }
        }
    }

    @Override
    protected void verify(DynamicObject[] adjusts, boolean isSubmit) {
        super.verify(adjusts, isSubmit);
        if (adjusts == null || adjusts.length == 0) {
            return;
        }
        Long modelId = null;
        HashSet<String> status = new HashSet<String>();
        status.add(AdjustBillStateEnum.SAVE.getShortNumber());
        status.add(AdjustBillStateEnum.SUBMIT.getShortNumber());
        ArrayList billIds = Lists.newArrayListWithCapacity((int)adjusts.length);
        for (DynamicObject adjust : adjusts) {
            billIds.add(adjust.getLong("id"));
        }
        String entityNumber = adjusts[0].getDataEntityType().getName();
        Map<Long, String> billStatusMap = this.queryBillStatus(billIds, entityNumber);
        for (DynamicObject adjust : adjusts) {
            Long tmpId = adjust.getDynamicObject("model").getLong("id");
            if (modelId == null) {
                modelId = tmpId;
            } else if (tmpId.compareTo(modelId) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u63d0\u4ea4\u4e0d\u540c\u4f53\u7cfb\u4e0b\u7684\u9884\u7b97\u8c03\u6574\u3001\u8c03\u5242\u5355\u3002", (String)"Adjust_Submit_0", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            String billStatus = billStatusMap.get(adjust.getLong("id"));
            if (billStatus == null) {
                billStatus = adjust.getString("billstatus");
            }
            if (status.contains(billStatus)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u3001\u8c03\u5242\u5355\u4e0d\u662f\u4fdd\u5b58\u6216\u8005\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4", (String)"Adjust_Submit_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }
}

