/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.adjust.AbstractAdjust;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;

public class AdjustUnSubmitOp
extends AbstractAdjust {
    private static final Log log = LogFactory.getLog(AdjustUnSubmitOp.class);

    public static AdjustUnSubmitOp get() {
        return new AdjustUnSubmitOp();
    }

    public void unSubmit(DynamicObject[] adjusts) {
        if (adjusts == null || adjusts.length == 0) {
            return;
        }
        this.verify(adjusts, false);
        Long modelId = adjusts[0].getDynamicObject("model").getLong("id");
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(modelId);
        ArrayList billIds = Lists.newArrayListWithCapacity((int)adjusts.length);
        for (DynamicObject adjust : adjusts) {
            billIds.add(adjust.getLong("id"));
        }
        this.budgetOccupation(billIds, adjusts, modelCacheHelper);
        SaveServiceHelper.save((DynamicObject[])adjusts);
    }

    protected void budgetOccupation(List<Object> billIds, DynamicObject[] adjusts, IModelCacheHelper modelCacheHelper) {
        if (billIds == null || billIds.isEmpty() || adjusts == null || adjusts.length == 0 || modelCacheHelper == null) {
            return;
        }
        String formType = adjusts[0].getString("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        if (modelCacheHelper.getModelobj().isModelByEB()) {
            IAdjustBillService adjustBillService = AdjustHelper.getInstance(AdjustBillEnum.EXPENSE);
            for (DynamicObject bill : adjusts) {
                AdjustBill adjustBill = AdjustBillConvertor.dynamic2AdjustBill(bill, false);
                adjustBillService.saveOccupyData2Olap(adjustBill, false);
            }
        } else {
            this.submitByBgm(adjusts, false);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_eb_adjdetail set fsubmitvalue = 0 where ", new Object[0]).appendIn("fid", billIds);
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    @Override
    protected void verify(DynamicObject[] adjusts, boolean isSubmit) {
        super.verify(adjusts, isSubmit);
        if (adjusts == null || adjusts.length == 0) {
            return;
        }
        Long modelId = null;
        String formType = null;
        HashSet<String> status = new HashSet<String>();
        status.add(AdjustBillStateEnum.SUBMIT.getShortNumber());
        status.add(AdjustBillStateEnum.AUDITING.getShortNumber());
        ArrayList billIds = Lists.newArrayListWithCapacity((int)adjusts.length);
        for (DynamicObject adjust : adjusts) {
            billIds.add(adjust.getLong("id"));
        }
        String entityNumber = adjusts[0].getDataEntityType().getName();
        Map<Long, String> billStatusMap = this.queryBillStatus(billIds, entityNumber);
        for (DynamicObject adjust : adjusts) {
            Long tmpId = adjust.getDynamicObject("model").getLong("id");
            if (modelId == null) {
                modelId = tmpId;
            } else if (tmpId.compareTo(modelId) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u63d0\u4ea4\u4e0d\u540c\u4f53\u7cfb\u4e0b\u7684\u9884\u7b97\u8c03\u6574\u3001\u8c03\u5242\u5355\u3002", (String)"Adjust_Submit_0", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (formType == null) {
                formType = adjust.getString("billtype");
            } else if (!formType.equals(adjust.getString("billtype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u63d0\u4ea4\u9884\u7b97\u8c03\u6574\u5355\u548c\u8c03\u5242\u5355\u3002", (String)"Adjust_Submit_6", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            String billStatus = billStatusMap.get(adjust.getLong("id"));
            if (billStatus != null && status.contains(billStatus)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u3001\u8c03\u5242\u5355\u4e0d\u662f\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u64a4\u9500", (String)"Adjust_Submit_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }
}

