/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.epm.eb.business.adjust.CheckAdjustment;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;

public class CheckAdjust {
    private static final String ENTRYENTITY = "entryentity";

    public static boolean bgmIsAdjust(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache, IFormView view, String itemClickBar, String formType, String dataModelFormType) {
        CheckAdjust.bgmCheckDatas(dataModel, itemClickBar);
        return CheckAdjustment.bgmIsAdjustment(dataModel, customDimsInfoCache, view, itemClickBar, formType, dataModelFormType);
    }

    private static void bgmCheckDatas(IDataModel dataModel, String itemClickBar) {
        Map<String, List<DynamicObject>> group = CheckAdjust.bgmgetGroup(dataModel);
        DynamicObjectCollection multperiod = (DynamicObjectCollection)dataModel.getValue("budgetperiods");
        for (Map.Entry<String, List<DynamicObject>> entry : group.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            if (list.size() > 1) {
                CheckAdjust.bgmCheckMetric(list, key, itemClickBar);
            }
            CheckAdjust.bgmCheckSumEqualZero(multperiod, key, list, itemClickBar);
        }
    }

    private static String bgmBatchCheckMetric(List<DynamicObject> list, String key, String billno) {
        StringBuilder errorMessageSb = new StringBuilder();
        Set metricNumbers = list.stream().map(p -> p.getDynamicObject("metric").getString("number")).collect(Collectors.toSet());
        if (metricNumbers.size() > 1) {
            errorMessageSb.append(ResManager.loadResFormat((String)"\u7b2c%1\u7ec4\u5ea6\u91cf\u4e0d\u540c\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CheckAdjust_9", (String)"epm-eb-formplugin", (Object[])new Object[]{key})).append("\r\n");
        }
        return errorMessageSb.toString();
    }

    private static void bgmCheckMetric(List<DynamicObject> list, String key, String itemClickBar) {
        Set metricNumbers = list.stream().map(p -> p.getDynamicObject("adjmetric").getString("number")).collect(Collectors.toSet());
        if (metricNumbers.size() > 1) {
            String itemClickType = BudgetAdjustCheckUtils.getItemClickType(itemClickBar);
            String Message = ResManager.loadResFormat((String)"%1\u5931\u8d25\uff0c\u7b2c%2\u7ec4\u5ea6\u91cf\u4e0d\u540c\u3002", (String)"CheckAdjust_18", (String)"epm-eb-formplugin", (Object[])new Object[]{itemClickType, key});
            throw new KDBizException(Message);
        }
    }

    private static String bgmBatchCheckSumEqualZero(List<DynamicObject> list, String key, String billno) {
        StringBuilder errorMessageSb = new StringBuilder();
        BigDecimal finalData = BigDecimal.ZERO;
        for (DynamicObject doc : list) {
            finalData = finalData.add(doc.getBigDecimal("adjustdata"));
        }
        if (finalData.compareTo(BigDecimal.ZERO) != 0) {
            errorMessageSb.append(ResManager.loadResFormat((String)"\u7b2c%1\u7ec4\u8c03\u6574\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CheckAdjust_8", (String)"epm-eb-formplugin", (Object[])new Object[]{key})).append("\r\n");
        }
        return errorMessageSb.toString();
    }

    private static void bgmCheckSumEqualZero(DynamicObjectCollection multperiod, String key, List<DynamicObject> list, String itemClickBar) {
        BigDecimal finalData = CheckAdjust.bgmcomparaData(list, multperiod);
        if (finalData.compareTo(BigDecimal.ZERO) != 0) {
            String itemClickType = BudgetAdjustCheckUtils.getItemClickType(itemClickBar);
            String Message = ResManager.loadResFormat((String)"%1\u5931\u8d25\u3002\u7b2c%2\u7ec4\u6570\u636e\u8c03\u6574\u4e0d\u5e73\u8861\u3002", (String)"CheckAdjust_17", (String)"epm-eb-formplugin", (Object[])new Object[]{itemClickType, key});
            throw new KDBizException(Message);
        }
    }

    public static boolean IsAdjust(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache, IFormView view, String itemClickBar, String formType, String dataModelFormType) {
        Map<String, List<DynamicObject>> group = CheckAdjust.getGroup(dataModel);
        DynamicObjectCollection multperiod = (DynamicObjectCollection)dataModel.getValue("multperiod");
        for (Map.Entry<String, List<DynamicObject>> entry : group.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            BigDecimal finalData = CheckAdjust.comparaData(list, multperiod);
            if (finalData.compareTo(BigDecimal.ZERO) == 0) continue;
            String itemClickType = BudgetAdjustCheckUtils.getItemClickType(itemClickBar);
            String Message = ResManager.loadResFormat((String)"%1\u5931\u8d25\u3002\u7b2c%2\u7ec4\u6570\u636e\u8c03\u6574\u4e0d\u5e73\u8861\u3002", (String)"CheckAdjust_17", (String)"epm-eb-formplugin", (Object[])new Object[]{itemClickType, key});
            throw new KDBizException(Message);
        }
        return CheckAdjustment.IsAdjustment(dataModel, customDimsInfoCache, view, itemClickBar, formType, dataModelFormType);
    }

    private static BigDecimal bgmcomparaData(List<DynamicObject> list, DynamicObjectCollection multperiod) {
        BigDecimal finalData = BigDecimal.ZERO;
        for (DynamicObject doc : list) {
            for (int i = 1; i <= multperiod.size(); ++i) {
                finalData = finalData.add(doc.getBigDecimal("adjadjustdata" + i));
            }
        }
        return finalData;
    }

    private static BigDecimal comparaData(List<DynamicObject> list, DynamicObjectCollection multperiod) {
        BigDecimal finalData = BigDecimal.ZERO;
        for (DynamicObject doc : list) {
            BigDecimal adjadjustdata = BigDecimal.ZERO;
            for (int i = 1; i <= multperiod.size(); ++i) {
                adjadjustdata = adjadjustdata.add(doc.getBigDecimal("adjadjustdata" + i));
            }
            finalData = adjadjustdata.add(finalData);
        }
        return finalData;
    }

    private static String getAdjustEntryKey(DynamicObject entry) {
        StringBuilder memberKey = new StringBuilder();
        memberKey.append(entry.getString("entity.number")).append('@');
        memberKey.append(entry.getString("account.number")).append('@');
        if (entry.get("budgetperiod") != null) {
            memberKey.append(entry.getString("budgetperiod.number")).append('@');
        } else if (entry.get("year") != null && entry.get("period") != null) {
            memberKey.append(entry.getString("year.number")).append('@');
            memberKey.append(entry.getString("period.number")).append('@');
        }
        if (entry.get("customdim1") != null) {
            memberKey.append(entry.getString("customdim1.number")).append('@');
        }
        if (entry.get("customdim2") != null) {
            memberKey.append(entry.getString("customdim2.number")).append('@');
        }
        if (entry.get("customdim3") != null) {
            memberKey.append(entry.getString("customdim3.number")).append('@');
        }
        if (entry.get("customdim4") != null) {
            memberKey.append(entry.getString("customdim4.number")).append('@');
        }
        if (entry.get("customdim5") != null) {
            memberKey.append(entry.getString("customdim5.number")).append('@');
        }
        if (entry.get("customdim6") != null) {
            memberKey.append(entry.getString("customdim6.number")).append('@');
        }
        return memberKey.toString();
    }

    private static Map<String, List<DynamicObject>> bgmgetGroup(IDataModel dataModel) {
        HashMap<String, List<DynamicObject>> sameGroupMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection entryEntitys = dataModel.getEntryEntity(ENTRYENTITY);
        for (DynamicObject entryEntity : entryEntitys) {
            List currentGroupList = sameGroupMap.computeIfAbsent(entryEntity.getString("adjgroupnum").trim(), v -> new ArrayList(10));
            currentGroupList.add(entryEntity);
        }
        return sameGroupMap;
    }

    private static Map<String, List<DynamicObject>> getGroup(IDataModel dataModel) {
        HashMap<String, List<DynamicObject>> sameGroupMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(ENTRYENTITY);
        for (DynamicObject doc : entryEntity) {
            String groupnum = doc.getString("adjgroupnum").trim();
            if (!sameGroupMap.containsKey(groupnum)) {
                ArrayList<DynamicObject> groupList = new ArrayList<DynamicObject>(16);
                groupList.add(doc);
                sameGroupMap.put(groupnum, groupList);
                continue;
            }
            List list = (List)sameGroupMap.get(groupnum);
            list.add(doc);
        }
        return sameGroupMap;
    }

    public static void bgmbatchIsSubmitAdjust(DynamicObject[] bills, Map<Long, List<DynamicObject>> definedDimMap, DynamicInfoCollection billInfos) {
        CheckAdjustment.bgmbatchIsSubmitAdjustment(bills, definedDimMap, billInfos);
        HashMap<String, StringBuilder> billErrMessageMap = new HashMap<String, StringBuilder>(16);
        List values = billInfos.getValues();
        for (DynamicInfoCollection.InfoObject info : values) {
            String billNum = (String)info.getValueByPropName("billno");
            String errorInfo = (String)info.getValueByPropName("errorInfo");
            if (billErrMessageMap.containsKey(billNum)) continue;
            StringBuilder sb = new StringBuilder();
            billErrMessageMap.put(billNum, sb.append(errorInfo));
        }
        for (DynamicObject tempBill : bills) {
            ArrayList<String> errorMessageList = new ArrayList<String>(16);
            DynamicObjectCollection entryRows = tempBill.getDynamicObjectCollection("adjdetailentity");
            HashMap<String, List> groupMap = new HashMap<String, List>(16);
            for (DynamicObject entryRow : entryRows) {
                String groupNum = entryRow.getString("groupnum").trim();
                groupMap.computeIfAbsent(groupNum, v -> new ArrayList(16)).add(entryRow);
            }
            String billno = tempBill.getString("billno");
            for (Map.Entry entry : groupMap.entrySet()) {
                String key = (String)entry.getKey();
                List list = (List)entry.getValue();
                if (list.size() > 1) {
                    errorMessageList.add(CheckAdjust.bgmBatchCheckMetric(list, key, billno));
                }
                errorMessageList.add(CheckAdjust.bgmBatchCheckSumEqualZero(list, key, billno));
            }
            for (DynamicInfoCollection.InfoObject in : values) {
                if (!in.getValueByPropName("billno").equals(billno)) continue;
                StringBuilder errorMessageSb = (StringBuilder)billErrMessageMap.get(billno);
                String join = StringUtils.join(errorMessageList, (String)"");
                errorMessageSb.append(join);
                in.setValueByPropName("errorInfo", (Object)errorMessageSb.toString());
            }
        }
    }

    public static void batchIsSubmitAdjust(DynamicInfoCollection billInfos, List<String> headDimKeys, Map<String, DynamicInfoCollection> customDimInfo) {
        String billNum;
        CheckAdjustment.batchIsSubmitAdjustment(billInfos, headDimKeys, customDimInfo);
        HashMap<String, StringBuilder> billErrMessageMap = new HashMap<String, StringBuilder>(16);
        List values = billInfos.getValues();
        for (DynamicInfoCollection.InfoObject info : values) {
            billNum = (String)info.getValueByPropName("billno");
            String errorInfo = (String)info.getValueByPropName("errorInfo");
            if (billErrMessageMap.containsKey(billNum)) continue;
            StringBuilder sb = new StringBuilder();
            billErrMessageMap.put(billNum, sb.append(errorInfo));
        }
        for (DynamicInfoCollection.InfoObject in : values) {
            billNum = (String)in.getValueByPropName("billno");
            List entityDimStrs = (List)in.getValueByPropName("entityDimStrs");
            HashMap<String, BigDecimal> groupMap = new HashMap<String, BigDecimal>(16);
            for (int k = 0; k < entityDimStrs.size(); ++k) {
                String entityDimStr = (String)entityDimStrs.get(k);
                String money = entityDimStr.substring(entityDimStr.indexOf("(") + 1, entityDimStr.indexOf(")"));
                HashMap<Integer, Integer> moneyMap = new HashMap<Integer, Integer>(16);
                int p = 1;
                for (int i = 0; i < money.length(); ++i) {
                    if (money.charAt(i) != '@') continue;
                    moneyMap.put(p, i);
                    ++p;
                }
                if (!groupMap.containsKey(money.substring(0, (Integer)moneyMap.get(1)))) {
                    groupMap.put(money.substring(0, (Integer)moneyMap.get(1)), new BigDecimal(money.substring((Integer)moneyMap.get(2) + 1, (Integer)moneyMap.get(3))));
                    continue;
                }
                BigDecimal s = (BigDecimal)groupMap.get(money.substring(0, (Integer)moneyMap.get(1)));
                groupMap.put(money.substring(0, (Integer)moneyMap.get(1)), s.add(new BigDecimal(money.substring((Integer)moneyMap.get(2) + 1, (Integer)moneyMap.get(3)))));
            }
            for (Map.Entry entry : groupMap.entrySet()) {
                String key = (String)entry.getKey();
                if (((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) == 0) continue;
                StringBuilder stringBuilder = (StringBuilder)billErrMessageMap.get(billNum);
                String message = ResManager.loadResFormat((String)"\u7b2c%1\u7ec4\u8c03\u6574\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CheckAdjust_8", (String)"epm-eb-formplugin", (Object[])new Object[]{key});
                in.setValueByPropName("errorInfo", (Object)stringBuilder.append(message).append("\r\n").toString());
            }
        }
    }
}

