/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class CheckAdjustment {
    private static final Log log = LogFactory.getLog(CheckAdjustment.class);
    private static final String ENTRYENTITY = "entryentity";
    private static Map<String, BigDecimal> adjustValueMap = new HashMap<String, BigDecimal>(16);
    private static Map<String, BigDecimal> submitValueMap = new HashMap<String, BigDecimal>(16);
    private static Map<String, Map<String, BigDecimal>> adjustValueMapByBillNumber = new HashMap<String, Map<String, BigDecimal>>(16);
    private static Boolean adjustCheckFlag = false;

    public static boolean IsAdjustment(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache, IFormView view, String itemClickBar, String formType, String dataModelFormType) {
        boolean bl;
        List<CompareDataPojo> finalDataByPeriodAndOrg = CheckAdjustment.getFinalDataByPeriodAndOrg(dataModel, customDimsInfoCache);
        Long modelId = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        boolean allowNegative = ControlParamsSettingUtil.adjustAllowNegative((Long)modelId, (String)dataModelFormType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        boolean isLimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)modelId, (String)dataModelFormType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        if (!allowNegative) {
            for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
                if (compareDataPojo.getFinaldata().compareTo(BigDecimal.ZERO) >= 0) continue;
                String string = BudgetAdjustCheckUtils.getItemClickType(itemClickBar);
                String Message = ResManager.loadResFormat((String)"\u201c%1\u201d\u5931\u8d25\uff0c\u7b2c%2\u884c\u7684\u201c%3\u201d\u8c03\u6574\u540e\u7684\u9884\u7b97\u6570\u5c0f\u4e8e0\u3002", (String)"CheckAdjustment_3", (String)"epm-eb-formplugin", (Object[])new Object[]{string, compareDataPojo.getRow() + 1, compareDataPojo.getPreiodName()});
                throw new KDBizException(Message);
            }
        }
        if (isLimitBalance) {
            for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
                if (!compareDataPojo.isBeyondLimitBalance()) continue;
                String string = BudgetAdjustCheckUtils.getItemClickType(itemClickBar);
                String Message = ResManager.loadResFormat((String)"\u201c%1\u201d\u5931\u8d25\uff0c\u7b2c%2\u884c\u7684\u201c%3\u201d\u8c03\u6574\u540e\u7684\u9884\u7b97\u6570\u5c0f\u4e8e0\u3002", (String)"CheckAdjustment_3", (String)"epm-eb-formplugin", (Object[])new Object[]{string, compareDataPojo.getRow() + 1, compareDataPojo.getPreiodName()});
                throw new KDBizException(Message);
            }
        }
        ArrayList<CompareDataPojo> checkByPeriodAndOrg = new ArrayList<CompareDataPojo>(finalDataByPeriodAndOrg.size());
        for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            if (compareDataPojo.getAdjustdata().compareTo(BigDecimal.ZERO) == 0) continue;
            checkByPeriodAndOrg.add(compareDataPojo);
        }
        boolean bl2 = false;
        for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            if (compareDataPojo.getAdjustdata().compareTo(BigDecimal.ZERO) >= 0) continue;
            bl = true;
            break;
        }
        if (!bl && "adjustcheck".equals(itemClickBar)) {
            if ("1".equals(formType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5355\u8c03\u589e\u9884\u7b97\uff0c\u65e0\u9700\u8fdb\u884c\u68c0\u67e5\u3002", (String)"AdjustCheckPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if ("2".equals(formType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u5242\u5355\u8c03\u589e\u9884\u7b97\uff0c\u65e0\u9700\u8fdb\u884c\u8c03\u6574\u68c0\u67e5\u3002", (String)"AdjustCheckPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        adjustValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, "adjustValue", formType);
        adjustCheckFlag = false;
        Collection<IBudgetBalance> collection = CheckAdjustment.queryBalance(dataModel, customDimsInfoCache);
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        List values = customDimsInfoCache.getValues();
        long model = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        if (CollectionUtils.isNotEmpty(checkByPeriodAndOrg) && BudgetAdjustCheckUtils.checkAuditTrailParamRelation(model, formType).booleanValue()) {
            adjustCheckFlag = true;
            Collection<IBudgetBalance> checkIBudgetBalances = CheckAdjustment.queryBalance(dataModel, customDimsInfoCache);
            ArrayList<IBudgetBalance> resultIBudgetBalances = new ArrayList<IBudgetBalance>(checkIBudgetBalances.size());
            for (IBudgetBalance ibe : checkIBudgetBalances) {
                log.info("adjust check balance by eb getAccount() = " + ibe.getAccount(true).getNumber() + " getPeriod() = " + ibe.getPeriod(true) + " controltype = " + ibe.getSetting().getSettingType() + " getBalance() = " + ibe.getBalance() + " getAdjustCheckBalance() = " + ibe.getAdjustCheckBalance() + " getAdjustCheckBeyond() = " + ibe.getAdjustCheckBeyond() + " getBudget() = " + ibe.getBudget() + " getAdjustCheckBudget() = " + ibe.getAdjustCheckBudget());
                if ("submit".equals(itemClickBar) && ibe.getSetting().isBeyond() || !ibe.getAdjustCheckBeyond()) continue;
                resultIBudgetBalances.add(ibe);
            }
            if (CollectionUtils.isNotEmpty(resultIBudgetBalances)) {
                List orgNumberList = finalDataByPeriodAndOrg.stream().map(CompareDataPojo::getOrgnumber).collect(Collectors.toList());
                orgNumberList = orgNumberList.stream().distinct().collect(Collectors.toList());
                HashMap<String, Integer> orgNumberSortMap = new HashMap<String, Integer>(orgNumberList.size());
                for (int i = 0; i < orgNumberList.size(); ++i) {
                    orgNumberSortMap.put((String)orgNumberList.get(i), i);
                }
                BudgetAdjustCheckUtils.openAdjustCheckPage(view, resultIBudgetBalances, orgNumberSortMap);
                return true;
            }
        }
        if ("submit".equals(itemClickBar)) {
            for (IBudgetBalance ibe : collection) {
                for (CompareDataPojo com : finalDataByPeriodAndOrg) {
                    if (com.getAdjustdata().compareTo(BigDecimal.ZERO) >= 0 || com.getFinaldata().compareTo(BigDecimal.ZERO) < 0 || !CheckAdjustment.compareAllMember(ibe, com, values)) continue;
                    CheckAdjustment.setFinaladata(ibe, com);
                }
            }
        } else if ("adjustcheck".equals(itemClickBar)) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6574\u68c0\u67e5\u901a\u8fc7\u3002", (String)"AdjustCheckPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return false;
    }

    public static boolean bgmIsAdjustment(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache, IFormView view, String itemClickBar, String formType, String dataModelFormType) {
        boolean bl;
        List<CompareDataPojo> finalDataByPeriodAndOrg = CheckAdjustment.bgmgetFinalDataByPeriodAndOrg(dataModel, customDimsInfoCache);
        Long modelId = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        boolean allowNegative = ControlParamsSettingUtil.adjustAllowNegative((Long)modelId, (String)dataModelFormType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        boolean isLimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)modelId, (String)dataModelFormType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        if (!allowNegative) {
            for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
                if (compareDataPojo.getFinaldata().compareTo(BigDecimal.ZERO) >= 0) continue;
                String string = BudgetAdjustCheckUtils.getItemClickType(itemClickBar);
                String Message = ResManager.loadResFormat((String)"\u201c%1\u201d\u5931\u8d25\uff0c\u7b2c%2\u884c\u7684\u201c%3\u201d\u8c03\u6574\u540e\u7684\u9884\u7b97\u6570\u5c0f\u4e8e0\u3002", (String)"CheckAdjustment_3", (String)"epm-eb-formplugin", (Object[])new Object[]{string, compareDataPojo.getRow() + 1, compareDataPojo.getPreiodName()});
                throw new KDBizException(Message);
            }
        }
        if (isLimitBalance) {
            for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
                if (!compareDataPojo.isBeyondLimitBalance()) continue;
                String string = BudgetAdjustCheckUtils.getItemClickType(itemClickBar);
                String Message = ResManager.loadResFormat((String)"\u201c%1\u201d\u5931\u8d25\uff0c\u7b2c%2\u884c\u7684\u201c%3\u201d\u8c03\u6574\u540e\u7684\u9884\u7b97\u6570\u5c0f\u4e8e0\u3002", (String)"CheckAdjustment_3", (String)"epm-eb-formplugin", (Object[])new Object[]{string, compareDataPojo.getRow() + 1, compareDataPojo.getPreiodName()});
                throw new KDBizException(Message);
            }
        }
        ArrayList<CompareDataPojo> checkByPeriodAndOrg = new ArrayList<CompareDataPojo>(finalDataByPeriodAndOrg.size());
        for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            if (compareDataPojo.getAdjustdata().compareTo(BigDecimal.ZERO) == 0) continue;
            checkByPeriodAndOrg.add(compareDataPojo);
        }
        boolean bl2 = false;
        for (CompareDataPojo com : finalDataByPeriodAndOrg) {
            if (com.getAdjustdata().compareTo(BigDecimal.ZERO) >= 0) continue;
            bl = true;
        }
        if (!bl) {
            if ("adjustcheck".equals(itemClickBar)) {
                if ("1".equals(formType)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u5355\u8c03\u589e\u9884\u7b97\uff0c\u65e0\u9700\u8fdb\u884c\u68c0\u67e5\u3002", (String)"AdjustCheckPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if ("2".equals(formType)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u5242\u5355\u8c03\u589e\u9884\u7b97\uff0c\u65e0\u9700\u8fdb\u884c\u8c03\u6574\u68c0\u67e5\u3002", (String)"AdjustCheckPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
            return false;
        }
        adjustValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(checkByPeriodAndOrg, "adjustValue", formType);
        adjustCheckFlag = true;
        long l = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        Collection<Object> checkIBudgetBalances = new ArrayList(16);
        if (BudgetAdjustCheckUtils.checkAuditTrailParamRelation(l, formType).booleanValue()) {
            checkIBudgetBalances = CheckAdjustment.bgmqueryBalance(dataModel, customDimsInfoCache);
        }
        ArrayList<IBudgetBalance> resultIBudgetBalances = new ArrayList<IBudgetBalance>(checkIBudgetBalances.size());
        if (checkIBudgetBalances == null) {
            return false;
        }
        for (IBudgetBalance iBudgetBalance : checkIBudgetBalances) {
            log.info("adjust check balance by bgmd getAccount() = " + iBudgetBalance.getAccount(true).getNumber() + " getPeriod() = " + iBudgetBalance.getPeriod(true) + " controltype = " + iBudgetBalance.getSetting().getSettingType() + " getBalance() = " + iBudgetBalance.getBalance() + " getAdjustCheckBalance() = " + iBudgetBalance.getAdjustCheckBalance() + " getAdjustCheckBeyond() = " + iBudgetBalance.getAdjustCheckBeyond() + " getBudget() = " + iBudgetBalance.getBudget() + " getAdjustCheckBudget() = " + iBudgetBalance.getAdjustCheckBudget());
            if ("submit".equals(itemClickBar) && iBudgetBalance.getSetting().isBeyond() || !iBudgetBalance.getAdjustCheckBeyond()) continue;
            resultIBudgetBalances.add(iBudgetBalance);
        }
        if (CollectionUtils.isNotEmpty(resultIBudgetBalances)) {
            List orgNumberList = finalDataByPeriodAndOrg.stream().map(CompareDataPojo::getOrgnumber).collect(Collectors.toList());
            orgNumberList = orgNumberList.stream().distinct().collect(Collectors.toList());
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(orgNumberList.size());
            for (int i = 0; i < orgNumberList.size(); ++i) {
                hashMap.put((String)orgNumberList.get(i), i);
            }
            BudgetAdjustCheckUtils.openAdjustCheckPage(view, resultIBudgetBalances, hashMap);
            return true;
        }
        if ("adjustcheck".equals(itemClickBar)) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6574\u68c0\u67e5\u901a\u8fc7\u3002", (String)"AdjustCheckPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return false;
    }

    private static void setFinaladata(IBudgetBalance ibe, CompareDataPojo com) {
        BigDecimal adjustdata;
        BigDecimal budget = ibe.getBudget();
        if (budget == null) {
            budget = BigDecimal.ZERO;
        }
        if ((adjustdata = com.getAdjustdata()) == null) {
            adjustdata = BigDecimal.ZERO;
        }
        BigDecimal finalData = budget.add(adjustdata);
        com.setFinaldata(finalData);
    }

    private static List<CompareDataPojo> bgmgetFinalDataByPeriodAndOrg(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache) {
        Long modelId = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(ENTRYENTITY);
        DynamicObjectCollection budgetperiods = (DynamicObjectCollection)dataModel.getValue("budgetperiods");
        String versionNumber = ((DynamicObject)dataModel.getValue("version")).getString("number");
        String currencyNumber = ((DynamicObject)dataModel.getValue("currency")).getString("number");
        String changeTypeNumber = ((DynamicObject)dataModel.getValue("changetype")).getString("number");
        String dataTypeNumber = ((DynamicObject)dataModel.getValue("datatype")).getString("number");
        long model = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        long bizmodel = ((DynamicObject)dataModel.getValue("bizmodel")).getLong("id");
        String billNumber = (String)dataModel.getValue("billno");
        Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByBizModel(modelId, bizmodel);
        StringBuilder rowDimMembers = new StringBuilder();
        HashMap<String, CompareDataPojo> rowAdjustDataMap = new HashMap<String, CompareDataPojo>(16);
        ArrayList<CompareDataPojo> rowData = new ArrayList<CompareDataPojo>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String orgNumber = ((DynamicObject)entry.get("adjentity")).getString("number");
            String accountNumber = ((DynamicObject)entry.get("adjaccount")).getString("number");
            String metricNumber = ((DynamicObject)entry.get("adjmetric")).getString("number");
            Long accountId = entry.getLong("adjaccount.id");
            Long datasetId = AdjustHelper.getDatasetId(accountId);
            Map<String, Dimension> rowCustomDimMap = AdjustHelper.getCustomDimsByDataset(modelId, datasetId, customDimMap);
            int row = i;
            for (int j = 1; j < budgetperiods.size() + 1; ++j) {
                CompareDataPojo com;
                DynamicObject object = (DynamicObject)entry.get("adjbudgetperiod" + j);
                if (object == null) continue;
                String periodName = object.getString("name");
                String period = object.getString("number");
                BigDecimal adjadjustdata = (BigDecimal)entry.get("adjadjustdata" + j);
                BigDecimal finaldata = (BigDecimal)entry.get("adjfinaldata" + j);
                BigDecimal limitBalance = (BigDecimal)entry.get("adjlimitbalance" + j);
                boolean isBeyond = Convert.toBool((Object)entry.get("adjbeyond" + j), (Boolean)true);
                HashMap<String, String> customdimMap = new HashMap<String, String>(16);
                HashMap<String, String> customDimMemberMap = new HashMap<String, String>(16);
                rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(period).append("!!").append(SysDimensionEnum.Entity.getNumber()).append("@").append(orgNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
                for (Map.Entry<String, Dimension> customEntry : rowCustomDimMap.entrySet()) {
                    String dimKey = "adj" + customEntry.getKey();
                    Dimension customDim = customEntry.getValue();
                    DynamicObject customDimObj = entry.getDynamicObject(dimKey);
                    String customDimMem = customDimObj != null ? customDimObj.getString("number") : customDim.getNoneNumber();
                    customdimMap.put(dimKey, customDimMem);
                    customDimMemberMap.put(customDim.getNumber(), customDimMem);
                    rowDimMembers.append("!!").append(customDim.getNumber()).append("@").append(customDimMem);
                }
                if (rowAdjustDataMap.containsKey(rowDimMembers.toString())) {
                    com = (CompareDataPojo)rowAdjustDataMap.get(rowDimMembers.toString());
                    com.setAdjustdata(com.getAdjustdata().add(adjadjustdata));
                    com.setFinaldata(finaldata);
                    com.setRow(row);
                } else {
                    com = new CompareDataPojo(periodName, finaldata, adjadjustdata, limitBalance, isBeyond, orgNumber, accountNumber, row);
                    com.setPreiod(period);
                    com.setCurrencyNumber(currencyNumber);
                    com.setVersionNumber(versionNumber);
                    com.setChangetypeNumber(changeTypeNumber);
                    com.setCustomdimMap(customdimMap);
                    com.setCustomdimMemberMap(customDimMemberMap);
                    com.setMetricNumber(metricNumber);
                    com.setDatatypeNumber(dataTypeNumber);
                    com.setModel(Long.valueOf(model));
                    com.setBizmodel(Long.valueOf(bizmodel));
                    com.setBillNumber(billNumber);
                    rowData.add(com);
                    rowAdjustDataMap.put(rowDimMembers.toString(), com);
                }
                rowDimMembers.setLength(0);
            }
        }
        return rowData;
    }

    private static List<CompareDataPojo> getFinalDataByPeriodAndOrg(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache) {
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(ENTRYENTITY);
        DynamicObjectCollection multperiod = (DynamicObjectCollection)dataModel.getValue("multperiod");
        String versionNumber = ((DynamicObject)dataModel.getValue("version")).getString("number");
        String yearNumber = ((DynamicObject)dataModel.getValue("year")).getString("number");
        String currencyNumber = ((DynamicObject)dataModel.getValue("currency")).getString("number");
        String dataTypeNumber = ((DynamicObject)dataModel.getValue("datatype")).getString("number");
        long model = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        String billNumber = (String)dataModel.getValue("billno");
        ArrayList<CompareDataPojo> rowData = new ArrayList<CompareDataPojo>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String orgNumber = ((DynamicObject)entry.get("adjentity")).getString("number");
            String accountNumber = ((DynamicObject)entry.get("adjaccount")).getString("number");
            int row = i;
            for (int j = 1; j < multperiod.size() + 1; ++j) {
                DynamicObject object = (DynamicObject)entry.get("adjperiod" + j);
                if (object == null) continue;
                String periodName = object.getString("name");
                String period = object.getString("number");
                if (entry.getBigDecimal("adjadjustdata" + j).compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal adjadjustdata = (BigDecimal)entry.get("adjadjustdata" + j);
                BigDecimal finaldata = (BigDecimal)entry.get("adjfinaldata" + j);
                BigDecimal limitbalance = (BigDecimal)entry.get("adjlimitbalance" + j);
                boolean isBeyond = Convert.toBool((Object)entry.get("adjbeyond" + j), (Boolean)true);
                CompareDataPojo com = new CompareDataPojo(periodName, finaldata, adjadjustdata, limitbalance, isBeyond, orgNumber, accountNumber, row);
                com.setPreiod(period);
                com.setCurrencyNumber(currencyNumber);
                com.setYearNumber(yearNumber);
                com.setVersionNumber(versionNumber);
                HashMap<Object, String> CustomdimMap = new HashMap<Object, String>(16);
                HashMap<Object, String> customDimMemberMap = new HashMap<Object, String>(16);
                for (DynamicInfoCollection.InfoObject in : customDimsInfoCache.getValues()) {
                    CustomdimMap.put(in.getValueByPropName("controlkey"), ((DynamicObject)entry.get((String)in.getValueByPropName("controlkey"))).getString("number"));
                    customDimMemberMap.put(in.getValueByPropName("number"), ((DynamicObject)entry.get((String)in.getValueByPropName("controlkey"))).getString("number"));
                }
                com.setCustomdimMap(CustomdimMap);
                com.setCustomdimMemberMap(customDimMemberMap);
                com.setModel(Long.valueOf(model));
                com.setDatatypeNumber(dataTypeNumber);
                com.setBillNumber(billNumber);
                rowData.add(com);
            }
        }
        return rowData;
    }

    private static Collection<IBudgetBalance> bgmqueryBalance(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache) {
        ArrayList<String> type = new ArrayList<String>(16);
        ArrayList<Map<String, String>> dimlist = new ArrayList(16);
        if (adjustCheckFlag.booleanValue()) {
            long model = ((DynamicObject)dataModel.getValue("model")).getLong("id");
            long bizModel = ((DynamicObject)dataModel.getValue("bizmodel")).getLong("id");
            dimlist.addAll(CheckAdjustment.bgmgetDimQueryList(dataModel, customDimsInfoCache, false));
            if (BudgetAdjustCheckUtils.checkCustomDimExist(model, bizModel)) {
                dimlist.addAll(CheckAdjustment.bgmgetDimQueryList(dataModel, customDimsInfoCache, true));
            }
        }
        if (!CheckAdjustment.IsExitMixturePeriod(dimlist = dimlist.stream().distinct().collect(Collectors.toList()), type)) {
            return CheckAdjustment.getAllIbCollection(dimlist, dataModel, type, null, null);
        }
        return CheckAdjustment.queryBalanceBytype(dataModel, dimlist, type, null, null);
    }

    private static Collection<IBudgetBalance> queryBalance(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache) {
        ArrayList<String> type = new ArrayList<String>(16);
        ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
        long model = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        if (adjustCheckFlag.booleanValue()) {
            CheckAdjustment.getDimQueryList(dimlist, dataModel, customDimsInfoCache, true, false);
            if (BudgetAdjustCheckUtils.checkCustomDimExist(model, 0L)) {
                CheckAdjustment.getDimQueryList(dimlist, dataModel, customDimsInfoCache, true, true);
            }
        } else {
            CheckAdjustment.getDimQueryList(dimlist, dataModel, customDimsInfoCache, false, false);
        }
        if (!CheckAdjustment.IsExitMixturePeriod(dimlist, type)) {
            return CheckAdjustment.getAllIbCollection(dimlist, dataModel, type, null, null);
        }
        return CheckAdjustment.queryBalanceBytype(dataModel, dimlist, type, null, null);
    }

    private static Collection<IBudgetBalance> getAllIbCollection(List<Map<String, String>> dimlist, IDataModel dataModel, Collection<String> type, Long modelid, Long bussModelid) {
        ArrayList<IBudgetBalance> cl = new ArrayList<IBudgetBalance>(16);
        ArrayList<Map<String, String>> qlist = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> hlist = new ArrayList<Map<String, String>>(16);
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>(16);
        for (int k = 0; k < dimlist.size(); ++k) {
            for (String key : dimlist.get(k).keySet()) {
                if (key.equals("Period") && dimlist.get(k).get(key).startsWith("Q_") || key.equals("BudgetPeriod") && dimlist.get(k).get(key).contains(".Q")) {
                    qlist.add(dimlist.get(k));
                    continue;
                }
                if (key.equals("Period") && dimlist.get(k).get(key).startsWith("HF_") || key.equals("BudgetPeriod") && dimlist.get(k).get(key).contains(".HF")) {
                    hlist.add(dimlist.get(k));
                    continue;
                }
                if ((!key.equals("Period") || !dimlist.get(k).get(key).startsWith("M_")) && (!key.equals("BudgetPeriod") || !dimlist.get(k).get(key).contains(".M"))) continue;
                mlist.add(dimlist.get(k));
            }
        }
        if (qlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            Collection<IBudgetBalance> budgetBalances = CheckAdjustment.queryBalanceBytype(dataModel, qlist, type, modelid, bussModelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (hlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            Collection<IBudgetBalance> budgetBalances = CheckAdjustment.queryBalanceBytype(dataModel, hlist, type, modelid, bussModelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        if (mlist.size() != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection<IBudgetBalance> budgetBalances = CheckAdjustment.queryBalanceBytype(dataModel, mlist, type, modelid, bussModelid);
            cl.addAll(budgetBalances);
            type.clear();
        }
        return cl;
    }

    private static Collection<IBudgetBalance> queryBalanceBytype(IDataModel dataModel, List<Map<String, String>> dimlist, Collection<String> type, Long modelid, Long bussModelid) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        Collection<IBudgetBalance> iBudgetBalances = null;
        modelid = dataModel == null ? modelid.longValue() : ((DynamicObject)dataModel.getValue("model")).getLong("id");
        Long bussinessModelId = dataModel == null || dataModel.getValue("bizmodel") == null ? 0L : ((DynamicObject)dataModel.getValue("bizmodel")).getLong("id");
        if (IDUtils.isNotEmptyLong((Long)bussModelid).booleanValue()) {
            bussinessModelId = bussModelid;
        }
        iBudgetBalances = adjustCheckFlag != false ? bgControlCaller.queryBalance(modelid, dimlist, type, true, bussinessModelId, adjustValueMap, submitValueMap) : bgControlCaller.queryBalance(modelid, dimlist, type, true, bussinessModelId);
        return iBudgetBalances;
    }

    private static boolean IsExitMixturePeriod(List<Map<String, String>> dimlist, Collection<String> type) {
        int i = 0;
        int j = 0;
        int z = 0;
        for (Map<String, String> map : dimlist) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value;
                if ("Period".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value.startsWith("Q_")) {
                        ++i;
                    } else if (value.startsWith("H_")) {
                        ++j;
                    } else if (value.startsWith("M_")) {
                        ++z;
                    }
                }
                if (!"BudgetPeriod".equals(entry.getKey())) continue;
                value = entry.getValue();
                if (value.indexOf(".Q") >= 0) {
                    ++i;
                    continue;
                }
                if (value.indexOf(".H") >= 0) {
                    ++j;
                    continue;
                }
                if (value.indexOf(".M") < 0) continue;
                ++z;
            }
        }
        if (i != 0 && j == 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        } else if (i == 0 && j != 0 && z == 0) {
            type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        } else if (i == 0 && j == 0 && z != 0) {
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
        } else {
            return false;
        }
        return true;
    }

    private static List<Map<String, String>> bgmgetDimQueryList(IDataModel dataModel, DynamicInfoCollection customDimsInfoCache, boolean customTotalFlag) {
        ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
        DynamicObjectCollection budgetperiods = (DynamicObjectCollection)dataModel.getValue("budgetperiods");
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(ENTRYENTITY);
        Long modelId = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        String formType = (String)dataModel.getValue("billtype");
        String billNumber = (String)dataModel.getValue("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        for (DynamicObject entryDynamicObject : entryEntity) {
            Long accountId = entryDynamicObject.getLong("adjaccount.id");
            Long datasetId = AdjustHelper.getDatasetId(accountId);
            DynamicInfoCollection rowCustomDimsInfoCache = AdjustHelper.getRowCustomDimInfo(customDimsInfoCache, modelId, datasetId);
            String entryNumber = ((DynamicObject)entryDynamicObject.get("adjentity")).getString("number");
            String accountNumber = ((DynamicObject)entryDynamicObject.get("adjaccount")).getString("number");
            String metricNumber = ((DynamicObject)entryDynamicObject.get("adjmetric")).getString("number");
            for (int i = 0; i < budgetperiods.size(); ++i) {
                int adjustValueIndex = i + 1;
                if (entryDynamicObject.getBigDecimal("adjadjustdata" + adjustValueIndex).compareTo(BigDecimal.ZERO) == 0) continue;
                HashMap<Object, Object> dimMap = new HashMap<Object, Object>(16);
                dimMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), ((DynamicObject)budgetperiods.get(i)).getString("fbasedataid.number"));
                String datatypeNumber = ((DynamicObject)dataModel.getValue("datatype")).getString("number");
                dimMap.put(SysDimensionEnum.DataType.getNumber(), datatypeNumber);
                String versionNumber = ((DynamicObject)dataModel.getValue("version")).getString("number");
                dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
                String currencyNumber = ((DynamicObject)dataModel.getValue("currency")).getString("number");
                dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                String changetypeNumber = ((DynamicObject)dataModel.getValue("changetype")).getString("number");
                dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changetypeNumber);
                dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
                dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
                dimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
                dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
                if (!rowCustomDimsInfoCache.isEmpty()) {
                    for (DynamicInfoCollection.InfoObject in : rowCustomDimsInfoCache.getValues()) {
                        if (customTotalFlag) {
                            dimMap.put(in.getValueByPropName("number"), in.getValueByPropName("number"));
                            continue;
                        }
                        dimMap.put(in.getValueByPropName("number"), ((DynamicObject)entryDynamicObject.get((String)in.getValueByPropName("controlkey"))).getString("number"));
                    }
                }
                dimMap.put("billNumber", billNumber);
                dimlist.add(dimMap);
            }
        }
        return dimlist;
    }

    private static void getDimQueryList(List<Map<String, String>> dimlist, IDataModel dataModel, DynamicInfoCollection customDimsInfoCache, boolean checkFlag, boolean customTotalFlag) {
        DynamicObjectCollection priod = (DynamicObjectCollection)dataModel.getValue("multperiod");
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(ENTRYENTITY);
        Long modelId = ((DynamicObject)dataModel.getValue("model")).getLong("id");
        String formType = (String)dataModel.getValue("billtype");
        String billNumber = (String)dataModel.getValue("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        for (DynamicObject entryDynamicObject : entryEntity) {
            String entryNumber = ((DynamicObject)entryDynamicObject.get("adjentity")).getString("number");
            String accountNumber = ((DynamicObject)entryDynamicObject.get("adjaccount")).getString("number");
            for (int i = 0; i < priod.size(); ++i) {
                if (checkFlag) {
                    int adjustValueIndex = i + 1;
                    if (entryDynamicObject.getBigDecimal("adjadjustdata" + adjustValueIndex).compareTo(BigDecimal.ZERO) == 0) continue;
                }
                HashMap<String, String> dimMap = new HashMap<String, String>(16);
                dimMap.put(SysDimensionEnum.Period.getNumber(), ((DynamicObject)priod.get(i)).getString("fbasedataid.number"));
                String datatypeNumber = ((DynamicObject)dataModel.getValue("datatype")).getString("number");
                dimMap.put(SysDimensionEnum.DataType.getNumber(), datatypeNumber);
                String versionNumber = ((DynamicObject)dataModel.getValue("version")).getString("number");
                dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
                String yearNumber = ((DynamicObject)dataModel.getValue("year")).getString("number");
                dimMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
                String currencyNumber = ((DynamicObject)dataModel.getValue("currency")).getString("number");
                dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                String changetypeNumber = ((DynamicObject)dataModel.getValue("changetype")).getString("number");
                dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changetypeNumber);
                dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
                dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
                dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
                if (!customDimsInfoCache.isEmpty()) {
                    if (checkFlag && customTotalFlag) {
                        for (DynamicInfoCollection.InfoObject in : customDimsInfoCache.getValues()) {
                            dimMap.put((String)in.getValueByPropName("number"), (String)in.getValueByPropName("number"));
                        }
                    } else {
                        for (DynamicInfoCollection.InfoObject in : customDimsInfoCache.getValues()) {
                            dimMap.put((String)in.getValueByPropName("number"), ((DynamicObject)entryDynamicObject.get((String)in.getValueByPropName("controlkey"))).getString("number"));
                        }
                    }
                }
                if (checkFlag) {
                    dimMap.put("billNumber", billNumber);
                }
                dimlist.add(dimMap);
            }
        }
    }

    private static boolean compareAllMember(IBudgetBalance ibe, CompareDataPojo com, List<DynamicInfoCollection.InfoObject> values) {
        return CheckAdjustment.customDimsSame(ibe, com, values) && CheckAdjustment.compareMember(ibe, com);
    }

    private static boolean customDimsSame(IBudgetBalance ibe, CompareDataPojo com, List<DynamicInfoCollection.InfoObject> values) {
        int size = values.size();
        Map customdimMap = com.getCustomdimMap();
        if (customdimMap == null) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            Member member = ibe.getMember(true, (String)values.get(i).getValueByPropName("number"));
            String customMember = (String)customdimMap.get(values.get(i).getValueByPropName("controlkey"));
            if (member == null || member.getNumber() == null || !StringUtils.isNotEmpty((String)customMember) || member.getNumber().equals(customMember)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareMember(IBudgetBalance ibe, CompareDataPojo com) {
        if (ibe == null || com == null) {
            return false;
        }
        String account = ibe.getAccount(true).getNumber();
        String orgUnit = ibe.getOrgUnit(true).getNumber();
        String version = ibe.getVersion(true).getNumber();
        String currency = ibe.getCurrency(true).getNumber();
        if (ibe.getBizModel().isEBByModel()) {
            String year = ibe.getYear(true).getNumber();
            String period = ibe.getPeriod(true).getNumber();
            return account.equals(com.getAccountNumber()) && orgUnit.equals(com.getOrgnumber()) && period.equals(com.getPreiod()) && version.equals(com.getVersionNumber()) && year.equals(com.getYearNumber()) && currency.equals(com.getCurrencyNumber());
        }
        String metric = ibe.getMember(true, SysDimensionEnum.Metric.getNumber()).getNumber();
        String period = ibe.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
        return account.equals(com.getAccountNumber()) && orgUnit.equals(com.getOrgnumber()) && metric.equals(com.getMetricNumber()) && period.equals(com.getPreiod()) && version.equals(com.getVersionNumber()) && currency.equals(com.getCurrencyNumber());
    }

    public static void bgmbatchIsSubmitAdjustment(DynamicObject[] bills, Map<Long, List<DynamicObject>> definedDimMap, DynamicInfoCollection billInfos) {
        List values = billInfos.getValues();
        HashMap<String, StringBuilder> billErrMessageMap = new HashMap<String, StringBuilder>(16);
        for (DynamicInfoCollection.InfoObject in : values) {
            if (billErrMessageMap.containsKey(in.getValueByPropName("billno"))) continue;
            StringBuilder sb = new StringBuilder();
            billErrMessageMap.put((String)in.getValueByPropName("billno"), sb);
        }
        Map<Long, List<CompareDataPojo>> finalDataByPeriodAndOrg = CheckAdjustment.bgmgetFinalDataByPeriodAndOrgByBatch(bills, definedDimMap);
        Map<String, List<CompareDataPojo>> checkDataByPeriodAndOrg = CheckAdjustment.bgmGetCheckDataByPeriodAndOrgByBatch(bills, definedDimMap);
        String formType = null;
        Long modelId = 0L;
        if (bills.length > 0 && bills[0] != null) {
            formType = bills[0].getString("billtype");
            modelId = bills[0].getDynamicObject("model").getLong("id");
        }
        BudgetAdjustCheckUtils.getBatchBillSameCheckDataMap(checkDataByPeriodAndOrg);
        adjustValueMapByBillNumber = CheckAdjustment.getAdjustValueMapByBill(checkDataByPeriodAndOrg, formType);
        adjustCheckFlag = true;
        Map<Object, Object> checkIBudgetBalances = new HashMap(bills.length);
        if (BudgetAdjustCheckUtils.checkAuditTrailParamRelation(modelId, formType).booleanValue()) {
            checkIBudgetBalances = CheckAdjustment.bgmqueryBalanceByBatch(bills, definedDimMap);
        }
        HashMap modelCacheHelperMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap modelViewIdsMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap<String, Integer> errorCount = new HashMap<String, Integer>(16);
        for (DynamicObject tempBill : bills) {
            boolean allowNegative = ControlParamsSettingUtil.adjustAllowNegative((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
            boolean isShowlimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
            List<CompareDataPojo> compareDataPojos = finalDataByPeriodAndOrg.get(tempBill.getLong("id"));
            if (allowNegative && !isShowlimitBalance) continue;
            for (CompareDataPojo com : compareDataPojos) {
                IModelCacheHelper orCreate = modelCacheHelperMap.computeIfAbsent(com.getModel(), f -> ModelCacheContext.getOrCreate((Long)com.getModel()));
                Map viewIds = modelViewIdsMap.computeIfAbsent(com.getBizmodel(), f -> orCreate.getViewsByBusModel(com.getBizmodel()));
                if ((allowNegative || com.getFinaldata().compareTo(BigDecimal.ZERO) >= 0) && (!isShowlimitBalance || !com.isBeyondLimitBalance())) continue;
                for (DynamicInfoCollection.InfoObject in : values) {
                    if (!in.getValueByPropName("billno").equals(com.getBillNumber())) continue;
                    Integer index = (Integer)errorCount.get(com.getBillNumber());
                    if (index == null) {
                        index = 0;
                    }
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    errorCount.put(com.getBillNumber(), index);
                    String message = ResManager.loadResFormat((String)"\u3000\u3000(%1)\u9884\u7b97\u7ec4\u7ec7\u201c%2\u201d\u3001\u9884\u7b97\u79d1\u76ee\u4e3a\u201c%3\u201d\u3001\u9884\u7b97\u671f\u95f4\u201c%4\u201d", (String)"CheckAdjustment_17", (String)"epm-eb-formplugin", (Object[])new Object[]{index, BudgetAdjustCheckUtils.getMemberName(orCreate, SysDimensionEnum.Entity.getNumber(), (Long)viewIds.get(SysDimensionEnum.Entity.getNumber()), com.getOrgnumber()), BudgetAdjustCheckUtils.getMemberName(orCreate, SysDimensionEnum.Account.getNumber(), null, com.getAccountNumber()), BudgetAdjustCheckUtils.getMemberName(orCreate, SysDimensionEnum.BudgetPeriod.getNumber(), null, com.getPreiod())});
                    if (index <= 1) {
                        ((StringBuilder)billErrMessageMap.get(com.getBillNumber())).append(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u9884\u7b97\u6570\u5c0f\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CheckAdjustment_16", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n").append(ResManager.loadResFormat((String)"\u3000\u3000\u4ee5\u4e0b\u6570\u636e\u5b58\u5728\u95ee\u9898\uff1a%1", (String)"CheckAdjustment_18", (String)"epm-eb-formplugin", (Object[])new Object[]{""})).append("\r\n").append(message).append("\r\n");
                        continue;
                    }
                    ((StringBuilder)billErrMessageMap.get(com.getBillNumber())).append(message).append("\r\n");
                }
            }
        }
        for (DynamicObject tempBill : bills) {
            String billNo = tempBill.getString("billno");
            Collection checkBudgetBalances = (Collection)checkIBudgetBalances.get(billNo);
            if (checkBudgetBalances == null) continue;
            ArrayList<IBudgetBalance> resultBudgetBalances = new ArrayList<IBudgetBalance>(checkBudgetBalances.size());
            for (IBudgetBalance ibe : checkBudgetBalances) {
                log.info("adjust check balance by batch bamd getAccount() = " + ibe.getAccount(true).getNumber() + " getPeriod() = " + ibe.getPeriod(true) + " controltype = " + ibe.getSetting().getSettingType() + " getBalance() = " + ibe.getBalance() + " getAdjustCheckBalance() = " + ibe.getAdjustCheckBalance() + " getAdjustCheckBeyond() = " + ibe.getAdjustCheckBeyond() + " getBudget() = " + ibe.getBudget() + " getAdjustCheckBudget() = " + ibe.getAdjustCheckBudget());
                if (!ibe.getAdjustCheckBeyond() || ibe.getSetting().isBeyond()) continue;
                resultBudgetBalances.add(ibe);
            }
            for (DynamicInfoCollection.InfoObject in : values) {
                if (!in.getValueByPropName("billno").equals(billNo)) continue;
                StringBuilder stringBuilder = (StringBuilder)billErrMessageMap.get(billNo);
                if (resultBudgetBalances.size() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u3000\u3000\u8c03\u6574\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"CheckAdjustment_19", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
                    continue;
                }
                stringBuilder.append(ResManager.loadKDString((String)"\u8c03\u6574\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"CheckAdjustment_15", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
            }
        }
        for (DynamicInfoCollection.InfoObject in : values) {
            StringBuilder stringBuilder = (StringBuilder)billErrMessageMap.get(in.getValueByPropName("billno"));
            in.setValueByPropName("errorInfo", (Object)stringBuilder.toString());
        }
    }

    public static void batchIsSubmitAdjustment(DynamicInfoCollection billInfos, List<String> headDimKeys, Map<String, DynamicInfoCollection> CustomDimInfo) {
        List values = billInfos.getValues();
        List props = billInfos.getProps();
        HashMap<String, List<DynamicInfoCollection.InfoObject>> map = new HashMap<String, List<DynamicInfoCollection.InfoObject>>(16);
        for (Object in : values) {
            List<Object> list;
            if (!map.containsKey(in.getValueByPropName("modelCube"))) {
                list = new ArrayList<Object>(16);
                list.add(in);
                map.put((String)in.getValueByPropName("modelCube"), list);
                continue;
            }
            list = (List)map.get(in.getValueByPropName("modelCube"));
            list.add(in);
        }
        HashMap<String, List<DynamicInfoCollection.InfoObject>> billNoMap = new HashMap<String, List<DynamicInfoCollection.InfoObject>>(16);
        for (DynamicInfoCollection.InfoObject in : values) {
            List<DynamicInfoCollection.InfoObject> list;
            if (!billNoMap.containsKey(in.getValueByPropName("billno"))) {
                list = new ArrayList<DynamicInfoCollection.InfoObject>(16);
                list.add(in);
                billNoMap.put((String)in.getValueByPropName("billno"), list);
                continue;
            }
            list = (List)billNoMap.get(in.getValueByPropName("billno"));
            list.add(in);
        }
        HashMap<String, StringBuilder> billErrMessageMap = new HashMap<String, StringBuilder>(16);
        for (DynamicInfoCollection.InfoObject in : values) {
            if (billErrMessageMap.containsKey(in.getValueByPropName("billno"))) continue;
            StringBuilder sb = new StringBuilder();
            billErrMessageMap.put((String)in.getValueByPropName("billno"), sb);
        }
        Map<String, List<CompareDataPojo>> finalDataByPeriodAndOrg = CheckAdjustment.getFinalDataByPeriodAndOrgByBatch(map, props, CustomDimInfo);
        Map<String, List<CompareDataPojo>> billNumberCheckDataMap = CheckAdjustment.getBillNumberCheckDataMap(finalDataByPeriodAndOrg);
        String formType = null;
        String modelId = "0L";
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            formType = (String)((DynamicInfoCollection.InfoObject)values.get(0)).getValueByPropName("billtype");
            modelId = (String)((DynamicInfoCollection.InfoObject)values.get(0)).getValueByPropName("modelId");
        }
        BudgetAdjustCheckUtils.getBatchBillSameCheckDataMap(billNumberCheckDataMap);
        adjustValueMapByBillNumber = CheckAdjustment.getAdjustValueMapByBillNumber(billNumberCheckDataMap, "adjustValue", formType);
        adjustCheckFlag = false;
        Map<String, Collection<IBudgetBalance>> iBudgetBalances = CheckAdjustment.queryBalanceByBatch(map, props, CustomDimInfo);
        Map<Object, Object> checkIBudgetBalances = new HashMap(iBudgetBalances.size());
        if (billNumberCheckDataMap != null && billNumberCheckDataMap.size() > 0 && BudgetAdjustCheckUtils.checkAuditTrailParamRelation(Long.parseLong(modelId), formType).booleanValue()) {
            adjustCheckFlag = true;
            DynamicInfoCollection dynamicInfoCollection = null;
            for (Map.Entry entry : map.entrySet()) {
                String cube = (String)entry.getKey();
                dynamicInfoCollection = CustomDimInfo.get(cube);
            }
            checkIBudgetBalances = CheckAdjustment.checkBalanceByEbBatch(billNoMap, props, dynamicInfoCollection);
        }
        if (iBudgetBalances == null || iBudgetBalances.isEmpty()) {
            return;
        }
        HashMap modelCacheHelperMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap modelViewIdsMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap<String, Integer> errorCount = new HashMap<String, Integer>(16);
        for (String Cube2 : map.keySet()) {
            List<CompareDataPojo> compareDataPojos = finalDataByPeriodAndOrg.get(Cube2);
            DynamicInfoCollection dynamicInfoCollection = CustomDimInfo.get(Cube2);
            ArrayList<DynamicInfoCollection.InfoObject> dimvalues = null;
            dimvalues = dynamicInfoCollection != null ? dynamicInfoCollection.getValues() : new ArrayList<DynamicInfoCollection.InfoObject>(16);
            boolean isEb = ModelUtil.isEbOrBgModel(Long.parseLong(modelId));
            boolean allowNegative = ControlParamsSettingUtil.adjustAllowNegative((Long)Long.parseLong(modelId), (String)formType, (boolean)isEb);
            boolean isShowlimitBalance = ControlParamsSettingUtil.isShowLimitBalance((Long)Long.parseLong(modelId), (String)formType, (boolean)isEb);
            if (!allowNegative || isShowlimitBalance) {
                for (CompareDataPojo com : compareDataPojos) {
                    IModelCacheHelper orCreate = modelCacheHelperMap.computeIfAbsent(com.getModel(), f -> ModelCacheContext.getOrCreate((Long)com.getModel()));
                    Map viewIds = modelViewIdsMap.computeIfAbsent(com.getBizmodel(), f -> orCreate.getViewsByBusModel(com.getBizmodel()));
                    if ((allowNegative || com.getAdjustdata().compareTo(BigDecimal.ZERO) >= 0 || com.getFinaldata().compareTo(BigDecimal.ZERO) >= 0) && (!isShowlimitBalance || !com.isBeyondLimitBalance())) continue;
                    for (DynamicInfoCollection.InfoObject in : values) {
                        if (!in.getValueByPropName("billno").equals(com.getBillNumber())) continue;
                        String preiod = BudgetAdjustCheckUtils.getMemberName(orCreate, SysDimensionEnum.Year.getNumber(), null, com.getYearNumber()) + BudgetAdjustCheckUtils.getMemberName(orCreate, SysDimensionEnum.Period.getNumber(), null, com.getPreiod());
                        Integer index = (Integer)errorCount.get(com.getBillNumber());
                        if (index == null) {
                            index = 0;
                        }
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                        errorCount.put(com.getBillNumber(), index);
                        String message = ResManager.loadResFormat((String)"\u3000\u3000(%1)\u9884\u7b97\u7ec4\u7ec7\u201c%2\u201d\u3001\u9884\u7b97\u79d1\u76ee\u4e3a\u201c%3\u201d\u3001\u9884\u7b97\u671f\u95f4\u201c%4\u201d", (String)"CheckAdjustment_17", (String)"epm-eb-formplugin", (Object[])new Object[]{index, BudgetAdjustCheckUtils.getMemberName(orCreate, SysDimensionEnum.Entity.getNumber(), (Long)viewIds.get(SysDimensionEnum.Entity.getNumber()), com.getOrgnumber()), BudgetAdjustCheckUtils.getMemberName(orCreate, SysDimensionEnum.Account.getNumber(), null, com.getAccountNumber()), preiod});
                        if (index <= 1) {
                            ((StringBuilder)billErrMessageMap.get(com.getBillNumber())).append(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u9884\u7b97\u6570\u5c0f\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"CheckAdjustment_16", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n").append(ResManager.loadResFormat((String)"\u3000\u3000\u4ee5\u4e0b\u6570\u636e\u5b58\u5728\u95ee\u9898\uff1a%1", (String)"CheckAdjustment_18", (String)"epm-eb-formplugin", (Object[])new Object[]{""})).append("\r\n").append(message).append("\r\n");
                            continue;
                        }
                        ((StringBuilder)billErrMessageMap.get(com.getBillNumber())).append(message).append("\r\n");
                    }
                }
            }
            Collection<IBudgetBalance> budgetBalances = iBudgetBalances.get(Cube2);
            for (IBudgetBalance ibe : budgetBalances) {
                for (CompareDataPojo com : compareDataPojos) {
                    if (com.getAdjustdata().compareTo(BigDecimal.ZERO) >= 0 || com.getFinaldata().compareTo(BigDecimal.ZERO) < 0 || !CheckAdjustment.compareAllMember(ibe, com, dimvalues)) continue;
                    CheckAdjustment.setFinaladata(ibe, com);
                }
            }
        }
        for (String billNo : billNoMap.keySet()) {
            Collection checkBudgetBalances = (Collection)checkIBudgetBalances.get(billNo);
            if (!CollectionUtils.isNotEmpty((Collection)checkBudgetBalances)) continue;
            ArrayList<IBudgetBalance> resultBudgetBalances = new ArrayList<IBudgetBalance>(checkBudgetBalances.size());
            for (IBudgetBalance ibe : checkBudgetBalances) {
                log.info("adjust check balance by batch eb getAccount() = " + ibe.getAccount(true).getNumber() + " getPeriod() = " + ibe.getPeriod(true) + " controltype = " + ibe.getSetting().getSettingType() + " getBalance() = " + ibe.getBalance() + " getAdjustCheckBalance() = " + ibe.getAdjustCheckBalance() + " getAdjustCheckBeyond() = " + ibe.getAdjustCheckBeyond() + " getBudget() = " + ibe.getBudget() + " getAdjustCheckBudget() = " + ibe.getAdjustCheckBudget());
                if (!ibe.getAdjustCheckBeyond() || ibe.getSetting().isBeyond()) continue;
                resultBudgetBalances.add(ibe);
            }
            for (DynamicInfoCollection.InfoObject in : values) {
                if (!in.getValueByPropName("billno").equals(billNo)) continue;
                StringBuilder stringBuilder = (StringBuilder)billErrMessageMap.get(billNo);
                if (resultBudgetBalances.size() <= 0) continue;
                stringBuilder.append(ResManager.loadKDString((String)"\u8c03\u6574\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"CheckAdjustment_15", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("\r\n");
            }
        }
        for (DynamicInfoCollection.InfoObject in : values) {
            StringBuilder stringBuilder = (StringBuilder)billErrMessageMap.get(in.getValueByPropName("billno"));
            in.setValueByPropName("errorInfo", (Object)stringBuilder.toString());
        }
    }

    private static Map<String, List<CompareDataPojo>> getBillNumberCheckDataMap(Map<String, List<CompareDataPojo>> finalDataByPeriodAndOrg) {
        HashMap<String, List<CompareDataPojo>> billNumberDataMap = new HashMap<String, List<CompareDataPojo>>(finalDataByPeriodAndOrg.size());
        ArrayList allDatas = new ArrayList(16);
        for (Map.Entry<String, List<CompareDataPojo>> entry : finalDataByPeriodAndOrg.entrySet()) {
            allDatas.addAll(entry.getValue());
        }
        for (CompareDataPojo dataPojo : allDatas) {
            if (dataPojo.getAdjustdata().compareTo(BigDecimal.ZERO) == 0) continue;
            String billNumber = dataPojo.getBillNumber();
            List billNumberDatas = (List)billNumberDataMap.get(billNumber);
            if (billNumberDatas == null) {
                billNumberDatas = Lists.newLinkedList();
                billNumberDatas.add(dataPojo);
                billNumberDataMap.put(billNumber, billNumberDatas);
                continue;
            }
            billNumberDatas.add(dataPojo);
        }
        return billNumberDataMap;
    }

    private static Map<String, Map<String, BigDecimal>> getAdjustValueMapByBillNumber(Map<String, List<CompareDataPojo>> checkDataByPeriodAndOrg, String valueType, String formType) {
        HashMap<String, Map<String, BigDecimal>> adjustValueMapByBillNumber = new HashMap<String, Map<String, BigDecimal>>(16);
        if (checkDataByPeriodAndOrg == null || checkDataByPeriodAndOrg.size() == 0) {
            return adjustValueMapByBillNumber;
        }
        for (Map.Entry<String, List<CompareDataPojo>> entry : checkDataByPeriodAndOrg.entrySet()) {
            String billNumber = entry.getKey();
            List<CompareDataPojo> compareDataPojoList = entry.getValue();
            Map<String, BigDecimal> adjustMap = adjustValueMapByBillNumber.computeIfAbsent(billNumber, f -> Maps.newLinkedHashMap());
            adjustMap = BudgetAdjustCheckUtils.getAdjustValueMap(compareDataPojoList, valueType, formType);
            adjustValueMapByBillNumber.put(billNumber, adjustMap);
        }
        return adjustValueMapByBillNumber;
    }

    private static Map<String, Map<String, BigDecimal>> getAdjustValueMapByBill(Map<String, List<CompareDataPojo>> checkDataByPeriodAndOrg, String formType) {
        HashMap<String, Map<String, BigDecimal>> adjustValueMapByBill = new HashMap<String, Map<String, BigDecimal>>(16);
        if (checkDataByPeriodAndOrg == null || checkDataByPeriodAndOrg.size() == 0) {
            return adjustValueMapByBill;
        }
        for (Map.Entry<String, List<CompareDataPojo>> entry : checkDataByPeriodAndOrg.entrySet()) {
            String bill = entry.getKey();
            List<CompareDataPojo> compareDataPojoList = entry.getValue();
            Map<String, BigDecimal> adjustMap = adjustValueMapByBill.computeIfAbsent(bill, f -> Maps.newLinkedHashMap());
            adjustMap = BudgetAdjustCheckUtils.getAdjustValueMap(compareDataPojoList, "adjustValue", formType);
            adjustValueMapByBill.put(bill, adjustMap);
        }
        return adjustValueMapByBill;
    }

    private static Map<String, Collection<IBudgetBalance>> bgmqueryBalanceByBatch(DynamicObject[] bills, Map<Long, List<DynamicObject>> definedDimMap) {
        HashMap<String, Collection<IBudgetBalance>> balanceMap = new HashMap<String, Collection<IBudgetBalance>>(16);
        for (DynamicObject tempBill : bills) {
            String bill = tempBill.getString("billno");
            if (balanceMap.get(bill) != null) continue;
            balanceMap.put(bill, CheckAdjustment.bgmQueryBalanceByBill(bills, bill, definedDimMap));
        }
        return balanceMap;
    }

    private static Collection<IBudgetBalance> bgmQueryBalanceByBill(DynamicObject[] bills, String bill, Map<Long, List<DynamicObject>> definedDimMap) {
        Collection<IBudgetBalance> iBudgetBalances = null;
        Map<String, List<Map<String, String>>> dimlistMap = CheckAdjustment.bgmgetDimQueryListByBatch(bills, definedDimMap);
        List<Map<String, String>> dimList = dimlistMap.get(bill);
        if (dimList == null) {
            return iBudgetBalances;
        }
        ArrayList<String> type = new ArrayList<String>(16);
        Long bussModelId = 0L;
        if (bills[0].getDynamicObject("bizmodel") != null && IDUtils.isNotEmptyLong((Long)bills[0].getDynamicObject("bizmodel").getLong("id")).booleanValue()) {
            bussModelId = bills[0].getDynamicObject("bizmodel").getLong("id");
        }
        adjustValueMap = adjustValueMapByBillNumber.get(bill);
        iBudgetBalances = !CheckAdjustment.IsExitMixturePeriod(dimList = dimList.stream().distinct().collect(Collectors.toList()), type) ? CheckAdjustment.getAllIbCollection(dimList, null, type, bills[0].getDynamicObject("model").getLong("id"), bussModelId) : CheckAdjustment.queryBalanceBytype(null, dimList, type, bills[0].getDynamicObject("model").getLong("id"), bussModelId);
        return iBudgetBalances;
    }

    private static Map<String, Collection<IBudgetBalance>> queryBalanceByBatch(Map<String, List<DynamicInfoCollection.InfoObject>> map, List<String> props, Map<String, DynamicInfoCollection> customDimInfo) {
        HashMap<String, Collection<IBudgetBalance>> balanceMap = new HashMap<String, Collection<IBudgetBalance>>(16);
        for (Map.Entry<String, List<DynamicInfoCollection.InfoObject>> entry : map.entrySet()) {
            String cube = entry.getKey();
            if (balanceMap.containsKey(cube)) continue;
            DynamicInfoCollection dynamicInfoCollection = customDimInfo.get(cube);
            Collection<IBudgetBalance> budgetBalances = CheckAdjustment.queryBalanceByCube(entry.getValue(), dynamicInfoCollection, props);
            balanceMap.put(cube, budgetBalances);
        }
        return balanceMap;
    }

    private static Map<String, Collection<IBudgetBalance>> checkBalanceByEbBatch(Map<String, List<DynamicInfoCollection.InfoObject>> billNoMap, List<String> props, DynamicInfoCollection dynamicInfoCollection) {
        HashMap<String, Collection<IBudgetBalance>> checkBalanceMap = new HashMap<String, Collection<IBudgetBalance>>(16);
        for (Map.Entry<String, List<DynamicInfoCollection.InfoObject>> entry : billNoMap.entrySet()) {
            String billNo = entry.getKey();
            if (checkBalanceMap.containsKey(billNo)) continue;
            adjustValueMap = adjustValueMapByBillNumber.get(billNo);
            Collection<IBudgetBalance> budgetBalances = CheckAdjustment.checkBalanceByBillNumber(entry.getValue(), dynamicInfoCollection, props);
            checkBalanceMap.put(billNo, budgetBalances);
        }
        return checkBalanceMap;
    }

    private static Collection<IBudgetBalance> queryBalanceByCube(List<DynamicInfoCollection.InfoObject> list, DynamicInfoCollection customDimsInfoCache, List<String> props) {
        ArrayList<String> type = new ArrayList<String>(16);
        ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
        CheckAdjustment.getDimQueryListByBatch(dimlist, list, customDimsInfoCache, props, false, false);
        if (!CheckAdjustment.IsExitMixturePeriod(dimlist, type)) {
            return CheckAdjustment.getAllIbCollection(dimlist, null, type, Long.parseLong(list.get(0).getValueByPropName("modelId").toString()), IDUtils.toLong((Object)list.get(0).getValueByPropName("fbizmodelid")));
        }
        return CheckAdjustment.queryBalanceBytype(null, dimlist, type, Long.parseLong(list.get(0).getValueByPropName("modelId").toString()), IDUtils.toLong((Object)list.get(0).getValueByPropName("fbizmodelid")));
    }

    private static Collection<IBudgetBalance> checkBalanceByBillNumber(List<DynamicInfoCollection.InfoObject> list, DynamicInfoCollection customDimsInfoCache, List<String> props) {
        ArrayList<String> type = new ArrayList<String>(16);
        ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
        long modelId = Long.parseLong(list.get(0).getValueByPropName("modelId").toString());
        CheckAdjustment.getDimQueryListByBatch(dimlist, list, customDimsInfoCache, props, true, false);
        if (BudgetAdjustCheckUtils.checkCustomDimExist(modelId, 0L)) {
            CheckAdjustment.getDimQueryListByBatch(dimlist, list, customDimsInfoCache, props, true, true);
        }
        if (!CheckAdjustment.IsExitMixturePeriod(dimlist, type)) {
            return CheckAdjustment.getAllIbCollection(dimlist, null, type, Long.parseLong(list.get(0).getValueByPropName("modelId").toString()), IDUtils.toLong((Object)list.get(0).getValueByPropName("fbizmodelid")));
        }
        return CheckAdjustment.queryBalanceBytype(null, dimlist, type, Long.parseLong(list.get(0).getValueByPropName("modelId").toString()), IDUtils.toLong((Object)list.get(0).getValueByPropName("fbizmodelid")));
    }

    private static Map<String, List<Map<String, String>>> bgmgetDimQueryListByBatch(DynamicObject[] bills, Map<Long, List<DynamicObject>> definedDimMap) {
        LinkedHashMap adjustCheckDimListMap = Maps.newLinkedHashMap();
        for (DynamicObject tempBill : bills) {
            long billId = tempBill.getLong("id");
            List<DynamicObject> defineds = definedDimMap.get(billId);
            if (CollectionUtils.isNotEmpty(defineds)) {
                CheckAdjustment.getCheckBgmBillDimList(adjustCheckDimListMap, tempBill, defineds, true);
            }
            CheckAdjustment.getCheckBgmBillDimList(adjustCheckDimListMap, tempBill, defineds, false);
        }
        return adjustCheckDimListMap;
    }

    private static void getCheckBgmBillDimList(Map<String, List<Map<String, String>>> adjustCheckDimListMap, DynamicObject tempBill, List<DynamicObject> defineds, boolean customTotalFlag) {
        String billNo = tempBill.getString("billno");
        DynamicObjectCollection detailEntrys = tempBill.getDynamicObjectCollection("adjdetailentity");
        DynamicObject version = tempBill.getDynamicObject("version");
        DynamicObject changeType = tempBill.getDynamicObject("changeType");
        DynamicObject currency = tempBill.getDynamicObject("currency");
        DynamicObject datatype = tempBill.getDynamicObject("datatype");
        Long modelId = tempBill.getDynamicObject("model").getLong("id");
        String formType = tempBill.getString("billtype");
        String billNumber = tempBill.getString("billno");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        for (DynamicObject detailEntry : detailEntrys) {
            BigDecimal adjustValue = detailEntry.getBigDecimal("adjustdata");
            if (adjustValue != null && adjustValue.compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            dimMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), detailEntry.getDynamicObject("budgetperiod").getString("number"));
            dimMap.put(SysDimensionEnum.Entity.getNumber(), detailEntry.getDynamicObject("entity").getString("number"));
            dimMap.put(SysDimensionEnum.Account.getNumber(), detailEntry.getDynamicObject("account").getString("number"));
            dimMap.put(SysDimensionEnum.DataType.getNumber(), datatype.getString("number"));
            dimMap.put(SysDimensionEnum.Version.getNumber(), version.getString("number"));
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currency.getString("number"));
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changeType.getString("number"));
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            dimMap.put(SysDimensionEnum.Metric.getNumber(), detailEntry.getDynamicObject("metric").getString("number"));
            for (int j = 0; j < defineds.size(); ++j) {
                String number = defineds.get(j).getString("number");
                DynamicObject customDimObj = detailEntry.getDynamicObject("customdim" + (j + 1));
                if (customDimObj == null) continue;
                if (customTotalFlag) {
                    dimMap.put(number, number);
                    continue;
                }
                dimMap.put(number, customDimObj.getString("number"));
            }
            dimMap.put("billNumber", billNumber);
            List dimList = adjustCheckDimListMap.computeIfAbsent(billNo, f -> Lists.newLinkedList());
            dimList.add(dimMap);
        }
    }

    private static void getDimQueryListByBatch(List<Map<String, String>> dimlist, List<DynamicInfoCollection.InfoObject> list, DynamicInfoCollection customDimsInfoCache, List<String> props, boolean checkFlag, boolean customTotalFlag) {
        for (DynamicInfoCollection.InfoObject entryDynamicObject : list) {
            String headDimStr = (String)entryDynamicObject.getValueByPropName("headDimStr");
            String billNumber = (String)entryDynamicObject.getValueByPropName("billno");
            String formType = (String)entryDynamicObject.getValueByPropName("billtype");
            Long modelId = Long.parseLong(entryDynamicObject.getValueByPropName("modelId").toString());
            if (formType == null) {
                formType = EbAdjBillTypeEnum.adjust.getNumber();
            }
            HashMap<Integer, Integer> headDimMap = new HashMap<Integer, Integer>(16);
            int m = 1;
            for (int i = 0; i < headDimStr.length(); ++i) {
                if (headDimStr.charAt(i) != '|') continue;
                headDimMap.put(m, i);
                ++m;
            }
            String DatatypeNumber = headDimStr.substring(0, (Integer)headDimMap.get(1));
            String VersionNumber = headDimStr.substring((Integer)headDimMap.get(1) + 1, (Integer)headDimMap.get(2));
            String YearNumber = headDimStr.substring((Integer)headDimMap.get(2) + 1, (Integer)headDimMap.get(3));
            String ChangetypeNumber = headDimStr.substring((Integer)headDimMap.get(3) + 1, (Integer)headDimMap.get(4));
            String CurrencyNumber = headDimStr.substring((Integer)headDimMap.get(4) + 1, headDimStr.length());
            String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
            List entityDimStrs = (List)entryDynamicObject.getValueByPropName("entityDimStrs");
            for (String entityDimStr : entityDimStrs) {
                if (checkFlag) {
                    String money = entityDimStr.substring(entityDimStr.indexOf("(") + 1, entityDimStr.indexOf(")"));
                    HashMap<Integer, Integer> moneyMap = new HashMap<Integer, Integer>(16);
                    int p = 1;
                    for (int i = 0; i < money.length(); ++i) {
                        if (money.charAt(i) != '@') continue;
                        moneyMap.put(p, i);
                        ++p;
                    }
                    BigDecimal adjustData = new BigDecimal(money.substring((Integer)moneyMap.get(2) + 1, (Integer)moneyMap.get(3)));
                    if (adjustData.compareTo(BigDecimal.ZERO) == 0) continue;
                }
                HashMap<String, String> dimMap = new HashMap<String, String>(16);
                HashMap<Integer, Integer> charMap = new HashMap<Integer, Integer>(16);
                int j = 1;
                for (int i = 0; i < entityDimStr.length(); ++i) {
                    if (entityDimStr.charAt(i) != '|') continue;
                    charMap.put(j, i);
                    ++j;
                }
                dimMap.put(SysDimensionEnum.Period.getNumber(), entityDimStr.substring(0, (Integer)charMap.get(1)));
                dimMap.put(SysDimensionEnum.Entity.getNumber(), entityDimStr.substring((Integer)charMap.get(1) + 1, (Integer)charMap.get(2)));
                dimMap.put(SysDimensionEnum.Account.getNumber(), entityDimStr.substring((Integer)charMap.get(2) + 1, (Integer)charMap.get(3)));
                dimMap.put(SysDimensionEnum.DataType.getNumber(), DatatypeNumber);
                dimMap.put(SysDimensionEnum.Version.getNumber(), VersionNumber);
                dimMap.put(SysDimensionEnum.Year.getNumber(), YearNumber);
                dimMap.put(SysDimensionEnum.Currency.getNumber(), CurrencyNumber);
                dimMap.put(SysDimensionEnum.ChangeType.getNumber(), ChangetypeNumber);
                dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
                if (customDimsInfoCache != null) {
                    int z = 0;
                    for (DynamicInfoCollection.InfoObject info : customDimsInfoCache.getValues()) {
                        if (checkFlag && customTotalFlag) {
                            dimMap.put((String)info.getValueByPropName("number"), (String)info.getValueByPropName("number"));
                        } else {
                            dimMap.put((String)info.getValueByPropName("number"), entityDimStr.substring((Integer)charMap.get(3 + z) + 1, (Integer)charMap.get(4 + z)));
                        }
                        ++z;
                    }
                }
                if (checkFlag) {
                    dimMap.put("billNumber", billNumber);
                }
                dimlist.add(dimMap);
            }
        }
    }

    private static Map<Long, List<CompareDataPojo>> bgmgetFinalDataByPeriodAndOrgByBatch(DynamicObject[] bills, Map<Long, List<DynamicObject>> definedDimMap) {
        HashMap<Long, List<CompareDataPojo>> comMap = new HashMap<Long, List<CompareDataPojo>>(16);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject tempBill = bills[i];
            String entityNumber = tempBill.getDataEntityType().getName();
            long billId = tempBill.getLong("id");
            List pojos = comMap.computeIfAbsent(billId, v -> new ArrayList(16));
            DynamicObjectCollection detailEntrys = tempBill.getDynamicObjectCollection("adjdetailentity");
            DynamicObject version = tempBill.getDynamicObject("version");
            DynamicObject changeType = tempBill.getDynamicObject("changeType");
            DynamicObject currency = tempBill.getDynamicObject("currency");
            DynamicObject datatype = tempBill.getDynamicObject("datatype");
            DynamicObject model = tempBill.getDynamicObject("model");
            DynamicObject bizModel = tempBill.getDynamicObject("bizmodel");
            List<DynamicObject> defineds = definedDimMap.get(billId);
            StringBuilder rowDimMembers = new StringBuilder();
            HashMap<String, CompareDataPojo> rowDataMap = new HashMap<String, CompareDataPojo>(16);
            for (DynamicObject detailEntry : detailEntrys) {
                CompareDataPojo pojo = new CompareDataPojo();
                DynamicObject tempObj = detailEntry.getDynamicObject("budgetperiod");
                pojo.setPreiod(tempObj.getString("number"));
                pojo.setPreiodName(tempObj.getString("name"));
                rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(tempObj.getString("number")).append("!!");
                tempObj = detailEntry.getDynamicObject("entity");
                rowDimMembers.append(SysDimensionEnum.Entity.getNumber()).append("@").append(tempObj.getString("number")).append("!!");
                pojo.setOrgnumber(tempObj.getString("number"));
                rowDimMembers.append(tempObj.getString("number")).append("!!");
                tempObj = detailEntry.getDynamicObject("account");
                pojo.setAccountNumber(tempObj.getString("number"));
                rowDimMembers.append(SysDimensionEnum.Account.getNumber()).append("@").append(tempObj.getString("number")).append("!!");
                tempObj = detailEntry.getDynamicObject("metric");
                pojo.setMetricNumber(tempObj.getString("number"));
                rowDimMembers.append(SysDimensionEnum.Metric.getNumber()).append("@").append(tempObj.getString("number"));
                pojo.setDatatypeNumber(datatype.getString("number"));
                pojo.setVersionNumber(version.getString("number"));
                pojo.setChangetypeNumber(changeType.getString("number"));
                pojo.setCurrencyNumber(currency.getString("number"));
                BigDecimal adjustData = detailEntry.getBigDecimal("adjustdata");
                BigDecimal finalData = detailEntry.getBigDecimal("finaldata");
                pojo.setBillNumber(tempBill.getString("billno"));
                pojo.setAdjustdata(adjustData);
                pojo.setFinaldata(finalData);
                if ("eb_adjustbill".equals(entityNumber) || "eb_adjpstbill".equals(entityNumber)) {
                    pojo.setSubmitValue(detailEntry.getBigDecimal("submitvalue"));
                }
                pojo.setLimitBalance(detailEntry.getBigDecimal("limitbalance"));
                pojo.setBeyond(Convert.toBool((Object)detailEntry.get("beyond"), (Boolean)true).booleanValue());
                HashMap<String, String> dimNumbersMap = new HashMap<String, String>(16);
                for (int j = 0; j < defineds.size(); ++j) {
                    String number = defineds.get(j).getString("number");
                    DynamicObject customDimObj = detailEntry.getDynamicObject("customdim" + (j + 1));
                    if (customDimObj == null) continue;
                    dimNumbersMap.put(number, customDimObj.getString("number"));
                    rowDimMembers.append("!!").append(number).append("@").append(customDimObj.getString("number"));
                }
                pojo.setCustomdimMap(dimNumbersMap);
                pojo.setCustomdimMemberMap(dimNumbersMap);
                pojo.setModel(Long.valueOf(model.getLong("id")));
                pojo.setBizmodel(Long.valueOf(bizModel.getLong("id")));
                if (rowDataMap.containsKey(rowDimMembers.toString())) {
                    CompareDataPojo dataPojo = (CompareDataPojo)rowDataMap.get(rowDimMembers.toString());
                    BigDecimal newAdjustData = dataPojo.getAdjustdata().add(adjustData);
                    dataPojo.setAdjustdata(newAdjustData);
                    dataPojo.setFinaldata(finalData);
                } else {
                    rowDataMap.put(rowDimMembers.toString(), pojo);
                    pojos.add(pojo);
                }
                rowDimMembers.setLength(0);
            }
        }
        return comMap;
    }

    private static Map<String, List<CompareDataPojo>> bgmGetCheckDataByPeriodAndOrgByBatch(DynamicObject[] bills, Map<Long, List<DynamicObject>> definedDimMap) {
        HashMap<String, List<CompareDataPojo>> comMap = new HashMap<String, List<CompareDataPojo>>(16);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject tempBill = bills[i];
            String entityNumber = tempBill.getDataEntityType().getName();
            long billId = tempBill.getLong("id");
            String billNo = tempBill.getString("billno");
            List pojos = comMap.computeIfAbsent(billNo, v -> new ArrayList(16));
            DynamicObjectCollection detailEntrys = tempBill.getDynamicObjectCollection("adjdetailentity");
            DynamicObject version = tempBill.getDynamicObject("version");
            DynamicObject changeType = tempBill.getDynamicObject("changeType");
            DynamicObject currency = tempBill.getDynamicObject("currency");
            DynamicObject datatype = tempBill.getDynamicObject("datatype");
            DynamicObject model = tempBill.getDynamicObject("model");
            DynamicObject bizModel = tempBill.getDynamicObject("bizmodel");
            List<DynamicObject> defineds = definedDimMap.get(billId);
            for (DynamicObject detailEntry : detailEntrys) {
                if (detailEntry.getBigDecimal("adjustdata").compareTo(BigDecimal.ZERO) == 0) continue;
                CompareDataPojo pojo = new CompareDataPojo();
                DynamicObject tempObj = detailEntry.getDynamicObject("budgetperiod");
                pojo.setPreiod(tempObj.getString("number"));
                pojo.setPreiodName(tempObj.getString("name"));
                tempObj = detailEntry.getDynamicObject("entity");
                pojo.setOrgnumber(tempObj.getString("number"));
                tempObj = detailEntry.getDynamicObject("account");
                pojo.setAccountNumber(tempObj.getString("number"));
                tempObj = detailEntry.getDynamicObject("metric");
                pojo.setMetricNumber(tempObj.getString("number"));
                pojo.setDatatypeNumber(datatype.getString("number"));
                pojo.setVersionNumber(version.getString("number"));
                pojo.setChangetypeNumber(changeType.getString("number"));
                pojo.setCurrencyNumber(currency.getString("number"));
                pojo.setBillNumber(tempBill.getString("billno"));
                pojo.setAdjustdata(detailEntry.getBigDecimal("adjustdata"));
                pojo.setFinaldata(detailEntry.getBigDecimal("finaldata"));
                if ("eb_adjustbill".equals(entityNumber) || "eb_adjpstbill".equals(entityNumber)) {
                    pojo.setSubmitValue(detailEntry.getBigDecimal("submitvalue"));
                }
                pojo.setLimitBalance(detailEntry.getBigDecimal("limitbalance"));
                pojo.setBeyond(Convert.toBool((Object)detailEntry.get("beyond"), (Boolean)true).booleanValue());
                HashMap<String, String> dimNumbersMap = new HashMap<String, String>(16);
                for (int j = 0; j < defineds.size(); ++j) {
                    String number = defineds.get(j).getString("number");
                    DynamicObject customDimObj = detailEntry.getDynamicObject("customdim" + (j + 1));
                    if (customDimObj == null) continue;
                    dimNumbersMap.put(number, customDimObj.getString("number"));
                }
                pojo.setCustomdimMap(dimNumbersMap);
                pojo.setCustomdimMemberMap(dimNumbersMap);
                pojo.setModel(Long.valueOf(model.getLong("id")));
                pojo.setBizmodel(Long.valueOf(bizModel.getLong("id")));
                pojos.add(pojo);
            }
        }
        return comMap;
    }

    private static Map<String, List<CompareDataPojo>> getFinalDataByPeriodAndOrgByBatch(Map<String, List<DynamicInfoCollection.InfoObject>> map, List<String> props, Map<String, DynamicInfoCollection> CustomDimInfo) {
        HashMap<String, List<CompareDataPojo>> comMap = new HashMap<String, List<CompareDataPojo>>(16);
        for (Map.Entry<String, List<DynamicInfoCollection.InfoObject>> entry : map.entrySet()) {
            String cube = entry.getKey();
            if (comMap.containsKey(cube)) continue;
            ArrayList<CompareDataPojo> com = new ArrayList<CompareDataPojo>(16);
            for (DynamicInfoCollection.InfoObject in : entry.getValue()) {
                List entityDimStrs = (List)in.getValueByPropName("entityDimStrs");
                for (int k = 0; k < entityDimStrs.size(); ++k) {
                    CompareDataPojo cdp = new CompareDataPojo();
                    String entityDimStr = (String)entityDimStrs.get(k);
                    HashMap<Integer, Integer> charMap = new HashMap<Integer, Integer>(16);
                    int j = 1;
                    for (int i = 0; i < entityDimStr.length(); ++i) {
                        if (entityDimStr.charAt(i) != '|') continue;
                        charMap.put(j, i);
                        ++j;
                    }
                    cdp.setPreiod(entityDimStr.substring(0, (Integer)charMap.get(1)));
                    cdp.setOrgnumber(entityDimStr.substring((Integer)charMap.get(1) + 1, (Integer)charMap.get(2)));
                    cdp.setAccountNumber(entityDimStr.substring((Integer)charMap.get(2) + 1, (Integer)charMap.get(3)));
                    DynamicInfoCollection dynamicInfoCollection = CustomDimInfo.get(cube);
                    if (dynamicInfoCollection != null) {
                        int z = 0;
                        HashMap<String, String> CustomdimMap = new HashMap<String, String>(16);
                        HashMap<String, String> customDimMemberMap = new HashMap<String, String>(16);
                        for (DynamicInfoCollection.InfoObject info : dynamicInfoCollection.getValues()) {
                            CustomdimMap.put((String)info.getValueByPropName("number"), entityDimStr.substring((Integer)charMap.get(3 + z) + 1, (Integer)charMap.get(4 + z)));
                            customDimMemberMap.put((String)info.getValueByPropName("number"), entityDimStr.substring((Integer)charMap.get(3 + z) + 1, (Integer)charMap.get(4 + z)));
                            ++z;
                        }
                        cdp.setCustomdimMap(CustomdimMap);
                        cdp.setCustomdimMemberMap(customDimMemberMap);
                    }
                    cdp.setBillNumber((String)in.getValueByPropName("billno"));
                    String money = entityDimStr.substring(entityDimStr.indexOf("(") + 1, entityDimStr.indexOf(")"));
                    HashMap<Integer, Integer> moneyMap = new HashMap<Integer, Integer>(16);
                    int p = 1;
                    for (int i = 0; i < money.length(); ++i) {
                        if (money.charAt(i) != '@') continue;
                        moneyMap.put(p, i);
                        ++p;
                    }
                    cdp.setAdjustdata(new BigDecimal(money.substring((Integer)moneyMap.get(2) + 1, (Integer)moneyMap.get(3))));
                    cdp.setFinaldata(new BigDecimal(money.substring((Integer)moneyMap.get(3) + 1, money.length())));
                    String headDimStr = (String)in.getValueByPropName("headDimStr");
                    HashMap<Integer, Integer> headDimMap = new HashMap<Integer, Integer>(16);
                    int m = 1;
                    for (int i = 0; i < headDimStr.length(); ++i) {
                        if (headDimStr.charAt(i) != '|') continue;
                        headDimMap.put(m, i);
                        ++m;
                    }
                    cdp.setDatatypeNumber(headDimStr.substring(0, (Integer)headDimMap.get(1)));
                    cdp.setVersionNumber(headDimStr.substring((Integer)headDimMap.get(1) + 1, (Integer)headDimMap.get(2)));
                    cdp.setYearNumber(headDimStr.substring((Integer)headDimMap.get(2) + 1, (Integer)headDimMap.get(3)));
                    cdp.setChangetypeNumber(headDimStr.substring((Integer)headDimMap.get(3) + 1, (Integer)headDimMap.get(4)));
                    cdp.setCurrencyNumber(headDimStr.substring((Integer)headDimMap.get(4) + 1, headDimStr.length()));
                    cdp.setModel(Long.valueOf(Long.parseLong(in.getValueByPropName("modelId").toString())));
                    com.add(cdp);
                }
            }
            comMap.put(cube, com);
        }
        return comMap;
    }
}

