/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.budgetform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormService;
import kd.epm.eb.business.adjust.budgetform.SchemaBudgetFormService;
import kd.epm.eb.business.adjust.budgetform.TaskBudgetFormService;
import kd.epm.eb.common.adjust.budgetform.AssignSchemaTaskDto;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;

public class BudgetFormHelper {
    public static BudgetFormService getBudgetFormService(String code) {
        if (SchemaTaskEnum.SCHEMA.getCode().equals(code)) {
            return SchemaBudgetFormService.getInstance();
        }
        if (SchemaTaskEnum.TASK.getCode().equals(code)) {
            return TaskBudgetFormService.getInstance();
        }
        return null;
    }

    public static TreeNode buildTemplateRootNode(Long modelId, Set<Long> templateIds) {
        String templateEntityKey;
        String templateCatalogEntityKey;
        if (AdjustHelper.isEb(modelId)) {
            templateCatalogEntityKey = "eb_templatecatalog_bg";
            templateEntityKey = "eb_templateentity_bg";
        } else {
            templateCatalogEntityKey = "eb_templatecatalog";
            templateEntityKey = "eb_templateentity";
        }
        HashMap<Long, List> catalogTempMap = new HashMap<Long, List>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("id", "in", templateIds));
        qFilter.and("templatestatus", "in", Arrays.asList("B", ""));
        DynamicObjectCollection templateEntity = QueryServiceHelper.query((String)templateEntityKey, (String)"id,name,number,templatecatalog", (QFilter[])qFilter.toArray(), (String)"number");
        for (DynamicObject templateObj : templateEntity) {
            String templateId = templateObj.getString("id");
            String catalogId = templateObj.getString("templatecatalog");
            TreeNode node = new TreeNode();
            node.setId(templateId);
            node.setText(templateObj.getString("name"));
            node.setParentid(catalogId);
            node.setLongNumber(templateObj.getString("number"));
            HashMap<String, String> dataMap = new HashMap<String, String>(1);
            dataMap.put("hasTemplate", "1");
            dataMap.put("number", templateObj.getString("number"));
            dataMap.put("name", templateObj.getString("name"));
            node.setData(dataMap);
            List treeNodes = catalogTempMap.computeIfAbsent(IDUtils.toLong((Object)catalogId), v -> new ArrayList(16));
            treeNodes.add(node);
        }
        QFilter catalogFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection templateCatalogColl = QueryServiceHelper.query((String)templateCatalogEntityKey, (String)"id,name,number,parent", (QFilter[])catalogFilter.toArray(), (String)"level desc");
        HashSet<Long> catalogIds = new HashSet<Long>(16);
        for (DynamicObject templateCatalog : templateCatalogColl) {
            String id = templateCatalog.getString("id");
            String parentId = templateCatalog.getString("parent");
            List treeNodes = (List)catalogTempMap.get(IDUtils.toLong((Object)id));
            if (CollectionUtils.isNotEmpty((Collection)treeNodes)) {
                catalogIds.add(IDUtils.toLong((Object)id));
                catalogIds.add(IDUtils.toLong((Object)parentId));
                continue;
            }
            if (!catalogIds.contains(IDUtils.toLong((Object)id))) continue;
            catalogIds.add(IDUtils.toLong((Object)parentId));
        }
        QFilter catalogFilterV = new QFilter("model", "=", (Object)modelId);
        catalogFilterV.and(new QFilter("id", "in", catalogIds));
        DynamicObjectCollection templateCatalogCollV = QueryServiceHelper.query((String)templateCatalogEntityKey, (String)"id,name,number,parent", (QFilter[])catalogFilterV.toArray(), (String)"level,sequence");
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(templateCatalogCollV.size());
        for (DynamicObject templateCatalog : templateCatalogCollV) {
            String id = templateCatalog.getString("id");
            String name = templateCatalog.getString("name");
            String parentId = templateCatalog.getString("parent");
            TreeNode node = new TreeNode();
            node.setId(id);
            node.setText(name);
            node.setParentid(parentId);
            catalogMap.put(id, node);
        }
        TreeNode rootNode = new TreeNode();
        rootNode.setId("");
        rootNode.setParentid("");
        for (DynamicObject templateCatalog : templateCatalogCollV) {
            String id = templateCatalog.getString("id");
            String number = templateCatalog.getString("number");
            String parentId = templateCatalog.getString("parent");
            TreeNode node = (TreeNode)catalogMap.get(id);
            HashMap<String, String> dataMap = new HashMap<String, String>(1);
            dataMap.put("hasTemplate", "0");
            node.setData(dataMap);
            List treeNodes = (List)catalogTempMap.get(IDUtils.toLong((Object)id));
            if (CollectionUtils.isNotEmpty((Collection)treeNodes)) {
                node.addChildren(treeNodes);
            }
            TreeNode parentNode = (TreeNode)catalogMap.get(parentId);
            if ("root".equals(number) && "0".equals(parentId) && StringUtils.isEmpty((String)rootNode.getId())) {
                rootNode = node;
                rootNode.setText(templateCatalog.getString("name"));
                rootNode.setParentid("");
                continue;
            }
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return rootNode;
    }

    public static TreeNode buildTemplateRootNode(Long modelId) {
        Set rootRelates;
        String templateEntityKey;
        String templateCatalogEntityKey;
        if (AdjustHelper.isEb(modelId)) {
            templateCatalogEntityKey = "eb_templatecatalog_bg";
            templateEntityKey = "eb_templateentity_bg";
        } else {
            templateCatalogEntityKey = "eb_templatecatalog";
            templateEntityKey = "eb_templateentity";
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection templateCatalogColl = QueryServiceHelper.query((String)templateCatalogEntityKey, (String)"id,name,number,parent", (QFilter[])filter.toArray(), (String)"level,sequence");
        HashMap<Long, Set<Long>> subIdMap = new HashMap<Long, Set<Long>>(templateCatalogColl.size());
        HashMap<Long, BasedataPojo> catalogMap = new HashMap<Long, BasedataPojo>(16);
        Long rootCatalog = 0L;
        for (DynamicObject templateCatalog : templateCatalogColl) {
            Long id = templateCatalog.getLong("id");
            String number = templateCatalog.getString("number");
            Long parentId = templateCatalog.getLong("parent");
            if (IDUtils.isNull((Long)parentId) && "root".equals(number)) {
                rootCatalog = id;
                continue;
            }
            String name = templateCatalog.getString("name");
            Set subIds = subIdMap.computeIfAbsent(parentId, v -> new HashSet(16));
            subIds.add(id);
            catalogMap.put(id, new BasedataPojo(id, name, number));
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("templatestatus", "in", Arrays.asList("B", ""));
        DynamicObjectCollection templateEntity = QueryServiceHelper.query((String)templateEntityKey, (String)"id,name,number,templatecatalog", (QFilter[])qFilter.toArray(), (String)"number");
        HashMap<Long, BasedataPojo> templateMap = new HashMap<Long, BasedataPojo>(templateEntity.size());
        for (DynamicObject templateObj : templateEntity) {
            Long id = templateObj.getLong("id");
            String number = templateObj.getString("number");
            String name = templateObj.getString("name");
            Long catalogId = templateObj.getLong("templatecatalog");
            Set tempIds = subIdMap.computeIfAbsent(catalogId, v -> new HashSet(16));
            tempIds.add(id);
            templateMap.put(id, new BasedataPojo(id, name, number));
        }
        ArrayList topCatalogs = new ArrayList(16);
        if (rootCatalog != 0L && CollectionUtils.isNotEmpty((Collection)(rootRelates = (Set)subIdMap.get(rootCatalog)))) {
            topCatalogs.addAll(rootRelates);
        }
        TreeNode rootNode = new TreeNode();
        rootNode.setId("0");
        rootNode.setParentid("");
        rootNode.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CentralRelationSettingPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
        int count = 0;
        for (Long catalog : topCatalogs) {
            count += BudgetFormHelper.buildTreeNodes(children, subIdMap, catalogMap, templateMap, "0", catalog);
        }
        if (children.size() != 0) {
            rootNode.setChildren(children);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(1);
        dataMap.put("leafCounts", String.valueOf(count));
        rootNode.setData(dataMap);
        return rootNode;
    }

    private static int buildTreeNodes(List<TreeNode> children, Map<Long, Set<Long>> subIdMap, Map<Long, BasedataPojo> catalogMap, Map<Long, BasedataPojo> templateMap, String parentId, Long curNodeId) {
        TreeNode treeNode = new TreeNode();
        BasedataPojo basedataPojo = catalogMap.get(curNodeId);
        if (basedataPojo != null) {
            treeNode.setId(String.valueOf(curNodeId));
            treeNode.setParentid(parentId);
            treeNode.setText(basedataPojo.getNumber() + " " + basedataPojo.getName());
            treeNode.setLeaf(false);
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("name", basedataPojo.getName());
            data.put("number", basedataPojo.getNumber());
            treeNode.setData(data);
            int count = 0;
            ArrayList<TreeNode> children_new = new ArrayList<TreeNode>(16);
            Set<Long> subIds = subIdMap.get(curNodeId);
            if (subIds != null) {
                for (Long subId : subIds) {
                    count += BudgetFormHelper.buildTreeNodes(children_new, subIdMap, catalogMap, templateMap, String.valueOf(curNodeId), subId);
                }
            }
            if (count != 0) {
                treeNode.setChildren(children_new);
                children.add(treeNode);
            }
            return count;
        }
        basedataPojo = templateMap.get(curNodeId);
        if (basedataPojo != null) {
            treeNode.setId(String.valueOf(curNodeId));
            treeNode.setParentid(parentId);
            treeNode.setText(basedataPojo.getNumber() + " " + basedataPojo.getName());
            treeNode.setLeaf(true);
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("name", basedataPojo.getName());
            data.put("number", basedataPojo.getNumber());
            treeNode.setData(data);
            children.add(treeNode);
            return 1;
        }
        return 0;
    }

    public static boolean isBudgetForm(IFormView formView) {
        String isBudgetForm;
        boolean result = false;
        if (formView != null && StringUtils.isNotEmpty((String)(isBudgetForm = (String)formView.getFormShowParameter().getCustomParam("isBudgetForm")))) {
            result = true;
        }
        return result;
    }

    public static void expandOrShrinkNodes(TreeView treeView, TreeNode treeNode, boolean isExpand) {
        if (treeNode == null) {
            return;
        }
        if (isExpand) {
            treeView.expand(treeNode.getId());
        } else {
            treeView.collapse(treeNode.getId());
        }
        List children = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : children) {
                BudgetFormHelper.expandOrShrinkNodes(treeView, child, isExpand);
            }
        }
    }

    public static void saveSchemaTask(Long modelId, List<AssignSchemaTaskDto> assignSchemaTaskList) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DeleteServiceHelper.delete((String)"bgm_adjust_schematask", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> schemaTaskList = new ArrayList<DynamicObject>(assignSchemaTaskList.size());
        for (AssignSchemaTaskDto schemaTaskDto : assignSchemaTaskList) {
            DynamicObject schemaTask = BusinessDataServiceHelper.newDynamicObject((String)"bgm_adjust_schematask");
            schemaTask.set("model", (Object)modelId);
            schemaTask.set("orgviewid", (Object)schemaTaskDto.getOrgViewId());
            schemaTask.set("bizmodel", (Object)schemaTaskDto.getBizModelId());
            schemaTask.set("datatype", (Object)schemaTaskDto.getDataTypeId());
            schemaTask.set("version", (Object)schemaTaskDto.getVersionId());
            schemaTask.set("sourceid", (Object)schemaTaskDto.getId());
            schemaTask.set("sourcetype", (Object)schemaTaskDto.getType());
            schemaTask.set("sourcenumber", (Object)schemaTaskDto.getNumber());
            schemaTask.set("sourcename", (Object)schemaTaskDto.getName());
            schemaTask.set("assignname", (Object)schemaTaskDto.getAssignName());
            schemaTask.set("budgetperiod", (Object)schemaTaskDto.getPeriodId());
            schemaTask.set("status", (Object)schemaTaskDto.getStatus());
            schemaTask.set("assigntime", (Object)schemaTaskDto.getAssignTime());
            schemaTask.set("createtime", (Object)TimeServiceHelper.now());
            schemaTaskList.add(schemaTask);
        }
        SaveServiceHelper.save((DynamicObject[])schemaTaskList.toArray(new DynamicObject[0]));
    }

    public static String getUniqueId(Long sourceId, Long periodId, Long dataTypeId, Long versionId) {
        return sourceId + "#" + periodId + "#" + dataTypeId + "#" + versionId;
    }

    public static boolean isEntityPageDim(ITemplateModel templateModel) {
        boolean isEntityPageDim = false;
        List pageDimensionEntryList = templateModel.getPagemembentry();
        for (IPageDimensionEntry entry : pageDimensionEntryList) {
            String dimNumber = entry.getDimension().getNumber();
            if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) continue;
            isEntityPageDim = true;
            break;
        }
        return isEntityPageDim;
    }
}

