/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.budgetform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormService;
import kd.epm.eb.business.templateperm.TemplatePermServiceHelper;
import kd.epm.eb.common.adjust.budgetform.AssignSchemaTaskDto;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskEnum;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskReq;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;

public class SchemaBudgetFormService
implements BudgetFormService {
    private static SchemaBudgetFormService schemaBudgetFormService = null;

    private SchemaBudgetFormService() {
    }

    public static SchemaBudgetFormService getInstance() {
        if (schemaBudgetFormService == null) {
            return new SchemaBudgetFormService();
        }
        return schemaBudgetFormService;
    }

    @Override
    public List<AssignSchemaTaskDto> getAssignSchemaTask(SchemaTaskReq schemaTaskReq) {
        QFilter qFilter = new QFilter("model", "=", (Object)schemaTaskReq.getModelId());
        if (IDUtils.isNotNull((Long)schemaTaskReq.getBizModelId())) {
            qFilter.and("bizrange", "=", (Object)schemaTaskReq.getBizModelId());
            qFilter.and("scheme.orgview.id", "=", (Object)AdjustHelper.getDefaultOrgViewId(schemaTaskReq.getModelId(), schemaTaskReq.getBizModelId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)schemaTaskReq.getPeriodIds())) {
            qFilter.and("year", "in", (Object)schemaTaskReq.getPeriodIds());
        }
        qFilter.and("scheme.status", "in", Arrays.asList("1", "0"));
        DynamicObjectCollection assignSchemaColl = QueryServiceHelper.query((String)"eb_schemeassign", (String)"scheme.id,scheme.number,scheme.name,scheme.status,scheme.orgview.id,year.id,assigntime,bizrange.id,version.id,datatype.id,name", (QFilter[])qFilter.toArray());
        ArrayList<AssignSchemaTaskDto> schemaTaskDtoList = new ArrayList<AssignSchemaTaskDto>(assignSchemaColl.size());
        for (DynamicObject assignSchema : assignSchemaColl) {
            AssignSchemaTaskDto schemaTaskDto = new AssignSchemaTaskDto();
            schemaTaskDto.setId(Long.valueOf(assignSchema.getLong("scheme.id")));
            schemaTaskDto.setOrgViewId(Long.valueOf(assignSchema.getLong("scheme.orgview.id")));
            schemaTaskDto.setNumber(assignSchema.getString("scheme.number"));
            schemaTaskDto.setName(assignSchema.getString("scheme.name"));
            schemaTaskDto.setAssignName(assignSchema.getString("name"));
            schemaTaskDto.setStatus(assignSchema.getString("scheme.status"));
            schemaTaskDto.setPeriodId(Long.valueOf(assignSchema.getLong("year.id")));
            schemaTaskDto.setAssignTime(assignSchema.getDate("assigntime"));
            schemaTaskDto.setType(SchemaTaskEnum.SCHEMA.getCode());
            schemaTaskDto.setBizModelId(Long.valueOf(assignSchema.getLong("bizrange.id")));
            schemaTaskDto.setDataTypeId(Long.valueOf(assignSchema.getLong("datatype.id")));
            schemaTaskDto.setVersionId(Long.valueOf(assignSchema.getLong("version.id")));
            schemaTaskDtoList.add(schemaTaskDto);
        }
        return schemaTaskDtoList;
    }

    @Override
    public Set<Long> getAssignOrgIds(Long sourceId, Long modelId, Long bizModelId, Long orgViewId, Long templateId) {
        Set hasPermOrgIdSet;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select forgid, forgrange from t_eb_templateorg where fschemeid = ? ", new Object[]{sourceId});
        sqlBuilder.append("and ftemplateid = ?", new Object[]{templateId});
        sqlBuilder.append(" group by forgid, forgrange", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"getEntityPermInScheme", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long orgId = next.getLong("forgid");
                Integer range = next.getInteger("forgrange");
                if (RangeEnum.ONLY.getIndex() == range.intValue()) {
                    orgIds.add(orgId);
                    continue;
                }
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgId);
                if (member == null) continue;
                List memberList = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, member.getNumber(), range.intValue());
                for (Member orgMember : memberList) {
                    if (orgMember.getNumber().endsWith("offsetentry")) continue;
                    orgIds.add(orgMember.getId());
                }
            }
        }
        boolean modelManager = ModelServiceHelper.isModelManager((Long)modelId);
        if (!modelManager && CollectionUtils.isNotEmpty((Collection)(hasPermOrgIdSet = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)orgViewId, (DimMembPermType)DimMembPermType.READ, (boolean)true)))) {
            orgIds.retainAll(hasPermOrgIdSet);
        }
        return orgIds;
    }

    @Override
    public Set<Long> getAssignTemplateIds(Long sourceId, Long modelId) {
        Long schemeViewId;
        Set<Long> hasPermTemplateIdSet;
        HashSet<Long> templateIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftemplateid from t_eb_templateorg where fschemeid = ? ", new Object[]{sourceId});
        sqlBuilder.append(" group by ftemplateid", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"getTemplatePermInScheme", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long templateId = next.getLong("ftemplateid");
                templateIds.add(templateId);
            }
        }
        boolean modelManager = ModelServiceHelper.isModelManager((Long)modelId);
        if (!modelManager && (hasPermTemplateIdSet = TemplatePermServiceHelper.getUserHasPermTemplateIds(modelId, TemplateTypeEnum.BUDGET, null, null, schemeViewId = TemplatePermServiceHelper.getSchemeViewId(sourceId))) != null) {
            templateIds.retainAll(hasPermTemplateIdSet);
        }
        return templateIds;
    }

    @Override
    public Set<Long> getAssignProcessIds(Map<String, Long> idMap, Long entityId, Long templateId) {
        Long modelId = idMap.get("modelId");
        Long periodId = idMap.get("periodId");
        Long versionId = idMap.get("versionId");
        Long datatypeId = idMap.get("datatypeId");
        QFBuilder qfBuilder = new QFBuilder(new QFilter("model", "=", (Object)modelId));
        qfBuilder.add(new QFilter("period", "=", (Object)periodId));
        qfBuilder.add(new QFilter("datatype", "=", (Object)datatypeId));
        qfBuilder.add(new QFilter("version", "=", (Object)versionId));
        qfBuilder.add(new QFilter("template", "=", (Object)templateId));
        qfBuilder.add(new QFilter("entity", "=", (Object)entityId));
        DynamicObject[] reportProcessArr = BusinessDataServiceHelper.load((String)"eb_reportprocess", (String)"id", (QFilter[])qfBuilder.toArrays(), (String)"template.number asc");
        HashSet<Long> processIds = new HashSet<Long>(reportProcessArr.length);
        for (DynamicObject reportProcess : reportProcessArr) {
            processIds.add(reportProcess.getLong("id"));
        }
        return processIds;
    }
}

