/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.budgetform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormService;
import kd.epm.eb.common.adjust.budgetform.AssignSchemaTaskDto;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskEnum;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskReq;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;

public class TaskBudgetFormService
implements BudgetFormService {
    private static final Log log = LogFactory.getLog(TaskBudgetFormService.class);
    private static TaskBudgetFormService taskBudgetFormService = null;

    private TaskBudgetFormService() {
    }

    public static TaskBudgetFormService getInstance() {
        if (taskBudgetFormService == null) {
            return new TaskBudgetFormService();
        }
        return taskBudgetFormService;
    }

    @Override
    public List<AssignSchemaTaskDto> getAssignSchemaTask(SchemaTaskReq schemaTaskReq) {
        ArrayList<AssignSchemaTaskDto> schemaTaskDtoList = new ArrayList<AssignSchemaTaskDto>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct t.fid,a.fnumber,t.fisclosed,tl.fname,a.fbizmodelid,a.fyearid,a.fdatetypeid,a.fversionid,b.fcreatedate,b.forgviewid,al.fname as listname from t_eb_task t", new Object[0]);
        sqlBuilder.append("join t_eb_task_l tl on t.fid = tl.fid", new Object[0]);
        sqlBuilder.append("join t_eb_tasklist a on t.ftasklistid = a.fid", new Object[0]);
        sqlBuilder.append("join t_eb_tasklist_l al on t.ftasklistid = al.fid", new Object[0]);
        sqlBuilder.append("join t_eb_taskprocess b on t.fid = b.ftaskid", new Object[0]);
        sqlBuilder.append("left join t_eb_taskproces_executors c on b.fid = c.fid", new Object[0]);
        sqlBuilder.append("left join t_eb_taskprosupervisor s on b.fid =s.fid", new Object[0]);
        sqlBuilder.append("where a.fmodelid = ?", new Object[]{schemaTaskReq.getModelId()});
        if (IDUtils.isNotNull((Long)schemaTaskReq.getBizModelId())) {
            sqlBuilder.append("and a.fbizmodelid = ?", new Object[]{schemaTaskReq.getBizModelId()});
            sqlBuilder.append("and b.forgviewid = ?", new Object[]{AdjustHelper.getDefaultOrgViewId(schemaTaskReq.getModelId(), schemaTaskReq.getBizModelId())});
        }
        if (CollectionUtils.isNotEmpty((Collection)schemaTaskReq.getPeriodIds())) {
            sqlBuilder.append("and ", new Object[0]).appendIn("fyearid", schemaTaskReq.getPeriodIds().toArray());
        }
        sqlBuilder.append("and tl.flocaleid = ?", new Object[]{Lang.get().toString()});
        sqlBuilder.append("and al.flocaleid = ?", new Object[]{Lang.get().toString()});
        if (!schemaTaskReq.isAll()) {
            sqlBuilder.append("and ( c.fbasedataid = ?", new Object[]{UserUtils.getUserId()});
            sqlBuilder.append("or s.fsupervisorid = ? )", new Object[]{UserUtils.getUserId()});
        }
        sqlBuilder.append("order by b.fcreatedate desc", new Object[0]);
        HashSet<Long> sourceIds = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryTask", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    if (!sourceIds.add(row.getLong("fid"))) continue;
                    String closed = row.getString("fisclosed");
                    AssignSchemaTaskDto schemaTaskDto = new AssignSchemaTaskDto();
                    schemaTaskDto.setId(row.getLong("fid"));
                    schemaTaskDto.setOrgViewId(row.getLong("forgviewid"));
                    schemaTaskDto.setNumber(row.getString("fnumber"));
                    schemaTaskDto.setName(row.getString("listname"));
                    schemaTaskDto.setAssignName(row.getString("fname"));
                    schemaTaskDto.setStatus("0".equals(closed) ? "2" : closed);
                    schemaTaskDto.setPeriodId(row.getLong("fyearid"));
                    schemaTaskDto.setAssignTime(row.getDate("fcreatedate"));
                    schemaTaskDto.setType(SchemaTaskEnum.TASK.getCode());
                    schemaTaskDto.setBizModelId(row.getLong("fbizmodelid"));
                    schemaTaskDto.setDataTypeId(row.getLong("fdatetypeid"));
                    schemaTaskDto.setVersionId(row.getLong("fversionid"));
                    schemaTaskDtoList.add(schemaTaskDto);
                }
            }
        }
        return schemaTaskDtoList;
    }

    @Override
    public Set<Long> getAssignOrgIds(Long sourceId, Long modelId, Long bizModelId, Long orgViewId, Long templateId) {
        QFilter qFilter = new QFilter("task", "=", (Object)sourceId);
        qFilter.and(new QFilter("template", "=", (Object)templateId));
        qFilter.and(new QFilter("executors.fbasedataid_id", "=", (Object)UserUtils.getUserId()).or(new QFilter("entryentity.supervisor.id", "=", (Object)UserUtils.getUserId())));
        DynamicObjectCollection assignTaskColl = QueryServiceHelper.query((String)"eb_taskprocess", (String)"org.id", (QFilter[])qFilter.toArray());
        HashSet<Long> orgIds = new HashSet<Long>(assignTaskColl.size());
        for (DynamicObject assignTask : assignTaskColl) {
            Long orgId = assignTask.getLong("org.id");
            orgIds.add(orgId);
        }
        log.info("TaskBudgetFormService#getAssignOrgIds sourceId={}, orgIds={}", (Object)sourceId, orgIds);
        boolean modelManager = ModelServiceHelper.isModelManager((Long)modelId);
        if (!modelManager) {
            Set hasPermOrgIdSet = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)bizModelId, (Long)orgViewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            log.info("TaskBudgetFormService#getAssignOrgIds sourceId={}, hasPermOrgIdSet={}", (Object)sourceId, (Object)hasPermOrgIdSet);
            if (CollectionUtils.isNotEmpty((Collection)hasPermOrgIdSet)) {
                orgIds.retainAll(hasPermOrgIdSet);
            }
        }
        return orgIds;
    }

    @Override
    public Set<Long> getAssignTemplateIds(Long sourceId, Long modelId) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftemplateid from t_eb_taskreftemplate", new Object[0]);
        sqlBuilder.append("where fid = ?", new Object[]{sourceId});
        try (DataSet ds = DB.queryDataSet((String)"queryTaskTemplate", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            if (ds != null) {
                for (Row row : ds) {
                    templateIds.add(row.getLong("ftemplateid"));
                }
            }
        }
        return templateIds;
    }

    @Override
    public Set<Long> getAssignProcessIds(Map<String, Long> idMap, Long entityId, Long templateId) {
        Long sourceId = idMap.get("sourceId");
        Long periodId = idMap.get("periodId");
        Long versionId = idMap.get("versionId");
        Long datatypeId = idMap.get("datatypeId");
        QFilter qFilter = new QFilter("org", "=", (Object)entityId);
        qFilter.and("template", "=", (Object)templateId);
        qFilter.and("task.tasklist.year", "=", (Object)periodId);
        qFilter.and("task.tasklist.version", "=", (Object)versionId);
        qFilter.and("task.tasklist.datatype", "=", (Object)datatypeId);
        qFilter.and("task.id", "=", (Object)sourceId);
        DynamicObjectCollection taskProcessColl = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> processIds = new HashSet<Long>(taskProcessColl.size());
        taskProcessColl.forEach(e -> processIds.add(e.getLong("id")));
        return processIds;
    }
}

