/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillDetail;
import kd.epm.eb.common.adjust.BasicData;
import kd.epm.eb.common.adjust.CustomDim;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class ExpenseAdjustBillServiceImpl
implements IAdjustBillService {
    private static final Log log = LogFactory.getLog(ExpenseAdjustBillServiceImpl.class);
    private static ExpenseAdjustBillServiceImpl instance = null;

    public static ExpenseAdjustBillServiceImpl getInstance() {
        if (instance == null) {
            instance = new ExpenseAdjustBillServiceImpl();
        }
        return instance;
    }

    @Override
    public Map<String, List<Pair<Integer, BigDecimal>>> getRowBudgetData(AdjustBill adjustBill) {
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
        this.setMemberWithBillHead(adjustBill, memberInfo);
        LinkedHashMap<String, List<Pair<Integer, BigDecimal>>> rowBudgetDataMap = new LinkedHashMap<String, List<Pair<Integer, BigDecimal>>>(16);
        this.setMemberWithBillDetail(adjustBill, memberInfo, rowBudgetDataMap);
        this.addAdjustDataForOnOrderBills(adjustBill, rowBudgetDataMap);
        Map<String, Object> olapData = this.queryOlapData(adjustBill, memberInfo);
        log.info("ExpenseAdjustBillService#getRowBudgetData billNumber={}, olapData={}", (Object)adjustBill.getBillNumber(), (Object)SerializationUtils.toJsonString(olapData));
        this.setRowBudgetData(olapData, rowBudgetDataMap);
        return rowBudgetDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOccupyData2Olap(AdjustBill adjustBill, boolean isSubmit) {
        LinkedList bgDataList = Lists.newLinkedList();
        Long modelId = adjustBill.getModel().getId();
        List billDetailList = adjustBill.getDetailList();
        for (AdjustBillDetail billDetail : billDetailList) {
            BigDecimal adjustValue;
            BigDecimal bigDecimal = adjustValue = isSubmit ? billDetail.getAdjustData() : billDetail.getSubmitValue();
            if (adjustValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            BgData data = this.getBgData(adjustBill, billDetail, "BudgetOccupation");
            if (isSubmit) {
                data.setValue(adjustValue);
            } else {
                data.setValue(adjustValue.negate());
            }
            bgDataList.add(data);
        }
        log.info("ExpenseAdjustBillService#saveOccupyData2Olap billNumber={}, bgDataList={}", (Object)adjustBill.getBillNumber(), (Object)SerializationUtils.toJsonString((Object)bgDataList));
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List<String> dimNumbers = Arrays.asList(cacheHelper.getModelobj().getDimensionNums());
        try (EbBatchSave save = EbOlapServiceHelper.getBatchSave();){
            OlapTraceServiceHelper.setTraceOpInfo((String)adjustBill.getBillNumber());
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.Adjust));
            SaveCommandInfo command = new SaveCommandInfo();
            command.addDimensions(cacheHelper.getModelobj().getDimensionNums());
            command.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            command.setIncrement(true);
            save.open(cacheHelper.getModelobj().getCubeNumber(), command);
            for (BgData data : bgDataList) {
                save.add(dimNumbers, data);
            }
            save.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveBudgetData2Olap(AdjustBill adjustBill, boolean isAudit) {
        LinkedList bgDataList = Lists.newLinkedList();
        Long modelId = adjustBill.getModel().getId();
        String formType = adjustBill.getBillType();
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        List billDetailList = adjustBill.getDetailList();
        for (AdjustBillDetail billDetail : billDetailList) {
            BigDecimal adjustValue = billDetail.getAdjustData();
            if (adjustValue.compareTo(BigDecimal.ZERO) == 0) continue;
            BgData data = this.getBgData(adjustBill, billDetail, auditTrail);
            if (isAudit) {
                data.setValue(adjustValue);
            } else {
                data.setValue(adjustValue.negate());
            }
            bgDataList.add(data);
        }
        log.info("ExpenseAdjustBillService#saveBudgetData2Olap billNumber={}, bgDataList={}", (Object)adjustBill.getBillNumber(), (Object)SerializationUtils.toJsonString((Object)bgDataList));
        AggregateExpr expr = new AggregateExpr();
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List<String> dimNumbers = Arrays.asList(cacheHelper.getModelobj().getDimensionNums());
        try (EbBatchSave save = EbOlapServiceHelper.getBatchSave();){
            OlapTraceServiceHelper.setTraceOpInfo((String)adjustBill.getBillNumber());
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.Adjust));
            SaveCommandInfo command = new SaveCommandInfo();
            command.addDimensions(cacheHelper.getModelobj().getDimensionNums());
            command.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            command.setIncrement(true);
            save.open(cacheHelper.getModelobj().getCubeNumber(), command);
            for (BgData data : bgDataList) {
                save.add(dimNumbers, data);
                for (String dimNum : dimNumbers) {
                    expr.addMembers(dimNum, new HashSet<String>(Collections.singletonList(data.getMemberNumber(dimNum))));
                }
            }
            save.flush();
        }
        HashSet<String> members = expr.getMembers().get(SysDimensionEnum.AuditTrail.getNumber());
        members = members == null ? new HashSet<String>(16) : members;
        members.add("ATTotal");
        ScriptCommand command = ScriptCommand.getIntance(OlapServiceHelper.getOlapConnection((String)adjustBill.getModel().getNumber()));
        command.execute(modelId, (IExpress)expr);
    }

    private void setMemberWithBillHead(AdjustBill adjustBill, Map<String, Set<String>> memberInfo) {
        String yearNumber = adjustBill.getYear().getNumber();
        HashSet<String> yearSet = new HashSet<String>(1);
        yearSet.add(yearNumber);
        memberInfo.put(SysDimensionEnum.Year.getNumber(), yearSet);
        String dataTypeNumber = adjustBill.getDataType().getNumber();
        HashSet<String> dataTypeSet = new HashSet<String>(1);
        dataTypeSet.add(dataTypeNumber);
        memberInfo.put(SysDimensionEnum.DataType.getNumber(), dataTypeSet);
        String changeTypeNumber = adjustBill.getChangeType().getNumber();
        HashSet<String> changeTypeSet = new HashSet<String>(1);
        changeTypeSet.add(changeTypeNumber);
        memberInfo.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeSet);
        String versionNumber = adjustBill.getVersion().getNumber();
        HashSet<String> versionSet = new HashSet<String>(1);
        versionSet.add(versionNumber);
        memberInfo.put(SysDimensionEnum.Version.getNumber(), versionSet);
        String currencyNumber = adjustBill.getCurrency().getNumber();
        HashSet<String> currencySet = new HashSet<String>(1);
        currencySet.add(currencyNumber);
        memberInfo.put(SysDimensionEnum.Currency.getNumber(), currencySet);
    }

    private void setMemberWithBillDetail(AdjustBill adjustBill, Map<String, Set<String>> memberInfo, Map<String, List<Pair<Integer, BigDecimal>>> rowBudgetDataMap) {
        List billDetailList = adjustBill.getDetailList();
        if (CollectionUtils.isEmpty((Collection)billDetailList)) {
            return;
        }
        HashMap<String, BigDecimal> rowAdjustDataMap = new HashMap<String, BigDecimal>(billDetailList.size());
        StringBuilder rowDimMembers = new StringBuilder();
        for (AdjustBillDetail billDetail : billDetailList) {
            String periodNumber = billDetail.getPeriod().getNumber();
            String entityNumber = billDetail.getEntity().getNumber();
            String accountNumber = billDetail.getAccount().getNumber();
            memberInfo.computeIfAbsent(SysDimensionEnum.Entity.getNumber(), value -> new HashSet(16)).add(entityNumber);
            memberInfo.computeIfAbsent(SysDimensionEnum.Period.getNumber(), value -> new HashSet(16)).add(periodNumber);
            memberInfo.computeIfAbsent(SysDimensionEnum.Account.getNumber(), value -> new HashSet(16)).add(accountNumber);
            rowDimMembers.append(periodNumber).append("!!").append(entityNumber).append("!!").append(accountNumber);
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                String dimMemberNum = customDim.getMemberNumber();
                rowDimMembers.append("!!").append(dimMemberNum);
                memberInfo.computeIfAbsent(customDim.getDimNumber(), value -> new HashSet(16)).add(dimMemberNum);
            }
            if (rowAdjustDataMap.containsKey(rowDimMembers.toString())) {
                BigDecimal adjustData = (BigDecimal)rowAdjustDataMap.get(rowDimMembers.toString());
                List<Pair<Integer, BigDecimal>> rowValueList = rowBudgetDataMap.get(rowDimMembers.toString());
                rowValueList.add((Pair<Integer, BigDecimal>)new Pair((Object)billDetail.getRow(), (Object)adjustData));
                rowAdjustDataMap.put(rowDimMembers.toString(), adjustData.add(billDetail.getAdjustData()));
            } else {
                rowAdjustDataMap.put(rowDimMembers.toString(), billDetail.getAdjustData());
                List rowValueList = rowBudgetDataMap.computeIfAbsent(rowDimMembers.toString(), v -> new ArrayList(16));
                rowValueList.add(new Pair((Object)billDetail.getRow(), (Object)new BigDecimal(0)));
            }
            rowDimMembers.setLength(0);
        }
    }

    private Map<String, Object> queryOlapData(AdjustBill adjustBill, Map<String, Set<String>> memberInfo) {
        SelectCommandInfo commandInfo = new SelectCommandInfo();
        commandInfo.addDims(new String[]{SysDimensionEnum.Period.getNumber()});
        commandInfo.addDims(new String[]{SysDimensionEnum.Entity.getNumber()});
        commandInfo.addDims(new String[]{SysDimensionEnum.Account.getNumber()});
        BasicData model = adjustBill.getModel();
        Long modelId = model.getId();
        Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByModel(modelId);
        for (Map.Entry<String, Dimension> dimEntry : customDimMap.entrySet()) {
            Dimension customDim = dimEntry.getValue();
            String dimNum = customDim.getNumber();
            commandInfo.addDims(new String[]{dimNum});
        }
        memberInfo.forEach((dimName, memberNums) -> commandInfo.addFilter(dimName, memberNums.toArray(new String[1])));
        String billType = adjustBill.getBillType();
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)billType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        commandInfo.addFilter(SysDimensionEnum.AuditTrail.getNumber(), new String[]{auditTrail});
        commandInfo.addFilter(SysDimensionEnum.Scenario.getNumber(), new String[]{"NoScenario"});
        commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        if ("ATTotal".equals(auditTrail)) {
            this.aggregate(adjustBill.getModel().getId(), adjustBill.getModel().getNumber(), commandInfo);
        }
        return EbOlapServiceHelper.queryData(commandInfo, adjustBill.getModel().getNumber());
    }

    private void setRowBudgetData(Map<String, Object> olapData, Map<String, List<Pair<Integer, BigDecimal>>> rowBudgetDataMap) {
        for (Map.Entry<String, List<Pair<Integer, BigDecimal>>> rowEntry : rowBudgetDataMap.entrySet()) {
            String rowDims = rowEntry.getKey();
            Object olapValue = olapData.get(rowDims);
            if (olapValue == null) continue;
            List<Pair<Integer, BigDecimal>> rowValueList = rowEntry.getValue();
            for (Pair<Integer, BigDecimal> rowValue : rowValueList) {
                if (olapValue instanceof Long) {
                    rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add(new BigDecimal((Long)olapValue)));
                    continue;
                }
                if (!(olapValue instanceof BigDecimal)) continue;
                rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add((BigDecimal)olapValue));
            }
        }
    }

    private void aggregate(Long modelId, String modelNumber, SelectCommandInfo commandInfo) {
        List filterList = commandInfo.getFilter();
        AggregateExpr expr = new AggregateExpr();
        for (DimensionFilterItem filter : filterList) {
            HashSet<String> dimSet = new HashSet<String>(16);
            dimSet.addAll(filter.getValues());
            expr.addMembers(filter.getName(), dimSet);
        }
        HashSet<String> internalCompanySet = new HashSet<String>(1);
        internalCompanySet.add("ICNone");
        expr.addMembers(SysDimensionEnum.InternalCompany.getNumber(), internalCompanySet);
        HashSet<String> processSet = new HashSet<String>(1);
        processSet.add("IRpt");
        expr.addMembers(SysDimensionEnum.Process.getNumber(), processSet);
        ScriptCommand command = ScriptCommand.getIntance(ScriptCommand.getOlapConnection(modelNumber));
        command.execute(modelId, (IExpress)expr);
    }

    private void addAdjustDataForOnOrderBills(AdjustBill adjustBill, Map<String, List<Pair<Integer, BigDecimal>>> rowBudgetDataMap) {
        String billType;
        if (adjustBill.isActual()) {
            return;
        }
        Long billId = adjustBill.getBillId();
        Long modelId = adjustBill.getModel().getId();
        if (!ControlParamsSettingUtil.isOnOrder((Long)modelId, (String)(billType = adjustBill.getBillType()))) {
            return;
        }
        QFBuilder qFilter = new QFBuilder("model", "=", (Object)modelId);
        qFilter.add("year", "=", (Object)adjustBill.getYear().getId());
        qFilter.add("datatype", "=", (Object)adjustBill.getDataType().getId());
        qFilter.add("version", "=", (Object)adjustBill.getVersion().getId());
        qFilter.add("changetype", "=", (Object)adjustBill.getChangeType().getId());
        qFilter.add("currency", "=", (Object)adjustBill.getCurrency().getId());
        qFilter.add("billstatus", "in", (Object)new String[]{AdjustBillStateEnum.SUBMIT.getShortNumber(), AdjustBillStateEnum.AUDITING.getShortNumber()});
        Map onOrderBillMap = BusinessDataServiceHelper.loadFromCache((String)"eb_adjustbill", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Map)onOrderBillMap)) {
            return;
        }
        Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByModel(modelId);
        for (DynamicObject billObj : onOrderBillMap.values()) {
            if (billId != null && billId.equals(billObj.getLong("id"))) continue;
            StringBuilder rowDimMembers = new StringBuilder();
            DynamicObjectCollection billDetails = billObj.getDynamicObjectCollection("adjdetailentity");
            for (DynamicObject rowObj : billDetails) {
                DynamicObject periodObj = rowObj.getDynamicObject("period");
                String periodNumber = periodObj.getString("number");
                DynamicObject entityObj = rowObj.getDynamicObject("entity");
                String entityNumber = entityObj.getString("number");
                DynamicObject accountObj = rowObj.getDynamicObject("account");
                String accountNumber = accountObj.getString("number");
                rowDimMembers.append(periodNumber).append("!!").append(entityNumber).append("!!").append(accountNumber);
                for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                    String dimKey = entry.getKey();
                    Dimension dimension = entry.getValue();
                    DynamicObject customDimObj = rowObj.getDynamicObject(dimKey);
                    String customDimNumber = "";
                    customDimNumber = customDimObj != null ? customDimObj.getString("number") : dimension.getNoneNumber();
                    rowDimMembers.append("!!").append(customDimNumber);
                }
                BigDecimal adjustData = rowObj.getBigDecimal("adjustdata");
                List<Pair<Integer, BigDecimal>> rowValueList = rowBudgetDataMap.get(rowDimMembers.toString());
                if (CollectionUtils.isNotEmpty(rowValueList)) {
                    for (Pair<Integer, BigDecimal> rowValue : rowValueList) {
                        rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add(adjustData));
                    }
                }
                rowDimMembers.setLength(0);
            }
        }
    }

    private BgData getBgData(AdjustBill adjustBill, AdjustBillDetail billDetail, String auditTrail) {
        BgData data = new BgData(adjustBill.getModel().getId());
        data.setMember(SysDimensionEnum.Year.getNumber(), adjustBill.getYear().getNumber());
        data.setMember(SysDimensionEnum.Version.getNumber(), adjustBill.getVersion().getNumber());
        data.setMember(SysDimensionEnum.Currency.getNumber(), adjustBill.getCurrency().getNumber());
        data.setMember(SysDimensionEnum.DataType.getNumber(), adjustBill.getDataType().getNumber());
        data.setMember(SysDimensionEnum.ChangeType.getNumber(), adjustBill.getChangeType().getNumber());
        data.setMember(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
        data.setMember(SysDimensionEnum.Process.getNumber(), "IRpt");
        data.setMember(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
        data.setMember(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
        String periodNumber = billDetail.getPeriod().getNumber();
        String entityNumber = billDetail.getEntity().getNumber();
        String accountNumber = billDetail.getAccount().getNumber();
        data.setMember(SysDimensionEnum.Period.getNumber(), periodNumber);
        data.setMember(SysDimensionEnum.Entity.getNumber(), entityNumber);
        data.setMember(SysDimensionEnum.Account.getNumber(), accountNumber);
        List customDimList = billDetail.getCustomDimList();
        for (CustomDim customDim : customDimList) {
            data.setMember(customDim.getDimNumber(), customDim.getMemberNumber());
        }
        return data;
    }
}

