/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillDetail;
import kd.epm.eb.common.adjust.CustomDim;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class OverallAdjustBillServiceImpl
implements IAdjustBillService {
    private static final Log log = LogFactory.getLog(OverallAdjustBillServiceImpl.class);
    private static OverallAdjustBillServiceImpl instance = null;

    public static OverallAdjustBillServiceImpl getInstance() {
        if (instance == null) {
            instance = new OverallAdjustBillServiceImpl();
        }
        return instance;
    }

    @Override
    public Map<String, List<Pair<Integer, BigDecimal>>> getRowBudgetData(AdjustBill adjustBill) {
        LogStats stats = new LogStats("getRowBudgetData-log:");
        stats.addInfo("getRowBudgetData-start.");
        stats.addInfo("billNumber=" + adjustBill.getBillNumber());
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
        this.setMemberWithBillHead(adjustBill, memberInfo);
        stats.add("setMemberWithBillHead end.");
        LinkedHashMap<String, List<Pair<Integer, BigDecimal>>> rowBudgetDataMap = new LinkedHashMap<String, List<Pair<Integer, BigDecimal>>>(16);
        LinkedHashMap<Long, Map<String, Set<String>>> datasetDimMemMap = new LinkedHashMap<Long, Map<String, Set<String>>>(16);
        this.setMemberWithBillDetail(adjustBill, memberInfo, rowBudgetDataMap, datasetDimMemMap);
        stats.add("setMemberWithBillDetail end.");
        Map<Map<String, String>, Object> olapData = this.queryOlapData(adjustBill, datasetDimMemMap);
        stats.add("queryOlapData end.");
        this.setRowBudgetData(olapData, rowBudgetDataMap);
        stats.add("setRowBudgetData end.");
        stats.addInfo("getRowBudgetData-end.");
        log.info(stats.toString());
        return rowBudgetDataMap;
    }

    @Override
    public void saveOccupyData2Olap(AdjustBill adjustBill, boolean isSubmit) {
        log.info("OverallAdjustBillService#saveOccupyData2Olap start, billNumber={}, isSubmit={}", (Object)adjustBill.getBillNumber(), (Object)isSubmit);
        long modelId = adjustBill.getModel().getId();
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String dataTypeNumber = adjustBill.getDataType().getNumber();
        String changeTypeNumber = adjustBill.getChangeType().getNumber();
        String versionNumber = adjustBill.getVersion().getNumber();
        String currencyNumber = adjustBill.getCurrency().getNumber();
        List billDetailList = adjustBill.getDetailList();
        Map<String, List<AdjustBillDetail>> sameDimRowDataMap = this.getSameDimRowDataMap(billDetailList);
        for (Map.Entry<String, List<AdjustBillDetail>> entry : sameDimRowDataMap.entrySet()) {
            List<AdjustBillDetail> rowList = entry.getValue();
            BigDecimal adjustValue = BigDecimal.ZERO;
            for (AdjustBillDetail row : rowList) {
                if (isSubmit) {
                    adjustValue = adjustValue.add(row.getAdjustData());
                    continue;
                }
                adjustValue = adjustValue.add(row.getSubmitValue());
            }
            if (adjustValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            BigDecimal value = adjustValue;
            if (!isSubmit) {
                value = adjustValue.negate();
            }
            AdjustBillDetail billDetail = rowList.get(0);
            String periodNumber = billDetail.getBudgetPeriod().getNumber();
            String entityNumber = billDetail.getEntity().getNumber();
            String accountNumber = billDetail.getAccount().getNumber();
            String metricNumber = billDetail.getMetric().getNumber();
            HashMap<String, String> dimMemberMap = new HashMap<String, String>(16);
            dimMemberMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
            dimMemberMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
            dimMemberMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimMemberMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            dimMemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
            dimMemberMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            dimMemberMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMemberMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            dimMemberMap.put(SysDimensionEnum.AuditTrail.getNumber(), "BudgetOccupation");
            Long datasetId = billDetail.getDatasetId();
            if (AdjustHelper.isHasInternalCompany(modelId, datasetId)) {
                dimMemberMap.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            }
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                dimMemberMap.put(customDim.getDimNumber(), customDim.getMemberNumber());
            }
            IShrekSave shrekSave = null;
            try {
                Model model = cacheHelper.getModelobj();
                DynamicObject datasetObj = DatasetServiceHelper.loadDatasets((Long)datasetId);
                Dataset dataset = Dataset.of((DynamicObject)datasetObj);
                String[] dimensionNums = cacheHelper.getDimensionNums(datasetId);
                String[] metas = AdjustHelper.getCellMeta(dimMemberMap, dimensionNums);
                log.info("OverallAdjustBillService#saveOccupyData2Olap billNumber={}, metas={}, value={}", new Object[]{adjustBill.getBillNumber(), metas, value});
                LogStats stats = new LogStats("budget-shrek-log : ");
                stats.addInfo("begin-saveOccupyData2Olap");
                OlapTraceServiceHelper.setTraceOpInfo((String)adjustBill.getBillNumber());
                OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.Adjust));
                shrekSave = ShrekOlapServiceHelper.saveDataByIncrement((Model)model, (Dataset)dataset, (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
                shrekSave.add(metas, (Object)value);
            }
            catch (Exception ex) {
                log.error("OverallAdjustBillService#saveOccupyData2Olap error:" + ex);
                throw new KDBizException(ex.getMessage());
            }
            finally {
                if (shrekSave == null) continue;
                shrekSave.close();
            }
        }
        log.info("OverallAdjustBillService#saveOccupyData2Olap end");
    }

    @Override
    public void saveBudgetData2Olap(AdjustBill adjustBill, boolean isAudit) {
        Long datasetId;
        Long modelId = adjustBill.getModel().getId();
        String billType = adjustBill.getBillType();
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)billType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        List billDetailList = adjustBill.getDetailList();
        HashMap<Long, List> datasetCellMap = new HashMap<Long, List>(billDetailList.size());
        Map<String, List<AdjustBillDetail>> sameDimRowDataMap = this.getSameDimRowDataMap(billDetailList);
        for (Map.Entry<String, List<AdjustBillDetail>> entry : sameDimRowDataMap.entrySet()) {
            List<AdjustBillDetail> rowList = entry.getValue();
            BigDecimal adjustValue = BigDecimal.ZERO;
            for (AdjustBillDetail row : rowList) {
                adjustValue = adjustValue.add(row.getAdjustData());
            }
            if (adjustValue.compareTo(BigDecimal.ZERO) == 0) continue;
            AdjustBillDetail billDetail = rowList.get(0);
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            Long datasetId2 = billDetail.getDatasetId();
            String periodNumber = billDetail.getBudgetPeriod().getNumber();
            String entityNumber = billDetail.getEntity().getNumber();
            String accountNumber = billDetail.getAccount().getNumber();
            String metricNumber = billDetail.getMetric().getNumber();
            List bgCells = datasetCellMap.computeIfAbsent(datasetId2, v -> new LinkedList());
            memberMap.put(SysDimensionEnum.DataType.getNumber(), adjustBill.getDataType().getNumber());
            memberMap.put(SysDimensionEnum.ChangeType.getNumber(), adjustBill.getChangeType().getNumber());
            memberMap.put(SysDimensionEnum.Version.getNumber(), adjustBill.getVersion().getNumber());
            memberMap.put(SysDimensionEnum.Currency.getNumber(), adjustBill.getCurrency().getNumber());
            memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            memberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
            memberMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
            memberMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            memberMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            if (AdjustHelper.isHasInternalCompany(modelId, datasetId2)) {
                memberMap.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            }
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                String dimNumber = customDim.getDimNumber();
                String memberNumber = customDim.getMemberNumber();
                memberMap.put(dimNumber, memberNumber);
            }
            BGCell bgCell = new BGCell(memberMap, (Object)adjustValue);
            bgCells.add(bgCell);
        }
        OlapTraceServiceHelper.setTraceOpInfo((String)adjustBill.getBillNumber());
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.Adjust));
        OlapWriteOption olapWriteOption = new OlapWriteOption();
        olapWriteOption.setValidPerm(false);
        olapWriteOption.setDataLockThrowErr(true);
        olapWriteOption.setIncrement(true);
        HashMap<Long, List> changedCellMap = new HashMap<Long, List>(billDetailList.size());
        for (Map.Entry entry : datasetCellMap.entrySet()) {
            datasetId = (Long)entry.getKey();
            List cellValues = (List)entry.getValue();
            List changedCells = OlapCommService.getInstance().save(new SaveRequest(modelId, datasetId, cellValues), olapWriteOption);
            List bgCells = changedCellMap.computeIfAbsent(datasetId, v -> Lists.newArrayList());
            bgCells.addAll(changedCells);
            changedCellMap.put(datasetId, bgCells);
        }
        for (Map.Entry entry : changedCellMap.entrySet()) {
            datasetId = (Long)entry.getKey();
            List changedCells = (List)entry.getValue();
            if (changedCells == null || changedCells.isEmpty()) continue;
            log.info("OverallAdjustBillService#saveBudgetData2Olap==>billNumber={}, datasetId={}, changedCells={}", new Object[]{adjustBill.getBillNumber(), datasetId, SerializationUtils.toJsonString((Object)changedCells)});
            String traceId = RequestContext.getOrCreate().getTraceId();
            EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> {
                RequestContext.getOrCreate().setTraceId(traceId);
                RuleExecutionService.getInstance().executeRuleChain(null, datasetId, modelId, changedCells, RuleExecuteTypeEnum.ADJUST.getType());
            });
        }
    }

    private void setMemberWithBillHead(AdjustBill adjustBill, Map<String, Set<String>> memberInfo) {
        HashSet<String> dataTypeSet = new HashSet<String>(1);
        HashSet<String> changeTypeSet = new HashSet<String>(1);
        HashSet<String> versionSet = new HashSet<String>(1);
        if (adjustBill.isActual()) {
            dataTypeSet.add("Actual");
            changeTypeSet.add("ActualChanges");
            versionSet.add("ACTUAL");
        } else {
            String dataTypeNumber = adjustBill.getDataType().getNumber();
            dataTypeSet.add(dataTypeNumber);
            String changeTypeNumber = adjustBill.getChangeType().getNumber();
            changeTypeSet.add(changeTypeNumber);
            String versionNumber = adjustBill.getVersion().getNumber();
            versionSet.add(versionNumber);
        }
        String currencyNumber = adjustBill.getCurrency().getNumber();
        HashSet<String> currencySet = new HashSet<String>(1);
        currencySet.add(currencyNumber);
        long modelId = adjustBill.getModel().getId();
        String formType = adjustBill.getBillType();
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        HashSet<String> auditTrailSet = new HashSet<String>(1);
        auditTrailSet.add(auditTrail);
        memberInfo.put(SysDimensionEnum.DataType.getNumber(), dataTypeSet);
        memberInfo.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeSet);
        memberInfo.put(SysDimensionEnum.Version.getNumber(), versionSet);
        memberInfo.put(SysDimensionEnum.Currency.getNumber(), currencySet);
        memberInfo.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailSet);
    }

    private void setMemberWithBillDetail(AdjustBill adjustBill, Map<String, Set<String>> memberInfo, Map<String, List<Pair<Integer, BigDecimal>>> rowBudgetDataMap, Map<Long, Map<String, Set<String>>> datasetDimMemMap) {
        List billDetailList = adjustBill.getDetailList();
        if (CollectionUtils.isEmpty((Collection)billDetailList)) {
            return;
        }
        Long modelId = adjustBill.getModel().getId();
        HashMap<String, BigDecimal> rowAdjustDataMap = new HashMap<String, BigDecimal>(billDetailList.size());
        StringBuilder rowDimMembers = new StringBuilder();
        for (AdjustBillDetail billDetail : billDetailList) {
            String periodNumber = billDetail.getBudgetPeriod().getNumber();
            String entityNumber = billDetail.getEntity().getNumber();
            String accountNumber = billDetail.getAccount().getNumber();
            String metricNumber = billDetail.getMetric().getNumber();
            rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(periodNumber).append("!!").append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                rowDimMembers.append("!!").append(customDim.getDimNumber()).append("@").append(customDim.getMemberNumber());
            }
            if (rowAdjustDataMap.containsKey(rowDimMembers.toString())) {
                BigDecimal adjustData = (BigDecimal)rowAdjustDataMap.get(rowDimMembers.toString());
                List<Pair<Integer, BigDecimal>> rowValueList = rowBudgetDataMap.get(rowDimMembers.toString());
                rowValueList.add((Pair<Integer, BigDecimal>)new Pair((Object)billDetail.getRow(), (Object)adjustData));
                rowAdjustDataMap.put(rowDimMembers.toString(), adjustData.add(billDetail.getAdjustData()));
            } else {
                rowAdjustDataMap.put(rowDimMembers.toString(), billDetail.getAdjustData());
                List rowValueList = rowBudgetDataMap.computeIfAbsent(rowDimMembers.toString(), v -> new ArrayList(16));
                rowValueList.add(new Pair((Object)billDetail.getRow(), (Object)new BigDecimal(0)));
            }
            rowDimMembers.setLength(0);
            Long datasetId = billDetail.getDatasetId();
            if (datasetDimMemMap.containsKey(datasetId)) {
                Map<String, Set<String>> existedMemberInfo = datasetDimMemMap.get(datasetId);
                for (Map.Entry<String, Set<String>> entry : existedMemberInfo.entrySet()) {
                    String dimKey = entry.getKey();
                    Set<String> dimMemberSet = entry.getValue();
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimKey)) {
                        dimMemberSet.add(periodNumber);
                        continue;
                    }
                    if (SysDimensionEnum.Entity.getNumber().equals(dimKey)) {
                        dimMemberSet.add(entityNumber);
                        continue;
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimKey)) {
                        dimMemberSet.add(accountNumber);
                        continue;
                    }
                    if (SysDimensionEnum.Metric.getNumber().equals(dimKey)) {
                        dimMemberSet.add(metricNumber);
                        continue;
                    }
                    for (CustomDim customDim : customDimList) {
                        String dimNumber = customDim.getDimNumber();
                        if (!dimNumber.equals(dimKey)) continue;
                        dimMemberSet.add(customDim.getMemberNumber());
                    }
                }
                continue;
            }
            HashMap<String, Set<String>> datasetMemberInfo = new HashMap<String, Set<String>>(16);
            datasetMemberInfo.putAll(memberInfo);
            this.setRowMemberInfo(billDetail, datasetMemberInfo, modelId, datasetId);
            datasetDimMemMap.put(datasetId, datasetMemberInfo);
        }
    }

    private void setRowMemberInfo(AdjustBillDetail billDetail, Map<String, Set<String>> memberInfo, Long modelId, Long datasetId) {
        HashSet<String> budgetPeriodSet = new HashSet<String>(16);
        budgetPeriodSet.add(billDetail.getBudgetPeriod().getNumber());
        memberInfo.put(SysDimensionEnum.BudgetPeriod.getNumber(), budgetPeriodSet);
        HashSet<String> entitySet = new HashSet<String>(16);
        entitySet.add(billDetail.getEntity().getNumber());
        memberInfo.put(SysDimensionEnum.Entity.getNumber(), entitySet);
        HashSet<String> accountSet = new HashSet<String>(16);
        accountSet.add(billDetail.getAccount().getNumber());
        memberInfo.put(SysDimensionEnum.Account.getNumber(), accountSet);
        HashSet<String> metricSet = new HashSet<String>(16);
        metricSet.add(billDetail.getMetric().getNumber());
        memberInfo.put(SysDimensionEnum.Metric.getNumber(), metricSet);
        if (AdjustHelper.isHasInternalCompany(modelId, datasetId)) {
            HashSet<String> companySet = new HashSet<String>(1);
            companySet.add("ICNone");
            memberInfo.put(SysDimensionEnum.InternalCompany.getNumber(), companySet);
        }
        List customDimList = billDetail.getCustomDimList();
        for (CustomDim customDim : customDimList) {
            String dimNumber = customDim.getDimNumber();
            HashSet<String> customDimSet = new HashSet<String>(16);
            customDimSet.add(customDim.getMemberNumber());
            memberInfo.put(dimNumber, customDimSet);
        }
    }

    private Map<Map<String, String>, Object> queryOlapData(AdjustBill adjustBill, Map<Long, Map<String, Set<String>>> datasetDimMemMap) {
        HashMap<Map<String, String>, Object> olapData = new HashMap<Map<String, String>, Object>(datasetDimMemMap.size());
        for (Map.Entry<Long, Map<String, Set<String>>> entry : datasetDimMemMap.entrySet()) {
            long datasetId = entry.getKey();
            Map<String, Set<String>> dimMemberMap = entry.getValue();
            QueryRequest queryRequest = new QueryRequest(adjustBill.getModel().getId(), Long.valueOf(datasetId), dimMemberMap);
            List bgCells = OlapCommService.getInstance().queryList(queryRequest);
            for (BGCell bgCell : bgCells) {
                olapData.put(bgCell.getMemberMap(), bgCell.getValue());
            }
        }
        return olapData;
    }

    private void setRowBudgetData(Map<Map<String, String>, Object> olapData, Map<String, List<Pair<Integer, BigDecimal>>> rowBudgetDataMap) {
        block0: for (Map.Entry<String, List<Pair<Integer, BigDecimal>>> rowEntry : rowBudgetDataMap.entrySet()) {
            String rowDims = rowEntry.getKey();
            for (Map.Entry<Map<String, String>, Object> olapEntry : olapData.entrySet()) {
                Map<String, String> olapDimMemMap = olapEntry.getKey();
                Object olapValue = olapEntry.getValue();
                if (!AdjustHelper.isSameDims(olapDimMemMap, rowDims)) continue;
                List<Pair<Integer, BigDecimal>> rowValueList = rowEntry.getValue();
                for (Pair<Integer, BigDecimal> rowValue : rowValueList) {
                    if (rowValue == null || olapValue == null) continue;
                    if (olapValue instanceof Long) {
                        rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add(new BigDecimal((Long)olapValue)));
                        continue;
                    }
                    if (!(olapValue instanceof BigDecimal)) continue;
                    rowValue.setValue((Object)((BigDecimal)rowValue.getValue()).add((BigDecimal)olapValue));
                }
                continue block0;
            }
        }
    }

    private Map<String, List<AdjustBillDetail>> getSameDimRowDataMap(List<AdjustBillDetail> billDetailList) {
        LinkedHashMap<String, List<AdjustBillDetail>> sameDimRowDataMap = new LinkedHashMap<String, List<AdjustBillDetail>>(billDetailList.size());
        StringBuilder rowDimMembers = new StringBuilder();
        for (AdjustBillDetail billDetail : billDetailList) {
            String periodNumber = billDetail.getBudgetPeriod().getNumber();
            String entityNumber = billDetail.getEntity().getNumber();
            String accountNumber = billDetail.getAccount().getNumber();
            String metricNumber = billDetail.getMetric().getNumber();
            rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(periodNumber).append("!!").append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                rowDimMembers.append("!!").append(customDim.getDimNumber()).append("@").append(customDim.getMemberNumber());
            }
            List rowDataList = sameDimRowDataMap.computeIfAbsent(rowDimMembers.toString(), v -> new ArrayList(16));
            rowDataList.add(billDetail);
            rowDimMembers.setLength(0);
        }
        return sameDimRowDataMap;
    }
}

