/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillValidator;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.CheckAdjust;
import kd.epm.eb.business.adjust.CheckAdjustment;
import kd.epm.eb.business.adjust.validator.ExpenseBudgetAdjustValidator;
import kd.epm.eb.business.adjust.validator.IAdjustValidatorSource;
import kd.epm.eb.business.adjust.validator.IBatchAdjustValidatorSource;
import kd.epm.eb.business.adjust.validator.OverallAdjustValidator;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAdjustValidator {
    protected static final Log log = LogFactory.getLog(AbstractAdjustValidator.class);
    private IAdjustValidatorSource source = null;
    private String operation = null;
    private List<String> errorInfos = new ArrayList<String>(16);
    private DynamicInfoCollection billInfos = null;

    protected AbstractAdjustValidator(@NotNull IAdjustValidatorSource source, @NotNull String operation) {
        this.source = source;
        this.operation = operation;
    }

    public IAdjustValidatorSource getSource() {
        return this.source;
    }

    public String getOperation() {
        return this.operation;
    }

    public List<String> getErrorInfos() {
        return this.errorInfos;
    }

    public DynamicInfoCollection getBillInfos() {
        return this.billInfos;
    }

    public void batchValidate(ExtendedDataEntity[] dataEntities) {
        block19: {
            if (dataEntities == null || dataEntities.length == 0) {
                return;
            }
            ArrayList<DynamicObject> dynObjs = new ArrayList<DynamicObject>(dataEntities.length);
            ArrayList<ExtendedDataEntity> dyndes = new ArrayList<ExtendedDataEntity>(dataEntities.length);
            for (ExtendedDataEntity ede : dataEntities) {
                try {
                    List<String> msgs;
                    String checkMsg;
                    this.getSource().setDynObj4Batch(ede.getDataEntity());
                    if ("save".equals(this.getOperation())) {
                        if (this.checkMustInputProp(ede, "billtype")) {
                            return;
                        }
                        if (this.checkMustInputProp(ede, "applier")) {
                            return;
                        }
                        if (this.checkMustInputProp(ede, "billstatus")) {
                            return;
                        }
                        if (this.checkMustInputProp(ede, "applydate")) {
                            return;
                        }
                        if (this.checkMustInputProp(ede, "company")) {
                            return;
                        }
                        if (this.checkMustInputProp(ede, "department")) {
                            return;
                        }
                    }
                    if ((checkMsg = this.beforeCheckModel()) != null) {
                        this.processErrorMsg(false, ede, checkMsg);
                        return;
                    }
                    if ("save".equals(this.getOperation()) && (msgs = this.checkDimPerm()) != null && !msgs.isEmpty()) {
                        this.processErrorMsg(false, ede, msgs);
                        continue;
                    }
                    if (!this.getSource().isEbForm()) {
                        this.getSource().singleValidate(this.getOperation());
                    }
                    if ("submit".equals(this.getOperation()) && (msgs = this.checkMustInput()) != null && !msgs.isEmpty()) {
                        this.processErrorMsg(false, ede, msgs);
                        continue;
                    }
                    dynObjs.add(ede.getDataEntity());
                    dyndes.add(ede);
                }
                catch (Throwable e) {
                    log.error(e);
                    this.processErrorMsg(false, ede, RequestContext.getOrCreate().getTraceId());
                }
            }
            try {
                Map<String, String> errorInfos;
                if (dynObjs.isEmpty() || !"submit".equals(this.getOperation()) || (errorInfos = this.validateList(this.getSource().isEbForm(), dynObjs.toArray(new DynamicObject[0]))) == null || errorInfos.isEmpty()) break block19;
                for (ExtendedDataEntity ede : dyndes) {
                    String error = errorInfos.get(ede.getValue("billno"));
                    if (error == null) continue;
                    this.processErrorMsg(true, ede, error);
                }
            }
            catch (Throwable e) {
                log.error(e);
                for (ExtendedDataEntity ede : dyndes) {
                    this.processErrorMsg(false, ede, RequestContext.getOrCreate().getTraceId());
                }
            }
        }
    }

    private boolean checkMustInputProp(ExtendedDataEntity ede, String prop) {
        Object value = this.getSource().getValue(prop);
        boolean isEmpty = false;
        if (value == null) {
            isEmpty = true;
        } else if (value instanceof ILocaleString) {
            if (StringUtils.isEmpty((String)((ILocaleString)value).getLocaleValue())) {
                isEmpty = true;
            }
        } else if (value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            isEmpty = true;
        }
        if (isEmpty) {
            String msg = ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u5355\u636e%1\u7684\u5fc5\u5f55\u9879%2\u3002", (String)"AdjustBillListPlugin_15_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getSource().getValue("billno"), prop});
            this.processErrorMsg(true, ede, msg);
        }
        return isEmpty;
    }

    public Map<String, String> validateList(boolean isEb, DynamicObject[] bills) {
        LinkedHashMap<String, String> errorInfos = new LinkedHashMap<String, String>(16);
        if (bills == null || bills.length == 0) {
            return errorInfos;
        }
        this.getSource().setDynObj4Batch(bills[0]);
        HashSet<String> modelIds = new HashSet<String>(16);
        ArrayList<String> headDimKeys = new ArrayList<String>(16);
        if (!isEb) {
            Collections.addAll(headDimKeys, "DataType", "Version", "budgetperiods", "ChangeType", "Currency");
        } else {
            Collections.addAll(headDimKeys, "DataType", "Version", "Year", "ChangeType", "Currency");
        }
        for (DynamicObject bill : bills) {
            String modelId = bill.getString("model.id");
            modelIds.add(modelId);
        }
        Map<String, DynamicInfoCollection> CustomDimInfo = null;
        HashMap<Long, List<DynamicObject>> definedDimMap = new HashMap<Long, List<DynamicObject>>(16);
        if (isEb) {
            CustomDimInfo = this.queryAllCustomDimsInfoOfModels(modelIds);
        } else {
            this.buildBgmDefineds(bills, definedDimMap);
        }
        DynamicInfoCollection billInfos = this.buildBillInfoCollection(bills, headDimKeys, errorInfos, CustomDimInfo, definedDimMap, isEb);
        List infoList = billInfos.getValues();
        if (infoList.size() > 0) {
            if (!isEb) {
                List values = billInfos.getValues();
                ArrayList<Long> passedBillIds = new ArrayList<Long>(values.size());
                for (DynamicInfoCollection.InfoObject in : values) {
                    String billId = (String)in.getValueByPropName("billId");
                    passedBillIds.add(Long.valueOf(billId));
                }
                DynamicObject[] passedBills = BusinessDataServiceHelper.load((Object[])passedBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bgm_adjustbill"));
                if ("1".equals(this.getSource().getFormType())) {
                    CheckAdjustment.bgmbatchIsSubmitAdjustment(passedBills, definedDimMap, billInfos);
                } else {
                    CheckAdjust.bgmbatchIsSubmitAdjust(passedBills, definedDimMap, billInfos);
                }
            } else if (isEb) {
                if ("1".equals(this.getSource().getFormType())) {
                    CheckAdjustment.batchIsSubmitAdjustment(billInfos, headDimKeys, CustomDimInfo);
                } else {
                    CheckAdjust.batchIsSubmitAdjust(billInfos, headDimKeys, CustomDimInfo);
                }
            }
            this.getCheckInfoAndMoveBills(billInfos.getValues(), errorInfos);
            if (!isEb) {
                AdjustBillValidator.batchValidate(infoList, errorInfos);
            }
            this.checkDimPerm(bills, billInfos.getValues(), errorInfos);
        }
        return errorInfos;
    }

    private Map<String, DynamicInfoCollection> queryAllCustomDimsInfoOfModels(Set<String> modelIds) {
        QFBuilder qb = new QFBuilder("model", "in", (Object)IDUtils.toLongs(modelIds));
        qb.add("issysdimension", "=", (Object)"0");
        DynamicObjectCollection customDims = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name,id,model.number,dseq,shortnumber", (QFilter[])qb.toArray(), (String)"dseq");
        HashMap<String, DynamicInfoCollection> custemInfos = new HashMap<String, DynamicInfoCollection>(16);
        int seq = 1;
        if (!customDims.isEmpty()) {
            for (DynamicObject dim : customDims) {
                String modelCube = dim.getString("model.number");
                String name = dim.getString("name");
                String number = dim.getString("number");
                String id = dim.getString("id");
                String shortNum = dim.getString("shortnumber");
                DynamicInfoCollection dimInfo = (DynamicInfoCollection)custemInfos.get(modelCube);
                if (dimInfo == null) {
                    dimInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4fe1\u606f-\u5e8f\u53f7\u3001\u7f16\u7801\u3001\u7b80\u7801\u3001\u540d\u79f0\u3001id", (String)"AdjustBillListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"controlkey", "seq", "number", "shortNum", "name", "id"});
                    custemInfos.put(modelCube, dimInfo);
                }
                seq = dimInfo.getValues().size() + 1;
                dimInfo.addInfo(new Object[]{number, seq, number, shortNum, name, id});
            }
        }
        return custemInfos;
    }

    private void buildBgmDefineds(DynamicObject[] bills, Map<Long, List<DynamicObject>> definedDimMap) {
        for (DynamicObject tempBill : bills) {
            ArrayList<DynamicObject> customDims = new ArrayList<DynamicObject>();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)tempBill.getLong("model.id"));
            List dimensionList = modelCacheHelper.getDimensionListByBusModel(this.getBizModelId());
            for (Dimension dimension : dimensionList) {
                if (dimension.isPreset()) continue;
                DynamicObject dim = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
                dim.set("id", (Object)dimension.getId());
                dim.set("shortnumber", (Object)dimension.getShortNumber());
                dim.set("number", (Object)dimension.getNumber());
                dim.set("name", (Object)dimension.getName());
                customDims.add(dim);
            }
            definedDimMap.put(tempBill.getLong("id"), customDims);
        }
    }

    private DynamicInfoCollection getCustomDimsByModelCube(String modelCube, Map<String, DynamicInfoCollection> CustomDimInfo) {
        DynamicInfoCollection infos = null;
        if (CustomDimInfo != null) {
            infos = CustomDimInfo.get(modelCube);
        }
        return infos;
    }

    private DynamicInfoCollection buildBillInfoCollection(DynamicObject[] bills, List<String> headDimKeys, Map<String, String> errorInfo, Map<String, DynamicInfoCollection> CustomDimInfo, Map<Long, List<DynamicObject>> definedDimMap, boolean isEb) {
        ArrayList<String> entryentityKeys = null;
        entryentityKeys = !isEb ? new ArrayList<String>(Arrays.asList("Entity", "Account", "Metric", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6")) : new ArrayList<String>(Arrays.asList("Period", "Entity", "Account", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6"));
        DynamicInfoCollection customDimInfo = null;
        DynamicInfoCollection billInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u5c01\u88c5--\u4f53\u7cfbId,\u4f53\u7cfbcube\uff0c\u5355\u636e\u7f16\u7801\uff0c\u5355\u636eid\uff0c\u5355\u636e\u5934\u7ef4\u5ea6\u4e32\uff0c\u5206\u5f55\u7ef4\u5ea6\u4e32\u96c6\u5408\uff0c\u9519\u8bef\u4fe1\u606f", (String)"AdjustBillListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"modelId", "modelCube", "billno", "billId", "headDimStr", "entityDimStrs", "errorInfo", "billtype"});
        String formType = null;
        if (errorInfo == null) {
            errorInfo = new LinkedHashMap<String, String>(16);
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map<String, Dimension> customDimMap = AdjustHelper.getCustomDimsByBizModel(this.getModelId(), this.getBizModelId());
        block0: for (DynamicObject bill : bills) {
            String modelCube = bill.getString("model.number");
            String modelId = bill.getString("model.id");
            String billStatus = bill.getString("billstatus");
            String billno = bill.getString("billno");
            String billId = bill.getString("id");
            formType = bill.getString("billtype");
            customDimInfo = this.getCustomDimsByModelCube(modelCube, CustomDimInfo);
            if (billStatus == null || !billStatus.equals("A") && !billStatus.equals("D")) {
                errorInfo.put(billno, ResManager.loadResFormat((String)"\u5355\u636e\u201c%1\u201d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"AdjustBillListPlugin_14_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno}));
                continue;
            }
            ArrayList<String> vals = new ArrayList<String>(16);
            DynamicObject dimVal = null;
            for (String key : headDimKeys) {
                if (bill.get(key) instanceof DynamicObjectCollection) {
                    DynamicObjectCollection docs = bill.getDynamicObjectCollection(key);
                    for (DynamicObject obj : docs) {
                        vals.add(obj.getDynamicObject("fbasedataid").getString("number"));
                    }
                    continue;
                }
                if (bill.get(key) instanceof DynamicObject) {
                    dimVal = bill.getDynamicObject(key);
                    vals.add(dimVal.getString("number"));
                    continue;
                }
                errorInfo.put(billno, ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u5355\u636e%1\u7684\u5fc5\u5f55\u9879%2\u3002", (String)"AdjustBillListPlugin_15_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno, key}));
                continue block0;
            }
            if (bill.getString("adjustreason").equals("")) {
                errorInfo.put(billno, ResManager.loadResFormat((String)"\u5355\u636e\u201c%1\u201d\u5fc5\u5f55\u9879\u8c03\u6574\u539f\u56e0\u672a\u586b\u5199\u3002", (String)"AdjustBillListPlugin_16_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno}));
                continue;
            }
            String headDimStr = String.join((CharSequence)"|", vals.toArray(new String[1]));
            DynamicObjectCollection entryRows = bill.getDynamicObjectCollection("adjdetailentity");
            if (entryRows.isEmpty()) {
                errorInfo.put(billno, ResManager.loadResFormat((String)"\u5355\u636e\u201c%1\u201d\u6709\u5fc5\u5f55\u9879\u8c03\u6574\u660e\u7ec6\u672a\u586b\u5199\u3002", (String)"AdjustBillListPlugin_17_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno}));
                continue;
            }
            ArrayList<String> entityDimStrs = new ArrayList<String>(16);
            String rowDimStr = null;
            List dimSeqs = customDimInfo == null ? new ArrayList(16) : customDimInfo.getAllValOfOneProp("seq");
            HashMap<String, Boolean> markRowAdjData = new HashMap<String, Boolean>(16);
            for (DynamicObject row : entryRows) {
                Object olaVal;
                String key2;
                boolean hasAdjust = false;
                vals.clear();
                Iterator iterator = entryentityKeys.iterator();
                while (iterator.hasNext() && !(key2 = (String)iterator.next()).contains("customdim")) {
                    dimVal = row.getDynamicObject(key2);
                    if (dimVal == null) {
                        errorInfo.put(billno, ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u5355\u636e%1\u7684\u5fc5\u5f55\u9879%2\u3002", (String)"AdjustBillListPlugin_15_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno, key2}));
                        continue block0;
                    }
                    vals.add(dimVal.getString("number"));
                }
                if (!isEb) {
                    List<DynamicObject> definedDims = definedDimMap.get(bill.getLong("id"));
                    for (int i = 0; i < definedDims.size(); ++i) {
                        dimVal = row.getDynamicObject("customdim" + (i + 1));
                        if (dimVal == null) continue;
                        vals.add(dimVal.getString("number"));
                    }
                    long account = row.getLong("account.id");
                    Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), Long.valueOf(account));
                    Long datasetId = accountMember.getDatasetId();
                    Map<String, Dimension> rowCustomDimMap = AdjustHelper.getCustomDimsByDataset(this.getModelId(), datasetId, customDimMap);
                    HashSet<Long> dimensionIds = new HashSet<Long>(16);
                    for (Map.Entry<String, Dimension> entry : rowCustomDimMap.entrySet()) {
                        String dimKey = entry.getKey();
                        Dimension dimension = entry.getValue();
                        DynamicObject customDimObj = row.getDynamicObject(dimKey);
                        if (customDimObj == null) continue;
                        dimensionIds.add(dimension.getId());
                    }
                    Collection<Dimension> dimensions = rowCustomDimMap.values();
                    if (dimensionIds.size() != dimensions.size()) {
                        Set collect = dimensions.stream().filter(dimension1 -> !dimensionIds.contains(dimension1.getId())).map(BaseCache::getName).collect(Collectors.toSet());
                        errorInfo.put(billno, ResManager.loadResFormat((String)"\u5355\u636e\u201c%1\u201d\u4e2d\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u201c%2\u201d\u672a\u586b\u5199\u3002", (String)"AdjustBillListPlugin_20_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno, org.apache.commons.lang3.StringUtils.join(collect, (String)"\uff0c")}));
                        continue block0;
                    }
                } else {
                    for (String key2 : dimSeqs) {
                        dimVal = row.getDynamicObject("customdim" + key2);
                        if (dimVal == null) {
                            errorInfo.put(billno, ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u5355\u636e%1\u7684\u5fc5\u5f55\u9879%2\u3002", (String)"AdjustBillListPlugin_15_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno, key2}));
                            continue block0;
                        }
                        vals.add(dimVal.getString("number"));
                    }
                }
                String groupNum = "null";
                if (formType.equals("2") && (groupNum = row.getString("groupnum")).equals("")) {
                    errorInfo.put(billno, ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u5355\u636e\u201c%1\u201d\u7684\u5fc5\u5f55\u9879\u8c03\u5242\u7ec4\u53f7\u3002", (String)"AdjustBillListPlugin_18_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno}));
                    continue block0;
                }
                String rowSign = row.getString("ordersign").split(":")[0];
                BigDecimal adjustData = row.getBigDecimal("adjustdata");
                BigDecimal budgetData = row.getBigDecimal("budgetdata");
                adjustData = row.getBigDecimal("adjustdata");
                BigDecimal finalData = row.getBigDecimal("finaldata");
                vals.add("(" + groupNum + "@" + budgetData.toString() + "@" + adjustData.toString() + "@" + finalData.toString() + ")");
                if (adjustData.compareTo(BigDecimal.ZERO) != 0) {
                    hasAdjust = true;
                }
                if ((olaVal = markRowAdjData.get(rowSign)) == null || olaVal.equals(false)) {
                    markRowAdjData.put(rowSign, hasAdjust);
                }
                rowDimStr = String.join((CharSequence)"|", vals.toArray(new String[1]));
                entityDimStrs.add(rowDimStr);
            }
            if (!markRowAdjData.containsValue(false)) {
                billInfos.addInfo(new Object[]{modelId, modelCube, billno, billId, headDimStr, entityDimStrs, null, formType});
                continue;
            }
            errorInfo.put(billno, ResManager.loadResFormat((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u8c03\u6574\u6570\u3002", (String)"AdjustBillListPlugin_19_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billno}));
        }
        return billInfos;
    }

    private void getCheckInfoAndMoveBills(List<DynamicInfoCollection.InfoObject> infoList, Map<String, String> errorInfos) {
        Iterator<DynamicInfoCollection.InfoObject> iterator = infoList.iterator();
        while (iterator.hasNext()) {
            DynamicInfoCollection.InfoObject info = iterator.next();
            String billNum = (String)info.getValueByPropName("billno");
            Object errorInfo = info.getValueByPropName("errorInfo");
            if (errorInfo == null || !StringUtils.isNotEmpty((String)errorInfo.toString())) continue;
            if (errorInfos != null) {
                StringBuilder errorMessage = new StringBuilder(errorInfo.toString());
                errorMessage.setLength(errorMessage.length() - 2);
                errorInfos.put(billNum, ResManager.loadResFormat((String)"\u5355\u636e\uff08%1\uff09%2", (String)"AdjustBillListPlugin_11_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{billNum, errorMessage.toString()}));
            }
            iterator.remove();
        }
    }

    private void checkDimPerm(DynamicObject[] bills, List<DynamicInfoCollection.InfoObject> infoList, Map<String, String> errorInfos) {
        Long modelId = this.getModelId();
        List permControlDims = DimMembPermUtil.getPermControlDim((Long)modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        ArrayList<String> definedDim = new ArrayList<String>(16);
        ArrayList<String> permControlDim = new ArrayList<String>(16);
        List dimensionList = ModelUtil.isEbOrBgModel(modelId) ? ModelCacheContext.getOrCreate((Long)modelId).getDimensionList() : ModelCacheContext.getOrCreate((Long)modelId).getDimensionListByBusModel(this.getBizModelId());
        for (Dimension dimension : dimensionList) {
            if (!dimension.isPreset()) {
                definedDim.add(dimension.getNumber());
            }
            if (!permControlDims.contains(dimension.getNumber())) continue;
            permControlDim.add(dimension.getNumber());
        }
        HashSet<String> billNos = new HashSet<String>(16);
        Long userId = UserUtils.getUserId();
        DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)this.getBizModelId(), permControlDim, (Long)userId, (DimMembPermType)DimMembPermType.WRITE);
        for (DynamicObject bill : bills) {
            this.getSource().setDynObj4Batch(bill);
            HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(permControlDim.size());
            StringBuilder stringBuilder = new StringBuilder();
            for (String dim : permControlDim) {
                DynamicObject value;
                if (!SysDimensionEnum.DataType.getNumber().equals(dim) && !SysDimensionEnum.ChangeType.getNumber().equals(dim) && !SysDimensionEnum.Version.getNumber().equals(dim) || (value = bill.getDynamicObject(dim.toLowerCase())) == null) continue;
                MemberItem memberItem = new MemberItem(true, Long.valueOf(value.getLong("id")));
                memberItemMap.put(dim, memberItem);
                stringBuilder.append(value.getString("number")).append(",");
            }
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("adjdetailentity");
            for (int row = 0; row < entryEntity.size(); ++row) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                HashMap<String, MemberItem> entryMemberMap = new HashMap<String, MemberItem>(permControlDim.size());
                entryMemberMap.putAll(memberItemMap);
                StringBuilder entryStringBuilder = new StringBuilder(stringBuilder);
                for (String dim : permControlDim) {
                    DynamicObject object = null;
                    if (SysDimensionEnum.getEnumByNumber((String)dim) == null) {
                        int index = definedDim.indexOf(dim) + 1;
                        object = dynamicObject.getDynamicObject("customdim" + index);
                    } else if (SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Account.getNumber().equals(dim) || SysDimensionEnum.Metric.getNumber().equals(dim)) {
                        object = dynamicObject.getDynamicObject(dim.toLowerCase());
                    }
                    if (object == null) continue;
                    MemberItem memberItem = new MemberItem(true, Long.valueOf(object.getLong("id")));
                    entryMemberMap.put(dim, memberItem);
                    entryStringBuilder.append(object.getString("number")).append(",");
                }
                boolean check = permChecker.check(entryMemberMap);
                if (check) continue;
                String error = ResManager.loadResFormat((String)"\u5355\u636e%1\u7b2c%2\u5206\u5f55\u7ef4\u5ea6\u7ec4\u5408%3\u65e0\u6743\u3002", (String)"BaseEbAdjustBillEditPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[]{bill.getString("billno"), row + 1, entryStringBuilder.substring(0, entryStringBuilder.length() - 1)});
                errorInfos.put(bill.getString("billno"), error);
                billNos.add(bill.getString("billno"));
            }
        }
        Iterator<DynamicInfoCollection.InfoObject> iterator = infoList.iterator();
        while (iterator.hasNext()) {
            DynamicInfoCollection.InfoObject info = iterator.next();
            String billNum = (String)info.getValueByPropName("billno");
            if (!billNos.contains(billNum)) continue;
            iterator.remove();
        }
    }

    private void processErrorMsg(boolean hasNumber, ExtendedDataEntity ede, String msg) {
        if (StringUtils.isEmpty((String)msg) || ede == null) {
            return;
        }
        if (this.getSource() instanceof IBatchAdjustValidatorSource) {
            if (!hasNumber) {
                msg = ResManager.loadResFormat((String)"\u5355\u636e\uff08%1\uff09%2", (String)"AdjustBillValidator_15", (String)"epm-eb-business", (Object[])new Object[]{ede.getValue("billno"), msg});
            }
            ((IBatchAdjustValidatorSource)this.getSource()).addErrorMessage(ede, msg);
        }
    }

    private void processErrorMsg(boolean hasNumber, ExtendedDataEntity ede, List<String> msgs) {
        if (msgs == null || msgs.isEmpty()) {
            return;
        }
        this.processErrorMsg(hasNumber, ede, String.join((CharSequence)"\r\n", msgs));
    }

    public static AbstractAdjustValidator getInstance(@NotNull IAdjustValidatorSource source, @NotNull String operation) {
        if (source.isEbForm()) {
            return new ExpenseBudgetAdjustValidator(source, operation);
        }
        return new OverallAdjustValidator(source, operation);
    }

    public Long getBizModelId() {
        if (this.getSource().isEbForm()) {
            return 0L;
        }
        DynamicObject bizModel = (DynamicObject)this.getSource().getValue("bizmodel");
        return bizModel == null ? 0L : bizModel.getLong("id");
    }

    protected Long getModelId() {
        DynamicObject model = (DynamicObject)this.getSource().getValue("model");
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    public String checkAdjustReason() {
        Object adjustreason = this.getSource().getValue("adjustreason");
        if (StringUtils.isEmpty((String)String.valueOf(adjustreason))) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u6574\u539f\u56e0\u3002", (String)"BaseEbAdjustBillEditPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (msg == null) {
                msg = "adjustreason";
            }
            return msg;
        }
        return null;
    }

    public String beforeCheck() {
        String msg = this.beforeCheckModel();
        if (msg != null) {
            return msg;
        }
        DynamicObjectCollection entryRows = this.getSource().getEntryEntity("entryentity");
        if (!entryRows.isEmpty()) {
            int rowIndex = 1;
            for (DynamicObject row : entryRows) {
                for (int i = 1; i <= 19; ++i) {
                    Object finalData = row.get("adjfinaldata" + i);
                    if (finalData == null) continue;
                    String finalDataStr = finalData.toString();
                    if (finalDataStr.contains(".")) {
                        finalDataStr = finalDataStr.substring(0, finalDataStr.indexOf("."));
                    }
                    if (finalDataStr.length() <= 13) continue;
                    return ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6574\u6570\u957f\u5ea6\u8d85\u8fc713\u4f4d\u3002", (String)"BaseEbAdjustBillEditPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex});
                }
                ++rowIndex;
            }
        }
        return null;
    }

    private String beforeCheckModel() {
        DynamicObject busModel;
        DynamicObject model = (DynamicObject)this.getSource().getValue("model");
        if (model == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BaseEbAdjustBillEditPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (!this.getSource().isEbForm() && (busModel = (DynamicObject)this.getSource().getValue("bizmodel")) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BaseEbAdjustBillEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public List<String> checkDimPerm() {
        Long modelId = this.getModelId();
        List permControlDims = DimMembPermUtil.getPermControlDim((Long)modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        ArrayList<String> definedDim = new ArrayList<String>(16);
        ArrayList<String> permControlDim = new ArrayList<String>(16);
        List dimensionList = ModelUtil.isEbOrBgModel(modelId) ? this.source.getModelCache(modelId).getDimensionList() : this.source.getModelCache(modelId).getDimensionListByBusModel(this.getBizModelId());
        for (Dimension dimension : dimensionList) {
            if (!dimension.isPreset()) {
                definedDim.add(dimension.getNumber());
            }
            if (!permControlDims.contains(dimension.getNumber())) continue;
            permControlDim.add(dimension.getNumber());
        }
        Long userId = UserUtils.getUserId();
        DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)this.getBizModelId(), permControlDim, (Long)userId, (DimMembPermType)DimMembPermType.WRITE);
        HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(permControlDim.size());
        StringBuilder stringBuilder = new StringBuilder();
        for (String dim : permControlDim) {
            Object value;
            if (!SysDimensionEnum.DataType.getNumber().equals(dim) && !SysDimensionEnum.ChangeType.getNumber().equals(dim) && !SysDimensionEnum.Version.getNumber().equals(dim) || (value = this.getSource().getValue(dim.toLowerCase())) == null) continue;
            MemberItem memberItem = new MemberItem(true, Long.valueOf(((DynamicObject)value).getLong("id")));
            memberItemMap.put(dim, memberItem);
            stringBuilder.append(((DynamicObject)value).getString("number")).append(",");
        }
        DynamicObjectCollection entryEntity = this.getSource().getEntryEntity("entryentity");
        ArrayList<String> errorMsg = new ArrayList<String>(entryEntity.size());
        for (int row = 0; row < entryEntity.size(); ++row) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
            HashMap<String, MemberItem> entryMemberMap = new HashMap<String, MemberItem>(permControlDim.size());
            entryMemberMap.putAll(memberItemMap);
            StringBuilder entryStringBuilder = new StringBuilder(stringBuilder);
            for (String dim : permControlDim) {
                DynamicObject object = null;
                if (SysDimensionEnum.getEnumByNumber((String)dim) == null) {
                    int index = definedDim.indexOf(dim) + 1;
                    object = dynamicObject.getDynamicObject("adjcustomdim" + index);
                } else if (SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Account.getNumber().equals(dim) || SysDimensionEnum.Metric.getNumber().equals(dim)) {
                    object = dynamicObject.getDynamicObject("adj" + dim.toLowerCase());
                }
                if (object == null) continue;
                MemberItem memberItem = new MemberItem(true, Long.valueOf(object.getLong("id")));
                entryMemberMap.put(dim, memberItem);
                entryStringBuilder.append(object.getString("number")).append(",");
            }
            boolean check = permChecker.check(entryMemberMap);
            for (int j = 1; j < 21; ++j) {
                this.getSource().setEnable(check, row, "adjadjustdata" + j, "adjfinaldata" + j);
            }
            if (check) continue;
            String error = ResManager.loadResFormat((String)"\u7b2c%1\u5206\u5f55\u7ef4\u5ea6\u7ec4\u5408%2\u65e0\u6743\u3002", (String)"BaseEbAdjustBillEditPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[]{row + 1, entryStringBuilder.substring(0, entryStringBuilder.length() - 1)});
            errorMsg.add(error);
        }
        return errorMsg;
    }

    public List<String> checkMustInput() {
        int periodCount = this.getSource().getCachePeriodInfo().getValues().size();
        DynamicInfoCollection customDims = this.getSource().getCustomDimsInfoCache();
        DynamicObjectCollection entryRows = this.getSource().getEntryEntity("entryentity");
        int rowNum = 1;
        StringBuilder errorInfo = new StringBuilder();
        ArrayList<String> errorList = new ArrayList<String>(16);
        if (entryRows.isEmpty()) {
            errorList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u660e\u7ec6\u5206\u5f55\u3002", (String)"BaseEbAdjustBillEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return errorList;
        }
        boolean needGroupNum = this.getSource().getFormType().equals(EbAdjBillTypeEnum.adjpst.getNumber());
        for (DynamicObject row : entryRows) {
            Object val;
            errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"BaseEbAdjustBillEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(rowNum).append(ResManager.loadKDString((String)"\u884c", (String)"BaseEbAdjustBillEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0])).append("[");
            this.setErrorInfoForRowDim(row, errorInfo, customDims, rowNum - 1);
            boolean hasData = false;
            for (int i = 1; i <= periodCount; ++i) {
                val = row.get("adjadjustdata" + i);
                if (val == null || BigDecimal.ZERO.compareTo((BigDecimal)val) == 0) continue;
                hasData = true;
                break;
            }
            if (!hasData) {
                if (EbAdjBillTypeEnum.adjust.getNumber().equals(this.getSource().getFormType())) {
                    errorInfo.append(ResManager.loadKDString((String)"\u8c03\u6574\u6570\u3001", (String)"BaseEbAdjustBillEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    errorInfo.append(ResManager.loadKDString((String)"\u8c03\u5242\u6570\u3001", (String)"BaseEbAdjustBillEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            if (needGroupNum && ((val = row.get("adjgroupnum")) == null || "".equals(val))) {
                errorInfo.append(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u3001", (String)"BaseEbAdjustBillEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (errorInfo.charAt(errorInfo.length() - 1) != '[') {
                errorInfo.setCharAt(errorInfo.length() - 1, ']');
                errorInfo.append(ResManager.loadKDString((String)"\u672a\u586b", (String)"BaseEbAdjustBillEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                errorList.add(errorInfo.toString());
            }
            ++rowNum;
            errorInfo.setLength(0);
        }
        if (errorList.isEmpty()) {
            return null;
        }
        return errorList;
    }

    public void checkOrgPerm(String entityNumber, String bizAppId) {
        if (!this.getSource().isCheckModel()) {
            Object company = this.getSource().getValue("company");
            long id = 0L;
            if (company != null) {
                id = ((DynamicObject)company).getLong("id");
            }
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNumber);
            int i = PermissionServiceHelper.checkPermission((long)UserUtils.getUserId(), (String)"DIM_ORG", (long)id, (String)bizAppId, (String)entityNumber, (String)"47156aff000000ac");
            if (i == 0) {
                String permDesc = ResManager.loadKDString((String)"\u65b0\u589e", (String)"EBPermission_7", (String)"epm-eb-common", (Object[])new Object[0]);
                throw new KDBizException(ResManager.loadResFormat((String)"\u65e0\u201c%1\u201d\u7684\u201c%2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EBPermission_8", (String)"epm-eb-common", (Object[])new Object[]{met.getDisplayName(), permDesc}));
            }
        }
    }

    public abstract void setErrorInfoForRowDim(DynamicObject var1, StringBuilder var2, DynamicInfoCollection var3, int var4);

    public abstract boolean billHeadOver();

    public void singleValidate(Set<Integer> completedRows, String opType) {
    }

    public static final String getFormType(@NotNull IAdjustValidatorSource source) {
        String formType = (String)source.getValue("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        return formType;
    }

    public static final List<String> getEntityKeys(boolean isEbForm) {
        if (isEbForm) {
            return new ArrayList<String>(Arrays.asList("Entity", "Account", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6"));
        }
        return new ArrayList<String>(Arrays.asList("Entity", "Account", "Metric", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6", "customdim7", "customdim8", "customdim9", "customdim10", "customdim11", "customdim12", "customdim13", "customdim14", "customdim15", "customdim16", "customdim17", "customdim18", "customdim19", "customdim20", "customdim21", "customdim22", "customdim23", "customdim24", "customdim25", "customdim26", "customdim27", "customdim28", "customdim29", "customdim30", "customdim31", "customdim32", "customdim33", "customdim34", "customdim35", "customdim36", "customdim37", "customdim38", "customdim39", "customdim40", "customdim41", "customdim42", "customdim43", "customdim44", "customdim45", "customdim46", "customdim47", "customdim48", "customdim49", "customdim50"));
    }

    public static final String[] getPeriodGroupKeys(boolean isEbForm) {
        if (isEbForm) {
            return new String[]{"period", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
        }
        return new String[]{"budgetperiod", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
    }
}

