/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.validator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.validator.AbstractAdjustValidator;
import kd.epm.eb.business.adjust.validator.IBatchAdjustValidatorSource;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.LogSignHelper;

public class AdjustBillOpValidator
extends AbstractValidator
implements IBatchAdjustValidatorSource {
    private boolean isEb = false;
    DynamicInfoCollection periodInfos = null;
    Map<String, DynamicInfoCollection> customDimsMap = new HashMap<String, DynamicInfoCollection>(10);
    private DynamicObject curDynObj = null;
    private Map<String, Boolean> existControlDims = new HashMap<String, Boolean>(16);

    public AdjustBillOpValidator(boolean isEb) {
        this.isEb = isEb;
        this.setValidatePriority(ValidatePriority.First);
    }

    public void validate() {
        if (AdjustBillOpValidator.isNeedValidate() || this.getOption() != null && this.getOption().containsVariable("AdjustBillOpValidator_NeedValidate")) {
            AbstractAdjustValidator.getInstance(this, this.getOperateKey()).batchValidate(this.dataEntities);
        }
    }

    public static boolean isNeedValidate() {
        try {
            return LogSignHelper.needLog((String)"AdjustBillValidate", (String)"NeedValidate");
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public boolean checkAdjustment(String operation) {
        return false;
    }

    @Override
    public DynamicInfoCollection getCachePeriodInfo() {
        return this.periodInfos;
    }

    @Override
    public DynamicInfoCollection getCustomDimsInfoCache() {
        Long bizModelId;
        Long modelId = this.getModelId();
        String key = this.getKey(modelId, bizModelId = this.getBizModelId());
        if (this.customDimsMap.containsKey(key)) {
            return this.customDimsMap.get(key);
        }
        DynamicInfoCollection infos = null;
        infos = this.isEb ? AdjustHelper.buildCustomDimInfo(modelId) : AdjustHelper.buildCustomDimInfo(modelId, bizModelId);
        this.customDimsMap.put(key, infos);
        return infos;
    }

    @Override
    public DynamicObjectCollection getEntryEntity(String prop) {
        if (this.getDynObj4Batch() != null) {
            return this.getDynObj4Batch().getDynamicObjectCollection(prop);
        }
        return null;
    }

    @Override
    public String getFormType() {
        return AbstractAdjustValidator.getFormType(this);
    }

    @Override
    public IModelCacheHelper getModelCache(Long modelId) {
        return ModelCacheContext.getOrCreate((Long)this.getModelId());
    }

    @Override
    public Object getValue(String prop) {
        if (this.getDynObj4Batch() != null) {
            return this.getDynObj4Batch().get(prop);
        }
        return null;
    }

    @Override
    public void setResponseTheChanged(boolean need) {
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    @Override
    public boolean isEbForm() {
        return this.isEb;
    }

    @Override
    public void setEnable(Boolean paramBoolean, int paramInt, String ... paramVarArgs) {
    }

    @Override
    public void singleValidate(String opType) {
    }

    @Override
    public void setDynObj4Batch(DynamicObject obj) {
        this.curDynObj = obj;
        if (this.curDynObj != null) {
            DynamicObjectCollection periods = this.isEbForm() ? (DynamicObjectCollection)this.getValue("multperiod") : (DynamicObjectCollection)this.getValue("budgetperiods");
            this.periodInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u591a\u9009\u671f\u95f4\u4fe1\u606f-id,\u7f16\u7801\uff0c\u540d\u79f0\uff0c\u5e8f\u53f7", (String)"BaseEbAdjustBillEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "number", "name", "order"});
            int num = 1;
            for (DynamicObject period : periods) {
                String name = period.getString("fbasedataid.name");
                String id = period.getString("fbasedataid.id");
                String number = period.getString("fbasedataid.number");
                this.periodInfos.addInfo(new Object[]{id, number, name, num});
                ++num;
            }
            this.convertToAdjustEntity(false);
        }
    }

    @Override
    public DynamicObject getDynObj4Batch() {
        return this.curDynObj;
    }

    @Override
    public void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        super.addErrorMessage(dataEntity, content);
    }

    @Override
    public void batchCreateNewEntryRow(String prop, int rowNum) {
        if (this.getDynObj4Batch() != null) {
            DynamicObjectCollection col = this.getDynObj4Batch().getDynamicObjectCollection(prop);
            for (int i = 0; i < rowNum; ++i) {
                col.addNew();
            }
        }
    }

    @Override
    public void deleteEntryData(String prop) {
        if (this.getDynObj4Batch() != null) {
            this.getDynObj4Batch().getDynamicObjectCollection(prop).clear();
        }
    }

    @Override
    public Long getBizModelId() {
        if (this.isEbForm()) {
            return 0L;
        }
        DynamicObject bizModel = (DynamicObject)this.getValue("bizModel");
        if (bizModel != null) {
            return bizModel.getLong("id");
        }
        return 0L;
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getValue("model");
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    @Override
    public DynamicObject getEntryRowEntity(String prop, int rowindex) {
        if (this.getDynObj4Batch() != null) {
            return (DynamicObject)this.getDynObj4Batch().getDynamicObjectCollection(prop).get(rowindex);
        }
        return null;
    }

    @Override
    public String getCurrentDimNumber(String controlKey) {
        String dimNum = null;
        if (controlKey.contains("custom")) {
            DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
            dimNum = (String)customDims.getValOfOnePropByAnotherProp("number", "controlkey", (Object)controlKey);
        } else {
            for (SysDimensionEnum dimensionEnum : SysDimensionEnum.values()) {
                if (!controlKey.contains(dimensionEnum.getNumber().toLowerCase())) continue;
                dimNum = dimensionEnum.getNumber();
            }
        }
        return dimNum;
    }

    @Override
    public Map<String, String> getCustomDimMap() {
        return null;
    }

    @Override
    public boolean isExistControlDim() {
        Long bizModelId;
        Long modelId = this.getModelId();
        String key = this.getKey(modelId, bizModelId = this.getBizModelId());
        if (this.existControlDims.containsKey(key)) {
            return this.existControlDims.get(key);
        }
        QFilter modelQF = new QFilter("model", "=", (Object)this.getModelId());
        QFilter bizModelQF = new QFilter("businessmodel", "=", (Object)this.getBizModelId());
        boolean exists = QueryServiceHelper.exists((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{modelQF, bizModelQF});
        this.existControlDims.put(key, exists);
        return exists;
    }

    private String getKey(Long modelId, Long bizModelId) {
        String key = modelId + "_" + bizModelId;
        return key;
    }
}

