/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.validator.IAdjustBillValidator;
import kd.epm.eb.business.bizrule.RuleFindService;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillDetail;
import kd.epm.eb.common.adjust.BasicData;
import kd.epm.eb.common.adjust.CustomDim;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.bgmddatalock.v2.IDataLockChecker;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class AdjustBillValidatorImpl
implements IAdjustBillValidator {
    private static AdjustBillValidatorImpl instance = null;

    public static AdjustBillValidatorImpl getInstance() {
        if (instance == null) {
            instance = new AdjustBillValidatorImpl();
        }
        return instance;
    }

    @Override
    public boolean validateDimView(AdjustBill adjustBill, Set<String> errorBillNos, List<String> errorTips) {
        List detailList = adjustBill.getDetailList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return true;
        }
        ArrayList<String> rowErrorList = new ArrayList<String>(16);
        StringBuilder rowError = new StringBuilder();
        HashSet<Integer> rows = new HashSet<Integer>(detailList.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)adjustBill.getModel().getId());
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(adjustBill.getBizModel().getId());
        for (AdjustBillDetail billDetail : detailList) {
            int row = billDetail.getRow();
            if (!rows.add(row)) continue;
            BasicData entityObj = billDetail.getEntity();
            String entityNumber = entityObj.getNumber();
            Long entityViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
            Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityNumber);
            if (entityMember == null) {
                rowError.append(ResManager.loadResFormat((String)"\u9884\u7b97\u7ec4\u7ec7[%1]", (String)"AdjustBillValidator_12", (String)"epm-eb-business", (Object[])new Object[]{entityObj.getName()})).append("\u3001");
            }
            StringBuilder customDimNames = new StringBuilder();
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                String dimNumber = customDim.getDimNumber();
                String memberNumber = customDim.getMemberNumber();
                Long dimViewId = (Long)dimViewMap.get(dimNumber);
                Member customDimMember = modelCacheHelper.getMember(dimNumber, dimViewId, memberNumber);
                if (customDimMember != null) continue;
                customDimNames.append(customDim.getMemberName()).append("|");
            }
            if (StringUtils.isNotEmpty((String)customDimNames.toString())) {
                customDimNames.deleteCharAt(customDimNames.lastIndexOf("|"));
                rowError.append(ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7ec4\u5408[%1]", (String)"AdjustBillValidator_13", (String)"epm-eb-business", (Object[])new Object[]{customDimNames})).append("\u3001");
            }
            if (StringUtils.isNotEmpty((String)rowError.toString())) {
                rowError.deleteCharAt(rowError.lastIndexOf("\u3001"));
                String errorMsg = ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5206\u5f55\uff1a%2\u4e0d\u662f\u5f53\u524d\u9ed8\u8ba4\u89c6\u56fe\u7684\u6210\u5458\u3002", (String)"AdjustBillValidator_14", (String)"epm-eb-business", (Object[])new Object[]{row + 1, rowError.toString()}) + "\n";
                rowErrorList.add(errorMsg);
            }
            rowError.setLength(0);
        }
        if (!rowErrorList.isEmpty()) {
            String rowErrorStr = String.join((CharSequence)"", rowErrorList);
            String errorTip = ResManager.loadResFormat((String)"\u5355\u636e\uff08%1\uff09", (String)"AdjustBillValidator_2", (String)"epm-eb-business", (Object[])new Object[]{adjustBill.getBillNumber()});
            errorBillNos.add(adjustBill.getBillNumber());
            errorTips.add(errorTip + rowErrorStr);
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRowDimSame(AdjustBill adjustBill, Set<String> errorBillNos, List<String> errorTips, boolean allowSameDims) {
        List detailList = adjustBill.getDetailList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return true;
        }
        if (allowSameDims) {
            String billType = adjustBill.getBillType();
            if (EbAdjBillTypeEnum.adjpst.getNumber().equals(billType)) {
                HashSet<String> errorGroupNums = new HashSet<String>(16);
                Map<String, Set<Integer>> sameDimRowMap = this.getSameDimRowMap(detailList);
                for (Map.Entry<String, Set<Integer>> entry : sameDimRowMap.entrySet()) {
                    Set<Integer> rows = entry.getValue();
                    HashSet<String> groupNums = new HashSet<String>(rows.size());
                    for (int row : rows) {
                        AdjustBillDetail billDetail = (AdjustBillDetail)detailList.get(row);
                        String groupNum = billDetail.getGroupNum();
                        if (groupNums.add(groupNum)) continue;
                        errorGroupNums.add(groupNum);
                    }
                }
                if (errorGroupNums.isEmpty()) {
                    return true;
                }
                StringBuilder rowErrorStr = new StringBuilder();
                rowErrorStr.append(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\uff1a", (String)"AdjustBillValidator_10", (String)"epm-eb-business", (Object[])new Object[0]));
                for (String groupNum : errorGroupNums) {
                    rowErrorStr.append(groupNum).append("\u3001");
                }
                rowErrorStr.deleteCharAt(rowErrorStr.lastIndexOf("\u3001"));
                rowErrorStr.append("\uff0c");
                rowErrorStr.append(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"AdjustBillValidator_9", (String)"epm-eb-business", (Object[])new Object[0]));
                String string = ResManager.loadResFormat((String)"\u5355\u636e\uff08%1\uff09", (String)"AdjustBillValidator_2", (String)"epm-eb-business", (Object[])new Object[]{adjustBill.getBillNumber()});
                errorBillNos.add(adjustBill.getBillNumber());
                errorTips.add(string + rowErrorStr);
                return false;
            }
            return true;
        }
        StringBuilder rowDimMembers = new StringBuilder();
        HashMap<String, Set> sameDimRowMap = new HashMap<String, Set>(detailList.size());
        for (AdjustBillDetail billDetail : detailList) {
            int n = billDetail.getRow();
            BasicData entityObj = billDetail.getEntity();
            BasicData accountObj = billDetail.getAccount();
            BasicData metricObj = billDetail.getMetric();
            String entityNumber = entityObj.getNumber();
            String accountNumber = accountObj.getNumber();
            String metricNumber = metricObj.getNumber();
            rowDimMembers.append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                String dimNumber = customDim.getDimNumber();
                String memberNumber = customDim.getMemberNumber();
                rowDimMembers.append("!!").append(dimNumber).append("@").append(memberNumber);
            }
            Set rows = sameDimRowMap.computeIfAbsent(rowDimMembers.toString(), v -> new HashSet(16));
            rows.add(n);
            rowDimMembers.setLength(0);
        }
        ArrayList<String> rowErrorList = new ArrayList<String>(16);
        StringBuilder rowError = new StringBuilder();
        for (Map.Entry entry : sameDimRowMap.entrySet()) {
            Set rows = (Set)entry.getValue();
            if (rows.size() <= 1) continue;
            rowError.append(ResManager.loadKDString((String)"\u7b2c", (String)"AdjustBillValidator_0", (String)"epm-eb-business", (Object[])new Object[0]));
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                rowError.append(i + 1).append("\u3001");
            }
            rowError.deleteCharAt(rowError.lastIndexOf("\u3001"));
            rowError.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\uff0c\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"AdjustBillValidator_1", (String)"epm-eb-business", (Object[])new Object[0]));
            rowErrorList.add(rowError.toString());
            rowError.setLength(0);
        }
        if (!rowErrorList.isEmpty()) {
            String string = String.join((CharSequence)"", rowErrorList);
            String errorTip = ResManager.loadResFormat((String)"\u5355\u636e\uff08%1\uff09", (String)"AdjustBillValidator_2", (String)"epm-eb-business", (Object[])new Object[]{adjustBill.getBillNumber()});
            errorBillNos.add(adjustBill.getBillNumber());
            errorTips.add(errorTip + string);
            return false;
        }
        return true;
    }

    @Override
    public boolean validateDimRule(AdjustBill adjustBill, Set<String> errorBillNos, List<String> errorTips, String auditTrail) {
        BasicData changeType = adjustBill.getChangeType();
        BasicData dataType = adjustBill.getDataType();
        BasicData currency = adjustBill.getCurrency();
        BasicData version = adjustBill.getVersion();
        if (changeType == null || dataType == null || currency == null || version == null) {
            return true;
        }
        RuleFindService ruleFindService = RuleFindService.getInstance();
        Long modelId = adjustBill.getModel().getId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(adjustBill.getBizModel().getId());
        List detailList = adjustBill.getDetailList();
        ArrayList<String> rowErrorList = new ArrayList<String>(16);
        for (AdjustBillDetail billDetail : detailList) {
            boolean hasRule;
            BasicData budgetPeriod = billDetail.getBudgetPeriod();
            BasicData entity = billDetail.getEntity();
            BasicData account = billDetail.getAccount();
            BasicData metric = billDetail.getMetric();
            if (budgetPeriod == null || entity == null || account == null || metric == null) continue;
            int row = billDetail.getRow();
            Long datasetId = billDetail.getDatasetId();
            HashMap<String, String> cellMap = new HashMap<String, String>(16);
            cellMap.put(SysDimensionEnum.ChangeType.getNumber(), changeType.getNumber());
            cellMap.put(SysDimensionEnum.DataType.getNumber(), dataType.getNumber());
            cellMap.put(SysDimensionEnum.Currency.getNumber(), currency.getNumber());
            cellMap.put(SysDimensionEnum.Version.getNumber(), version.getNumber());
            cellMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), budgetPeriod.getNumber());
            cellMap.put(SysDimensionEnum.Entity.getNumber(), entity.getNumber());
            cellMap.put(SysDimensionEnum.Account.getNumber(), account.getNumber());
            cellMap.put(SysDimensionEnum.Metric.getNumber(), metric.getNumber());
            cellMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            StringBuilder customDimNames = new StringBuilder();
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                cellMap.put(customDim.getDimNumber(), customDim.getMemberNumber());
                customDimNames.append(customDim.getMemberName()).append("|");
            }
            if (StringUtils.isNotEmpty((String)customDimNames.toString())) {
                customDimNames.deleteCharAt(customDimNames.lastIndexOf("|"));
            }
            if (AdjustHelper.isHasInternalCompany(modelId, datasetId)) {
                cellMap.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
            }
            if (!(hasRule = ruleFindService.checkCellDetailHasRule(modelId, datasetId, cellMap, dimViewMap))) continue;
            String errorMsg = StringUtils.isNotEmpty((String)customDimNames.toString()) ? ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u9884\u7b97\u671f\u95f4[%2]\u3001\u7ec4\u7ec7[%3]\u3001\u79d1\u76ee[%4]\u3001\u5ea6\u91cf[%5]\u3001\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7ec4\u5408[%6]\uff0c\u5b58\u5728\u542f\u7528\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8c03\u6574\u3002", (String)"AdjustBillValidator_7", (String)"epm-eb-business", (Object[])new Object[]{row + 1, billDetail.getBudgetPeriod().getName(), billDetail.getEntity().getName(), billDetail.getAccount().getName(), billDetail.getMetric().getName(), customDimNames}) + "\n" : ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u9884\u7b97\u671f\u95f4[%2]\u3001\u7ec4\u7ec7[%3]\u3001\u79d1\u76ee[%4]\u3001\u5ea6\u91cf[%5]\uff0c\u5b58\u5728\u542f\u7528\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8c03\u6574\u3002", (String)"AdjustBillValidator_8", (String)"epm-eb-business", (Object[])new Object[]{row + 1, billDetail.getBudgetPeriod().getName(), billDetail.getEntity().getName(), billDetail.getAccount().getName(), billDetail.getMetric().getName(), customDimNames}) + "\n";
            rowErrorList.add(errorMsg);
        }
        if (!rowErrorList.isEmpty()) {
            String billNo = adjustBill.getBillNumber();
            String billType = adjustBill.getBillType();
            String billTypeName = EbAdjBillTypeEnum.getEnum((String)billType).getName();
            errorBillNos.add(billNo);
            String rowErrorStr = String.join((CharSequence)"", rowErrorList);
            String errorTip = ResManager.loadResFormat((String)"%1\u3010%2\u3011\u5206\u5f55", (String)"AdjustBillValidator_6", (String)"epm-eb-business", (Object[])new Object[]{billTypeName, billNo}) + "\n";
            errorTips.add(errorTip + rowErrorStr);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean validateOnOrderBill(AdjustBill adjustBill, Set<String> errorBillNos, List<String> errorTips, Set<Long> selectBillIds, boolean allowOnOrder) {
        String rowDims;
        if (!allowOnOrder) {
            return true;
        }
        List detailList = adjustBill.getDetailList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return true;
        }
        List<String> errorMsgList = this.getErrorMsgList(adjustBill, selectBillIds);
        if (errorMsgList.isEmpty()) {
            return true;
        }
        LinkedHashMap<String, void> errorMap = new LinkedHashMap<String, void>(errorMsgList.size());
        for (String string : errorMsgList) {
            void var11_13;
            String string2 = string.split("=")[0];
            rowDims = string.split("=")[1];
            if (errorMap.containsKey(rowDims)) {
                String string3 = (String)errorMap.get(rowDims) + "," + string2;
            }
            errorMap.put(rowDims, var11_13);
        }
        ArrayList<String> errorInfoList = new ArrayList<String>(errorMsgList.size());
        for (Map.Entry entry : errorMap.entrySet()) {
            rowDims = (String)entry.getKey();
            String[] rowDimArr = rowDims.split("!!");
            String periodName = (String)entry.getValue();
            String billType = rowDimArr[5];
            String billTypeName = EbAdjBillTypeEnum.getEnum((String)billType).getName();
            String errorInfo = StringUtils.isNotEmpty((String)rowDimArr[4]) ? ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u9884\u7b97\u671f\u95f4[%2]\u3001\u7ec4\u7ec7[%3]\u3001\u79d1\u76ee[%4]\u3001\u5ea6\u91cf[%5]\u3001\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7ec4\u5408[%6]\uff0c\u5df2\u5b58\u5728\u672a\u5ba1\u6838\u7684%7[%8]\uff0c\u8bf7\u7b49\u5f85\u5355\u636e\u5904\u7406\u5b8c\u6210\u540e\u518d\u63d0\u4ea4\u3002", (String)"AdjustBillValidator_4", (String)"epm-eb-business", (Object[])new Object[]{rowDimArr[0], periodName, rowDimArr[1], rowDimArr[2], rowDimArr[3], rowDimArr[4], billTypeName, rowDimArr[6]}) + "\n" : ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u9884\u7b97\u671f\u95f4[%2]\u3001\u7ec4\u7ec7[%3]\u3001\u79d1\u76ee[%4]\u3001\u5ea6\u91cf[%5]\uff0c\u5df2\u5b58\u5728\u672a\u5ba1\u6838\u7684%6[%7]\uff0c\u8bf7\u7b49\u5f85\u5355\u636e\u5904\u7406\u5b8c\u6210\u540e\u518d\u63d0\u4ea4\u3002", (String)"AdjustBillValidator_5", (String)"epm-eb-business", (Object[])new Object[]{rowDimArr[0], periodName, rowDimArr[1], rowDimArr[2], rowDimArr[3], billTypeName, rowDimArr[6]}) + "\n";
            errorInfoList.add(errorInfo);
        }
        if (!errorInfoList.isEmpty()) {
            String string = adjustBill.getBillType();
            String string4 = EbAdjBillTypeEnum.getEnum((String)string).getName();
            String currBillNo = adjustBill.getBillNumber();
            String rowErrorStr = String.join((CharSequence)"", errorInfoList);
            String errorTip = ResManager.loadResFormat((String)"%1\u3010%2\u3011\u5206\u5f55", (String)"AdjustBillValidator_6", (String)"epm-eb-business", (Object[])new Object[]{string4, currBillNo}) + "\n";
            errorBillNos.add(currBillNo);
            errorTips.add(errorTip + rowErrorStr);
            return false;
        }
        return true;
    }

    private Map<String, Set<Integer>> getSameDimRowMap(List<AdjustBillDetail> detailList) {
        StringBuilder rowDimMembers = new StringBuilder();
        HashMap<String, Set<Integer>> sameDimRowMap = new HashMap<String, Set<Integer>>(detailList.size());
        for (int i = 0; i < detailList.size(); ++i) {
            AdjustBillDetail billDetail = detailList.get(i);
            BasicData periodObj = billDetail.getBudgetPeriod();
            BasicData entityObj = billDetail.getEntity();
            BasicData accountObj = billDetail.getAccount();
            BasicData metricObj = billDetail.getMetric();
            String periodNumber = periodObj.getNumber();
            String entityNumber = entityObj.getNumber();
            String accountNumber = accountObj.getNumber();
            String metricNumber = metricObj.getNumber();
            rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(periodNumber).append("!!").append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                String dimNumber = customDim.getDimNumber();
                String memberNumber = customDim.getMemberNumber();
                rowDimMembers.append("!!").append(dimNumber).append("@").append(memberNumber);
            }
            Set rows = sameDimRowMap.computeIfAbsent(rowDimMembers.toString(), v -> new HashSet(16));
            rows.add(i);
            rowDimMembers.setLength(0);
        }
        return sameDimRowMap;
    }

    private List<String> getErrorMsgList(AdjustBill adjustBill, Set<Long> selectBillIds) {
        ArrayList<String> errorMsgList = new ArrayList<String>(16);
        Map<String, Set<String>> onOrderBillDimMap = this.getOnOrderBillDimMap(adjustBill, selectBillIds);
        if (onOrderBillDimMap.isEmpty()) {
            return errorMsgList;
        }
        Set<String> currRowDimMemberList = this.getRowDimMemberList(adjustBill, true);
        for (String currRowDimMember : currRowDimMemberList) {
            for (Map.Entry<String, Set<String>> onOrderBillDimEntry : onOrderBillDimMap.entrySet()) {
                String key = onOrderBillDimEntry.getKey();
                Set<String> rowDimMemberList = onOrderBillDimEntry.getValue();
                for (String rowDimMember : rowDimMemberList) {
                    String currRowDimMembers = currRowDimMember.substring(currRowDimMember.indexOf("!!") + 2);
                    if (!currRowDimMembers.equals(rowDimMember)) continue;
                    String[] keyArr = key.split("#");
                    String billType = keyArr[0];
                    String billNo = keyArr[1];
                    String[] rowDimArr = currRowDimMember.split("!!");
                    int row = Integer.parseInt(rowDimArr[0]);
                    String[] periodArr = rowDimArr[1].split("@");
                    String[] entityArr = rowDimArr[2].split("@");
                    String[] accountArr = rowDimArr[3].split("@");
                    String[] metricArr = rowDimArr[4].split("@");
                    String periodName = periodArr[1].split("=")[1];
                    String entityName = entityArr[1].split("=")[1];
                    String accountName = accountArr[1].split("=")[1];
                    String metricName = metricArr[1].split("=")[1];
                    StringBuilder customDimNames = new StringBuilder();
                    if (rowDimArr.length > 5) {
                        for (int i = 5; i < rowDimArr.length; ++i) {
                            String[] customDimArr = rowDimArr[i].split("=");
                            String customDimName = customDimArr[1];
                            customDimNames.append(customDimName).append("|");
                        }
                    }
                    if (StringUtils.isNotEmpty((String)customDimNames.toString())) {
                        customDimNames.deleteCharAt(customDimNames.lastIndexOf("|"));
                    }
                    StringBuilder errorMsg = new StringBuilder();
                    errorMsg.append(periodName).append("=").append(row).append("!!").append(entityName).append("!!").append(accountName).append("!!").append(metricName).append("!!").append((CharSequence)customDimNames).append("!!").append(billType).append("!!").append(billNo);
                    if (errorMsgList.contains(errorMsg.toString())) continue;
                    errorMsgList.add(errorMsg.toString());
                }
            }
        }
        return errorMsgList;
    }

    private Map<String, Set<String>> getOnOrderBillDimMap(AdjustBill adjustBill, Set<Long> selectBillIds) {
        QFBuilder qFilter = new QFBuilder("model", "=", (Object)adjustBill.getModel().getId());
        qFilter.add("bizmodel", "=", (Object)adjustBill.getBizModel().getId());
        qFilter.add("datatype", "=", (Object)adjustBill.getDataType().getId());
        qFilter.add("version", "=", (Object)adjustBill.getVersion().getId());
        qFilter.add("changetype", "=", (Object)adjustBill.getChangeType().getId());
        qFilter.add("currency", "=", (Object)adjustBill.getCurrency().getId());
        qFilter.add("billstatus", "in", (Object)new String[]{AdjustBillStateEnum.SUBMIT.getShortNumber(), AdjustBillStateEnum.AUDITING.getShortNumber()});
        Map onOrderBillMap = BusinessDataServiceHelper.loadFromCache((String)"bgm_adjustbill", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty(selectBillIds)) {
            QFBuilder qFilterV = new QFBuilder("id", "in", selectBillIds);
            qFilterV.add("model", "=", (Object)adjustBill.getModel().getId());
            qFilterV.add("bizmodel", "=", (Object)adjustBill.getBizModel().getId());
            qFilterV.add("datatype", "=", (Object)adjustBill.getDataType().getId());
            qFilterV.add("version", "=", (Object)adjustBill.getVersion().getId());
            qFilterV.add("changetype", "=", (Object)adjustBill.getChangeType().getId());
            qFilterV.add("currency", "=", (Object)adjustBill.getCurrency().getId());
            Map selectedBillMap = BusinessDataServiceHelper.loadFromCache((String)"bgm_adjustbill", (QFilter[])qFilterV.toArray());
            onOrderBillMap.putAll(selectedBillMap);
        }
        HashMap<String, Set<String>> onOrderBillDimMap = new HashMap<String, Set<String>>(onOrderBillMap.size());
        for (Map.Entry billEntry : onOrderBillMap.entrySet()) {
            DynamicObject billObj = (DynamicObject)billEntry.getValue();
            String billType = billObj.getString("billtype");
            String billNumber = billObj.getString("billno");
            if (billNumber.equals(adjustBill.getBillNumber())) continue;
            AdjustBill onOrderBill = AdjustBillConvertor.dynamic2AdjustBill(billObj, false);
            Set<String> rowDimMemberSet = this.getRowDimMemberList(onOrderBill, false);
            onOrderBillDimMap.put(billType + "#" + billNumber, rowDimMemberSet);
        }
        return onOrderBillDimMap;
    }

    private Set<String> getRowDimMemberList(AdjustBill adjustBill, boolean containRow) {
        List detailList = adjustBill.getDetailList();
        StringBuilder rowDimMembers = new StringBuilder();
        LinkedHashSet<String> rowDimMemberSet = new LinkedHashSet<String>(detailList.size());
        for (AdjustBillDetail billDetail : detailList) {
            int row = billDetail.getRow();
            BasicData periodObj = billDetail.getBudgetPeriod();
            BasicData entityObj = billDetail.getEntity();
            BasicData accountObj = billDetail.getAccount();
            BasicData metricObj = billDetail.getMetric();
            String periodNumber = periodObj.getNumber();
            String periodName = periodObj.getName();
            String entityNumber = entityObj.getNumber();
            String entityName = entityObj.getName();
            String accountNumber = accountObj.getNumber();
            String accountName = accountObj.getName();
            String metricNumber = metricObj.getNumber();
            String metricName = metricObj.getName();
            if (containRow) {
                rowDimMembers.append(row + 1).append("!!");
            }
            rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(periodNumber).append("=").append(periodName).append("!!").append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("=").append(entityName).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("=").append(accountName).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber).append("=").append(metricName);
            List customDimList = billDetail.getCustomDimList();
            for (CustomDim customDim : customDimList) {
                String dimNumber = customDim.getDimNumber();
                String memberNumber = customDim.getMemberNumber();
                String memberName = customDim.getMemberName();
                rowDimMembers.append("!!").append(dimNumber).append("@").append(memberNumber).append("=").append(memberName);
            }
            rowDimMemberSet.add(rowDimMembers.toString());
            rowDimMembers.setLength(0);
        }
        return rowDimMemberSet;
    }

    @Override
    public boolean validateDimLock(AdjustBill adjustBill, Set<String> errorBillNos, List<String> errorTips, String auditTrail) {
        IDataLockChecker checker = DataLockService.getInstance().getCheckerByBizModel(adjustBill.getModel().getId(), adjustBill.getBizModel().getId());
        List adjustBillDetailList = adjustBill.getDetailList();
        HashSet<String> dimMemSet = new HashSet<String>(16);
        for (AdjustBillDetail detail : adjustBillDetailList) {
            boolean isDataLock;
            HashMap<String, String> dimMemMap = new HashMap<String, String>(16);
            dimMemMap.put(SysDimensionEnum.Version.getNumber(), adjustBill.getVersion().getNumber());
            dimMemMap.put(SysDimensionEnum.DataType.getNumber(), adjustBill.getDataType().getNumber());
            dimMemMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            dimMemMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), detail.getBudgetPeriod().getNumber());
            dimMemMap.put(SysDimensionEnum.Entity.getNumber(), detail.getEntity().getNumber());
            StringBuilder dimMemStr = new StringBuilder();
            dimMemStr.append(SysDimensionEnum.Entity.getNumber()).append("=").append(detail.getEntity().getNumber()).append(",");
            dimMemStr.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("=").append(detail.getBudgetPeriod().getNumber()).append(",");
            dimMemStr.append(SysDimensionEnum.Version.getNumber()).append("=").append(adjustBill.getVersion().getNumber()).append(",");
            dimMemStr.append(SysDimensionEnum.DataType.getNumber()).append("=").append(adjustBill.getDataType().getNumber()).append(",");
            dimMemStr.append(SysDimensionEnum.AuditTrail.getNumber()).append("=").append(auditTrail);
            if (!dimMemSet.add(dimMemStr.toString()) || !(isDataLock = checker.isDataLock(dimMemMap))) continue;
            errorBillNos.add(adjustBill.getBillNumber());
            String errorTip = ResManager.loadResFormat((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u6570\u636e%1\u4e3a\u5df2\u9501\u5b9a\u6570\u636e\u3002", (String)"AdjustBillValidator_16", (String)"epm-eb-business", (Object[])new Object[]{dimMemStr.toString()});
            errorTips.add(errorTip);
            return false;
        }
        return true;
    }
}

