/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust.validator;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.validator.AbstractAdjustValidator;
import kd.epm.eb.business.adjust.validator.IAdjustValidatorSource;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class OverallAdjustValidator
extends AbstractAdjustValidator {
    public OverallAdjustValidator(@NotNull IAdjustValidatorSource source, @NotNull String operation) {
        super(source, operation);
    }

    @Override
    public void setErrorInfoForRowDim(DynamicObject row, StringBuilder errorInfo, DynamicInfoCollection customDims, int rowNum) {
        IModelCacheHelper modelCacheHelper = this.getSource().getModelCache(this.getModelId());
        List<String> entryEntityKeys = OverallAdjustValidator.getEntityKeys(false);
        for (String dimKey : entryEntityKeys) {
            Member accountMember;
            Long accountId;
            dimKey = "adj" + dimKey;
            Object val = row.get(dimKey);
            if (val != null) continue;
            if (dimKey.contains("Entity")) {
                errorInfo.append(ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u3001", (String)"OverallBudgetAdjustPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (dimKey.contains("Account")) {
                errorInfo.append(ResManager.loadKDString((String)"\u9884\u7b97\u79d1\u76ee\u3001", (String)"OverallBudgetAdjustPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (dimKey.contains("Metric")) {
                errorInfo.append(ResManager.loadKDString((String)"\u5ea6\u91cf\u3001", (String)"OverallBudgetAdjustPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!dimKey.contains("customdim") || IDUtils.isNull((Long)(accountId = Long.valueOf(row.getLong("adjaccount.id")))) || (accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId)) == null) continue;
            Long datasetId = accountMember.getDatasetId();
            DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo(customDims, this.getModelId(), datasetId);
            List customDimsCtrlKeys = rowCustomDims.getAllValOfOneProp("controlkey");
            if (!customDimsCtrlKeys.contains(dimKey)) continue;
            Object valOfOnePropByAnotherProp = rowCustomDims.getValOfOnePropByAnotherProp("name", "controlkey", (Object)dimKey);
            errorInfo.append(valOfOnePropByAnotherProp).append('\u3001');
        }
    }

    @Override
    public boolean billHeadOver() {
        DynamicObjectCollection budgetPeriods = (DynamicObjectCollection)this.getSource().getValue("budgetperiods");
        if (this.getSource().getValue("bizmodel") != null && this.getSource().getValue("datatype") != null && CollectionUtils.isNotEmpty((Collection)budgetPeriods) && this.getSource().getValue("version") != null && this.getSource().getValue("changetype") != null && this.getSource().getValue("currency") != null) {
            this.getSource().setResponseTheChanged(true);
            return true;
        }
        return false;
    }
}

