/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasBoxDataService {
    private static final String ENTITY_NAME = "eb_analysiscanvas_boxdata";
    private static final Log log = LogFactory.getLog(AnalysisCanvasBoxDataService.class);

    public static AnalysisCanvasBoxDataService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasBoxDataService() {
    }

    public Map<String, String> load(Long sandboxId) {
        List<AnalysisCanvasBoxData> dataList = this.querySandboxAllData(sandboxId);
        if (CollectionUtils.isEmpty(dataList)) {
            return new HashMap<String, String>(4);
        }
        return dataList.stream().collect(Collectors.toMap(AnalysisCanvasBoxData::getItemId, AnalysisCanvasBoxData::getData, (v1, v2) -> v1));
    }

    public List<AnalysisCanvasBoxData> querySandboxAllData(Long sandboxId) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,canvasid,sanboxid,itemid,data", (QFilter[])new QFilter[]{new QFilter("sanboxid", "=", (Object)sandboxId)});
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public List<AnalysisCanvasBoxData> queryOtherSandBoxItems(Long canvasId, Long sandBoxId, String itemId) {
        QFilter qf = new QFilter("sanboxid", "not in", (Object)sandBoxId);
        QFilter qf1 = new QFilter("itemid", "=", (Object)itemId);
        QFilter qf2 = new QFilter("canvasid", "=", (Object)canvasId);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,canvasid,sanboxid,itemid,data", (QFilter[])new QFilter[]{qf, qf1, qf2});
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public Map<String, AnalysisCanvasBoxData> querySandboxData(Long boxId, List<String> itemListId) {
        QFilter qf = new QFilter("sanboxid", "=", (Object)boxId);
        QFilter qf1 = new QFilter("itemid", "in", itemListId);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,canvasid,sanboxid,itemid,data", (QFilter[])new QFilter[]{qf, qf1});
        if (dataList.isEmpty()) {
            return new HashMap<String, AnalysisCanvasBoxData>(4);
        }
        return dataList.stream().collect(Collectors.toMap(data -> data.getString("itemid"), this::transToModel, (v1, v2) -> v1));
    }

    public Map<Long, List<Map<String, Object>>> getItemChangeMembers(List<Long> itemIds, List<Long> sandboxIds) {
        if (CollectionUtils.isEmpty(itemIds) || CollectionUtils.isEmpty(sandboxIds)) {
            return new HashMap<Long, List<Map<String, Object>>>(4);
        }
        QFilter qf = new QFilter("1", "=", (Object)0);
        itemIds.forEach(item -> sandboxIds.forEach(sandbox -> qf.or(new QFilter("sanboxid", "=", sandbox).and("itemid", "=", (Object)item.toString()))));
        HashMap<Long, List<Map<String, Object>>> itemChangeMembers = new HashMap<Long, List<Map<String, Object>>>(itemIds.size());
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"sanboxid,itemid,data", (QFilter[])qf.toArray());
        dataList.forEach(data -> {
            JSONObject jsonObject = JSONObject.parseObject((String)data.getString("data"));
            if (jsonObject == null) {
                return;
            }
            try {
                JSONArray jsonArray = jsonObject.getJSONArray("changeMembers");
                if (jsonArray != null) {
                    List changeMember = jsonArray.stream().map(e -> (Map)e).collect(Collectors.toList());
                    List changeMembers = itemChangeMembers.computeIfAbsent(data.getLong("itemid"), v -> new ArrayList(16));
                    changeMembers.addAll(changeMember);
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        });
        return itemChangeMembers;
    }

    public void save(List<AnalysisCanvasBoxData> models) {
        DynamicObject[] objects = (DynamicObject[])models.stream().map(this::packageDynamicObject).toArray(DynamicObject[]::new);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])objects);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteNotExistItem(List<CustomItem> itemList, Long canvasId) {
        Set itemIds = itemList.stream().map(CustomItem::getId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(itemIds)) {
            QFilter qFilter = new QFilter("itemid", "not in", itemIds);
            qFilter.and("canvasid", "=", (Object)canvasId);
            DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
        }
    }

    public void deleteItemData(String itemId, Long canvasId) {
        QFilter qFilter = new QFilter("itemid", "=", (Object)itemId);
        qFilter.and("canvasid", "=", (Object)canvasId);
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void clearOtherBoxItemData(Long canvasId, Long sandBoxId, String itemId) {
        List<AnalysisCanvasBoxData> otherSandBoxItems = this.queryOtherSandBoxItems(canvasId, sandBoxId, itemId);
        if (CollectionUtils.isEmpty(otherSandBoxItems)) {
            return;
        }
        otherSandBoxItems.forEach(boxData -> boxData.setData(null));
        this.save(otherSandBoxItems);
    }

    public void deleteByBox(List<Long> boxIds) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("sanboxid", "in", boxIds)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteByBoxIdAndItemIds(Long boxId, List<String> itemIds, List<AnalysisCanvasBoxData> saveItemDataList) {
        List ids = saveItemDataList.stream().map(AnalysisCanvasBoxData::getId).collect(Collectors.toList());
        try (TXHandle tx = TX.required();){
            try {
                QFilter qf = new QFilter("sanboxid", "=", (Object)boxId);
                QFilter qf1 = new QFilter("itemid", "in", itemIds);
                QFilter qf2 = new QFilter("id", "not in", ids);
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qf, qf1, qf2});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public AnalysisCanvasBoxData buildModel(Long canvasId, Long sandboxId, String itemId, String data) {
        AnalysisCanvasBoxData model = new AnalysisCanvasBoxData();
        model.setCanvasId(canvasId);
        model.setSanboxId(sandboxId);
        model.setItemId(itemId);
        model.setData(data);
        return model;
    }

    public AnalysisCanvasBoxData transToModel(DynamicObject dynamicObject) {
        AnalysisCanvasBoxData model = new AnalysisCanvasBoxData();
        model.setId(dynamicObject.getLong("id"));
        model.setCanvasId(dynamicObject.getLong("canvasid"));
        model.setSanboxId(dynamicObject.getLong("sanboxid"));
        model.setItemId(dynamicObject.getString("itemid"));
        model.setData(dynamicObject.getString("data"));
        return model;
    }

    private DynamicObject packageDynamicObject(AnalysisCanvasBoxData model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("canvasid", (Object)model.getCanvasId());
        dynamicObject.set("sanboxid", (Object)model.getSanboxId());
        dynamicObject.set("itemid", (Object)model.getItemId());
        dynamicObject.set("data", (Object)model.getData());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final AnalysisCanvasBoxDataService instance = new AnalysisCanvasBoxDataService();

        private InnerClass() {
        }
    }
}

