/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCommentService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.forecast.PredictRecordService;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasBoxService {
    private static final Log log = LogFactory.getLog(AnalysisCanvasBoxService.class);
    private static final String ENTITY_NAME = "eb_analysiscanvas_box";

    public static AnalysisCanvasBoxService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasBoxService() {
    }

    public String loadCacheName(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return dynamicObject == null ? "" : dynamicObject.getString("name");
    }

    public AnalysisCanvasBox load(Long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id,canvasid,name,status,type,bseq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6c99\u76d8\u4e0d\u5b58\u5728\u3002\u8bf7\u5173\u95ed\u753b\u5e03\uff0c\u91cd\u65b0\u6253\u5f00\u3002", (String)"AnalysisCanvasService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return this.transToModel(dynamicObject);
    }

    public List<AnalysisCanvasBox> load(List<Long> ids) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,canvasid,name,status,type,bseq", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).sorted(Comparator.comparingInt(o -> ids.indexOf(o.getId()))).collect(Collectors.toList());
    }

    public AnalysisCanvasBox loadBaseBox(Long canvasId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id,canvasid,name,status,type,bseq", (QFilter[])new QFilter[]{new QFilter("canvasid", "=", (Object)canvasId).and("type", "=", (Object)AnalysisCanvasConstants.BoxType.BASE.getValue())});
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6c99\u76d8\u4e0d\u5b58\u5728\u3002\u8bf7\u5173\u95ed\u753b\u5e03\uff0c\u91cd\u65b0\u6253\u5f00\u3002", (String)"AnalysisCanvasService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return this.transToModel(dynamicObject);
    }

    public AnalysisCanvasBox loadActivated(Long canvasId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id,canvasid,name,status,type,bseq", (QFilter[])new QFilter[]{new QFilter("canvasid", "=", (Object)canvasId).and("status", "=", (Object)AnalysisCanvasConstants.BoxStatus.ACTIVATED.getValue())});
        if (dynamicObject == null) {
            AnalysisCanvasBox baseBox = this.loadBaseBox(canvasId);
            this.updateActivatedBox(baseBox.getId(), canvasId);
            return baseBox;
        }
        return this.transToModel(dynamicObject);
    }

    public List<AnalysisCanvasBox> loadByCanvas(Long canvasId) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,canvasid,name,status,type,bseq", (QFilter[])new QFilter[]{new QFilter("canvasid", "=", (Object)canvasId)}, (String)"bseq");
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public List<Object> loadCompareCanvas(Long canvasId) {
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        return QueryServiceHelper.queryPrimaryKeys((String)ENTITY_NAME, (QFilter[])qFilter.toArray(), (String)"bseq", (int)2);
    }

    public List<Object> loadLatestBox(Long canvasId, int size) {
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        return QueryServiceHelper.queryPrimaryKeys((String)ENTITY_NAME, (QFilter[])qFilter.toArray(), (String)"id desc", (int)size);
    }

    public int getSeq(long canvasId) {
        List<AnalysisCanvasBox> boxList = this.loadByCanvas(canvasId);
        if (CollectionUtils.isNotEmpty(boxList)) {
            return boxList.get(boxList.size() - 1).getSeq() + 1;
        }
        return 1;
    }

    public List<Long> loadBoxIdByCanvas(Long canvasId) {
        return this.loadByCanvas(canvasId).stream().map(AnalysisCanvasBox::getId).collect(Collectors.toList());
    }

    public void copySandbox(Long oldCanvasId, Long newCanvasId) {
        List<AnalysisCanvasBox> oldAnalysisCanvasBoxList = this.loadByCanvas(oldCanvasId);
        List<AnalysisCanvasBox> newAnalysisCanvasBoxList = this.getNewAnalysisCanvasBoxList(oldAnalysisCanvasBoxList, newCanvasId);
        this.copyDataSave(newAnalysisCanvasBoxList);
    }

    public List<AnalysisCanvasBox> getNewAnalysisCanvasBoxList(List<AnalysisCanvasBox> oldAnalysisCanvasBoxList, Long newCanvasId) {
        int size = oldAnalysisCanvasBoxList.size();
        ArrayList<AnalysisCanvasBox> newAnalysisCanvasBoxList = new ArrayList<AnalysisCanvasBox>(size);
        ArrayList<Long> ids = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            ids.add(GlobalIdUtil.genGlobalLongId());
        }
        Collections.sort(ids);
        AtomicInteger num = new AtomicInteger(0);
        oldAnalysisCanvasBoxList.forEach(oldAnalysisCanvasBox -> {
            AnalysisCanvasBox newAnalysisCanvasBox = new AnalysisCanvasBox();
            try {
                BeanUtils.copyProperties((Object)newAnalysisCanvasBox, (Object)oldAnalysisCanvasBox);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            newAnalysisCanvasBox.setCanvasId(newCanvasId);
            newAnalysisCanvasBox.setId((Long)ids.get(num.getAndIncrement()));
            newAnalysisCanvasBoxList.add(newAnalysisCanvasBox);
        });
        return newAnalysisCanvasBoxList;
    }

    public Object[] save(List<AnalysisCanvasBox> models) {
        DynamicObject[] objects = (DynamicObject[])models.stream().map(this::packageDynamicObject).toArray(DynamicObject[]::new);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            Object[] objectArray = SaveServiceHelper.save((DynamicObject[])objects);
            return objectArray;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void copyDataSave(List<AnalysisCanvasBox> models) {
        DynamicObject[] objects = (DynamicObject[])models.stream().map(this::copyPackageDynamicObject).toArray(DynamicObject[]::new);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])objects);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void updateActivatedBox(Long boxId, Long canvasId) {
        try (TXHandle tx = TX.required();){
            try {
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update T_EB_ANALYSISCANVAS_BOX set fstatus = ? where fcanvasid = ?", (Object[])new Object[]{AnalysisCanvasConstants.BoxStatus.UNACTIVATED.getValue(), canvasId});
                DB.update((DBRoute)BgBaseConstant.epm, (String)"update T_EB_ANALYSISCANVAS_BOX set fstatus = ? where fid = ?", (Object[])new Object[]{AnalysisCanvasConstants.BoxStatus.ACTIVATED.getValue(), boxId});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                AnalysisCubeService.getInstance().delSandbox(ids);
                AnalysisCanvasBoxDataService.getInstance().deleteByBox(ids);
                AnalysisCanvasCommentService.getInstance().deleteByBox(ids);
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteByCanvasId(Long canvasId) {
        List<Long> boxIds = this.loadBoxIdByCanvas(canvasId);
        this.delete(boxIds);
        PredictRecordService.getInstance().deleteCanvasRecord(canvasId, boxIds);
    }

    public AnalysisCanvasBox transToModel(DynamicObject dynamicObject) {
        AnalysisCanvasBox model = new AnalysisCanvasBox();
        model.setId(dynamicObject.getLong("id"));
        model.setCanvasId(dynamicObject.getLong("canvasid"));
        model.setType(dynamicObject.getString("type"));
        model.setName(dynamicObject.getString("name"));
        model.setSeq(dynamicObject.getInt("bseq"));
        model.setStatus(dynamicObject.getString("status"));
        return model;
    }

    private DynamicObject packageDynamicObject(AnalysisCanvasBox model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("canvasid", (Object)model.getCanvasId());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("type", (Object)model.getType());
        dynamicObject.set("bseq", (Object)model.getSeq());
        dynamicObject.set("status", (Object)model.getStatus());
        return dynamicObject;
    }

    private DynamicObject copyPackageDynamicObject(AnalysisCanvasBox model) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("id", (Object)model.getId());
        dynamicObject.set("canvasid", (Object)model.getCanvasId());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("type", (Object)model.getType());
        dynamicObject.set("bseq", (Object)model.getSeq());
        dynamicObject.set("status", (Object)model.getStatus());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final AnalysisCanvasBoxService instance = new AnalysisCanvasBoxService();

        private InnerClass() {
        }
    }
}

