/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCollectService;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasCateService {
    private static final String ENTITY_NAME = "eb_analysiscanvas_cate";
    private static final String DEFAULT = "default";

    public static AnalysisCanvasCateService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasCateService() {
    }

    public DynamicObject load(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
    }

    public boolean isDefault(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject number = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"number", (QFilter[])new QFilter[]{filter});
        return DEFAULT.equals(number.getString("number"));
    }

    public DynamicObjectCollection query() {
        QFilter creator = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, parent, name", (QFilter[])new QFilter[]{creator});
    }

    public Long queryParentCate(Long nodeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)nodeId);
        DynamicObject parent = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"parent", (QFilter[])new QFilter[]{qFilter});
        return parent == null ? null : Long.valueOf(parent.getLong("parent"));
    }

    public void addRootNode(List<DynamicObject> data) {
        LocaleString rootName = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b", (String)"AnalysisCanvasCateService_0", (String)"epm-eb-business");
        LocaleString defaultName = ResManager.getLocaleString((String)"\u9ed8\u8ba4\u5206\u7c7b", (String)"AnalysisCanvasCateService_1", (String)"epm-eb-business");
        DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        long rootId = GlobalIdUtil.genGlobalLongId();
        rootDy.set("id", (Object)rootId);
        rootDy.set("parent", (Object)0);
        rootDy.set("sequence", (Object)0);
        rootDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        rootDy.set("createdate", (Object)TimeServiceHelper.now());
        rootDy.set("number", (Object)"root");
        rootDy.set("name", (Object)rootName);
        DynamicObject defaultDy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        defaultDy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        defaultDy.set("parent", (Object)rootId);
        defaultDy.set("sequence", (Object)0);
        defaultDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        defaultDy.set("createdate", (Object)TimeServiceHelper.now());
        defaultDy.set("number", (Object)DEFAULT);
        defaultDy.set("name", (Object)defaultName);
        DynamicObject[] rootDys = new DynamicObject[]{rootDy, defaultDy};
        SaveServiceHelper.save((DynamicObject[])rootDys);
        data.add(rootDy);
        data.add(defaultDy);
    }

    public TreeNode getCateTree() {
        List<TreeNode> nodes;
        Optional<TreeNode> keyRoot;
        TreeNode rootNode = new TreeNode();
        DynamicObjectCollection query = this.query();
        ArrayList<DynamicObject> data = new ArrayList<DynamicObject>((Collection<DynamicObject>)query);
        if (CollectionUtils.isEmpty(data)) {
            this.addRootNode(data);
        }
        if ((keyRoot = (nodes = data.stream().map(e -> {
            TreeNode node = new TreeNode();
            node.setId(e.getString("id"));
            node.setParentid(e.getString("parent"));
            node.setText(e.getString("name"));
            node.setIsOpened(true);
            return node;
        }).collect(Collectors.toList())).stream().filter(e -> "0".equals(e.getParentid())).findFirst()).isPresent()) {
            rootNode = keyRoot.get();
            rootNode.setParentid("");
        }
        return this.covert(rootNode, nodes);
    }

    private TreeNode covert(TreeNode node, List<TreeNode> nodes) {
        List children = nodes.stream().filter(e -> e.getParentid().equals(node.getId())).map(e -> this.covert((TreeNode)e, nodes)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(children)) {
            node.setChildren(children);
        }
        return node;
    }

    public int getCurNodeSequence(Long parentId) {
        QFilter creator = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter parent = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{creator, parent};
        int result = 0;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)ENTITY_NAME, (String)"sequence", (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            result = dcs.stream().map(seqDy -> seqDy.getInt("sequence")).max((a, b) -> a > b ? 1 : -1).get();
            ++result;
        } else {
            result = 1;
        }
        return result;
    }

    public boolean checkNumberExisted(Long id, String number) {
        QFBuilder qb = new QFBuilder();
        qb.add("creator", "=", (Object)RequestContext.get().getCurrUserId());
        qb.add("number", "=", (Object)number);
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            qb.add(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qb.toArrays());
    }

    public boolean checkNameExisted(Long id, String name) {
        QFBuilder qb = new QFBuilder();
        qb.add("creator", "=", (Object)RequestContext.get().getCurrUserId());
        qb.add("name", "=", (Object)name);
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            qb.add(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qb.toArrays());
    }

    public void delete(Long nodeId, List<Long> childIds) {
        List<Long> canvasIds = AnalysisCanvasCollectService.getInstance().queryCanvasIdByCate(childIds);
        Long parentCateId = this.queryParentCate(nodeId);
        if (IDUtils.isEmptyLong((Long)parentCateId).booleanValue()) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_NAME), (Object[])childIds.toArray());
                AnalysisCanvasCollectService.getInstance().save(parentCateId, new ArrayList<Long>(new HashSet<Long>(canvasIds)), childIds);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static class InnerClass {
        private static final AnalysisCanvasCateService instance = new AnalysisCanvasCateService();

        private InnerClass() {
        }
    }
}

