/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasShareService;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasCollectService {
    private static final String ENTITY_NAME = "eb_analysiscanvas_collect";

    public static AnalysisCanvasCollectService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasCollectService() {
    }

    public List<Long> queryCanvasIdByCate(List<Long> cateIds) {
        QFilter filter = new QFilter("cate", "in", cateIds);
        filter.and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection id = QueryServiceHelper.query((String)ENTITY_NAME, (String)"canvas", (QFilter[])new QFilter[]{filter});
        return id.stream().map(e -> e.getLong("canvas")).collect(Collectors.toList());
    }

    public DynamicObject load(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
    }

    public DynamicObjectCollection query() {
        QFilter creator = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, parent, name", (QFilter[])new QFilter[]{creator});
    }

    public void save(Long cateId, List<Long> canvasIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject[] dynamicObjects = (DynamicObject[])canvasIds.stream().map(id -> {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            data.set("canvas", id);
            data.set("cate", (Object)cateId);
            data.set("creator", (Object)currUserId);
            data.set("createdate", (Object)now);
            return data;
        }).toArray(DynamicObject[]::new);
        QFilter qFilter = new QFilter("canvas", "in", canvasIds);
        qFilter.and(new QFilter("creator", "=", (Object)currUserId));
        qFilter.and(new QFilter("cate", "=", (Object)cateId));
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void save(Long cateId, List<Long> canvasIds, List<Long> cateIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject[] dynamicObjects = (DynamicObject[])canvasIds.stream().map(id -> {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            data.set("canvas", id);
            data.set("cate", (Object)cateId);
            data.set("creator", (Object)currUserId);
            data.set("createdate", (Object)now);
            return data;
        }).toArray(DynamicObject[]::new);
        QFilter qFilter = new QFilter("canvas", "in", canvasIds);
        qFilter.and(new QFilter("creator", "=", (Object)currUserId));
        qFilter.and(new QFilter("cate", "=", (Object)cateId));
        qFilter.or(new QFilter("cate", "in", cateIds));
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void delete(List<Long> childrenIds, List<Long> canvasIds) {
        if (CollectionUtils.isEmpty(childrenIds) || CollectionUtils.isEmpty(canvasIds)) {
            return;
        }
        QFilter qFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter qFilter1 = null;
        for (Long cateId : childrenIds) {
            for (Long canvasId : canvasIds) {
                if (qFilter1 == null) {
                    qFilter1 = new QFilter("canvas", "=", (Object)canvasId).and(new QFilter("cate", "=", (Object)cateId));
                    continue;
                }
                qFilter1.or(new QFilter("canvas", "=", (Object)canvasId).and(new QFilter("cate", "=", (Object)cateId)));
            }
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter.and(qFilter1)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteByCanvasIds(List<Long> canvasIds) {
        QFilter qFilter = new QFilter("canvas", "in", canvasIds);
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public void deleteByFilter(QFilter qFilter) {
        if (qFilter == null) {
            return;
        }
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public void deleteByCanvas(Long canvasId) {
        DynamicObject share = AnalysisCanvasService.getInstance().queryCanvasShare(canvasId);
        if (share != null && AnalysisCanvasConstants.ShareType.SELF.getValue().equals(share.getString("share"))) {
            List<Long> creatorIds = AnalysisCanvasShareService.getInstance().deleteCollectQFilter(canvasId, share.getLong("creater"));
            if (CollectionUtils.isEmpty(creatorIds)) {
                return;
            }
            QFilter qFilter = new QFilter("canvas", "=", (Object)canvasId).and("creator", "not in", creatorIds);
            try (TXHandle tx = TX.required();){
                try {
                    this.deleteByFilter(qFilter);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    private static class InnerClass {
        private static final AnalysisCanvasCollectService instance = new AnalysisCanvasCollectService();

        private InnerClass() {
        }
    }
}

