/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasComment;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasCommentService {
    private static final String ENTITY_NAME = "eb_analysiscanvas_comment";

    public static AnalysisCanvasCommentService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasCommentService() {
    }

    public AnalysisCanvasComment load(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u3002", (String)"AnalysisCanvasService_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return this.transToModel(dynamicObject);
    }

    public void save(Long canvasId, Long sandboxId, String comment, Long itemId) {
        DynamicObject dynamicObject = this.packageDynamicObject(canvasId, sandboxId, comment, itemId);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void delete(Long id) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteByBox(List<Long> boxIds) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("sandboxid", "in", boxIds)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteNotExistItem(List<CustomItem> itemList, Long canvasId) {
        Set itemIds = itemList.stream().map(item -> IDUtils.toLong((Object)item.getId())).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(itemIds)) {
            QFilter qFilter = new QFilter("itemid", "not in", itemIds);
            qFilter.and("canvasid", "=", (Object)canvasId);
            DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
        }
    }

    public AnalysisCanvasComment transToModel(DynamicObject dynamicObject) {
        Long creatorId = dynamicObject.getDynamicObject("createrid").getLong("id");
        boolean delFlag = creatorId.equals(RequestContext.get().getCurrUserId());
        String createDate = DateTimeUtils.format((Date)dynamicObject.getDate("createdate"));
        AnalysisCanvasComment model = new AnalysisCanvasComment();
        model.setId(dynamicObject.getString("id"));
        model.setCanvasId(dynamicObject.getDynamicObject("canvasid").getString("id"));
        model.setSandboxId(dynamicObject.getDynamicObject("sandboxid").getString("id"));
        model.setComment(dynamicObject.getString("comment"));
        model.setCreatorId(String.valueOf(creatorId));
        model.setCreator(dynamicObject.getDynamicObject("createrid").getString("name"));
        model.setCreateDate(createDate);
        model.setDelFlag(delFlag);
        model.setItemId(dynamicObject.getString("itemid"));
        return model;
    }

    private DynamicObject packageDynamicObject(Long canvasId, Long sandboxId, String comment, Long itemId) {
        Long id = GlobalIdUtil.genGlobalLongId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("canvasid", (Object)canvasId);
        dynamicObject.set("sandboxid", (Object)sandboxId);
        dynamicObject.set("comment", (Object)comment);
        dynamicObject.set("createrid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createdate", (Object)new Date());
        dynamicObject.set("itemid", (Object)itemId);
        return dynamicObject;
    }

    private static class InnerClass {
        private static final AnalysisCanvasCommentService instance = new AnalysisCanvasCommentService();

        private InnerClass() {
        }
    }
}

