/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.item.ItemHelper;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.ChartAxisModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.ChartSerialModel;
import kd.epm.eb.business.analysiscanvas.model.CompareData;
import kd.epm.eb.business.analysiscanvas.model.CompareHead;
import kd.epm.eb.business.analysiscanvas.model.CompareTable;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DataModel;
import kd.epm.eb.business.analysiscanvas.model.DimensionDto;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.MapModel;
import kd.epm.eb.business.analysiscanvas.model.MapValue;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.business.analysiscanvas.model.VarRange;
import kd.epm.eb.business.analysiscanvas.query.AnalysisPools;
import kd.epm.eb.business.analysiscanvas.query.QueryService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDtoHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class AnalysisCanvasCompareService {
    private static final Log log = LogFactory.getLog(AnalysisCanvasCompareService.class);
    private static final int MAX_NUMBER_COUNT = 50;
    private static final String ENTITY_NAME = "eb_analysiscanvas_cmp";
    private static final String VALUE_SUFFIX = "_V";
    private static final String REPORT_SUFFIX = "_R";
    private static final String DATA_SUFFIX = "_D";
    private static final String VALUE_KEY = "NAME_V";
    private static final String REPORT_KEY = "NAME_R";
    private static final String DATA_KEY = "NAME_D";

    public static AnalysisCanvasCompareService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasCompareService() {
    }

    public DynamicObject query(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
    }

    public boolean checkName(Long id, Long canvasId, String name) {
        QFilter qFilter = new QFilter("id", "!=", (Object)id).and("canvas", "=", (Object)canvasId).and("name", "=", (Object)name);
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
    }

    public Long copy(Long compareId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)compareId, (String)ENTITY_NAME);
        String name = dynamicObject.getString("name");
        HashSet<String> nameSet = new HashSet<String>(16);
        String filterName = name.length() > 44 ? name.substring(0, 44) : name;
        QFilter qfilter = new QFilter("name", "ftlike", (Object)filterName);
        try (DataSet allData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_NAME, (String)"name", (QFilter[])new QFilter[]{qfilter}, null);){
            while (allData.hasNext()) {
                Row row = allData.next();
                nameSet.add(row.getString("name"));
            }
        }
        String copyName = this.getCopyName(name, nameSet);
        String copyNumber = "Analysis_" + System.currentTimeMillis();
        Long newId = GlobalIdUtil.genGlobalLongId();
        DynamicObject copy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        copy.set("id", (Object)newId);
        copy.set("canvas", (Object)dynamicObject.getLong("canvas_id"));
        copy.set("model", (Object)dynamicObject.getLong("model_id"));
        copy.set("dataset", (Object)dynamicObject.getLong("dataset_id"));
        copy.set("name", (Object)copyName);
        copy.set("number", (Object)copyNumber);
        copy.set("desc", (Object)dynamicObject.getString("desc"));
        DynamicObjectCollection data = dynamicObject.getDynamicObjectCollection("entryentity");
        String entitySql = "insert into t_eb_analysiscanvas_cmp_d (fid, fentryid, fseq, fdata) VALUES(?,?,?,?)";
        List<Object[]> entityObject = this.packageObjects(data, newId);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copy});
                if (CollectionUtils.isNotEmpty(entityObject)) {
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)entitySql, entityObject);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        return newId;
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteByCanvasIds(List<Long> canvasIds) {
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("canvas", "in", canvasIds)});
    }

    private String getCopyName(String name, Set<String> nameSet) {
        String copyName = "";
        for (int i = 0; i < nameSet.size(); ++i) {
            StringBuilder appendName = new StringBuilder("copy");
            StringBuilder preName = new StringBuilder(name);
            if (i > 0) {
                appendName.append(i);
            }
            String string = copyName = name.length() + appendName.length() > 50 ? preName.substring(0, 50 - appendName.length()) + appendName : preName.append((CharSequence)appendName).toString();
            if (nameSet.contains(copyName)) continue;
            return copyName;
        }
        return copyName;
    }

    private List<Object[]> packageObjects(DynamicObjectCollection data, Long newId) {
        ArrayList<Object[]> objs = new ArrayList<Object[]>(data.size());
        long[] id = GlobalIdUtil.genGlobalLongIds((int)data.size());
        for (int i = 0; i < data.size(); ++i) {
            Object[] obj = new Object[]{newId, id[i], ((DynamicObject)data.get(i)).getLong("seq"), ((DynamicObject)data.get(i)).get("data")};
            objs.add(obj);
        }
        return objs;
    }

    public CompareTable getCompareDataByAll(Long compareId, Long canvasId, List<Long> sandboxIds, IFormView view) {
        DynamicObject compare = AnalysisCanvasCompareService.getInstance().query(compareId);
        DynamicObjectCollection entryEntity = compare.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return null;
        }
        DataModel dataModel = (DataModel)JSONObject.parseObject((String)((DynamicObject)entryEntity.get(0)).getString("data"), DataModel.class);
        AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(compare.getLong("canvas.id"));
        List allItems = StringUtils.isEmpty((String)canvas.getItem()) ? Collections.emptyList() : JSON.parseArray((String)canvas.getItem(), CustomItem.class);
        List<CustomItem> sliderItemList = ModelHelper.getItems("slider", allItems);
        List<CustomItem> dupontItemList = ModelHelper.getItems("dupontnode", allItems);
        List<CustomItem> reportItemList = ModelHelper.getItems("report", allItems);
        List<CustomItem> table2ItemList = ModelHelper.getItems("table2", allItems);
        List<CustomItem> filterItemList = ModelHelper.getItems("select", allItems);
        ArrayList calcItemList = Lists.newArrayList();
        calcItemList.addAll(sliderItemList);
        calcItemList.addAll(dupontItemList);
        calcItemList.addAll(reportItemList);
        calcItemList.addAll(table2ItemList);
        AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().loadActivated(canvasId);
        AnalysisService.getInstance().getItemDataFromBox(filterItemList, canvasBox, view);
        CompareTable compareData = this.getCompareData(null, filterItemList, calcItemList, dataModel, sandboxIds, view);
        String title = ResManager.loadResFormat((String)"%1-%2\u5bfc\u51fa", (String)"AnalysisCanvasCompareService_3", (String)"epm-eb-business", (Object[])new Object[]{canvas.getName(), compare.getString("name")});
        compareData.setTitle(title);
        return compareData;
    }

    public CompareTable getCompareDataByItem(CustomItem customItem, List<CustomItem> allItems, List<Long> sandboxIds, IFormView view) {
        List<CustomItem> filterItemList = ModelHelper.getItems("select", allItems);
        List<CustomItem> sliderItemList = ModelHelper.getItems("slider", allItems);
        List<CustomItem> dupontItemList = ModelHelper.getItems("dupontnode", allItems);
        List<CustomItem> reportItemList = ModelHelper.getItems("report", allItems);
        List<CustomItem> table2ItemList = ModelHelper.getItems("table2", allItems);
        ArrayList calcItemList = Lists.newArrayList();
        calcItemList.addAll(sliderItemList);
        calcItemList.addAll(dupontItemList);
        calcItemList.addAll(reportItemList);
        calcItemList.addAll(table2ItemList);
        return this.getCompareData(customItem, filterItemList, calcItemList, null, sandboxIds, view);
    }

    public CompareTable getCompareData(CustomItem customItem, List<CustomItem> filterItemList, List<CustomItem> calcItemList, DataModel dataModel, List<Long> sandboxIds, IFormView view) {
        List<Long> itemIds = calcItemList.stream().map(p -> IDUtils.toLong((Object)p.getId())).collect(Collectors.toList());
        Map<Long, List<Map<String, Object>>> itemChangeMembers = AnalysisCanvasBoxDataService.getInstance().getItemChangeMembers(itemIds, sandboxIds);
        ArrayList<QueryDto> queryList = new ArrayList<QueryDto>(16);
        this.buildItemQueryDim(calcItemList, itemChangeMembers, queryList);
        if (dataModel != null) {
            this.buildDataQueryDim(dataModel, queryList);
        }
        String traceId = RequestContext.get().getTraceId();
        JSONObject calcParam = new JSONObject();
        calcParam.put("traceId", (Object)traceId);
        List<AnalysisCanvasBox> canvasBoxList = AnalysisCanvasBoxService.getInstance().load(sandboxIds);
        ArrayList<Future> futureList = new ArrayList<Future>(canvasBoxList.size());
        for (AnalysisCanvasBox analysisCanvasBox : canvasBoxList) {
            Future future = AnalysisPools.COMPARE_POOL.submit(() -> {
                List<QueryDto> copyQueryList;
                AnalysisCanvasConstants.CalcType calcType = ModelHelper.isBaseBox(analysisCanvasBox) ? AnalysisCanvasConstants.CalcType.BASE : AnalysisCanvasConstants.CalcType.SAND;
                BoxCalcModel calcModel = new BoxCalcModel();
                if (customItem != null) {
                    CustomItem compareItem = (CustomItem)JSON.parseObject((String)JSON.toJSONString((Object)customItem), CustomItem.class);
                    List<CustomItem> itemList = Collections.singletonList(compareItem);
                    ItemHelper.getInstance().buildQueryDim(analysisCanvasBox, itemList, filterItemList, queryList, AnalysisCanvasConstants.OptType.CALC, calcParam, view);
                    copyQueryList = queryList.stream().map(QueryDto::clone).collect(Collectors.toList());
                    QueryService.getInstance().calc(analysisCanvasBox, calcType, AnalysisCanvasConstants.OptType.CALC, copyQueryList, calcParam);
                    ItemHelper.getInstance().processQueryResult(analysisCanvasBox, itemList, filterItemList, copyQueryList, AnalysisCanvasConstants.OptType.CALC, calcParam, view);
                    calcModel.item = compareItem;
                } else {
                    copyQueryList = queryList.stream().map(QueryDto::clone).collect(Collectors.toList());
                    QueryService.getInstance().calc(analysisCanvasBox, calcType, AnalysisCanvasConstants.OptType.CALC, copyQueryList, calcParam);
                }
                calcModel.sandbox = "sandbox" + analysisCanvasBox.getSeq();
                calcModel.name = analysisCanvasBox.getName();
                calcModel.CalcType = calcType;
                calcModel.queryList = copyQueryList;
                return calcModel;
            }, RequestContext.getOrCreate());
            futureList.add(future);
        }
        ArrayList<BoxCalcModel> boxCustomModels = new ArrayList<BoxCalcModel>(futureList.size());
        for (Future future : futureList) {
            try {
                BoxCalcModel customModel = (BoxCalcModel)future.get(60L, TimeUnit.SECONDS);
                boxCustomModels.add(customModel);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                throw new AnalysisCanvasException(e2, new ErrorCode("AnalysisService", e2.getMessage()), e2.getMessage());
            }
        }
        CompareTable compareTable = new CompareTable();
        Optional<BoxCalcModel> base = boxCustomModels.stream().filter(e -> e.CalcType == AnalysisCanvasConstants.CalcType.BASE).findFirst();
        BoxCalcModel baseModel = base.orElseGet(() -> (BoxCalcModel)boxCustomModels.get(0));
        this.buildTableHead(compareTable, boxCustomModels);
        this.buildValueDataDaTa(compareTable, calcItemList, itemChangeMembers, boxCustomModels, baseModel, filterItemList);
        this.buildReportDataDaTa(compareTable, calcItemList, itemChangeMembers, boxCustomModels, baseModel, filterItemList);
        if (dataModel != null) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)dataModel.getModel());
            JSONObject dimensionViews = dataModel.getDimensionViews();
            List<Member> rowMemberList = this.getMemberList(modelCache, dataModel.getRowFields().get(0), dimensionViews);
            List<Member> colMemberList = this.getMemberList(modelCache, dataModel.getColFields().get(0), dimensionViews);
            this.buildTableHead(compareTable, boxCustomModels, colMemberList);
            this.buildTableDataDaTa(compareTable, boxCustomModels, baseModel, dataModel, modelCache, rowMemberList, colMemberList);
        } else {
            this.buildTableDataDaTa(compareTable, boxCustomModels, baseModel);
        }
        return compareTable;
    }

    private void buildItemQueryDim(List<CustomItem> calcItemList, Map<Long, List<Map<String, Object>>> itemChangeMembers, List<QueryDto> queryList) {
        calcItemList.forEach(item -> {
            List changeMember = (List)itemChangeMembers.get(IDUtils.toLong((Object)item.getId()));
            if (CollectionUtils.isEmpty((Collection)changeMember)) {
                return;
            }
            BaseModel baseModel = ModelHelper.getModel(item);
            if (baseModel == null) {
                return;
            }
            Long modelId = IDUtils.toLong((Object)baseModel.getModel());
            Long datasetId = IDUtils.toLong((Object)baseModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            JSONObject dimensionViews = baseModel.getDimensionViews();
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
            List dimensionList = modelCache.getDimensionList(datasetId);
            dimensionList.forEach(d -> {
                String number = d.getNumber();
                Set memberSet = changeMember.stream().map(p -> p.get(number)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
                Set querySet = queryDim.computeIfAbsent(number, k -> new HashSet(memberSet.size()));
                querySet.addAll(CollectionUtils.isNotEmpty(memberSet) ? memberSet : Collections.singleton(d.getNoneNumber()));
            });
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, queryList);
            QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
        });
    }

    private void buildDataQueryDim(DataModel dataModel, List<QueryDto> queryList) {
        Long modelId = dataModel.getModel();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        JSONObject dimensionViews = dataModel.getDimensionViews();
        Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
        HashMap<String, Set<String>> queryDim = new HashMap<String, Set<String>>(20);
        this.processQueryDim(modelCache, dimensionViews, dataModel.getHideFields(), queryDim);
        this.processQueryDim(modelCache, dimensionViews, dataModel.getRowFields(), queryDim);
        this.processQueryDim(modelCache, dimensionViews, dataModel.getColFields(), queryDim);
        QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, dataModel.getDataset(), viewMap, queryList);
        QueryDtoHelper.mergeQueryDim(queryDto, queryDim);
    }

    private void processQueryDim(IModelCacheHelper modelCache, JSONObject dimensionViews, List<DimensionDto> fields, Map<String, Set<String>> queryDim) {
        fields.forEach(dto -> {
            String dimNumber = dto.getDim();
            Long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
            dto.getMembers().forEach(member -> {
                List memberList = modelCache.getMember(dimNumber, viewId, member.getNum(), member.getScope().intValue());
                Set memberSet = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                Set querySet = queryDim.computeIfAbsent(dimNumber, k -> new HashSet(memberSet.size()));
                querySet.addAll(memberSet);
            });
        });
    }

    private List<Member> getMemberList(IModelCacheHelper modelCache, DimensionDto dimensionDto, JSONObject dimensionViews) {
        Long viewId = ModelHelper.getViewId(dimensionDto.getDim(), dimensionViews);
        ArrayList<Member> memberList = new ArrayList<Member>(16);
        dimensionDto.getMembers().forEach(memberModel -> {
            List members = modelCache.getMember(dimensionDto.getDim(), viewId, memberModel.getNum(), memberModel.getScope().intValue());
            memberList.addAll(members);
        });
        return memberList;
    }

    private void buildTableHead(CompareTable table, List<BoxCalcModel> boxCalcModels) {
        ArrayList<CompareHead> valueHeadList = new ArrayList<CompareHead>(boxCalcModels.size() + 1);
        CompareHead head = new CompareHead();
        head.setFieldKey(VALUE_KEY);
        head.setName(ResManager.loadKDString((String)"\u53d8\u91cf\u540d\u79f0", (String)"AnalysisCanvasCompareService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        valueHeadList.add(head);
        ArrayList<CompareHead> reportHeadList = new ArrayList<CompareHead>(boxCalcModels.size() + 1);
        CompareHead reportHead = new CompareHead();
        reportHead.setFieldKey(REPORT_KEY);
        reportHead.setName(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408", (String)"AnalysisCanvasCompareService_2", (String)"epm-eb-business", (Object[])new Object[0]));
        reportHeadList.add(reportHead);
        boxCalcModels.forEach(e -> {
            CompareHead value = new CompareHead();
            value.setFieldKey(e.sandbox + VALUE_SUFFIX);
            value.setName(e.name);
            valueHeadList.add(value);
            CompareHead report = new CompareHead();
            report.setFieldKey(e.sandbox + REPORT_SUFFIX);
            report.setName(e.name);
            reportHeadList.add(report);
        });
        table.setValueHead(valueHeadList);
        table.setReportHead(reportHeadList);
    }

    private void buildTableHead(CompareTable table, List<BoxCalcModel> boxCalcModels, List<Member> colMemberList) {
        ArrayList<CompareHead> dataHeadList = new ArrayList<CompareHead>(16);
        CompareHead dataKey = new CompareHead();
        dataKey.setFieldKey(DATA_KEY);
        dataKey.setName(ResManager.loadKDString((String)"\u6bd4\u8f83\u8303\u56f4", (String)"AnalysisCanvasCompareService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        dataHeadList.add(dataKey);
        boxCalcModels.forEach(e -> {
            CompareHead data = new CompareHead();
            data.setFieldKey(e.sandbox + DATA_SUFFIX);
            data.setName(e.name);
            dataHeadList.add(data);
            List<CompareHead> headChild = colMemberList.stream().map(member -> {
                CompareHead c = new CompareHead();
                c.setFieldKey(e.sandbox + member.getNumber().replaceAll("\\.", ""));
                c.setName(member.getName());
                return c;
            }).collect(Collectors.toList());
            data.setChild(headChild);
        });
        table.setDataHead(dataHeadList);
    }

    private void buildValueDataDaTa(CompareTable table, List<CustomItem> calcItemList, Map<Long, List<Map<String, Object>>> itemChangeMembers, List<BoxCalcModel> boxCustomModels, BoxCalcModel baseModel, List<CustomItem> filterItemList) {
        List<CustomItem> sliderItemList = ModelHelper.getItems("slider", calcItemList);
        List<CustomItem> dupontItemList = ModelHelper.getItems("dupontnode", calcItemList);
        ArrayList<List<CompareData>> dataDataList = new ArrayList<List<CompareData>>();
        sliderItemList.forEach(slider -> {
            List changeMembers = (List)itemChangeMembers.get(IDUtils.toLong((Object)slider.getId()));
            if (CollectionUtils.isEmpty((Collection)changeMembers)) {
                return;
            }
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(slider.getId(), filterItemList);
            if (MapUtils.isNotEmpty(filterDim)) {
                changeMembers = changeMembers.stream().filter(change -> {
                    boolean matchFlag = true;
                    for (Map.Entry entry : filterDim.entrySet()) {
                        if (change.get(entry.getKey()).equals(entry.getValue())) continue;
                        matchFlag = false;
                    }
                    return matchFlag;
                }).collect(Collectors.toList());
            }
            VarModel varModel = ModelHelper.getModel(slider, VarModel.class);
            Long modelId = IDUtils.toLong((Object)varModel.getModel());
            Long datasetId = IDUtils.toLong((Object)varModel.getDataset());
            JSONObject dimensionViews = varModel.getDimensionViews();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List allDims = modelCache.getDimensionList(datasetId);
            List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            HashMap queryResultMaps = new HashMap(boxCustomModels.size());
            boxCustomModels.forEach(box -> {
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, box.queryList);
                Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
                queryResultMaps.put(box.sandbox, queryResult);
            });
            Map baseQueryResult = (Map)queryResultMaps.get(baseModel.sandbox);
            List<VarRange> vars = varModel.getVars();
            for (VarRange var : vars) {
                Optional<Map> optionalChangeMap = changeMembers.stream().filter(p -> var.getNum().equals(String.valueOf(p.get(varModel.getVarDim())))).findFirst();
                if (!optionalChangeMap.isPresent()) continue;
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(VALUE_KEY);
                title.setValue(StringUtils.isNotEmpty((String)var.getLabel()) ? var.getLabel() : var.getName());
                compareDataList.add(title);
                Map map = optionalChangeMap.get();
                HashMap queryCellMap = new HashMap(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    if ("_v".equals(entry.getKey()) || "_t".equals(entry.getKey()) || "_vw".equals(entry.getKey())) continue;
                    queryCellMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                }
                String dimNumber = SysDimensionEnum.Metric.getNumber();
                String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
                long metricViewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
                queryCellMap.remove("_v");
                queryCellMap.remove("_t");
                queryCellMap.remove("_vw");
                boxCustomModels.forEach(box -> {
                    Map queryResult = (Map)queryResultMaps.get(box.sandbox);
                    Object compareValue = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
                    Object baseValue = this.getCellValue(modelCache, queryCellMap, sortedDimList, baseQueryResult);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox + VALUE_SUFFIX);
                    compareData.setValue(this.formatCompareData(compareValue, metricMember.getDatatype()));
                    compareData.setColor(this.formatColor(baseValue, compareValue));
                    compareDataList.add(compareData);
                });
                dataDataList.add(compareDataList);
            }
        });
        dupontItemList.forEach(dupont -> {
            List changeMembers = (List)itemChangeMembers.get(IDUtils.toLong((Object)dupont.getId()));
            if (CollectionUtils.isEmpty((Collection)changeMembers)) {
                return;
            }
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(dupont.getId(), filterItemList);
            if (MapUtils.isNotEmpty(filterDim)) {
                changeMembers = changeMembers.stream().filter(change -> {
                    boolean matchFlag = true;
                    for (Map.Entry entry : filterDim.entrySet()) {
                        if (change.get(entry.getKey()).equals(entry.getValue())) continue;
                        matchFlag = false;
                    }
                    return matchFlag;
                }).collect(Collectors.toList());
            }
            DupontModel dupontModel = ModelHelper.getModel(dupont, DupontModel.class);
            Long modelId = IDUtils.toLong((Object)dupontModel.getModel());
            Long datasetId = IDUtils.toLong((Object)dupontModel.getDataset());
            JSONObject dimensionViews = dupontModel.getDimensionViews();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List allDims = modelCache.getDimensionList(datasetId);
            List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            HashMap queryResultMaps = new HashMap(boxCustomModels.size());
            boxCustomModels.forEach(box -> {
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, box.queryList);
                Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
                queryResultMaps.put(box.sandbox, queryResult);
            });
            Map baseQueryResult = (Map)queryResultMaps.get(baseModel.sandbox);
            List<BizValue> dupontConfig = dupontModel.getDupontConfig();
            for (BizValue bizValue : dupontConfig) {
                Optional<Map> optionalChangeMap = changeMembers.stream().filter(p -> bizValue.getNum().equals(String.valueOf(p.get(bizValue.getDim())))).findFirst();
                if (!optionalChangeMap.isPresent()) continue;
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(VALUE_KEY);
                title.setValue(bizValue.getName());
                compareDataList.add(title);
                Map map = optionalChangeMap.get();
                HashMap queryCellMap = new HashMap(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    if ("_v".equals(entry.getKey()) || "_t".equals(entry.getKey()) || "_vw".equals(entry.getKey())) continue;
                    queryCellMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                }
                String dimNumber = SysDimensionEnum.Metric.getNumber();
                String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
                long metricViewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
                queryCellMap.remove("_v");
                queryCellMap.remove("_t");
                queryCellMap.remove("_vw");
                boxCustomModels.forEach(box -> {
                    Map queryResult = (Map)queryResultMaps.get(box.sandbox);
                    Object compareValue = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
                    Object baseValue = this.getCellValue(modelCache, queryCellMap, sortedDimList, baseQueryResult);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox + VALUE_SUFFIX);
                    compareData.setValue(this.formatCompareData(compareValue, metricMember.getDatatype()));
                    compareData.setColor(this.formatColor(baseValue, compareValue));
                    compareDataList.add(compareData);
                });
                dataDataList.add(compareDataList);
            }
        });
        table.setValueData(dataDataList);
    }

    private void buildReportDataDaTa(CompareTable table, List<CustomItem> calcItemList, Map<Long, List<Map<String, Object>>> itemChangeMembers, List<BoxCalcModel> boxCustomModels, BoxCalcModel baseModel, List<CustomItem> filterItemList) {
        ArrayList<List<CompareData>> dataDataList = new ArrayList<List<CompareData>>();
        List<CustomItem> reportItemList = ModelHelper.getItems("report", calcItemList);
        List<Long> templateIds = reportItemList.stream().map(e -> IDUtils.toLong((Object)ModelHelper.getModel(e, ReportModel.class).getTempId())).collect(Collectors.toList());
        Map<Long, List<String>> rowColDimMaps = this.queryTemplate(templateIds);
        reportItemList.forEach(report -> {
            List<Map> changeMembers = (List<Map>)itemChangeMembers.get(IDUtils.toLong((Object)report.getId()));
            if (CollectionUtils.isEmpty((Collection)changeMembers)) {
                return;
            }
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(report.getId(), filterItemList);
            if (MapUtils.isNotEmpty(filterDim)) {
                changeMembers = changeMembers.stream().filter(change -> {
                    boolean matchFlag = true;
                    for (Map.Entry entry : filterDim.entrySet()) {
                        if (change.get(entry.getKey()).equals(entry.getValue())) continue;
                        matchFlag = false;
                    }
                    return matchFlag;
                }).collect(Collectors.toList());
            }
            ReportModel reportModel = ModelHelper.getModel(report, ReportModel.class);
            Long modelId = IDUtils.toLong((Object)reportModel.getModel());
            Long datasetId = IDUtils.toLong((Object)reportModel.getDataset());
            JSONObject dimensionViews = reportModel.getDimensionViews();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List allDims = modelCache.getDimensionList(datasetId);
            List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            HashMap queryResultMaps = new HashMap(boxCustomModels.size());
            boxCustomModels.forEach(box -> {
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, box.queryList);
                Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
                queryResultMaps.put(box.sandbox, queryResult);
            });
            Map baseQueryResult = (Map)queryResultMaps.get(baseModel.sandbox);
            List rowColDim = (List)rowColDimMaps.get(IDUtils.toLong((Object)reportModel.getTempId()));
            if (rowColDim == null) {
                return;
            }
            HashMap queryCellMaps = new HashMap(changeMembers.size());
            changeMembers.forEach(map -> {
                HashMap queryCellMap = new HashMap(map.size());
                StringBuilder dimKey = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    if (!("_v".equals(entry.getKey()) || "_t".equals(entry.getKey()) || "_vw".equals(entry.getKey()))) {
                        queryCellMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                    if (!rowColDim.contains(entry.getKey())) continue;
                    dimKey.append(entry.getValue());
                }
                queryCellMaps.put(dimKey.toString(), queryCellMap);
            });
            queryCellMaps.values().forEach(queryCellMap -> {
                ArrayList memberName = new ArrayList(rowColDim.size());
                rowColDim.forEach(dimNumber -> {
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                    Member member = modelCache.getMember(dimNumber, Long.valueOf(viewId), (String)queryCellMap.get(dimNumber));
                    memberName.add(member.getName());
                });
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(REPORT_KEY);
                title.setValue(StringUtils.join(memberName, (String)","));
                compareDataList.add(title);
                String dimNumber2 = SysDimensionEnum.Metric.getNumber();
                String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
                long metricViewId = ModelHelper.getViewId(dimNumber2, dimensionViews);
                Member metricMember = modelCache.getMember(dimNumber2, Long.valueOf(metricViewId), memNumber);
                queryCellMap.remove("_v");
                queryCellMap.remove("_t");
                queryCellMap.remove("_vw");
                boxCustomModels.forEach(box -> {
                    Map queryResult = (Map)queryResultMaps.get(box.sandbox);
                    Object compareValue = this.getCellValue(modelCache, (Map<String, String>)queryCellMap, sortedDimList, queryResult);
                    Object baseValue = this.getCellValue(modelCache, (Map<String, String>)queryCellMap, sortedDimList, baseQueryResult);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox + REPORT_SUFFIX);
                    compareData.setValue(this.formatCompareData(compareValue, metricMember.getDatatype()));
                    compareData.setColor(this.formatColor(baseValue, compareValue));
                    compareDataList.add(compareData);
                });
                dataDataList.add(compareDataList);
            });
        });
        List<CustomItem> table2ItemList = ModelHelper.getItems("table2", calcItemList);
        table2ItemList.forEach(table2 -> {
            List<Map> changeMembers = (List<Map>)itemChangeMembers.get(IDUtils.toLong((Object)table2.getId()));
            if (CollectionUtils.isEmpty((Collection)changeMembers)) {
                return;
            }
            Map<String, String> filterDim = ModelHelper.getFilterFromSelector(table2.getId(), filterItemList);
            if (MapUtils.isNotEmpty(filterDim)) {
                changeMembers = changeMembers.stream().filter(change -> {
                    boolean matchFlag = true;
                    for (Map.Entry entry : filterDim.entrySet()) {
                        if (change.get(entry.getKey()).equals(entry.getValue())) continue;
                        matchFlag = false;
                    }
                    return matchFlag;
                }).collect(Collectors.toList());
            }
            TableModel tableModel = ModelHelper.getModel(table2, TableModel.class);
            Long modelId = IDUtils.toLong((Object)tableModel.getModel());
            Long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
            JSONObject dimensionViews = tableModel.getDimensionViews();
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
            List allDims = modelCache.getDimensionList(datasetId);
            List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            HashMap queryResultMaps = new HashMap(boxCustomModels.size());
            boxCustomModels.forEach(box -> {
                QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, box.queryList);
                Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
                queryResultMaps.put(box.sandbox, queryResult);
            });
            Map baseQueryResult = (Map)queryResultMaps.get(baseModel.sandbox);
            List allRowColDim = Stream.of(tableModel.getRowDim(), tableModel.getColDim()).flatMap(Collection::stream).flatMap(Collection::stream).map(DimensionModel::getDim).collect(Collectors.toList());
            LinkedHashSet RowColDim = new LinkedHashSet(allRowColDim);
            HashMap queryCellMaps = new HashMap(changeMembers.size());
            changeMembers.forEach(map -> {
                HashMap queryCellMap = new HashMap(map.size());
                StringBuilder dimKey = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    if (!("_v".equals(entry.getKey()) || "_t".equals(entry.getKey()) || "_vw".equals(entry.getKey()))) {
                        queryCellMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                    if (!RowColDim.contains(entry.getKey())) continue;
                    dimKey.append(entry.getValue());
                }
                queryCellMaps.put(dimKey.toString(), queryCellMap);
            });
            log.info("table2ItemList queryCellMaps: {}", queryCellMaps);
            queryCellMaps.values().forEach(queryCellMap -> {
                ArrayList memberName = new ArrayList(RowColDim.size());
                RowColDim.forEach(dimNumber -> {
                    long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                    Member member = modelCache.getMember(dimNumber, Long.valueOf(viewId), (String)queryCellMap.get(dimNumber));
                    if (member == null) {
                        log.info("table2ItemList member: {}, {}, {}", new Object[]{dimNumber, viewId, queryCellMap.get(dimNumber)});
                    }
                    memberName.add(member.getName());
                });
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(REPORT_KEY);
                title.setValue(StringUtils.join(memberName, (String)","));
                compareDataList.add(title);
                String dimNumber2 = SysDimensionEnum.Metric.getNumber();
                String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
                long metricViewId = ModelHelper.getViewId(dimNumber2, dimensionViews);
                Member metricMember = modelCache.getMember(dimNumber2, Long.valueOf(metricViewId), memNumber);
                queryCellMap.remove("_v");
                queryCellMap.remove("_t");
                queryCellMap.remove("_vw");
                boxCustomModels.forEach(box -> {
                    Map queryResult = (Map)queryResultMaps.get(box.sandbox);
                    Object compareValue = this.getCellValue(modelCache, (Map<String, String>)queryCellMap, sortedDimList, queryResult);
                    Object baseValue = this.getCellValue(modelCache, (Map<String, String>)queryCellMap, sortedDimList, baseQueryResult);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox + REPORT_SUFFIX);
                    compareData.setValue(this.formatCompareData(compareValue, metricMember.getDatatype()));
                    compareData.setColor(this.formatColor(baseValue, compareValue));
                    compareDataList.add(compareData);
                });
                dataDataList.add(compareDataList);
            });
        });
        table.setReportData(dataDataList);
    }

    private void buildTableDataDaTa(CompareTable table, List<BoxCalcModel> boxCustomModels, BoxCalcModel baseModel, DataModel dataModel, IModelCacheHelper modelCache, List<Member> rowMemberList, List<Member> colMemberList) {
        Long modelId = dataModel.getModel();
        Long datasetId = dataModel.getDataset();
        JSONObject dimensionViews = dataModel.getDimensionViews();
        String rowDimNumber = dataModel.getRowFields().get(0).getDim();
        String colDimNumber = dataModel.getColFields().get(0).getDim();
        Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
        List allDims = modelCache.getDimensionList(dataModel.getDataset());
        List sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        List<DimensionDto> hideFields = dataModel.getHideFields();
        HashMap queryCellMap = new HashMap(hideFields.size());
        hideFields.forEach(dimensionDto -> queryCellMap.put(dimensionDto.getDim(), dimensionDto.getMembers().get(0).getNum()));
        String dimNumber = SysDimensionEnum.Metric.getNumber();
        String memNumber = (String)queryCellMap.get(SysDimensionEnum.Metric.getNumber());
        long metricViewId = ModelHelper.getViewId(dimNumber, dimensionViews);
        Member metricMember = modelCache.getMember(dimNumber, Long.valueOf(metricViewId), memNumber);
        HashMap queryResultMaps = new HashMap(boxCustomModels.size());
        ArrayList<List<CompareData>> dataDataList = new ArrayList<List<CompareData>>();
        boxCustomModels.forEach(box -> {
            QueryDto queryDto = QueryDtoHelper.getQueryDto(modelId, datasetId, viewMap, box.queryList);
            Map<MembersKey, BGCell> queryResult = queryDto.getQueryResult();
            queryResultMaps.put(box.sandbox, queryResult);
        });
        Map baseQueryResult = (Map)queryResultMaps.get(baseModel.sandbox);
        rowMemberList.forEach(row -> {
            queryCellMap.put(rowDimNumber, row.getNumber());
            ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
            CompareData title = new CompareData();
            title.setFieldKey(DATA_KEY);
            title.setValue(row.getName());
            compareDataList.add(title);
            boxCustomModels.forEach(box -> {
                Map queryResult = (Map)queryResultMaps.get(box.sandbox);
                colMemberList.forEach(col -> {
                    queryCellMap.put(colDimNumber, col.getNumber());
                    Object compareValue = this.getCellValue(modelCache, queryCellMap, sortedDimList, queryResult);
                    Object baseValue = this.getCellValue(modelCache, queryCellMap, sortedDimList, baseQueryResult);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox + col.getNumber().replaceAll("\\.", ""));
                    compareData.setValue(this.formatCompareData(compareValue, metricMember.getDatatype()));
                    compareData.setColor(this.formatColor(baseValue, compareValue));
                    compareDataList.add(compareData);
                });
            });
            dataDataList.add(compareDataList);
        });
        table.setDataData(dataDataList);
    }

    private void buildTableDataDaTa(CompareTable table, List<BoxCalcModel> boxCustomModels, BoxCalcModel baseModel) {
        ArrayList<CompareHead> dataHeadList = new ArrayList<CompareHead>(16);
        CompareHead dataKey = new CompareHead();
        dataKey.setFieldKey(DATA_KEY);
        dataKey.setName(ResManager.loadKDString((String)"\u6bd4\u8f83\u8303\u56f4", (String)"AnalysisCanvasCompareService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        dataHeadList.add(dataKey);
        ArrayList<List<CompareData>> dataDataList = new ArrayList<List<CompareData>>();
        CustomItem baseItem = baseModel.item;
        if ("bizindicator".equals(baseItem.getType())) {
            this.buildBuildBizData(baseItem, boxCustomModels, dataHeadList, dataDataList);
        } else {
            this.buildBuildChartData(baseItem, boxCustomModels, dataHeadList, dataDataList);
        }
        table.setDataHead(dataHeadList);
        table.setDataData(dataDataList);
    }

    private void buildBuildBizData(CustomItem baseItem, List<BoxCalcModel> boxCustomModels, List<CompareHead> dataHeadList, List<List<CompareData>> dataDataList) {
        BizModel baseBizModel = ModelHelper.getModel(baseItem, BizModel.class);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)baseBizModel.getModel()));
        BizValue baseMainMem = baseBizModel.getBizConfig().get(0);
        if (baseMainMem != null) {
            JSONObject dimensionViews = baseMainMem.getDimensionViews();
            Long viewId = IDUtils.toLong((Object)dimensionViews.getString(baseMainMem.getDim()));
            Member member = modelCache.getMember(baseMainMem.getDim(), viewId, baseMainMem.getNum());
            if (member != null) {
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(DATA_KEY);
                title.setValue(member.getName());
                compareDataList.add(title);
                boxCustomModels.forEach(box -> {
                    CompareHead data = new CompareHead();
                    data.setFieldKey(box.sandbox + DATA_SUFFIX);
                    data.setName(box.name);
                    dataHeadList.add(data);
                    BizModel bizModel = ModelHelper.getModel(box.item, BizModel.class);
                    BizValue mainMem = bizModel.getBizConfig().get(0);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox + DATA_SUFFIX);
                    compareData.setValue(this.formatCompareData(mainMem.getValue(), mainMem.getDt()));
                    compareData.setColor(this.formatColor(baseMainMem.getValue(), mainMem.getValue()));
                    compareDataList.add(compareData);
                });
                dataDataList.add(compareDataList);
            }
        }
        if (baseBizModel.getBizConfig().size() == 2) {
            BizValue baseSubMem = baseBizModel.getBizConfig().get(1);
            JSONObject dimensionViews = baseSubMem.getDimensionViews();
            Long viewId = IDUtils.toLong((Object)dimensionViews.getString(baseSubMem.getDim()));
            Member member = modelCache.getMember(baseSubMem.getDim(), viewId, baseSubMem.getNum());
            if (member != null) {
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(DATA_KEY);
                title.setValue(member.getName());
                compareDataList.add(title);
                boxCustomModels.forEach(box -> {
                    BizModel bizModel = ModelHelper.getModel(box.item, BizModel.class);
                    BizValue subMem = bizModel.getBizConfig().get(1);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox + DATA_SUFFIX);
                    compareData.setValue(this.formatCompareData(subMem.getValue(), subMem.getDt()));
                    compareData.setColor(this.formatColor(baseSubMem.getValue(), subMem.getValue()));
                    compareDataList.add(compareData);
                });
                dataDataList.add(compareDataList);
            }
        }
    }

    private void buildBuildChartData(CustomItem baseItem, List<BoxCalcModel> boxCustomModels, List<CompareHead> dataHeadList, List<List<CompareData>> dataDataList) {
        ChartModel baseChartModel = ModelHelper.getModel(baseItem, ChartModel.class);
        if ("bar".equals(baseChartModel.getType()) || "line".equals(baseChartModel.getType()) || "sortbar".equals(baseChartModel.getType()) || "barLine".equals(baseChartModel.getType())) {
            List<ChartSerialModel> dataList = baseChartModel.getSerVals();
            if (CollectionUtils.isEmpty(dataList)) {
                return;
            }
            boxCustomModels.forEach(box -> {
                CompareHead parent = new CompareHead();
                parent.setFieldKey(box.sandbox);
                parent.setName(box.name);
                List<CompareHead> child = ((ChartSerialModel)dataList.get(0)).getAxisList().stream().map(e -> {
                    CompareHead head = new CompareHead();
                    head.setFieldKey(box.sandbox + e.getNum().replaceAll("\\.", ""));
                    head.setName(e.getName());
                    return head;
                }).collect(Collectors.toList());
                parent.setChild(child);
                dataHeadList.add(parent);
            });
            int i = 0;
            while (i < dataList.size()) {
                ChartSerialModel chartSerialModel = dataList.get(i);
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(DATA_KEY);
                title.setValue(chartSerialModel.getSerial());
                compareDataList.add(title);
                List<ChartAxisModel> baseAxisList = chartSerialModel.getAxisList();
                int finalI = i++;
                boxCustomModels.forEach(box -> {
                    for (int j = 0; j < baseAxisList.size(); ++j) {
                        ChartAxisModel baseChartAxisModel = (ChartAxisModel)baseAxisList.get(j);
                        ChartModel chartModel = ModelHelper.getModel(box.item, ChartModel.class);
                        ChartAxisModel chartAxisModel = chartModel.getSerVals().get(finalI).getAxisList().get(j);
                        CompareData compareData = new CompareData();
                        compareData.setFieldKey(box.sandbox + chartAxisModel.getNum().replaceAll("\\.", ""));
                        compareData.setValue(this.formatCompareData(chartAxisModel.getValue(), chartAxisModel.getDt()));
                        compareData.setColor(this.formatColor(baseChartAxisModel.getValue(), chartAxisModel.getValue()));
                        compareDataList.add(compareData);
                    }
                });
                dataDataList.add(compareDataList);
            }
        } else if ("map".equals(baseChartModel.getType())) {
            boxCustomModels.forEach(box -> {
                CompareHead parent = new CompareHead();
                parent.setFieldKey(box.sandbox);
                parent.setName(box.name);
                dataHeadList.add(parent);
            });
            MapModel baseMap = baseChartModel.getMap();
            for (int i = 0; i < baseMap.getMapValues().size(); ++i) {
                MapValue baseMapValue = baseMap.getMapValues().get(i);
                if (baseMapValue.getMember() == null) continue;
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(DATA_KEY);
                title.setValue(baseMapValue.getName());
                compareDataList.add(title);
                int finalI = i;
                boxCustomModels.forEach(box -> {
                    ChartModel chartModel = ModelHelper.getModel(box.item, ChartModel.class);
                    MapModel map = chartModel.getMap();
                    MapValue mapValue = map.getMapValues().get(finalI);
                    CompareData compareData = new CompareData();
                    compareData.setFieldKey(box.sandbox);
                    compareData.setValue(this.formatCompareData(mapValue.getValue(), baseMap.getDt()));
                    compareData.setColor(this.formatColor(baseMapValue.getValue(), mapValue.getValue()));
                    compareDataList.add(compareData);
                });
                dataDataList.add(compareDataList);
            }
        } else {
            List<ChartSerialModel> dataList = baseChartModel.getSerVals();
            if (CollectionUtils.isEmpty(dataList)) {
                return;
            }
            boxCustomModels.forEach(box -> {
                CompareHead parent = new CompareHead();
                parent.setFieldKey(box.sandbox);
                parent.setName(box.name);
                dataHeadList.add(parent);
            });
            int i = 0;
            while (i < dataList.size()) {
                ChartSerialModel chartSerialModel = dataList.get(i);
                ArrayList<CompareData> compareDataList = new ArrayList<CompareData>(16);
                CompareData title = new CompareData();
                title.setFieldKey(DATA_KEY);
                title.setValue(chartSerialModel.getSerial());
                compareDataList.add(title);
                List<ChartAxisModel> baseAxisList = chartSerialModel.getAxisList();
                int finalI = i++;
                boxCustomModels.forEach(box -> {
                    for (int j = 0; j < baseAxisList.size(); ++j) {
                        ChartAxisModel baseChartAxisModel = (ChartAxisModel)baseAxisList.get(j);
                        ChartModel chartModel = ModelHelper.getModel(box.item, ChartModel.class);
                        ChartAxisModel chartAxisModel = chartModel.getSerVals().get(finalI).getAxisList().get(j);
                        CompareData compareData = new CompareData();
                        compareData.setFieldKey(box.sandbox);
                        compareData.setValue(this.formatCompareData(chartAxisModel.getValue(), chartAxisModel.getDt()));
                        compareData.setColor(this.formatColor(baseChartAxisModel.getValue(), chartAxisModel.getValue()));
                        compareDataList.add(compareData);
                    }
                });
                dataDataList.add(compareDataList);
            }
        }
    }

    private Object formatCompareData(Object val, String dataType) {
        if (MetricDataTypeEnum.RATE.getIndex().equals(dataType)) {
            BigDecimal bigDecimal = val instanceof BigDecimal ? (BigDecimal)val : new BigDecimal(val.toString());
            bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
            return bigDecimal.multiply(new BigDecimal(100)) + "%";
        }
        return val;
    }

    private String formatColor(Object baseValue, Object comPareValue) {
        BigDecimal comPareDecimal;
        BigDecimal baseDecimal = baseValue instanceof BigDecimal ? (BigDecimal)baseValue : new BigDecimal(baseValue.toString());
        int i = baseDecimal.compareTo(comPareDecimal = comPareValue instanceof BigDecimal ? (BigDecimal)comPareValue : new BigDecimal(comPareValue.toString()));
        if (i < 0) {
            return BgConstant.COLOR[0];
        }
        if (i == 0) {
            return BgConstant.COLOR[2];
        }
        return BgConstant.COLOR[1];
    }

    private Object getCellValue(IModelCacheHelper modelCache, Map<String, String> queryCellMap, List<String> sortedDimList, Map<MembersKey, BGCell> keyBGCellMap) {
        return this.getCellValue(modelCache, queryCellMap, sortedDimList, keyBGCellMap, 0.0);
    }

    private Object getCellValue(IModelCacheHelper modelCache, Map<String, String> queryCellMap, List<String> sortedDimList, Map<MembersKey, BGCell> keyBGCellMap, Object defaultValue) {
        Object[] keys = new String[sortedDimList.size() + 1];
        for (int i = 0; i < sortedDimList.size(); ++i) {
            String dimNumber = sortedDimList.get(i);
            if (queryCellMap.containsKey(dimNumber)) {
                keys[i + 1] = queryCellMap.get(dimNumber);
                continue;
            }
            Dimension dimension = modelCache.getDimension(dimNumber);
            keys[i + 1] = dimension.getNoneNumber();
        }
        MembersKey membersKey = new MembersKey(keys);
        BGCell bgCell = keyBGCellMap.get(membersKey);
        Object value = bgCell == null ? defaultValue : bgCell.getValue();
        return value;
    }

    private Map<Long, List<String>> queryTemplate(List<Long> templateIds) {
        QFilter qf = new QFilter("id", "in", templateIds);
        DynamicObjectCollection template = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, data", (QFilter[])qf.toArray());
        return template.stream().collect(Collectors.toMap(t -> t.getLong("id"), o -> {
            ITemplateModel data = TemplateModelJSONUtil.parseITemplateModel((String)o.getString("data"));
            if (data == null) {
                return new ArrayList();
            }
            return data.getRowcolDims();
        }));
    }

    private static class BoxCalcModel {
        String sandbox;
        String name;
        CustomItem item;
        AnalysisCanvasConstants.CalcType CalcType;
        List<QueryDto> queryList;

        private BoxCalcModel() {
        }
    }

    private static class InnerClass {
        private static final AnalysisCanvasCompareService instance = new AnalysisCanvasCompareService();

        private InnerClass() {
        }
    }
}

