/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.util.Arrays;
import java.util.Optional;
import kd.epm.eb.common.enums.MultiLangEnumBridge;

public interface AnalysisCanvasConstants {
    public static final String MODEL_VAR = "varModel";
    public static final String MODEL_CHART = "chartModel";
    public static final String MODEL_BIZ = "bizModel";
    public static final String MODEL_TAB = "tabModel";
    public static final String MODEL_TABLE = "tableModel";
    public static final String MODEL_SELECT = "selectModel";
    public static final String MODEL_REPORT = "reportModel";
    public static final String MODEL_DUPONT = "dupontModel";
    public static final String MODEL_PREDICT = "predictModel";
    public static final String TYPE_SLIDER = "slider";
    public static final String TYPE_CHART = "chart";
    public static final String TYPE_BIZINDICATOR = "bizindicator";
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_TABLE2 = "table2";
    public static final String TYPE_SELECT = "select";
    public static final String TYPE_REPORT = "report";
    public static final String TYPE_DUPONT = "dupont";
    public static final String TYPE_DUPONT_NODE = "dupontnode";
    public static final String TYPE_DUPONT_SYMBOL = "dupontsymbol";
    public static final String TYPE_TAB = "tab";
    public static final String TYPE_SUB_TAB = "subtab";
    public static final String TYPE_PREDICT = "predict";
    public static final String TYPE_IMAGE = "image";
    public static final String CHART_BAR = "bar";
    public static final String CHART_LINE = "line";
    public static final String CHART_PIE = "pie";
    public static final String CHART_ANNULAR = "annular";
    public static final String CHART_PROGRESS = "progress";
    public static final String CHART_BARLINE = "barLine";
    public static final String CHART_SORT_BAR = "sortbar";
    public static final String CHART_MAP = "map";
    public static final String CHART_GAUGE = "gauge";
    public static final String CALC_PARAM = "calcParam";
    public static final String CALC_TYPE = "calcType";
    public static final String VIEW_AREA = "viewArea";
    public static final String SPREAD_MANAGER_CACHE_KEY = "spreadManagerCacheKey";
    public static final String TEMPLATE_MODEL_CACHE_KEY = "templateModelCacheKey";
    public static final String TEMPLATE_BASE_CACHE_KEY = "templateBaseCacheKey";
    public static final String CHANGE_MEMBER_VALUE = "_v";
    public static final String CHANGE_MEMBER_TIME = "_t";
    public static final String CHANGE_MEMBER_VIEW = "_vw";
    public static final String TRACE_ID = "traceId";
    public static final int CELL_NOT_LEAF = 0;
    public static final int CELL_IS_LEAF = 1;
    public static final int CELL_DATA_LOCK = 2;
    public static final int CELL_HAS_RULE = 4;
    public static final int CODE_ERR_NORMAL = 1;
    public static final int CODE_ERR_WITH_CLOSE = 2;
    public static final long PREDICT_ITEM_ID = 10000L;
    public static final int MAX_NAME_LENGTH = 20;

    public static enum OptType {
        INIT,
        CALC,
        DRILL,
        EXPAND,
        VIRTUAL,
        SELECTOR_CHANGE,
        REL_QUERY;


        public static OptType find(String type) {
            Optional<OptType> optional = Arrays.stream(OptType.values()).filter(k -> k.name().equals(type)).findFirst();
            return optional.orElse(CALC);
        }
    }

    public static enum CalcType {
        BASE,
        SAND;


        public static CalcType find(String type) {
            Optional<CalcType> optional = Arrays.stream(CalcType.values()).filter(k -> k.name().equals(type)).findFirst();
            return optional.orElse(BASE);
        }
    }

    public static enum SerialType {
        BOX,
        DIM;

    }

    public static enum ShareStatus {
        FAIL("0"),
        SUCCESS("1");

        String value;

        private ShareStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ShareType {
        SELF("0"),
        SHARE("1");

        String value;

        private ShareType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BoxType {
        BASE("1"),
        SANDBOX("2");

        String value;

        private BoxType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BoxStatus {
        ACTIVATED("1"),
        UNACTIVATED("2");

        String value;

        private BoxStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Status {
        SAVE(Status.getSave(), "1"),
        RELEASE(Status.getRelease(), "2");

        private MultiLangEnumBridge name;
        String value;

        private Status(MultiLangEnumBridge name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name.loadKDString();
        }

        public String getValue() {
            return this.value;
        }

        private static MultiLangEnumBridge getSave() {
            return new MultiLangEnumBridge("\u6682\u5b58", "AnalysisCanvasConstants_1", "epm-eb-business");
        }

        private static MultiLangEnumBridge getRelease() {
            return new MultiLangEnumBridge("\u5df2\u53d1\u5e03", "AnalysisCanvasConstants_2", "epm-eb-business");
        }
    }
}

