/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCollectService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCommentService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCompareService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasShareService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUserSelService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasVarService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.item.ItemHelper;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.PageConfig;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.SelectModel;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasService {
    private static final Log log = LogFactory.getLog(AnalysisCanvasService.class);
    private static final String ENTITY_NAME = "eb_analysiscanvas";
    private static final int MAX_NUMBER_COUNT = 50;
    private final String selectAllField;
    private final String selectField;

    public static AnalysisCanvasService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasService() {
        this.selectAllField = "id, name, number, model, description, status, share, page, item, type, creater, modifier, modifydate";
        this.selectField = "id, name, number, model, description, status, share, modifier, modifydate";
    }

    public DynamicObject[] queryAllData(QFilter qFilter) {
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)this.selectField, (QFilter[])new QFilter[]{qFilter}, (String)"id");
    }

    public DynamicObject queryCanvasShare(Long canvasId) {
        QFilter qFilter = new QFilter("id", "=", (Object)canvasId);
        return QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"share, creater", (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection queryCanvasStatus(List<Long> canvasIds) {
        QFilter qFilter = new QFilter("id", "in", canvasIds);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"status", (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObjectCollection queryCanvasCreator(List<Long> canvasIds) {
        QFilter qFilter = new QFilter("id", "in", canvasIds);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, name, creater", (QFilter[])new QFilter[]{qFilter});
    }

    public void updateCanvas(Long canvasId, String canvas) {
        JSONObject jsonObject = JSON.parseObject((String)canvas);
        List itemList = JSON.parseArray((String)jsonObject.getString("itemList"), CustomItem.class);
        ItemHelper.getInstance().checkItem(itemList);
        String pageConfig = jsonObject.getString("pageConfig");
        PageConfig config = (PageConfig)JSON.parseObject((String)pageConfig, PageConfig.class);
        this.insertImageQuote(canvasId, itemList, config);
        this.updateCanvas(canvasId, itemList, pageConfig, RequestContext.get().getCurrUserId());
    }

    public void insertImageQuote(Long canvasId, List<CustomItem> itemList, PageConfig pageConfig) {
        List ids;
        this.deleteImageQuote(Collections.singletonList(canvasId));
        String rootUrl = UrlService.getDomainContextUrl();
        rootUrl = !rootUrl.endsWith("/") ? rootUrl + "/attachment/downloadImage" : rootUrl + "attachment/downloadImage";
        String url = rootUrl;
        Set urls = itemList.stream().filter(item -> "image".equals(item.getType())).map(item -> {
            Object value = item.getC().get((Object)"value");
            if (value == null) {
                return null;
            }
            String fullUrl = value.toString();
            return fullUrl.replace(url, "");
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (StringUtils.isNotEmpty((CharSequence)pageConfig.getUrl())) {
            urls.add(pageConfig.getUrl().replace(rootUrl, ""));
        }
        if (CollectionUtils.isEmpty((Collection)(ids = QueryServiceHelper.queryPrimaryKeys((String)"eb_analysiscanvas_img", (QFilter[])new QFilter[]{new QFilter("fileurl", "in", urls)}, null, (int)1000)))) {
            return;
        }
        DynamicObject[] dynamicObjects = new DynamicObject[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_analysiscanvas_quote");
            dynamicObject.set("canvasid", (Object)canvasId);
            dynamicObject.set("imageid", ids.get(i));
            dynamicObjects[i] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private void deleteImageQuote(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"eb_analysiscanvas_quote", (QFilter[])new QFilter[]{new QFilter("canvasid", "in", ids)});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void updateCanvas(Long canvasId, List<CustomItem> itemList, String pageConfig, Long updateUser) {
        ModelHelper.resetItems(itemList);
        this.clearItemStyle(itemList);
        this.clearItemValue(itemList);
        Set modelIds = itemList.stream().map(item -> {
            BaseModel model = ModelHelper.getModel(item);
            return model != null ? IDUtils.toLong((Object)model.getModel()) : null;
        }).filter(IDUtils::isNotEmptyLong).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", modelIds);
        DynamicObjectCollection model = QueryServiceHelper.query((String)"epm_model", (String)"name", (QFilter[])new QFilter[]{qFilter});
        List modelNames = model.stream().map(p -> p.getString("name")).collect(Collectors.toList());
        String modelName = String.join((CharSequence)",", modelNames);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)canvasId, (String)ENTITY_NAME);
        dynamicObject.set("item", (Object)AnalysisCanvasUtils.compressData(JSONObject.toJSONString(itemList)));
        dynamicObject.set("model", (Object)(modelName.length() > 500 ? modelName.substring(0, 500) : modelName));
        if (StringUtils.isNotBlank((CharSequence)pageConfig)) {
            dynamicObject.set("page", (Object)pageConfig);
        }
        if (updateUser != null) {
            dynamicObject.set("modifier", (Object)updateUser);
            dynamicObject.set("modifydate", (Object)new Date());
        }
        try (TXHandle tx = TX.required();){
            try {
                AnalysisCanvasBoxDataService.getInstance().deleteNotExistItem(itemList, canvasId);
                AnalysisCanvasVarService.getInstance().deleteNotExistItem(itemList, canvasId);
                AnalysisCanvasCommentService.getInstance().deleteNotExistItem(itemList, canvasId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                this.deleteQuote(Collections.singletonList(canvasId));
                this.saveQuote(canvasId, itemList);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void clearItemStyle(List<CustomItem> itemList) {
        itemList.forEach(item -> item.setS(null));
    }

    private void clearItemValue(List<CustomItem> itemList) {
        ItemHelper.getInstance().clearItemValue(itemList);
    }

    private void saveQuote(long canvasId, List<CustomItem> itemList) {
        List<MemberQuoteDao> quoteList = this.getItemQuote(canvasId, itemList);
        if (CollectionUtils.isNotEmpty(quoteList)) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quoteList});
        }
    }

    private void deleteQuote(List<Long> ids) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.AnalysisCanvas.getType(), ids});
    }

    private List<MemberQuoteDao> getItemQuote(long canvasId, List<CustomItem> itemList) {
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(itemList.size() * 10);
        ItemHelper.getInstance().buildItemQuote(canvasId, itemList, quotes);
        return quotes;
    }

    public List<AnalysisCanvas> load(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection data = QueryServiceHelper.query((String)ENTITY_NAME, (String)this.selectAllField, (QFilter[])new QFilter[]{qFilter});
        return data.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public AnalysisCanvas load(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject data = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)this.selectAllField, (QFilter[])new QFilter[]{qFilter});
        if (data == null) {
            return null;
        }
        return this.transToModel(data);
    }

    public String queryName(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject data = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"name", (QFilter[])new QFilter[]{qFilter});
        return data == null ? "" : data.getString("name");
    }

    public AnalysisCanvas loadByNum(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject data = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id, name, number, model, description, status, share, page, item, type, creater, modifier, modifydate", (QFilter[])new QFilter[]{qFilter});
        return this.transToModel(data);
    }

    public boolean numberIsExists(String id, String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            qFilter.and(new QFilter("id", "!=", (Object)Long.parseLong(id)));
        }
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                ids.forEach(canvasId -> AnalysisCanvasBoxService.getInstance().deleteByCanvasId((Long)canvasId));
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                this.deleteQuote(ids);
                this.deleteImageQuote(ids);
                AnalysisCanvasUserSelService.getInstance().delete(ids);
                AnalysisCanvasShareService.getInstance().deleteByCanvasIds(ids);
                AnalysisCanvasCollectService.getInstance().deleteByCanvasIds(ids);
                AnalysisCanvasVarService.getInstance().deleteByCanvasIds(ids);
                AnalysisCanvasCompareService.getInstance().deleteByCanvasIds(ids);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void updateStatus(AnalysisCanvasConstants.Status status, List<Long> pkIds) {
        DynamicObject[] objs;
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,status,modifier,modifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)})) {
            obj.set("status", (Object)status.getValue());
            obj.set("modifier", (Object)currUserId);
            obj.set("modifydate", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public long copy(Long id) {
        long newCanvasId;
        AnalysisCanvas model = this.load(id);
        AnalysisCanvas newModel = new AnalysisCanvas();
        try {
            BeanUtils.copyProperties((Object)newModel, (Object)model);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        HashSet<String> numberSet = new HashSet<String>(16);
        HashSet<String> nameSet = new HashSet<String>(16);
        String filterNumber = model.getNumber().length() > 44 ? model.getNumber().substring(0, 44) : model.getNumber();
        QFilter qfilter = new QFilter("number", "ftlike", (Object)filterNumber);
        try (DataSet allData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_NAME, (String)"name, number", (QFilter[])new QFilter[]{qfilter}, null);){
            while (allData.hasNext()) {
                Row row = allData.next();
                numberSet.add(row.getString("number"));
                nameSet.add(row.getString("name"));
            }
        }
        List<CustomItem> oldCustomItemList = this.getOldCustomItems(model);
        Map<String, String> itemMapping = oldCustomItemList.stream().collect(Collectors.toMap(CustomItem::getId, item -> String.valueOf(GlobalIdUtil.genGlobalLongId())));
        List<CustomItem> newCustomItemList = this.getNewCustomItems(oldCustomItemList, itemMapping);
        RequestContext requestContext = RequestContext.get();
        Date now = TimeServiceHelper.now();
        newModel.setId(0L);
        newModel.setName(this.getCopyName(model.getName(), nameSet));
        newModel.setNumber(this.getCopyName(model.getNumber(), numberSet));
        newModel.setStatus(AnalysisCanvasConstants.Status.SAVE.getValue());
        newModel.setItem(JSON.toJSONString(newCustomItemList));
        newModel.setCreatorId(requestContext.getCurrUserId());
        newModel.setCreateTime(now);
        newModel.setModifierId(requestContext.getCurrUserId());
        newModel.setModifyTime(now);
        DynamicObject newDynObj = this.packageDynamicObject(newModel);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynObj});
                newCanvasId = newDynObj.getLong("id");
                AnalysisCanvasBoxService.getInstance().copySandbox(id, newCanvasId);
                AnalysisCanvasVarService.getInstance().copyVar(id, newCanvasId, itemMapping);
                this.saveQuote(newCanvasId, newCustomItemList);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        return newCanvasId;
    }

    public String getCopyName(String name, Set<String> nameSet) {
        String copyName = "";
        for (int i = 0; i < nameSet.size(); ++i) {
            StringBuilder appendName = new StringBuilder("copy");
            StringBuilder preName = new StringBuilder(name);
            if (i > 0) {
                appendName.append(i);
            }
            String string = copyName = name.length() + appendName.length() > 50 ? preName.substring(0, 50 - appendName.length()) + appendName : preName.append((CharSequence)appendName).toString();
            if (nameSet.contains(copyName)) continue;
            return copyName;
        }
        return copyName;
    }

    public Set<String> getCopyNameSet(String number, String selectField) {
        HashSet<String> numberSet = new HashSet<String>(16);
        String filterNumber = number.length() > 44 ? number.substring(0, 44) : number;
        QFilter qfilter = new QFilter("number", "ftlike", (Object)filterNumber);
        try (DataSet allData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_NAME, (String)selectField, (QFilter[])new QFilter[]{qfilter}, null);){
            while (allData.hasNext()) {
                Row row = allData.next();
                numberSet.add(row.getString(selectField));
            }
        }
        return numberSet;
    }

    public AnalysisCanvas transToModel(DynamicObject dynamicObject) {
        AnalysisCanvas model = new AnalysisCanvas();
        model.setId(dynamicObject.getLong("id"));
        model.setNumber(dynamicObject.getString("number"));
        model.setName(dynamicObject.getString("name"));
        model.setType(dynamicObject.getString("type"));
        model.setStatus(dynamicObject.getString("status"));
        model.setDescription(dynamicObject.getString("description"));
        model.setPage(dynamicObject.getString("page"));
        model.setItem(AnalysisCanvasUtils.unCompressData(dynamicObject.getString("item")));
        model.setModifierId(dynamicObject.getLong("modifier"));
        model.setModifyTime(dynamicObject.getDate("modifydate"));
        model.setModel(dynamicObject.getString("model"));
        model.setShare(dynamicObject.getString("share"));
        model.setCreatorId(dynamicObject.getLong("creater"));
        if (StringUtils.isNotBlank((CharSequence)model.getItem())) {
            model.setItemList(JSON.parseArray((String)model.getItem(), CustomItem.class));
        }
        return model;
    }

    private DynamicObject packageDynamicObject(AnalysisCanvas model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("creater", (Object)model.getCreatorId());
            dynamicObject.set("createdate", (Object)model.getCreateTime());
            dynamicObject.set("status", (Object)model.getStatus());
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("number", (Object)model.getNumber());
        dynamicObject.set("name", (Object)model.getName());
        dynamicObject.set("type", (Object)model.getType());
        dynamicObject.set("status", (Object)model.getStatus());
        dynamicObject.set("description", (Object)model.getDescription());
        dynamicObject.set("page", (Object)model.getPage());
        dynamicObject.set("item", (Object)AnalysisCanvasUtils.compressData(model.getItem()));
        dynamicObject.set("modifier", (Object)model.getModifierId());
        dynamicObject.set("modifydate", (Object)model.getCreateTime());
        dynamicObject.set("model", (Object)model.getModel());
        dynamicObject.set("share", (Object)model.getShare());
        return dynamicObject;
    }

    public List<CustomItem> getOldCustomItems(AnalysisCanvas model) {
        if (StringUtils.isBlank((CharSequence)model.getItem())) {
            return Collections.emptyList();
        }
        return JSONObject.parseArray((String)model.getItem(), CustomItem.class);
    }

    public List<CustomItem> getNewCustomItems(List<CustomItem> oldCustomItemList, Map<String, String> itemMapping) {
        ArrayList<CustomItem> newCustomItemList = new ArrayList<CustomItem>(oldCustomItemList.size());
        for (CustomItem oldItem : oldCustomItemList) {
            CustomItem newItem = new CustomItem();
            try {
                BeanUtils.copyProperties((Object)newItem, (Object)oldItem);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            newItem.setId(itemMapping.get(oldItem.getId()));
            if (!"0".equals(oldItem.getPid())) {
                newItem.setPid(itemMapping.get(oldItem.getPid()));
            }
            switch (oldItem.getType()) {
                case "select": {
                    SelectModel newSelectModel = ModelHelper.getModel(newItem, SelectModel.class);
                    List<String> newRelationId = newSelectModel.getRelationId().stream().map(itemMapping::get).collect(Collectors.toList());
                    newSelectModel.setRelationId(newRelationId);
                    ModelHelper.updateModel(newItem, newSelectModel);
                    break;
                }
                case "chart": {
                    List<DimensionModel> newDims;
                    ChartModel newChartModel = ModelHelper.getModel(newItem, ChartModel.class);
                    if ("map".equals(newChartModel.getType())) {
                        newDims = this.buildNewDims(newChartModel.getMap().getDims(), itemMapping);
                        newChartModel.getMap().setDims(newDims);
                    } else {
                        newChartModel.getChartConfig().forEach(chartConfigModel -> {
                            List<DimensionModel> newDims = this.buildNewDims(chartConfigModel.getDims(), itemMapping);
                            chartConfigModel.setDims(newDims);
                        });
                        List<String> relationId = newChartModel.getRelationId();
                        if (CollectionUtils.isNotEmpty(relationId)) {
                            List<String> newRelationIds = relationId.stream().map(itemMapping::get).collect(Collectors.toList());
                            newChartModel.setRelationId(newRelationIds);
                        }
                    }
                    ModelHelper.updateModel(newItem, newChartModel);
                    break;
                }
                case "bizindicator": {
                    BizModel newBizModel = ModelHelper.getModel(newItem, BizModel.class);
                    newBizModel.getBizConfig().forEach(config -> {
                        List<DimensionModel> newDims = this.buildNewDims(config.getDims(), itemMapping);
                        config.setDims(newDims);
                    });
                    ModelHelper.updateModel(newItem, newBizModel);
                    break;
                }
                case "table": {
                    TabModel newTabModel = ModelHelper.getModel(newItem, TabModel.class);
                    List<DimensionModel> newDims = this.buildNewDims(newTabModel.getDims(), itemMapping);
                    newTabModel.setDims(newDims);
                    ModelHelper.updateModel(newItem, newTabModel);
                    break;
                }
                case "table2": {
                    TableModel newTableModel = ModelHelper.getModel(newItem, TableModel.class);
                    List<DimensionModel> newDims = this.buildNewDims(newTableModel.getDims(), itemMapping);
                    newTableModel.setDims(newDims);
                    ModelHelper.updateModel(newItem, newTableModel);
                    break;
                }
                case "slider": {
                    VarModel newVarModel = ModelHelper.getModel(newItem, VarModel.class);
                    List<DimensionModel> newDims = this.buildNewDims(newVarModel.getDims(), itemMapping);
                    newVarModel.setDims(newDims);
                    ModelHelper.updateModel(newItem, newVarModel);
                    break;
                }
                case "report": {
                    ReportModel newReportModel = ModelHelper.getModel(newItem, ReportModel.class);
                    List<DimensionModel> newDims = this.buildNewDims(newReportModel.getDims(), itemMapping);
                    newReportModel.setDims(newDims);
                    ModelHelper.updateModel(newItem, newReportModel);
                    break;
                }
                case "dupontnode": {
                    DupontModel newDupontModel = ModelHelper.getModel(newItem, DupontModel.class);
                    newDupontModel.getDupontConfig().forEach(config -> {
                        List<DimensionModel> newDims = this.buildNewDims(config.getDims(), itemMapping);
                        config.setDims(newDims);
                    });
                    ModelHelper.updateModel(newItem, newDupontModel);
                    break;
                }
                case "dupont": {
                    JSONObject c = newItem.getC();
                    List lineList = JSON.parseArray((String)JSON.toJSONString((Object)c.get((Object)"lineList")), JSONObject.class);
                    lineList.forEach(line -> {
                        line.fluentPut("from", itemMapping.get(line.getString("from")));
                        line.fluentPut("to", itemMapping.get(line.getString("to")));
                    });
                    c.fluentPut("lineList", (Object)lineList);
                    newItem.setC(c);
                    break;
                }
            }
            newCustomItemList.add(newItem);
        }
        return newCustomItemList;
    }

    private List<DimensionModel> buildNewDims(List<DimensionModel> oldDims, Map<String, String> itemMapping) {
        ArrayList<DimensionModel> newDims = new ArrayList<DimensionModel>(oldDims.size());
        oldDims.forEach(dimensionModel -> {
            if (!dimensionModel.getS().booleanValue()) {
                String oldItemId = dimensionModel.getRelSelectId();
                String newItemId = (String)itemMapping.get(oldItemId);
                dimensionModel.setRelSelectId(newItemId);
            }
            newDims.add((DimensionModel)dimensionModel);
        });
        return newDims;
    }

    private static class InnerClass {
        private static final AnalysisCanvasService instance = new AnalysisCanvasService();

        private InnerClass() {
        }
    }
}

