/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasShareRel;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;

public class AnalysisCanvasShareRelService {
    private static final String ENTITY_NAME = "eb_analysiscanvas_sha_rel";

    public static AnalysisCanvasShareRelService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasShareRelService() {
    }

    public List<AnalysisCanvasShareRel> queryByAncestor(long canvasId, List<Long> ancestors) {
        String selectFields = "id, canvasid, ancestor, descendant, distance";
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        qFilter.and(new QFilter("ancestor", "in", ancestors));
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public List<AnalysisCanvasShareRel> queryByDescendant(long canvasId, long descendant) {
        String selectFields = "id, canvasid, ancestor, descendant, distance";
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        qFilter.and(new QFilter("descendant", "=", (Object)descendant));
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public void save(long canvasId, long sharer, long receiver) {
        ArrayList<AnalysisCanvasShareRel> dataList = new ArrayList<AnalysisCanvasShareRel>(16);
        AnalysisCanvasShareRel rel = new AnalysisCanvasShareRel();
        rel.setCanvasId(canvasId);
        rel.setAncestor(sharer);
        rel.setDescendant(receiver);
        rel.setDistance(1L);
        dataList.add(rel);
        List<AnalysisCanvasShareRel> shareDescendants = this.queryByDescendant(canvasId, sharer);
        shareDescendants.forEach(d -> {
            AnalysisCanvasShareRel r = new AnalysisCanvasShareRel();
            r.setCanvasId(canvasId);
            r.setAncestor(d.getAncestor());
            r.setDescendant(receiver);
            r.setDistance(d.getDistance() + 1L);
            dataList.add(r);
        });
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dataList.stream().map(this::packageDynamicObject).toArray(DynamicObject[]::new)));
    }

    public void deleteByCanvasIds(List<Long> canvasIds) {
        QFilter qFilter = new QFilter("canvasid", "in", canvasIds);
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public void deleteByDescendant(long canvasId, List<Long> descendants) {
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        qFilter.and(new QFilter("descendant", "in", descendants));
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    private DynamicObject packageDynamicObject(AnalysisCanvasShareRel model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (IDUtils.isNull((Long)id)) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("canvasid", (Object)model.getCanvasId());
        dynamicObject.set("ancestor", (Object)model.getAncestor());
        dynamicObject.set("descendant", (Object)model.getDescendant());
        dynamicObject.set("distance", (Object)model.getDistance());
        return dynamicObject;
    }

    public AnalysisCanvasShareRel transToModel(DynamicObject dynamicObject) {
        AnalysisCanvasShareRel model = new AnalysisCanvasShareRel();
        model.setId(dynamicObject.getLong("id"));
        model.setCanvasId(dynamicObject.getLong("canvasid"));
        model.setAncestor(dynamicObject.getLong("ancestor"));
        model.setDescendant(dynamicObject.getLong("descendant"));
        model.setDistance(dynamicObject.getLong("distance"));
        return model;
    }

    private static class InnerClass {
        private static final AnalysisCanvasShareRelService instance = new AnalysisCanvasShareRelService();

        private InnerClass() {
        }
    }
}

