/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasCollectService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasShareRelService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasShare;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasShareRel;
import kd.epm.eb.common.utils.GlobalIdUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasShareService {
    private static final Log log = LogFactory.getLog(AnalysisCanvasService.class);
    private static final String ENTITY_NAME = "eb_analysiscanvas_share";

    public static AnalysisCanvasShareService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasShareService() {
    }

    public List<AnalysisCanvasShare> load(List<Long> ids) {
        String selectFields = "id, canvasid, sharers, receiver, look, status, reason, creatorid, createdate, sharedate";
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public Long queryCanvasId(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject data = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"canvasid", (QFilter[])new QFilter[]{qFilter});
        return data.getLong("canvasid");
    }

    public List<Long> querySuccessShareIds() {
        QFilter qFilter = new QFilter("receiver", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and("canvasid.share", "=", (Object)AnalysisCanvasConstants.ShareType.SELF.getValue());
        qFilter.and("status", "=", (Object)AnalysisCanvasConstants.ShareStatus.SUCCESS.getValue());
        DynamicObjectCollection data = QueryServiceHelper.query((String)ENTITY_NAME, (String)"canvasid", (QFilter[])new QFilter[]{qFilter});
        return data.stream().map(p -> p.getLong("canvasid")).collect(Collectors.toList());
    }

    public DynamicObjectCollection querySuccessReceiver(List<Long> canvasIds) {
        QFilter qFilter = new QFilter("canvasid", "in", canvasIds);
        qFilter.and("status", "=", (Object)AnalysisCanvasConstants.ShareStatus.SUCCESS.getValue());
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"receiver, canvasid", (QFilter[])new QFilter[]{qFilter});
    }

    public void updateLookStatus(Long canvasId) {
        QFilter qFilter = new QFilter("receiver", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and(new QFilter("canvasid", "=", (Object)canvasId));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"look", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject == null) {
            return;
        }
        dynamicObject.set("look", (Object)"1");
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void save(List<AnalysisCanvasShare> dataList) {
        try (TXHandle tx = TX.required();){
            try {
                long[] newIdArr = GlobalIdUtil.genGlobalLongIds((int)dataList.size());
                for (int i = 0; i < newIdArr.length; ++i) {
                    dataList.get(i).setId(newIdArr[i]);
                }
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dataList.stream().map(this::packageDynamicObject).toArray(DynamicObject[]::new)));
                dataList.stream().filter(d -> AnalysisCanvasConstants.ShareStatus.SUCCESS.getValue().equals(d.getStatus())).forEach(d -> AnalysisCanvasShareRelService.getInstance().save(d.getCanvasId(), d.getSharers(), d.getReceiver()));
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteByCanvasIds(List<Long> canvasIds) {
        QFilter qFilter = new QFilter("canvasid", "in", canvasIds);
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
        AnalysisCanvasShareRelService.getInstance().deleteByCanvasIds(canvasIds);
    }

    public void delete(Object[] idArr) {
        List<Long> ids = Arrays.stream(idArr).map(s -> Long.parseLong(s.toString())).collect(Collectors.toList());
        ArrayList deleteIds = new ArrayList(ids);
        List<AnalysisCanvasShare> dataList = this.load(ids);
        Map<Long, ArrayList> canvasMap = dataList.stream().collect(Collectors.toMap(AnalysisCanvasShare::getCanvasId, xva$0 -> Lists.newArrayList((Object[])new AnalysisCanvasShare[]{xva$0}), (o1, o2) -> {
            o1.addAll(o2);
            return o1;
        }));
        HashMap<Long, List> canvasSubSharerMap = new HashMap<Long, List>(16);
        HashMap<Long, List> canvasReceiverMap = new HashMap<Long, List>(16);
        canvasMap.forEach((canvasId, shareRecordList) -> {
            DynamicObjectCollection subShareRecords;
            List successRecordList = shareRecordList.stream().filter(d -> AnalysisCanvasConstants.ShareStatus.SUCCESS.getValue().equals(d.getStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(successRecordList)) {
                return;
            }
            List<Long> receiverList = successRecordList.stream().map(AnalysisCanvasShare::getReceiver).collect(Collectors.toList());
            ArrayList subSharerList = new ArrayList(receiverList);
            List<AnalysisCanvasShareRel> receiverShareRelList = AnalysisCanvasShareRelService.getInstance().queryByAncestor((long)canvasId, receiverList);
            List subReceiverList = receiverShareRelList.stream().map(AnalysisCanvasShareRel::getDescendant).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(subReceiverList)) {
                subSharerList.addAll(subReceiverList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(subShareRecords = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, sharers", (QFilter[])new QFilter[]{new QFilter("sharers", "in", subSharerList).and("canvasid", "=", canvasId)})))) {
                List subRecordIds = subShareRecords.stream().map(dyObj -> dyObj.getLong("id")).collect(Collectors.toList());
                deleteIds.addAll(subRecordIds);
            }
            canvasSubSharerMap.put((Long)canvasId, subSharerList);
            canvasReceiverMap.put((Long)canvasId, receiverList);
        });
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
                canvasReceiverMap.forEach((canvasId, receiverList) -> {
                    if (CollectionUtils.isEmpty((Collection)receiverList)) {
                        return;
                    }
                    ArrayList<Long> descendants = new ArrayList<Long>((Collection<Long>)receiverList);
                    AnalysisCanvasShareRelService.getInstance().deleteByDescendant((long)canvasId, (List<Long>)descendants);
                    QFilter collectFilter = null;
                    for (Long sharerId : receiverList) {
                        QFilter qFilter1 = new QFilter("canvas", "=", canvasId).and("creator", "=", (Object)sharerId);
                        if (collectFilter == null) {
                            collectFilter = qFilter1;
                            continue;
                        }
                        collectFilter.or(qFilter1);
                    }
                    if (collectFilter != null) {
                        AnalysisCanvasCollectService.getInstance().deleteByFilter(collectFilter);
                    }
                });
                canvasSubSharerMap.forEach((canvasId, subSharerList) -> {
                    if (CollectionUtils.isEmpty((Collection)subSharerList)) {
                        return;
                    }
                    ArrayList<Long> descendants = new ArrayList<Long>((Collection<Long>)subSharerList);
                    AnalysisCanvasShareRelService.getInstance().deleteByDescendant((long)canvasId, (List<Long>)descendants);
                    QFilter collectFilter = null;
                    for (Long sharerId : subSharerList) {
                        QFilter qFilter1 = new QFilter("canvas", "=", canvasId).and("creator", "=", (Object)sharerId);
                        if (collectFilter == null) {
                            collectFilter = qFilter1;
                            continue;
                        }
                        collectFilter.or(qFilter1);
                    }
                    if (collectFilter != null) {
                        AnalysisCanvasCollectService.getInstance().deleteByFilter(collectFilter);
                    }
                });
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public List<Long> deleteCollectQFilter(Long canvasId, Long creatorId) {
        QFilter canvasFilter = new QFilter("canvasid", "=", (Object)canvasId);
        canvasFilter.and("status", "=", (Object)AnalysisCanvasConstants.ShareStatus.SUCCESS.getValue());
        DynamicObjectCollection data = QueryServiceHelper.query((String)ENTITY_NAME, (String)"receiver", (QFilter[])new QFilter[]{canvasFilter});
        List<Long> receiverId = data.stream().map(e -> e.getLong("receiver")).collect(Collectors.toList());
        receiverId.add(creatorId);
        return receiverId;
    }

    private DynamicObject packageDynamicObject(AnalysisCanvasShare model) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("id", (Object)model.getId());
        dynamicObject.set("canvasid", (Object)model.getCanvasId());
        dynamicObject.set("sharers", (Object)model.getSharers());
        dynamicObject.set("receiver", (Object)model.getReceiver());
        dynamicObject.set("look", (Object)model.getLook());
        dynamicObject.set("status", (Object)model.getStatus());
        dynamicObject.set("reason", (Object)model.getReason());
        Date now = TimeServiceHelper.now();
        dynamicObject.set("creatorid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createdate", (Object)now);
        dynamicObject.set("sharedate", (Object)now);
        return dynamicObject;
    }

    public AnalysisCanvasShare transToModel(DynamicObject dynamicObject) {
        AnalysisCanvasShare model = new AnalysisCanvasShare();
        model.setId(dynamicObject.getLong("id"));
        model.setCanvasId(dynamicObject.getLong("canvasid"));
        model.setSharers(dynamicObject.getLong("sharers"));
        model.setReceiver(dynamicObject.getLong("receiver"));
        model.setLook(dynamicObject.getString("look"));
        model.setStatus(dynamicObject.getString("status"));
        model.setReason(dynamicObject.getString("reason"));
        model.setCreatorId(dynamicObject.getLong("creatorid"));
        model.setCreateDate(dynamicObject.getDate("createdate"));
        model.setShareDate(dynamicObject.getDate("sharedate"));
        return model;
    }

    private static class InnerClass {
        private static final AnalysisCanvasShareService instance = new AnalysisCanvasShareService();

        private InnerClass() {
        }
    }
}

