/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasUserSel;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasUserSelService {
    private static final Log log = LogFactory.getLog(AnalysisCanvasUserSelService.class);
    private static final String ENTITY_NAME = "eb_analysiscanvas_usersel";

    public static AnalysisCanvasUserSelService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasUserSelService() {
    }

    public List<AnalysisCanvasUserSel> queryCurrentCanvas(Long canvasId) {
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,canvasid,modelid,datasetid,dimmember,dimview, modifierid, modifydate", (QFilter[])qFilter.toArray(), (String)"id desc");
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public AnalysisCanvasUserSel queryOtherCanvas(Long canvasId) {
        QFilter qFilter = new QFilter("canvasid", "!=", (Object)canvasId);
        qFilter.and(new QFilter("modifierid", "=", (Object)RequestContext.get().getCurrUserId()));
        return this.queryOne(qFilter);
    }

    public AnalysisCanvasUserSel queryByDataset(Long canvasId, Long datasetId) {
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        qFilter.and(new QFilter("datasetid", "=", (Object)datasetId));
        return this.queryOne(qFilter);
    }

    public AnalysisCanvasUserSel queryOne(QFilter qFilter) {
        DynamicObjectCollection data = QueryServiceHelper.query((String)"QueryServiceHelper.eb_analysiscanvas_usersel", (String)ENTITY_NAME, (String)"id,canvasid,modelid,datasetid,dimmember,dimview, modifierid, modifydate", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        return data.size() == 0 ? null : this.transToModel((DynamicObject)data.get(0));
    }

    public Long getId(AnalysisCanvasUserSel model) {
        QFilter qFilter = new QFilter("canvasid", "=", (Object)model.getCanvasId());
        qFilter.and(new QFilter("datasetid", "=", (Object)model.getDataSetId()));
        DynamicObject data = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id", (QFilter[])qFilter.toArray());
        if (data == null) {
            return null;
        }
        return data.getLong("id");
    }

    public void save(AnalysisCanvasUserSel model) {
        model.setId(this.getId(model));
        DynamicObject dynamicObject = this.packageDynamicObject(model);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void delete(List<Long> canvasIds) {
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("canvasid", "in", canvasIds)});
    }

    private AnalysisCanvasUserSel transToModel(DynamicObject dynamicObject) {
        AnalysisCanvasUserSel model = new AnalysisCanvasUserSel();
        model.setId(dynamicObject.getLong("id"));
        model.setCanvasId(dynamicObject.getLong("canvasid"));
        model.setModelId(dynamicObject.getLong("modelid"));
        model.setDataSetId(dynamicObject.getLong("datasetid"));
        model.setDimMember(dynamicObject.getString("dimmember"));
        model.setDimView(dynamicObject.getString("dimview"));
        model.setModifierId(dynamicObject.getLong("modifierid"));
        model.setModifyDate(dynamicObject.getDate("modifydate"));
        return model;
    }

    private DynamicObject packageDynamicObject(AnalysisCanvasUserSel model) {
        Long id = model.getId();
        DynamicObject dynamicObject = IDUtils.isNull((Long)id) ? BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME) : BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        dynamicObject.set("canvasid", (Object)model.getCanvasId());
        dynamicObject.set("modelid", (Object)model.getModelId());
        dynamicObject.set("datasetid", (Object)model.getDataSetId());
        dynamicObject.set("dimmember", (Object)model.getDimMember());
        dynamicObject.set("dimview", (Object)model.getDimView());
        dynamicObject.set("modifierid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifydate", (Object)model.getModifyDate());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final AnalysisCanvasUserSelService instance = new AnalysisCanvasUserSelService();

        private InnerClass() {
        }
    }
}

