/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.ConfigurationUtil;
import kd.epm.eb.business.bizrule.RuleFindService;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasUtils {
    private static final boolean ANALYSIS_CANVAS_COMPRESS = ConfigurationUtil.getBoolean((String)"epm.eb.formplugin.analysiscanvas.compress", (Boolean)true);
    private static final String PREFIX = "base64";

    public static boolean checkPermRead(long modelId, long datasetId, Map<String, String> memberInfo, Map<String, Long> viewMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        long bizCtrlRangeId = modelCache.getBusModelByDataSet(Long.valueOf(datasetId));
        HashMap permissionMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String string : memberInfo.keySet()) {
            Long viewId = MapUtils.isNotEmpty(viewMap) ? viewMap.get(string) : Long.valueOf(0L);
            Set permMemberNumbers = DimMembPermHelper.getPermMembNumbers((String)string, (Long)modelId, (Long)bizCtrlRangeId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            permissionMap.put(string, permMemberNumbers);
        }
        for (Map.Entry entry : memberInfo.entrySet()) {
            Sets.SetView hasPermSet;
            String dimNumber = (String)entry.getKey();
            String memNumber = (String)entry.getValue();
            Set permMembNumbers = (Set)permissionMap.get(dimNumber);
            if (permMembNumbers == null || !CollectionUtils.isEmpty((Collection)(hasPermSet = Sets.intersection((Set)Sets.newHashSet((Object[])new String[]{memNumber}), (Set)permMembNumbers)))) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709 %1 \u7ef4\u5ea6\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"AnalysisService_21", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
        }
        return true;
    }

    public static RuleDto getCellRule(long modelId, long datasetId, Map<String, Long> viewMap, Map<String, String> memberInfo) {
        return RuleFindService.getInstance().findRuleByCell(modelId, datasetId, viewMap, memberInfo);
    }

    public static String compressData(String propsData) {
        byte[] bb;
        if (!ANALYSIS_CANVAS_COMPRESS) {
            return propsData;
        }
        try {
            bb = Base64.getEncoder().encode(GZIPUtils.compress((String)propsData));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return PREFIX + new String(bb);
    }

    public static String unCompressData(String item) {
        if (item.startsWith(PREFIX)) {
            byte[] bs = item.substring(6).getBytes(StandardCharsets.UTF_8);
            return new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(bs)));
        }
        return item;
    }
}

