/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasVar;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasVarService {
    private static final String ENTITY_NAME = "eb_analysiscanvas_var";

    public static AnalysisCanvasVarService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasVarService() {
    }

    public List<AnalysisCanvasVar> query(Long canvasId, Long itemId) {
        DynamicObjectCollection dataList;
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId);
        if (itemId != null) {
            qFilter.and("itemid", "=", (Object)itemId);
        }
        if (CollectionUtils.isEmpty((Collection)(dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, canvasid, itemid, dimension, variable, variablejson", (QFilter[])qFilter.toArray())))) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public void copyVar(Long oldCanvasId, Long newCanvasId, Map<String, String> itemMapping) {
        if (itemMapping.isEmpty()) {
            return;
        }
        List<AnalysisCanvasVar> data = this.query(oldCanvasId, null);
        data.forEach(var -> {
            var.setCanvasId(newCanvasId);
            var.setItemId(IDUtils.toLong(itemMapping.get(var.getItemId().toString())));
        });
        DynamicObject[] vars = (DynamicObject[])data.stream().map(this::copyPackageDynamicObject).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])vars);
    }

    public void save(Long canvasId, Long itemId, DynamicObjectCollection variables) {
        DynamicObject[] dynamicObjects = (DynamicObject[])variables.stream().map(v -> {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            data.set("canvasid", (Object)canvasId);
            data.set("itemid", (Object)itemId);
            data.set("dimension", (Object)v.getString("number"));
            data.set("variable", (Object)v.getString("variablenumber"));
            data.set("variablejson", (Object)v.getString("variablejson"));
            return data;
        }).toArray(DynamicObject[]::new);
        QFilter qFilter = new QFilter("canvasid", "=", (Object)canvasId).and("itemid", "=", (Object)itemId);
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteNotExistItem(List<CustomItem> itemList, Long canvasId) {
        Set itemIds = itemList.stream().map(item -> IDUtils.toLong((Object)item.getId())).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(itemIds)) {
            QFilter qFilter = new QFilter("itemid", "not in", itemIds);
            qFilter.and("canvasid", "=", (Object)canvasId);
            DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
        }
    }

    public void deleteByCanvasIds(List<Long> canvasIds) {
        QFilter qFilter = new QFilter("canvasid", "in", canvasIds);
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{qFilter});
    }

    public AnalysisCanvasVar transToModel(DynamicObject dynamicObject) {
        AnalysisCanvasVar model = new AnalysisCanvasVar();
        model.setId(dynamicObject.getLong("id"));
        model.setCanvasId(dynamicObject.getLong("canvasid"));
        model.setItemId(dynamicObject.getLong("itemid"));
        model.setDimension(dynamicObject.getString("dimension"));
        model.setVariable(dynamicObject.getString("variable"));
        model.setVariableJson(dynamicObject.getString("variablejson"));
        return model;
    }

    private DynamicObject copyPackageDynamicObject(AnalysisCanvasVar var) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("canvasid", (Object)var.getCanvasId());
        dynamicObject.set("itemid", (Object)var.getItemId());
        dynamicObject.set("dimension", (Object)var.getDimension());
        dynamicObject.set("variable", (Object)var.getVariable());
        dynamicObject.set("variablejson", (Object)var.getVariableJson());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final AnalysisCanvasVarService instance = new AnalysisCanvasVarService();

        private InnerClass() {
        }
    }
}

