/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.List;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.item.ItemHelper;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.common.eventbus.event.DataSetAddDimEvent;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCanvasDatasetService;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisEventListener {
    private static final Log log = LogFactory.getLog(AnalysisEventListener.class);

    public static AnalysisEventListener getInstance() {
        return InnerClass.instance;
    }

    private AnalysisEventListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void dataSetAddDimListener(DataSetAddDimEvent event) {
        Long datasetId = event.getDataSetId();
        List canvasDsList = AnalysisCanvasDatasetService.getInstance().loadByDataset(datasetId);
        if (CollectionUtils.isEmpty((Collection)canvasDsList)) {
            return;
        }
        Collection dimNumbers = event.getDims().values();
        DLock dLock = DLock.create((String)("bgm/analysis/datasetAddDim/" + datasetId));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            log.error("dlock timeout datasetId:{}", (Object)datasetId);
        }
        try {
            canvasDsList.forEach(ds -> {
                Long canvasId = ds.getCanvasId();
                AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(canvasId);
                List itemList = JSON.parseArray((String)canvas.getItem(), CustomItem.class);
                if (CollectionUtils.isEmpty((Collection)itemList)) {
                    return;
                }
                ItemHelper.getInstance().addNoneMember(datasetId, itemList, dimNumbers);
                AnalysisCanvasService.getInstance().updateCanvas(canvasId, itemList, null, null);
            });
        }
        finally {
            dLock.unlock();
        }
    }

    private static class InnerClass {
        private static final AnalysisEventListener instance = new AnalysisEventListener();

        private InnerClass() {
        }
    }
}

