/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxDataService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasBoxService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisLogService;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvas;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBoxData;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.item.ItemHelper;
import kd.epm.eb.business.analysiscanvas.item.ItemService;
import kd.epm.eb.business.analysiscanvas.item.ReportItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.model.VarModel;
import kd.epm.eb.business.analysiscanvas.query.AnalysisPools;
import kd.epm.eb.business.analysiscanvas.query.QueryService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.business.forecast.WriteService;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCanvasDatasetService;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.biztemplate.SaveBizTemplate;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AnalysisService {
    private static final Log log = LogFactory.getLog(AnalysisService.class);

    public static AnalysisService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisService() {
    }

    public void calc(long boxId, List<CustomItem> itemList, AnalysisCanvasConstants.CalcType reqCalcType, AnalysisCanvasConstants.OptType optType, IFormView formView) {
        String traceId = RequestContext.get().getTraceId();
        String logPrefix = "AnalysisCanvas calc traceId:" + traceId;
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        AnalysisCanvasConstants.CalcType calcType = reqCalcType == null ? AnalysisCanvasConstants.CalcType.find(formView.getPageCache().get("calcType")) : reqCalcType;
        JSONObject calcParam = this.getCalcParam(formView);
        calcParam.put("traceId", (Object)traceId);
        AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(boxId);
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        log.info("{} boxId:{} canvasId:{} boxName:{} calcType:{} optType:{} itemSize:{}", new Object[]{logPrefix, boxId, canvasBox.getCanvasId(), canvasBox.getName(), calcType.name(), optType.name(), itemList.size()});
        ModelHelper.resetItems(itemList);
        ItemService filterItemService = ItemService.getInstance("select");
        ItemService sliderItemService = ItemService.getInstance("slider");
        ItemService reportItemService = ItemService.getInstance("report");
        ItemService dupontItemService = ItemService.getInstance("dupontnode");
        ItemService table2ItemService = ItemService.getInstance("table2");
        ItemService predictItemService = ItemService.getInstance("predict");
        Stopwatch stepStopwatch = Stopwatch.createStarted();
        List<CustomItem> filterItemList = ModelHelper.getItems("select", itemList);
        if (ModelHelper.needSaveIntoBox(optType)) {
            filterItemService.saveDataIntoBox(canvasBox, filterItemList, formView);
        }
        log.info("{} filterItemList.saveDataIntoBox size:{} cost:{}ms", new Object[]{logPrefix, filterItemList.size(), stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stepStopwatch.reset().start();
        HashMap<String, ValueDto> calcChangeMembers = new HashMap<String, ValueDto>(20);
        List<CustomItem> sliderItemList = ModelHelper.getItems("slider", itemList);
        if (CollectionUtils.isNotEmpty(sliderItemList) && !ModelHelper.isBaseBox(canvasBox) && ModelHelper.isCalcQuery(calcType) && AnalysisCanvasConstants.OptType.CALC == optType) {
            sliderItemService.processItemVar(canvasBox, sliderItemList, filterItemList, calcChangeMembers, formView);
        }
        log.info("{} sliderItemList.processItemVar size:{} cost:{}ms", new Object[]{logPrefix, sliderItemList.size(), stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stepStopwatch.reset().start();
        List<CustomItem> reportItemList = ModelHelper.getItems("report", itemList);
        if (CollectionUtils.isNotEmpty(reportItemList) && !ModelHelper.isBaseBox(canvasBox) && ModelHelper.isCalcQuery(calcType) && AnalysisCanvasConstants.OptType.CALC == optType) {
            reportItemService.processItemVar(canvasBox, reportItemList, filterItemList, calcChangeMembers, formView);
        }
        log.info("{} reportItemList.processItemVar size:{} cost:{}ms", new Object[]{logPrefix, reportItemList.size(), stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stepStopwatch.reset().start();
        List<CustomItem> dupontItemList = ModelHelper.getItems("dupontnode", itemList);
        if (CollectionUtils.isNotEmpty(dupontItemList) && !ModelHelper.isBaseBox(canvasBox) && ModelHelper.isCalcQuery(calcType) && AnalysisCanvasConstants.OptType.CALC == optType) {
            dupontItemService.processItemVar(canvasBox, dupontItemList, filterItemList, calcChangeMembers, formView);
        }
        log.info("{} dupontItemList.processItemVar size:{} cost:{}ms", new Object[]{logPrefix, dupontItemList.size(), stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stepStopwatch.reset().start();
        List<CustomItem> table2ItemList = ModelHelper.getItems("table2", itemList);
        if (CollectionUtils.isNotEmpty(table2ItemList) && !ModelHelper.isBaseBox(canvasBox) && ModelHelper.isCalcQuery(calcType) && AnalysisCanvasConstants.OptType.CALC == optType) {
            table2ItemService.processItemVar(canvasBox, table2ItemList, filterItemList, calcChangeMembers, formView);
        }
        log.info("{} table2ItemList.processItemVar size:{} cost:{}ms", new Object[]{logPrefix, table2ItemList.size(), stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stepStopwatch.reset().start();
        List<CustomItem> predictItemList = ModelHelper.getItems("predict", itemList);
        if (CollectionUtils.isEmpty(predictItemList)) {
            HashMap<String, String> boxData = new HashMap<String, String>(1);
            Map<String, AnalysisCanvasBoxData> boxDataMap = AnalysisCanvasBoxDataService.getInstance().querySandboxData(boxId, Collections.singletonList(String.valueOf(10000L)));
            if (MapUtils.isNotEmpty(boxDataMap)) {
                boxData.put(String.valueOf(10000L), boxDataMap.get(String.valueOf(10000L)).getData());
            }
            predictItemList = new ArrayList<CustomItem>(1);
            predictItemService.getDataFromBox(predictItemList, canvasBox, filterItemList, boxData, formView);
            itemList.addAll(predictItemList);
        }
        if (CollectionUtils.isNotEmpty(predictItemList) && !ModelHelper.isBaseBox(canvasBox) && ModelHelper.isCalcQuery(calcType) && AnalysisCanvasConstants.OptType.CALC == optType) {
            predictItemService.processItemVar(canvasBox, predictItemList, filterItemList, calcChangeMembers, formView);
        }
        log.info("{} predictItemList.processItemVar size:{} cost:{}ms", new Object[]{logPrefix, predictItemList.size(), stepStopwatch.elapsed(TimeUnit.MILLISECONDS)});
        stepStopwatch.reset().start();
        ModelHelper.refreshChangeMembers(sliderItemList, calcChangeMembers);
        ModelHelper.refreshChangeMembers(reportItemList, calcChangeMembers);
        ModelHelper.refreshChangeMembers(dupontItemList, calcChangeMembers);
        ModelHelper.refreshChangeMembers(table2ItemList, calcChangeMembers);
        ModelHelper.refreshChangeMembers(predictItemList, calcChangeMembers);
        Future itemFuture = AnalysisPools.ITEM_CALC_POOL.submit(() -> {
            Stopwatch itemStopwatch = Stopwatch.createStarted();
            ArrayList<QueryDto> queryList = new ArrayList<QueryDto>(16);
            ItemHelper.getInstance().buildQueryDim(canvasBox, itemList, filterItemList, queryList, optType, calcParam, formView);
            log.info("{} buildQueryDim cost:{}ms", (Object)logPrefix, (Object)itemStopwatch.elapsed(TimeUnit.MILLISECONDS));
            itemStopwatch.reset().start();
            QueryService.getInstance().calc(canvasBox, calcType, optType, queryList, calcParam);
            log.info("{} querySize:{} cost:{}ms", new Object[]{logPrefix, queryList.size(), itemStopwatch.elapsed(TimeUnit.MILLISECONDS)});
            itemStopwatch.reset().start();
            ItemHelper.getInstance().processQueryResult(canvasBox, itemList, filterItemList, queryList, optType, calcParam, formView);
            log.info("{} processQueryResult cost:{}ms", (Object)logPrefix, (Object)itemStopwatch.elapsed(TimeUnit.MILLISECONDS));
            itemStopwatch.reset().start();
            return null;
        }, RequestContext.getOrCreate());
        Future reportItemFuture = AnalysisPools.ITEM_CALC_POOL.submit(() -> {
            Stopwatch itemStopwatch = Stopwatch.createStarted();
            ((ReportItemService)reportItemService).calc(reportItemList, canvasBox, filterItemList, calcType, optType, calcParam, formView);
            log.info("{} reportItemList.calc size:{} cost:{}ms", new Object[]{logPrefix, reportItemList.size(), itemStopwatch.elapsed(TimeUnit.MILLISECONDS)});
            itemStopwatch.reset().start();
            return null;
        }, RequestContext.getOrCreate());
        try {
            itemFuture.get(5L, TimeUnit.MINUTES);
            reportItemFuture.get(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AnalysisCanvasException(e, new ErrorCode("AnalysisService", e.getMessage()), e.getMessage());
        }
        itemList.removeIf(item -> "predict".equals(item.getType()));
        log.info("{} complete cost:{}ms", (Object)logPrefix, (Object)totalStopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private JSONObject getCalcParam(IFormView formView) {
        String paramStr = formView.getPageCache().get("calcParam");
        if (StringUtils.isNotBlank((CharSequence)paramStr)) {
            formView.getPageCache().remove("calcParam");
            return JSON.parseObject((String)paramStr);
        }
        return new JSONObject();
    }

    public void getItemDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, IFormView formView) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map<String, String> boxData = AnalysisCanvasBoxDataService.getInstance().load(canvasBox.getId());
        if (boxData.isEmpty()) {
            List<CustomItem> filterItemList = ModelHelper.getItems("select", itemList);
            ModelHelper.buildOption(filterItemList, formView);
        } else {
            ItemHelper.getInstance().getDataFromBox(canvasBox, itemList, boxData, formView);
        }
    }

    public void coverData(long canvasId, long boxId, IFormView formView) {
        String traceId = RequestContext.get().getTraceId();
        String logPrefix = "AnalysisCanvas coverData traceId:" + traceId;
        String canvasName = "";
        String canvasNumber = "GPT_FORECAST";
        AnalysisCanvas canvas = AnalysisCanvasService.getInstance().load(canvasId);
        List<CustomItem> itemList = new ArrayList<CustomItem>(1);
        if (canvas != null) {
            canvasName = canvas.getName();
            canvasNumber = canvas.getNumber();
            itemList = JSON.parseArray((String)canvas.getItem(), CustomItem.class);
        }
        ModelHelper.resetItems(itemList);
        AnalysisCanvasBox canvasBox = AnalysisCanvasBoxService.getInstance().load(boxId);
        Map<String, String> boxData = AnalysisCanvasBoxDataService.getInstance().load(boxId);
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        log.info("{} start canvas:{}[{}] box:{}[{}]", new Object[]{logPrefix, canvasNumber, canvasId, canvasBox.getName(), boxId});
        ItemService filterItemService = ItemService.getInstance("select");
        List<CustomItem> filterItemList = ModelHelper.getItems("select", itemList);
        filterItemService.getDataFromBox(filterItemList, canvasBox, null, boxData, formView);
        ItemService sliderItemService = ItemService.getInstance("slider");
        List<CustomItem> sliderItemList = ModelHelper.getItems("slider", itemList);
        sliderItemService.getDataFromBox(sliderItemList, canvasBox, filterItemList, boxData, formView);
        ItemService reportItemService = ItemService.getInstance("report");
        List<CustomItem> reportItemList = ModelHelper.getItems("report", itemList);
        reportItemService.getDataFromBox(reportItemList, canvasBox, filterItemList, boxData, formView);
        ItemService dupontItemService = ItemService.getInstance("dupontnode");
        List<CustomItem> dupontItemList = ModelHelper.getItems("dupontnode", itemList);
        dupontItemService.getDataFromBox(dupontItemList, canvasBox, filterItemList, boxData, formView);
        ItemService table2ItemService = ItemService.getInstance("table2");
        List<CustomItem> table2ItemList = ModelHelper.getItems("table2", itemList);
        table2ItemService.getDataFromBox(table2ItemList, canvasBox, filterItemList, boxData, formView);
        ItemService predictItemService = ItemService.getInstance("predict");
        ArrayList<CustomItem> predictItemList = new ArrayList<CustomItem>(1);
        predictItemService.getDataFromBox(predictItemList, canvasBox, filterItemList, boxData, formView);
        List<SaveDto> sliderCoverData = sliderItemService.buildCoverData(canvasBox, sliderItemList, filterItemList, formView);
        List<SaveDto> reportCoverData = reportItemService.buildCoverData(canvasBox, reportItemList, filterItemList, formView);
        List<SaveDto> dupontCoverData = dupontItemService.buildCoverData(canvasBox, dupontItemList, filterItemList, formView);
        List<SaveDto> table2CoverData = table2ItemService.buildCoverData(canvasBox, table2ItemList, filterItemList, formView);
        List<SaveDto> predictCoverData = predictItemService.buildCoverData(canvasBox, predictItemList, filterItemList, formView);
        AtomicInteger coverDataCount = new AtomicInteger(0);
        List<SaveDto> coverDataMap = this.mergeCoverData(sliderCoverData, reportCoverData, dupontCoverData, table2CoverData, predictCoverData);
        log.info("{} buildCoverData cost:{}ms", (Object)logPrefix, (Object)totalStopwatch.elapsed(TimeUnit.MILLISECONDS));
        coverDataMap.forEach(saveDto -> {
            Long modelId = saveDto.getModelId();
            Long datasetId = saveDto.getDatasetId();
            Map<String, Long> viewMap = saveDto.getViewMap();
            List<BGCell> datas = saveDto.getCells();
            Stopwatch started = Stopwatch.createStarted();
            log.info("{} doCover datas:{}", (Object)logPrefix, datas);
            if (CollectionUtils.isEmpty(datas)) {
                return;
            }
            coverDataCount.addAndGet(datas.size());
            OlapTraceServiceHelper.setTraceOpInfo((String)canvasBox.getName());
            OlapDataAuditService.getInstance().setOperationContextDefaultFormId(OlapDataAuditEventEnum.AnalysisCanvas.getDesc());
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.AnalysisCanvas));
            SaveRequest request = new SaveRequest(modelId, datasetId, datas, viewMap);
            SaveBizTemplate saveBizTemplate = SaveBizTemplate.newInstance();
            List changedCells = saveBizTemplate.doService(request);
            log.info("{} doCoverSave modelId:{} datasetId:{} dataSize:{} cost:{}ms", new Object[]{logPrefix, modelId, datasetId, datas.size(), started.elapsed(TimeUnit.MILLISECONDS)});
            started.reset().start();
            RuleExecutionService.getInstance().executeRuleChain(null, datasetId, modelId, changedCells, RuleExecuteTypeEnum.ANALYSIS.getType());
            log.info("{} executeRuleChain modelId:{} datasetId:{} cost:{}ms", new Object[]{logPrefix, modelId, datasetId, started.elapsed(TimeUnit.MILLISECONDS)});
            started.reset().start();
        });
        List canvasDatasetList = AnalysisCanvasDatasetService.getInstance().loadByBox(Long.valueOf(boxId));
        canvasDatasetList.forEach(ds -> {
            long datasetId = ds.getDataset();
            Long modelId = this.getModelIdByDataset(datasetId);
            if (modelId == null) {
                return;
            }
            Stopwatch started = Stopwatch.createStarted();
            String sandboxName = ShrekOlapUtils.getSandboxName((int)ds.getSeq());
            OlapManager.getInstance().dropSandbox(modelId.longValue(), datasetId, sandboxName);
            log.info("{} reset analysisCube:{} cost:{}ms", new Object[]{logPrefix, ds.getAnalysisCubeNum(), started.elapsed(TimeUnit.MILLISECONDS)});
            started.reset().start();
        });
        AnalysisCubeService.getInstance().syncForSaveBox(canvasId, boxId);
        sliderItemList.forEach(item -> {
            VarModel varModel = ModelHelper.getModel(item, VarModel.class);
            varModel.setChangeMembers(null);
            ModelHelper.updateModel(item, varModel);
        });
        reportItemList.forEach(item -> {
            ReportModel reportModel = ModelHelper.getModel(item, ReportModel.class);
            reportModel.setChangeMembers(null);
            ModelHelper.updateModel(item, reportModel);
        });
        dupontItemList.forEach(item -> {
            DupontModel dupontModel = ModelHelper.getModel(item, DupontModel.class);
            dupontModel.setChangeMembers(null);
            ModelHelper.updateModel(item, dupontModel);
        });
        table2ItemList.forEach(item -> {
            TableModel tableModel = ModelHelper.getModel(item, TableModel.class);
            tableModel.setChangeMembers(null);
            ModelHelper.updateModel(item, tableModel);
        });
        WriteService.getInstance().clearSandboxPredData(canvasId, boxId);
        Stopwatch started = Stopwatch.createStarted();
        this.calc(boxId, itemList, AnalysisCanvasConstants.CalcType.BASE, AnalysisCanvasConstants.OptType.CALC, formView);
        log.info("{} refresh analysisBox cost:{}ms", (Object)logPrefix, (Object)started.elapsed(TimeUnit.MILLISECONDS));
        started.reset().start();
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u8986\u76d6\u57fa\u51c6\u6570\u636e", "AnalysisService_5", "epm-eb-business");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u8986\u76d6\u4f7f\u7528\u7684\u6570\u636e\uff1a%1$s[%2$s]\uff0c\u6c99\u76d8\uff1a%3$s\uff0c\u6570\u636e\u91cf\uff1a%4$s", "AnalysisService_6", "epm-eb-business");
        AnalysisLogService.getInstance().writeOperateLog(formView, "over", opName, opDesc, new String[]{canvasName, canvasNumber, canvasBox.getName(), String.valueOf(coverDataCount.get())});
        log.info("{} complete canvas:{}[{}] box:{}[{}] cost:{}ms", new Object[]{logPrefix, canvasNumber, canvasId, canvasBox.getName(), boxId, totalStopwatch.elapsed(TimeUnit.MILLISECONDS)});
    }

    private Long getModelIdByDataset(long datasetId) {
        DynamicObject dyObject = BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset");
        if (dyObject == null) {
            return null;
        }
        return dyObject.getLong("model.id");
    }

    private List<SaveDto> mergeCoverData(@NotNull List<SaveDto> sliderCoverData, @NotNull List<SaveDto> reportCoverData, @NotNull List<SaveDto> dupontCoverData, @NotNull List<SaveDto> table2CoverData, @NotNull List<SaveDto> forecastCoverData) {
        ArrayList<SaveDto> coverData = new ArrayList<SaveDto>(sliderCoverData);
        if (CollectionUtils.isNotEmpty(reportCoverData)) {
            reportCoverData.forEach(e -> {
                Optional<SaveDto> optional = coverData.stream().filter(p -> p.getDatasetId().equals(e.getDatasetId()) && p.getViewId().equals(e.getViewId())).findFirst();
                if (optional.isPresent()) {
                    optional.get().getCells().addAll(e.getCells());
                } else {
                    coverData.add((SaveDto)e);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(dupontCoverData)) {
            dupontCoverData.forEach(e -> {
                Optional<SaveDto> optional = coverData.stream().filter(p -> p.getDatasetId().equals(e.getDatasetId()) && p.getViewId().equals(e.getViewId())).findFirst();
                if (optional.isPresent()) {
                    optional.get().getCells().addAll(e.getCells());
                } else {
                    coverData.add((SaveDto)e);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(table2CoverData)) {
            table2CoverData.forEach(e -> {
                Optional<SaveDto> optional = coverData.stream().filter(p -> p.getDatasetId().equals(e.getDatasetId()) && p.getViewId().equals(e.getViewId())).findFirst();
                if (optional.isPresent()) {
                    optional.get().getCells().addAll(e.getCells());
                } else {
                    coverData.add((SaveDto)e);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(forecastCoverData)) {
            forecastCoverData.forEach(e -> {
                Optional<SaveDto> optional = coverData.stream().filter(p -> p.getDatasetId().equals(e.getDatasetId()) && p.getViewId().equals(e.getViewId())).findFirst();
                if (optional.isPresent()) {
                    optional.get().getCells().addAll(e.getCells());
                } else {
                    coverData.add((SaveDto)e);
                }
            });
        }
        return coverData;
    }

    private static class InnerClass {
        private static final AnalysisService instance = new AnalysisService();

        private InnerClass() {
        }
    }
}

