/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasConstants;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.item.ItemService;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.query.IDataService;
import kd.epm.eb.business.analysiscanvas.query.QueryService;
import kd.epm.eb.business.analysiscanvas.query.dto.QueryDto;

public abstract class AbstractItemService
implements ItemService {
    @Override
    public void buildQueryDim(AnalysisCanvasBox canvasBox, String itemType, List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam, IFormView formView) {
        IDataService dataService = IDataService.getInstance(itemType, canvasBox, formView);
        if (dataService == null) {
            return;
        }
        dataService.buildQueryDim(itemList, filterItemList, dtoList, optType, calcParam);
    }

    @Override
    public void processQueryResult(AnalysisCanvasBox canvasBox, String itemType, List<CustomItem> itemList, List<CustomItem> filterItemList, List<QueryDto> dtoList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam, IFormView formView) {
        IDataService dataService = IDataService.getInstance(itemType, canvasBox, formView);
        if (dataService == null) {
            return;
        }
        dataService.processQueryResult(itemList, filterItemList, dtoList, optType, calcParam);
        this.afterProcessQueryResult(canvasBox, itemList, optType, calcParam);
        if (ModelHelper.needSaveIntoBox(optType)) {
            this.saveDataIntoBox(canvasBox, itemList, formView);
        }
    }

    protected void afterProcessQueryResult(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, AnalysisCanvasConstants.OptType optType, JSONObject calcParam) {
    }

    void queryBaseValue(CustomItem item, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, IFormView formView) {
        AnalysisCanvasConstants.CalcType calcType = AnalysisCanvasConstants.CalcType.BASE;
        AnalysisCanvasConstants.OptType optType = AnalysisCanvasConstants.OptType.CALC;
        ArrayList<QueryDto> queryList = new ArrayList<QueryDto>(16);
        this.buildQueryDim(canvasBox, item.getType(), Collections.singletonList(item), filterItemList, queryList, optType, null, formView);
        QueryService.getInstance().calc(canvasBox, calcType, optType, queryList, null);
        this.processQueryResult(canvasBox, item.getType(), Collections.singletonList(item), filterItemList, queryList, optType, null, formView);
    }

    protected void setOtherDim(List<DimensionModel> dims, Map<String, String> filterDim, Map<String, String> queryDim) {
        dims.forEach(dimModel -> {
            String memNumber;
            String dimNumber = dimModel.getDim();
            if (dimModel.getS().booleanValue()) {
                MemberModel member = dimModel.getMems().get(0);
                memNumber = member.getNum();
            } else {
                memNumber = (String)filterDim.get(dimNumber);
            }
            queryDim.put(dimNumber, memNumber);
        });
    }
}

