/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.analysiscanvas.item;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.entity.AnalysisCanvasBox;
import kd.epm.eb.business.analysiscanvas.item.AbstractItemService;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.BizValue;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimInfoDto;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ValueDto;
import kd.epm.eb.business.analysiscanvas.query.dto.SaveDto;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BizItemService
extends AbstractItemService {
    @Override
    public void saveDataIntoBox(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, IFormView formView) {
    }

    @Override
    public void getDataFromBox(List<CustomItem> itemList, AnalysisCanvasBox canvasBox, List<CustomItem> filterItemList, Map<String, String> boxData, IFormView formView) {
    }

    @Override
    public void clearItemValue(List<CustomItem> itemList) {
        itemList.forEach(item -> {
            BizModel bizModel = ModelHelper.getModel(item, BizModel.class);
            bizModel.getBizConfig().forEach(config -> config.setValue(null));
            ModelHelper.updateModel(item, bizModel);
        });
    }

    @Override
    public void buildItemQuote(long canvasId, List<CustomItem> itemList, List<MemberQuoteDao> quotes) {
        itemList.forEach(item -> {
            BizModel bizModel = ModelHelper.getModel(item, BizModel.class);
            Long modelId = IDUtils.toLong((Object)bizModel.getModel());
            Long datasetId = IDUtils.toLong((Object)bizModel.getDataset());
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), Long.valueOf(0L), datasetId, MemberTypeEnum.DATASET, MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            bizModel.getBizConfig().forEach(config -> {
                JSONObject dimensionViews = config.getDimensionViews();
                Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
                List<MemberQuoteDao> viewQuoteDao = QuoteBuilder.buildView(modelId, datasetId, viewMap, MemberQuoteResourceEnum.AnalysisCanvas, canvasId, modelCache);
                if (CollectionUtils.isNotEmpty(viewQuoteDao)) {
                    quotes.addAll(viewQuoteDao);
                }
                config.getDims().forEach(dim -> {
                    if (dim.getS().booleanValue()) {
                        String dimNumber = dim.getDim();
                        String memNumber = dim.getMems().get(0).getNum();
                        long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                        Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                        Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                        quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
                    }
                });
                String dimNumber = config.getDim();
                String memNumber = config.getNum();
                long viewId = ModelHelper.getViewId(dimNumber, dimensionViews);
                Dimension dimension = ModelHelper.getDimension(item.getName(), modelCache, datasetId, dimNumber);
                Member member = ModelHelper.getMember(item.getName(), modelCache, dimNumber, viewId, memNumber);
                quotes.add(new MemberQuoteDao(modelId, datasetId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.AnalysisCanvas, Long.valueOf(canvasId)));
            });
        });
    }

    @Override
    public void addNoneMember(long datasetId, List<CustomItem> itemList, Collection<String> dimNumbers) {
        itemList.forEach(item -> {
            BizModel bizModel = ModelHelper.getModel(item, BizModel.class);
            if (datasetId != IDUtils.toLong((Object)bizModel.getDataset())) {
                return;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)bizModel.getModel()));
            bizModel.getBizConfig().forEach(config -> {
                Map<String, DimensionModel> modelDimMap = config.getDims().stream().collect(Collectors.toMap(DimensionModel::getDim, v -> v, (o1, o2) -> o2));
                dimNumbers.forEach(dimNumber -> {
                    if (modelDimMap.containsKey(dimNumber)) {
                        return;
                    }
                    DimensionModel dimensionModel = new DimensionModel();
                    dimensionModel.setDim((String)dimNumber);
                    dimensionModel.setS(Boolean.TRUE);
                    MemberModel memberModel = new MemberModel();
                    Dimension dimension = modelCache.getDimension(dimNumber);
                    memberModel.setNum(dimension.getNoneNumber());
                    memberModel.setScope(RangeEnum.ONLY.getIndex());
                    dimensionModel.setMems(Collections.singletonList(memberModel));
                    config.getDims().add(dimensionModel);
                });
            });
            ModelHelper.updateModel(item, bizModel);
        });
    }

    @Override
    public void processItemVar(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, Map<String, ValueDto> calcChangeMembers, IFormView formView) {
    }

    @Override
    public List<SaveDto> buildCoverData(AnalysisCanvasBox canvasBox, List<CustomItem> itemList, List<CustomItem> filterItemList, IFormView formView) {
        return null;
    }

    @Override
    public DimInfoDto getDimInfo(AnalysisCanvasBox canvasBox, CustomItem item, List<CustomItem> filterItemList, JSONObject reqParam, IFormView formView) {
        BizModel bizModel = ModelHelper.getModel(item, BizModel.class);
        Long modelId = IDUtils.toLong((Object)bizModel.getModel());
        Long datasetId = IDUtils.toLong((Object)bizModel.getDataset());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List allDims = modelCache.getDimensionList(datasetId);
        List<String> sortedDimList = allDims.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        BizValue config = bizModel.getBizConfig().get(reqParam.getIntValue("configIndex"));
        if (config == null) {
            return null;
        }
        JSONObject dimensionViews = config.getDimensionViews();
        Map<String, Long> viewMap = ModelHelper.getViewMap(dimensionViews);
        Map<String, String> filterDim = ModelHelper.getFilterFromSelector(item.getId(), filterItemList);
        HashMap<String, String> memberInfo = new HashMap<String, String>(20);
        memberInfo.put(config.getDim(), config.getNum());
        this.setOtherDim(config.getDims(), filterDim, memberInfo);
        ModelHelper.fillMissMember(memberInfo, sortedDimList, modelCache);
        DimInfoDto dto = new DimInfoDto();
        dto.setModelId(modelId);
        dto.setDatasetId(datasetId);
        dto.setMemberInfo(memberInfo);
        dto.setViewMap(viewMap);
        return dto;
    }
}

